/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel;

import java.util.AbstractMap;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.enchantments.Enchantment;
import org.bukkit.entity.AbstractArrow;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Firework;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Projectile;
import org.bukkit.entity.SpectralArrow;
import org.bukkit.entity.ThrownPotion;
import org.bukkit.entity.TippedArrow;
import org.bukkit.entity.Trident;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.FireworkMeta;
import org.bukkit.inventory.meta.PotionMeta;
import org.bukkit.potion.PotionData;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionType;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.util.Vector;
import org.mcmonkey.sentinel.SentinelHelperObject;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.targeting.SentinelTarget;

public class SentinelWeaponHelper
extends SentinelHelperObject {
    public static final EntityType LINGERING_POTION;
    public static final EntityType TIPPED_ARROW;

    public void firePotion(ItemStack potion, Location target, Vector lead) {
        ++this.sentinel.stats_potionsThrown;
        AbstractMap.SimpleEntry<Location, Vector> start = this.sentinel.getLaunchDetail(target, lead);
        Entity entpotion = SentinelTarget.v1_14 ? start.getKey().getWorld().spawnEntity(start.getKey(), EntityType.SPLASH_POTION) : (SentinelTarget.v1_9 ? start.getKey().getWorld().spawnEntity(start.getKey(), potion.getType() == Material.SPLASH_POTION ? EntityType.SPLASH_POTION : LINGERING_POTION) : start.getKey().getWorld().spawnEntity(start.getKey(), EntityType.SPLASH_POTION));
        ((ThrownPotion)entpotion).setShooter((ProjectileSource)this.getLivingEntity());
        ((ThrownPotion)entpotion).setItem(potion);
        entpotion.setVelocity(this.sentinel.fixForAcc(start.getValue()));
        this.sentinel.swingWeapon();
    }

    public void fireArrow(ItemStack type, Location target, Vector lead) {
        Entity arrow;
        Vector baseVelocity;
        Location launchStart;
        if (SentinelTarget.v1_14 && type.getType() == Material.FIREWORK_ROCKET) {
            launchStart = this.sentinel.getLivingEntity().getEyeLocation();
            launchStart = launchStart.clone().add(launchStart.getDirection());
            baseVelocity = target.toVector().subtract(launchStart.toVector().add(lead));
            if (baseVelocity.lengthSquared() > 0.0) {
                baseVelocity = baseVelocity.normalize();
            }
            baseVelocity = baseVelocity.multiply(2);
        } else {
            AbstractMap.SimpleEntry<Location, Vector> start = this.sentinel.getLaunchDetail(target, lead);
            if (start == null || start.getKey() == null) {
                return;
            }
            launchStart = start.getKey();
            baseVelocity = start.getValue();
        }
        Vector velocity = this.sentinel.fixForAcc(baseVelocity);
        ++this.sentinel.stats_arrowsFired;
        if (SentinelTarget.v1_9) {
            PotionData data;
            if (SentinelTarget.v1_14) {
                double length = Math.max(1.0, velocity.length());
                if (type.getType() == Material.FIREWORK_ROCKET) {
                    FireworkMeta meta = (FireworkMeta)type.getItemMeta();
                    meta.setPower(3);
                    arrow = launchStart.getWorld().spawn(launchStart, EntityType.FIREWORK.getEntityClass(), e -> {
                        ((Firework)e).setShotAtAngle(true);
                        ((Firework)e).setFireworkMeta(meta);
                        e.setVelocity(velocity);
                    });
                } else {
                    Class toShoot = type.getType() == Material.SPECTRAL_ARROW ? SpectralArrow.class : (type.getType() == Material.TIPPED_ARROW ? TippedArrow.class : Arrow.class);
                    arrow = launchStart.getWorld().spawnArrow(launchStart, velocity.multiply(1.0 / length), (float)length, 0.0f, toShoot);
                    ((Projectile)arrow).setShooter((ProjectileSource)this.getLivingEntity());
                    ((Arrow)arrow).setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
                }
            } else {
                arrow = launchStart.getWorld().spawnEntity(launchStart, type.getType() == Material.SPECTRAL_ARROW ? EntityType.SPECTRAL_ARROW : (type.getType() == Material.TIPPED_ARROW ? TIPPED_ARROW : EntityType.ARROW));
                arrow.setVelocity(velocity);
                ((Projectile)arrow).setShooter((ProjectileSource)this.getLivingEntity());
            }
            if (arrow instanceof TippedArrow && type.getItemMeta() instanceof PotionMeta && (data = ((PotionMeta)type.getItemMeta()).getBasePotionData()).getType() != null && data.getType() != PotionType.UNCRAFTABLE) {
                ((TippedArrow)arrow).setBasePotionData(data);
                for (PotionEffect effect : ((PotionMeta)type.getItemMeta()).getCustomEffects()) {
                    ((TippedArrow)arrow).addCustomEffect(effect, true);
                }
            }
        } else {
            arrow = launchStart.getWorld().spawnEntity(launchStart, EntityType.ARROW);
            ((Projectile)arrow).setShooter((ProjectileSource)this.getLivingEntity());
            arrow.setVelocity(velocity);
        }
        if (this.sentinel.itemHelper.getHeldItem().containsEnchantment(Enchantment.ARROW_FIRE)) {
            arrow.setFireTicks(10000);
        }
        this.sentinel.useItem();
    }

    public void fireSnowball(Location target) {
        this.sentinel.swingWeapon();
        ++this.sentinel.stats_snowballsThrown;
        this.sentinel.faceLocation(target);
        Vector forward = this.getLivingEntity().getEyeLocation().getDirection();
        Location spawnAt = this.getLivingEntity().getEyeLocation().clone().add(forward.clone().multiply(this.sentinel.firingMinimumRange()));
        Entity ent = spawnAt.getWorld().spawnEntity(spawnAt, EntityType.SNOWBALL);
        ((Projectile)ent).setShooter((ProjectileSource)this.getLivingEntity());
        ent.setVelocity(this.sentinel.fixForAcc(target.clone().subtract(spawnAt).toVector().normalize().multiply(2.0)));
    }

    public void fireTrident(Location target) {
        if (!SentinelTarget.v1_13) {
            return;
        }
        this.sentinel.swingWeapon();
        ++this.sentinel.stats_arrowsFired;
        this.sentinel.faceLocation(target);
        Vector forward = this.getLivingEntity().getEyeLocation().getDirection();
        Location spawnAt = this.getLivingEntity().getEyeLocation().clone().add(forward.clone().multiply(this.sentinel.firingMinimumRange() + 2.0));
        Trident ent = (Trident)spawnAt.getWorld().spawnEntity(spawnAt, EntityType.TRIDENT);
        if (SentinelTarget.v1_14) {
            ent.setPickupStatus(AbstractArrow.PickupStatus.DISALLOWED);
        }
        ent.setShooter((ProjectileSource)this.getLivingEntity());
        ent.setVelocity(this.sentinel.fixForAcc(target.clone().subtract(spawnAt).toVector().normalize().multiply(2.0)));
    }

    public void fireEgg(Location target) {
        this.sentinel.swingWeapon();
        ++this.sentinel.stats_eggsThrown;
        this.sentinel.faceLocation(target);
        Vector forward = this.getLivingEntity().getEyeLocation().getDirection();
        Location spawnAt = this.getLivingEntity().getEyeLocation().clone().add(forward.clone().multiply(this.sentinel.firingMinimumRange()));
        Entity ent = spawnAt.getWorld().spawnEntity(spawnAt, EntityType.EGG);
        ((Projectile)ent).setShooter((ProjectileSource)this.getLivingEntity());
        ent.setVelocity(this.sentinel.fixForAcc(target.clone().subtract(spawnAt).toVector().normalize().multiply(2.0)));
    }

    public void firePearl(LivingEntity target) {
        this.sentinel.swingWeapon();
        this.sentinel.faceLocation(target.getEyeLocation());
        ++this.sentinel.stats_pearlsUsed;
        target.setVelocity(target.getVelocity().add(new Vector(0.0, this.sentinel.getDamage(), 0.0)));
    }

    public void fireFireball(Location target) {
        this.sentinel.swingWeapon();
        ++this.sentinel.stats_fireballsFired;
        this.sentinel.faceLocation(target);
        Vector forward = this.getLivingEntity().getEyeLocation().getDirection();
        Location spawnAt = this.getLivingEntity().getEyeLocation().clone().add(forward.clone().multiply(this.sentinel.firingMinimumRange()));
        Entity ent = spawnAt.getWorld().spawnEntity(spawnAt, EntityType.SMALL_FIREBALL);
        ((Projectile)ent).setShooter((ProjectileSource)this.getLivingEntity());
        ent.setVelocity(this.sentinel.fixForAcc(target.clone().subtract(spawnAt).toVector().normalize().multiply(4)));
    }

    public void fireSkull(Location target) {
        this.sentinel.swingWeapon();
        ++this.sentinel.stats_skullsThrown;
        this.sentinel.faceLocation(target);
        Vector forward = this.getLivingEntity().getEyeLocation().getDirection();
        Location spawnAt = this.getLivingEntity().getEyeLocation().clone().add(forward.clone().multiply(this.sentinel.firingMinimumRange()));
        Entity ent = spawnAt.getWorld().spawnEntity(spawnAt, EntityType.WITHER_SKULL);
        ((Projectile)ent).setShooter((ProjectileSource)this.getLivingEntity());
        ent.setVelocity(this.sentinel.fixForAcc(target.clone().subtract(spawnAt).toVector().normalize().multiply(4)));
    }

    public void punch(LivingEntity entity) {
        this.sentinel.faceLocation(entity.getLocation());
        this.sentinel.swingWeapon();
        ++this.sentinel.stats_punches;
        if (SentinelPlugin.instance.workaroundDamage) {
            if (SentinelPlugin.debugMe) {
                this.debug("workaround damage value at " + this.sentinel.getDamage() + " yields " + this.sentinel.getDamage() * (1.0 - this.sentinel.getArmor(entity)));
            }
            entity.damage(this.sentinel.getDamage() * (1.0 - this.sentinel.getArmor(entity)));
            this.knockback(entity);
            if (!this.sentinel.enemyDrops) {
                this.sentinel.needsDropsClear.add(entity.getUniqueId());
            }
        } else {
            if (SentinelPlugin.debugMe) {
                this.debug("Punch/natural for " + this.sentinel.getDamage());
            }
            entity.damage(this.sentinel.getDamage(), (Entity)this.getLivingEntity());
        }
    }

    public void knockback(LivingEntity entity) {
        Vector relative = entity.getLocation().toVector().subtract(this.getLivingEntity().getLocation().toVector());
        if (relative.lengthSquared() > 0.0) {
            relative = relative.normalize();
        }
        relative.setY(0.75);
        relative.multiply(0.5 / Math.max(1.0, entity.getVelocity().length()));
        entity.setVelocity(entity.getVelocity().multiply(0.25).add(relative));
        if (SentinelPlugin.debugMe) {
            this.debug("applied knockback velocity adder of " + relative);
        }
    }

    static {
        if (SentinelTarget.v1_14) {
            LINGERING_POTION = EntityType.SPLASH_POTION;
            TIPPED_ARROW = EntityType.ARROW;
        } else if (SentinelTarget.v1_9) {
            LINGERING_POTION = EntityType.valueOf((String)"LINGERING_POTION");
            TIPPED_ARROW = EntityType.valueOf((String)"TIPPED_ARROW");
        } else {
            LINGERING_POTION = null;
            TIPPED_ARROW = null;
        }
    }
}

