/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel.commands;

import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.CommandManager;
import net.citizensnpcs.api.command.Injector;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Owner;
import org.bukkit.ChatColor;
import org.bukkit.command.Command;
import org.bukkit.command.CommandSender;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelTrait;
import org.mcmonkey.sentinel.commands.SentinelAttackCommands;
import org.mcmonkey.sentinel.commands.SentinelChaseCommands;
import org.mcmonkey.sentinel.commands.SentinelGreetingCommands;
import org.mcmonkey.sentinel.commands.SentinelHealthCommands;
import org.mcmonkey.sentinel.commands.SentinelInfoCommands;
import org.mcmonkey.sentinel.commands.SentinelIntelligenceCommands;
import org.mcmonkey.sentinel.commands.SentinelTargetCommands;

public class SentinelCommand {
    public static final String colorBasic = ChatColor.YELLOW.toString();
    public static final String prefixGood = ChatColor.DARK_GREEN + "[Sentinel] " + colorBasic;
    public static final String prefixBad = ChatColor.DARK_GREEN + "[Sentinel] " + ChatColor.RED;
    public static CommandManager manager;
    private static Map<String, Method> sentinelCommandMethodMap;

    public static void buildCommandHandler() {
        manager = new CommandManager();
        manager.setInjector(new Injector(new Object[0]));
        SentinelCommand.grabCommandMethodMap(manager);
        manager.register(SentinelAttackCommands.class);
        manager.register(SentinelChaseCommands.class);
        manager.register(SentinelGreetingCommands.class);
        manager.register(SentinelHealthCommands.class);
        manager.register(SentinelInfoCommands.class);
        manager.register(SentinelIntelligenceCommands.class);
        manager.register(SentinelTargetCommands.class);
    }

    private static void grabCommandMethodMap(CommandManager instance) {
        try {
            Field field = CommandManager.class.getDeclaredField("commands");
            field.setAccessible(true);
            sentinelCommandMethodMap = (Map)field.get(instance);
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    private static boolean isSentinelRequired(String command, String modifier) {
        Method method = sentinelCommandMethodMap.get((command + " " + modifier).toLowerCase());
        if (method == null) {
            return false;
        }
        Requirements[] req = (Requirements[])method.getDeclaredAnnotationsByType(Requirements.class);
        if (req == null || req.length == 0) {
            return false;
        }
        for (Class traitClass : req[0].traits()) {
            if (!traitClass.equals(SentinelTrait.class)) continue;
            return true;
        }
        return false;
    }

    public static boolean onCommand(SentinelPlugin instance, CommandSender sender, Command command, String label, String[] args) {
        Object[] methodArgs;
        String modifier;
        String string = modifier = args.length > 0 ? args[0] : "";
        if (!manager.hasCommand(command, modifier) && !modifier.isEmpty()) {
            String closest = manager.getClosestCommandModifier(command.getName(), modifier);
            if (!closest.isEmpty()) {
                sender.sendMessage(prefixBad + "Unknown command. Did you mean:");
                sender.sendMessage(prefixGood + " /" + command.getName() + " " + closest);
            } else {
                sender.sendMessage(prefixBad + "Unknown command.");
            }
            return true;
        }
        NPC selected = CitizensAPI.getDefaultNPCSelector().getSelected(sender);
        SentinelTrait sentinel = null;
        CommandContext context = new CommandContext(sender, args);
        if (context.hasValueFlag("id") && sender.hasPermission("npc.select")) {
            selected = CitizensAPI.getNPCRegistry().getById(context.getFlagInteger("id"));
        }
        if (selected != null && selected.hasTrait(SentinelTrait.class)) {
            sentinel = (SentinelTrait)selected.getTrait(SentinelTrait.class);
        }
        if (SentinelCommand.isSentinelRequired(command.getName(), modifier)) {
            if (sentinel == null) {
                if (selected == null) {
                    sender.sendMessage(prefixBad + "Must have a Sentinel NPC selected!");
                } else {
                    sender.sendMessage(prefixBad + "Selected NPC is not a Sentinel! Use /trait sentinel to ensure an NPC becomes a Sentinel.");
                }
                return true;
            }
            if (!((Owner)selected.getTrait(Owner.class)).isOwnedBy(sender) && !sender.hasPermission("citizens.admin")) {
                sender.sendMessage(prefixBad + "You do not own this NPC (and you are not an admin).");
                return true;
            }
            methodArgs = new Object[]{sender, sentinel};
        } else {
            methodArgs = new Object[]{sender};
        }
        return manager.executeSafe(command, args, sender, methodArgs);
    }
}

