/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.util.AbstractMap;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.UUID;
import java.util.regex.Pattern;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.EntityTarget;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.FluidCollisionMode;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.EntityEquipment;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.RayTraceResult;
import org.bukkit.util.Vector;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelTrait;
import org.mcmonkey.sentinel.utilities.SentinelAPIBreakageFix;
import org.mcmonkey.sentinel.utilities.SentinelVersionCompat;
import org.mcmonkey.sentinel.utilities.VelocityTracker;

public class SentinelUtilities {
    public static Random random = new Random();
    public static HashMap<String, Pattern> regexes = new HashMap(128);
    public static final String ENCODING = "UTF-8";
    public static final int BUFFER_10_KB = 10240;
    private static final double EPSILON = 1.0E-7;
    private static final long UUID_VERSION_BITMASK = 28672L;

    public static int getMinWorldHeight(World world) {
        if (!SentinelVersionCompat.v1_17) {
            return 0;
        }
        return world.getMinHeight();
    }

    public static int getMaxWorldHeight(World world) {
        if (!SentinelVersionCompat.v1_17) {
            return 255;
        }
        return world.getMaxHeight();
    }

    public static Vector getVelocity(Entity entity) {
        if (entity instanceof Player && !CitizensAPI.getNPCRegistry().isNPC(entity)) {
            return VelocityTracker.getVelocityFor((Player)entity);
        }
        return entity.getVelocity();
    }

    public static SentinelTrait tryGetSentinel(Entity entity) {
        if (CitizensAPI.getNPCRegistry().isNPC(entity)) {
            return (SentinelTrait)CitizensAPI.getNPCRegistry().getNPC(entity).getTraitNullable(SentinelTrait.class);
        }
        return null;
    }

    public static ItemStack getHeldItem(LivingEntity entity) {
        if (entity.getEquipment() == null) {
            return null;
        }
        if (SentinelVersionCompat.v1_9) {
            return entity.getEquipment().getItemInMainHand();
        }
        return entity.getEquipment().getItemInHand();
    }

    public static ItemStack getOffhandItem(LivingEntity entity) {
        if (SentinelVersionCompat.v1_9 && entity.getEquipment() != null) {
            return entity.getEquipment().getItemInOffHand();
        }
        return null;
    }

    public static int getFireProtection(LivingEntity entity) {
        if (!SentinelVersionCompat.v1_9 || entity.getEquipment() == null) {
            return 0;
        }
        int level = 0;
        for (ItemStack item : entity.getEquipment().getArmorContents()) {
            if (item == null || !item.hasItemMeta() || !item.getItemMeta().hasEnchant(SentinelAPIBreakageFix.ENCHANTMENT_PROTECTION_FIRE)) continue;
            level = Math.max(level, item.getItemMeta().getEnchantLevel(SentinelAPIBreakageFix.ENCHANTMENT_PROTECTION_FIRE));
        }
        return level;
    }

    public static Location rayTrace(Location start, Location end) {
        double dSq = start.distanceSquared(end);
        if (dSq < 1.0) {
            if (end.getBlock().getType().isSolid()) {
                return start.clone();
            }
            return end.clone();
        }
        double dist = Math.sqrt(dSq);
        Vector move = end.toVector().subtract(start.toVector()).multiply(1.0 / dist);
        int iters = (int)Math.ceil(dist);
        Location cur = start.clone();
        Location next = cur.clone().add(move);
        for (int i = 0; i < iters; ++i) {
            if (next.getBlock().getType().isSolid()) {
                return cur;
            }
            cur = cur.add(move);
            next = next.add(move);
        }
        return cur;
    }

    public static Location pickNear(Location start, double range) {
        Location hit = SentinelUtilities.rayTrace(start.clone().add(0.0, 1.5, 0.0), start.clone().add(SentinelUtilities.randomDecimal(-range, range), 1.5, SentinelUtilities.randomDecimal(-range, range)));
        if (hit.subtract(0.0, 1.0, 0.0).getBlock().getType().isSolid()) {
            return hit;
        }
        return hit.subtract(0.0, 1.0, 0.0);
    }

    public static Pattern regexFor(String input) {
        Pattern result = regexes.get(input);
        if (result != null) {
            return result;
        }
        result = Pattern.compile(input, 2);
        regexes.put(input, result);
        return result;
    }

    public static boolean isRegexTarget(String name, String regex) {
        Pattern pattern = SentinelUtilities.regexFor(".*" + regex + ".*");
        return pattern.matcher(name).matches();
    }

    public static String getRegexTarget(String name, List<String> regexes) {
        for (String str : regexes) {
            if (!SentinelUtilities.isRegexTarget(name, str)) continue;
            return str;
        }
        return null;
    }

    public static String getItemTarget(ItemStack item, List<String> targets) {
        if (item == null || item.getType() == Material.AIR) {
            return targets.contains("air") ? "air" : null;
        }
        for (String str : targets) {
            if (str.startsWith("name:")) {
                String nameMatch = str.substring("name:".length());
                if (!item.hasItemMeta() || !item.getItemMeta().hasDisplayName() || !SentinelUtilities.isRegexTarget(item.getItemMeta().getDisplayName(), nameMatch)) continue;
                return str;
            }
            if (str.startsWith("lore:")) {
                String loreMatch = str.substring("lore:".length());
                if (!item.hasItemMeta() || !item.getItemMeta().hasLore()) continue;
                for (String lore : item.getItemMeta().getLore()) {
                    if (!SentinelUtilities.isRegexTarget(lore, loreMatch)) continue;
                    return str;
                }
                continue;
            }
            if (!SentinelUtilities.isRegexTarget(item.getType().name(), str)) continue;
            return str;
        }
        return null;
    }

    public static boolean isItemTarget(ItemStack item, List<String> targets) {
        return SentinelUtilities.getItemTarget(item, targets) != null;
    }

    public static boolean isRegexTargeted(String name, List<String> regexes) {
        return SentinelUtilities.getRegexTarget(name, regexes) != null;
    }

    public static boolean isLookingTowards(Location myLoc, Location theirLoc, float yawLimit, float pitchLimit) {
        Vector rel = theirLoc.toVector().subtract(myLoc.toVector()).normalize();
        float yaw = SentinelUtilities.normalizeYaw(myLoc.getYaw());
        float yawHelp = SentinelUtilities.getYaw(rel);
        if (!(Math.abs(yawHelp - yaw) < yawLimit || Math.abs(yawHelp + 360.0f - yaw) < yawLimit || Math.abs(yaw + 360.0f - yawHelp) < yawLimit)) {
            return false;
        }
        float pitch = myLoc.getPitch();
        float pitchHelp = SentinelUtilities.getPitch(rel);
        return Math.abs(pitchHelp - pitch) < pitchLimit;
    }

    public static float normalizeYaw(float yaw) {
        if ((yaw %= 360.0f) < 0.0f) {
            yaw = (float)((double)yaw + 360.0);
        }
        return yaw;
    }

    public static float getPitch(Vector vector) {
        double dx = vector.getX();
        double dy = vector.getY();
        double dz = vector.getZ();
        double forward = Math.sqrt(dx * dx + dz * dz);
        double pitch = Math.atan2(dy, forward) * 57.29577951308232;
        return (float)pitch;
    }

    public static float getYaw(Vector vector) {
        double dx = vector.getX();
        double dz = vector.getZ();
        double yaw = 0.0;
        if (dx != 0.0) {
            yaw = dx < 0.0 ? 4.71238898038469 : 1.5707963267948966;
            yaw -= Math.atan(dz / dx);
        } else if (dz < 0.0) {
            yaw = Math.PI;
        }
        return (float)(-yaw * 57.29577951308232);
    }

    public static double randomDecimal(double min, double max) {
        return random.nextDouble() * (max - min) + min;
    }

    public static boolean isAir(ItemStack its) {
        return its == null || its.getType() == Material.AIR;
    }

    public static Entity getEntityForID(UUID id) {
        if (!SentinelVersionCompat.v1_12) {
            for (World world : Bukkit.getServer().getWorlds()) {
                for (Entity e : world.getEntities()) {
                    if (!e.getUniqueId().equals(id)) continue;
                    return e;
                }
            }
            return null;
        }
        return Bukkit.getServer().getEntity(id);
    }

    public static boolean isInvisible(LivingEntity entity) {
        if (!SentinelPlugin.instance.ignoreInvisible || !entity.hasPotionEffect(PotionEffectType.INVISIBILITY)) {
            return false;
        }
        EntityEquipment eq = entity.getEquipment();
        if (eq == null) {
            return true;
        }
        if (SentinelVersionCompat.v1_9 ? !SentinelUtilities.isAir(eq.getItemInMainHand()) || !SentinelUtilities.isAir(eq.getItemInOffHand()) : !SentinelUtilities.isAir(eq.getItemInHand())) {
            return false;
        }
        return SentinelUtilities.isAir(eq.getBoots()) && SentinelUtilities.isAir(eq.getLeggings()) && SentinelUtilities.isAir(eq.getChestplate()) && SentinelUtilities.isAir(eq.getHelmet());
    }

    public static Entity getTargetFor(EntityTarget targ) {
        if (SentinelVersionCompat.v1_9) {
            return targ.getTarget();
        }
        try {
            Method meth = EntityTarget.class.getMethod("getTarget", new Class[0]);
            meth.setAccessible(true);
            return (LivingEntity)meth.invoke((Object)targ, new Object[0]);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return targ.getTarget();
        }
    }

    public static AbstractMap.SimpleEntry<Location, Vector> getLaunchDetail(Location start, Location target, Vector lead) {
        double sbase;
        double speeda;
        double angt = Double.POSITIVE_INFINITY;
        for (speeda = sbase = SentinelPlugin.instance.minShootSpeed; speeda <= sbase + 15.0 && Double.isInfinite(angt = SentinelUtilities.getArrowAngle(start, target, speeda, 20.0)); speeda += 5.0) {
        }
        if (Double.isInfinite(angt)) {
            return null;
        }
        double hangT = SentinelUtilities.hangtime(angt, speeda, target.getY() - start.getY(), 20.0);
        Location to = target.clone().add(lead.clone().multiply(hangT));
        Vector relative = to.clone().subtract(start.toVector()).toVector();
        double deltaXZ = Math.sqrt(relative.getX() * relative.getX() + relative.getZ() * relative.getZ());
        if (deltaXZ == 0.0) {
            deltaXZ = 0.1;
        }
        for (speeda = sbase; speeda <= sbase + 15.0 && Double.isInfinite(angt = SentinelUtilities.getArrowAngle(start, to, speeda, 20.0)); speeda += 5.0) {
        }
        if (Double.isInfinite(angt)) {
            return null;
        }
        relative.setY(Math.tan(angt) * deltaXZ);
        relative = relative.normalize();
        Vector normrel = relative.clone();
        relative = relative.multiply((speeda += 1.188 * hangT * hangT) / 20.0);
        start.setDirection(normrel);
        return new AbstractMap.SimpleEntry<Location, Vector>(start, relative);
    }

    public static double getArrowAngle(Location fireFrom, Location fireTo, double speed, double gravity) {
        double deltaY;
        double basic;
        double v2;
        double v4;
        Vector delta = fireTo.clone().subtract(fireFrom).toVector();
        double deltaXZ = Math.sqrt(delta.getX() * delta.getX() + delta.getZ() * delta.getZ());
        if (deltaXZ == 0.0) {
            deltaXZ = 0.1;
        }
        if ((v4 = (v2 = speed * speed) * v2) < (basic = gravity * (gravity * deltaXZ * deltaXZ + 2.0 * (deltaY = fireTo.getY() - fireFrom.getY()) * v2))) {
            return Double.NEGATIVE_INFINITY;
        }
        return Math.atan((v2 - Math.sqrt(v4 - basic)) / (gravity * deltaXZ));
    }

    public static double hangtime(double launchAngle, double vel, double deltaY, double gravity) {
        double b;
        double a = vel * Math.sin(launchAngle);
        double a2 = a * a + (b = -2.0 * gravity * deltaY);
        if (a2 < 0.0) {
            return 0.0;
        }
        return (a + Math.sqrt(a2)) / gravity;
    }

    public static String concatWithSpaces(String[] strs, int start) {
        StringBuilder temp = new StringBuilder();
        for (int i = start; i < strs.length; ++i) {
            temp.append(strs[i]).append(" ");
        }
        return temp.toString().trim();
    }

    public static String streamToString(InputStream is) {
        try {
            char[] buffer = new char[10240];
            StringBuilder out = new StringBuilder();
            try (InputStreamReader in = new InputStreamReader(is, ENCODING);){
                int rsz;
                while ((rsz = ((Reader)in).read(buffer, 0, buffer.length)) >= 0) {
                    out.append(buffer, 0, rsz);
                }
            }
            return out.toString();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public static boolean checkLineOfSightWithTransparency(LivingEntity start, LivingEntity end) {
        if (!SentinelVersionCompat.v1_13) {
            return start.hasLineOfSight((Entity)end);
        }
        if (SentinelUtilities.checkLineOfSightWithTransparency(start.getEyeLocation(), end.getEyeLocation())) {
            return true;
        }
        if (!SentinelPlugin.instance.enhanceLosTraces) {
            return false;
        }
        return SentinelUtilities.checkLineOfSightWithTransparency(start.getEyeLocation(), end.getLocation()) || SentinelUtilities.checkLineOfSightWithTransparency(start.getEyeLocation(), end.getLocation().add(0.0, 1.05, 0.0));
    }

    public static boolean checkLineOfSightWithTransparency(Location start, Location end) {
        Vector relative = end.toVector().subtract(start.toVector());
        double len = relative.length();
        if (Double.isInfinite(len) || Double.isNaN(len) || len < 1.0) {
            return true;
        }
        if (len > 128.0) {
            return false;
        }
        relative = relative.multiply(1.0 / len);
        RayTraceResult result = start.getWorld().rayTraceBlocks(start, relative, len, FluidCollisionMode.NEVER, true);
        if (result == null || result.getHitBlock() == null) {
            return true;
        }
        if (!SentinelVersionCompat.TRANSPARENT_BLOCKS.contains(result.getHitBlock().getType())) {
            return false;
        }
        Vector hitVec = result.getHitPosition();
        int startX = hitVec.getBlockX();
        int startY = hitVec.getBlockY();
        int startZ = hitVec.getBlockZ();
        Vector bumpForward = relative.multiply(0.1);
        while (hitVec.getBlockX() == startX && hitVec.getBlockY() == startY && hitVec.getBlockZ() == startZ) {
            hitVec = hitVec.add(bumpForward);
        }
        if (hitVec.getBlockY() <= SentinelUtilities.getMinWorldHeight(start.getWorld()) || hitVec.getBlockY() >= SentinelUtilities.getMaxWorldHeight(start.getWorld())) {
            return false;
        }
        Location hit = new Location(start.getWorld(), hitVec.getX(), hitVec.getY(), hitVec.getZ());
        if (!SentinelVersionCompat.TRANSPARENT_BLOCKS.contains(hit.getBlock().getType())) {
            return false;
        }
        return SentinelUtilities.checkLineOfSightWithTransparency(hit, end);
    }

    public static boolean approxEquals(double a, double b) {
        return Math.abs(a - b) < 1.0E-7;
    }

    public static void broadcastToSelected(NPC npc, String message) {
        Bukkit.getConsoleSender().sendMessage(message);
        if (!npc.isSpawned()) {
            return;
        }
        for (Player player : npc.getEntity().getLocation().getWorld().getPlayers()) {
            NPC selected;
            if (!player.isOnline() || (selected = CitizensAPI.getDefaultNPCSelector().getSelected((CommandSender)player)) == null || !selected.equals((Object)npc)) continue;
            player.sendMessage(message);
        }
    }

    public static boolean uuidEquals(UUID a, UUID b) {
        long mB;
        if (a == null || b == null) {
            return a == null && b == null;
        }
        if (a.getLeastSignificantBits() != b.getLeastSignificantBits()) {
            return false;
        }
        long mA = a.getMostSignificantBits() & 0xFFFFFFFFFFFF8FFFL;
        return mA == (mB = b.getMostSignificantBits() & 0xFFFFFFFFFFFF8FFFL);
    }
}

