/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel.commands;

import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.stream.Collectors;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.CommandManager;
import net.citizensnpcs.api.command.Injector;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Owner;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.command.Command;
import org.bukkit.command.CommandExecutor;
import org.bukkit.command.CommandSender;
import org.bukkit.command.PluginCommand;
import org.bukkit.command.TabCompleter;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelTrait;
import org.mcmonkey.sentinel.commands.SentinelAttackCommands;
import org.mcmonkey.sentinel.commands.SentinelChaseCommands;
import org.mcmonkey.sentinel.commands.SentinelGreetingCommands;
import org.mcmonkey.sentinel.commands.SentinelHealthCommands;
import org.mcmonkey.sentinel.commands.SentinelInfoCommands;
import org.mcmonkey.sentinel.commands.SentinelIntelligenceCommands;
import org.mcmonkey.sentinel.commands.SentinelTargetCommands;

public class SentinelCommand
implements CommandExecutor,
TabCompleter {
    public static final String colorBasic = ChatColor.YELLOW.toString();
    public static final String colorBad = ChatColor.RED.toString();
    public static final String colorEmphasis = ChatColor.AQUA.toString();
    public static final String prefixGood = ChatColor.DARK_GREEN + "[Sentinel] " + colorBasic;
    public static final String prefixBad = ChatColor.DARK_GREEN + "[Sentinel] " + colorBad;
    public CommandManager manager;
    public static SentinelCommand instance;
    private static Field commandInfoMethodField;
    private static Field annotationsField;
    public static HashSet<String> addTargetTabCompletions;
    public static HashSet<String> itemPrefixes;
    public static List<String> materialNames;

    public void buildCommandHandler(PluginCommand command) {
        instance = this;
        this.manager = new CommandManager();
        this.manager.setInjector(new Injector(new Object[0]));
        this.grabCommandField();
        this.manager.register(SentinelAttackCommands.class);
        this.manager.register(SentinelChaseCommands.class);
        this.manager.register(SentinelGreetingCommands.class);
        this.manager.register(SentinelHealthCommands.class);
        this.manager.register(SentinelInfoCommands.class);
        this.manager.register(SentinelIntelligenceCommands.class);
        this.manager.register(SentinelTargetCommands.class);
        command.setExecutor((CommandExecutor)this);
        command.setTabCompleter((TabCompleter)this);
    }

    private void grabCommandField() {
        try {
            annotationsField = CommandManager.CommandInfo.class.getDeclaredField("annotations");
            annotationsField.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        try {
            commandInfoMethodField = CommandManager.CommandInfo.class.getDeclaredField("method");
            commandInfoMethodField.setAccessible(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (annotationsField == null && commandInfoMethodField == null) {
            SentinelPlugin.instance.getLogger().warning("Cannot read CommandInfo method or annotations fields, command handling will fail.");
        }
    }

    private boolean isSentinelRequired(String command, String modifier) {
        CommandManager.CommandInfo info = this.manager.getCommand(new String[]{command, modifier});
        if (info == null) {
            return false;
        }
        try {
            Method method;
            Requirements[] reqs;
            List annotations;
            Requirements req = null;
            if (annotationsField != null && (annotations = (List)annotationsField.get(info)) != null) {
                for (Annotation annotation : annotations) {
                    if (!(annotation instanceof Requirements)) continue;
                    req = (Requirements)annotation;
                    break;
                }
            }
            if (commandInfoMethodField != null && req == null && (reqs = (Requirements[])(method = (Method)commandInfoMethodField.get(info)).getDeclaredAnnotationsByType(Requirements.class)).length > 0) {
                req = reqs[0];
            }
            if (req == null) {
                return false;
            }
            for (Class traitClass : req.traits()) {
                if (!traitClass.equals(SentinelTrait.class)) continue;
                return true;
            }
        }
        catch (IllegalAccessException ex) {
            ex.printStackTrace();
        }
        return false;
    }

    public boolean onCommand(CommandSender sender, Command command, String label, String[] args) {
        Object[] methodArgs;
        String modifier;
        String string = modifier = args.length > 0 ? args[0] : "";
        if (!this.manager.hasCommand(command, new String[]{modifier}) && !modifier.isEmpty()) {
            String closest = this.manager.getClosestCommandModifier(command.getName(), modifier);
            if (!closest.isEmpty()) {
                sender.sendMessage(prefixBad + "Unknown command. Did you mean:");
                sender.sendMessage(prefixGood + " /" + command.getName() + " " + closest);
            } else {
                sender.sendMessage(prefixBad + "Unknown command.");
            }
            return true;
        }
        NPC selected = CitizensAPI.getDefaultNPCSelector().getSelected(sender);
        SentinelTrait sentinel = null;
        CommandContext context = new CommandContext(sender, args);
        if (context.hasValueFlag("id") && sender.hasPermission("npc.select")) {
            try {
                selected = CitizensAPI.getNPCRegistry().getById(context.getFlagInteger("id"));
            }
            catch (NumberFormatException ex) {
                sender.sendMessage(prefixBad + "ID input is invalid (not an integer)!");
                return true;
            }
        }
        if (selected != null) {
            sentinel = (SentinelTrait)selected.getTraitNullable(SentinelTrait.class);
        }
        if (this.isSentinelRequired(command.getName(), modifier)) {
            if (sentinel == null) {
                if (selected == null) {
                    sender.sendMessage(prefixBad + "Must have a Sentinel NPC selected!");
                } else {
                    sender.sendMessage(prefixBad + "Selected NPC is not a Sentinel! Use /trait sentinel to ensure an NPC becomes a Sentinel.");
                }
                return true;
            }
            if (!((Owner)selected.getOrAddTrait(Owner.class)).isOwnedBy(sender) && !sender.hasPermission("citizens.admin")) {
                sender.sendMessage(prefixBad + "You do not own this NPC (and you are not an admin).");
                return true;
            }
            methodArgs = new Object[]{sender, sentinel};
        } else {
            methodArgs = new Object[]{sender};
        }
        return this.manager.executeSafe(command, args, sender, methodArgs);
    }

    private static List<String> filterForArg(Collection<String> output, String arg1) {
        String low = arg1.toLowerCase();
        return output.stream().filter(s -> s.startsWith(low)).collect(Collectors.toList());
    }

    public List<String> onTabComplete(CommandSender commandSender, Command command, String s, String[] strings) {
        NPC npc;
        if (s.equals("sentinel") && strings.length == 2 && (npc = CitizensAPI.getDefaultNPCSelector().getSelected(commandSender)) != null && npc.hasTrait(SentinelTrait.class)) {
            SentinelTrait sentinel = (SentinelTrait)npc.getOrAddTrait(SentinelTrait.class);
            switch (strings[0].toLowerCase()) {
                case "addtarget": 
                case "addignore": 
                case "addavoid": {
                    String prefix;
                    String low = strings[1].toLowerCase();
                    int colon = low.indexOf(58);
                    if (colon != -1 && colon + 1 < low.length() && itemPrefixes.contains(prefix = low.substring(0, colon))) {
                        List<String> materials = SentinelCommand.filterForArg(materialNames, low.substring(colon + 1));
                        materials.add("lore:");
                        materials.add("name:");
                        return SentinelCommand.filterForArg(materials.stream().map(m -> prefix + ":" + m).collect(Collectors.toList()), low);
                    }
                    return SentinelCommand.filterForArg(addTargetTabCompletions, low);
                }
                case "removetarget": {
                    return SentinelCommand.filterForArg(sentinel.allTargets.getTargetRemovableStrings(), strings[1]);
                }
                case "removeignore": {
                    return SentinelCommand.filterForArg(sentinel.allIgnores.getTargetRemovableStrings(), strings[1]);
                }
                case "removeavoid": {
                    return SentinelCommand.filterForArg(sentinel.allAvoids.getTargetRemovableStrings(), strings[1]);
                }
            }
        }
        return this.manager.onTabComplete(commandSender, command, s, strings);
    }

    static {
        addTargetTabCompletions = new HashSet();
        itemPrefixes = new HashSet<String>(Arrays.asList("helditem", "offhand", "equipped", "in_inventory"));
        materialNames = Arrays.stream(Material.values()).map(m -> m.name().toLowerCase()).collect(Collectors.toList());
        addTargetTabCompletions.addAll(Arrays.asList("player:", "npc:", "entityname:", "group:"));
        addTargetTabCompletions.addAll(Arrays.asList("helditem:", "offhand:", "equipped:", "in_inventory:"));
        addTargetTabCompletions.addAll(Arrays.asList("status:angry", "status:passive"));
        addTargetTabCompletions.addAll(Arrays.asList("event:", "event:pvp", "event:pve", "event:pvnpc", "event:pvsentinel", "event:eve", "event:pv:", "event:ev:", "event:npcvnpc", "event:guarded_fight", "event:message:"));
        addTargetTabCompletions.addAll(SentinelPlugin.targetOptions.keySet().stream().map(String::toLowerCase).collect(Collectors.toList()));
    }
}

