/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel.shaded.com.freneticllc.freneticutilities.freneticdatasyntax;

import java.util.ArrayList;
import java.util.Base64;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.mcmonkey.sentinel.shaded.com.freneticllc.freneticutilities.freneticdatasyntax.FDSData;
import org.mcmonkey.sentinel.shaded.com.freneticllc.freneticutilities.freneticdatasyntax.FDSInputException;
import org.mcmonkey.sentinel.shaded.com.freneticllc.freneticutilities.freneticdatasyntax.FDSUtility;

public class FDSSection {
    public int startingLine = 0;
    public LinkedHashMap<String, FDSData> data = new LinkedHashMap();
    public HashMap<String, FDSData> dataLowered = new HashMap();
    public ArrayList<String> postComments = new ArrayList();
    public char sectionPathSplit = FDSUtility.defaultSectionPathSplit;

    public FDSSection(String contents) {
        this.startingLine = 1;
        contents = FDSUtility.cleanFileData(contents);
        HashMap<Integer, FDSSection> spacedsections = new HashMap<Integer, FDSSection>();
        spacedsections.put(0, this);
        ArrayList<String> ccomments = new ArrayList<String>();
        ArrayList seccomments = new ArrayList();
        FDSSection csection = this;
        String[] data = FDSUtility.split(contents, '\n');
        int pspaces = 0;
        String secwaiting = null;
        ArrayList<FDSData> clist = null;
        for (int i = 0; i < data.length; ++i) {
            int spaces;
            String line = data[i];
            for (spaces = 0; spaces < line.length() && line.charAt(spaces) == ' '; ++spaces) {
            }
            if (spaces == line.length()) continue;
            String datum = FDSUtility.trimEnd(line.substring(spaces));
            if (datum.startsWith("#")) {
                ccomments.add(datum.substring(1));
                continue;
            }
            if (spaces < pspaces) {
                FDSSection temp = (FDSSection)spacedsections.get(spaces);
                if (temp != null) {
                    csection = temp;
                    Iterator iterator = new ArrayList(spacedsections.keySet()).iterator();
                    while (iterator.hasNext()) {
                        int test = (Integer)iterator.next();
                        if (test <= spaces) continue;
                        spacedsections.remove(test);
                    }
                } else {
                    this.exception(i, line, "Spaced incorrectly. Spacing length instanceof less than previous spacing length,but does not match the spacing value of any known section, valid: " + FDSUtility.join(" / ", spacedsections.keySet()) + ", found: " + spaces + ", was: " + pspaces);
                }
            }
            if (datum.charAt(0) == '-' || datum.charAt(0) == '=') {
                String clistline = FDSUtility.trimStart(datum.substring(1));
                if (clist == null) {
                    if (spaces >= pspaces && secwaiting != null) {
                        clist = new ArrayList<FDSData>();
                        csection.setRootData(FDSUtility.unEscapeKey(secwaiting), new FDSData(clist, new ArrayList<String>(seccomments)));
                        seccomments.clear();
                        secwaiting = null;
                    } else {
                        this.exception(i, line, "Line purpose unknown, attempted list entry when not building a list");
                    }
                }
                String unescaped = FDSUtility.unEscape(clistline);
                clist.add(new FDSData(datum.charAt(0) == '=' ? (Object)Base64.getDecoder().decode(unescaped) : FDSUtility.interpretType(unescaped), new ArrayList<String>(ccomments)));
                ccomments.clear();
                continue;
            }
            clist = null;
            String startofline = "";
            String endofline = "";
            char type = '\u0000';
            for (int spot = 0; spot < datum.length(); ++spot) {
                if (datum.charAt(spot) != ':' && datum.charAt(spot) != '=') continue;
                type = datum.charAt(spot);
                startofline = datum.substring(0, spot);
                endofline = spot == datum.length() - 1 ? "" : datum.substring(spot + 1);
                break;
            }
            endofline = FDSUtility.trimStart(endofline);
            if (type == '\u0000') {
                this.exception(i, line, "Line purpose unknown");
            }
            if (startofline.length() == 0) {
                this.exception(i, line, "Empty key label!");
            }
            if (spaces > pspaces && secwaiting != null) {
                FDSSection sect = new FDSSection();
                csection.setRootData(FDSUtility.unEscapeKey(secwaiting), new FDSData(sect, new ArrayList<String>(seccomments)));
                seccomments.clear();
                csection = sect;
                spacedsections.put(spaces, sect);
                secwaiting = null;
            }
            if (type == '=') {
                csection.setRootData(FDSUtility.unEscapeKey(startofline), new FDSData(Base64.getDecoder().decode(FDSUtility.unEscape(endofline)), new ArrayList<String>(ccomments)));
                ccomments.clear();
            } else if (type == ':') {
                if (endofline.length() == 0) {
                    secwaiting = startofline;
                    seccomments = new ArrayList(ccomments);
                    ccomments.clear();
                } else {
                    csection.setRootData(FDSUtility.unEscapeKey(startofline), new FDSData(FDSUtility.interpretType(FDSUtility.unEscape(endofline)), new ArrayList<String>(ccomments)));
                    ccomments.clear();
                }
            } else {
                this.exception(i, line, "Internal issue: unrecognize 'type' value: " + type);
            }
            pspaces = spaces;
        }
        this.postComments.addAll(ccomments);
    }

    private void exception(int linenumber, String line, String reason) {
        throw new RuntimeException("[FDS Parsing error] Line " + (linenumber + 1) + ": " + reason + ", from line as follows: `" + line + "`");
    }

    public FDSSection() {
    }

    public Set<String> getRootKeys() {
        return this.data.keySet();
    }

    public ArrayList<String> getStringList(String key) {
        ArrayList<FDSData> dat = this.getDataList(key);
        if (dat == null) {
            return null;
        }
        ArrayList<String> newlist = new ArrayList<String>(dat.size());
        for (int i = 0; i < dat.size(); ++i) {
            newlist.add(dat.get((int)i).internal.toString());
        }
        return newlist;
    }

    public ArrayList<FDSData> getDataList(String key) {
        FDSData got = this.getData(key);
        if (got == null) {
            return null;
        }
        Object o = got.internal;
        if (o instanceof ArrayList) {
            return (ArrayList)o;
        }
        ArrayList<FDSData> output = new ArrayList<FDSData>();
        output.add(got);
        return output;
    }

    public Boolean getBoolean(String key) {
        return this.getBoolean(key, null);
    }

    public Boolean getBoolean(String key, Boolean def) {
        FDSData got = this.getData(key);
        if (got == null) {
            return def;
        }
        Object o = got.internal;
        if (o instanceof Boolean) {
            return (Boolean)o;
        }
        return FDSUtility.toLowerCase(o.toString()).equals("true");
    }

    public String getString(String key) {
        return this.getString(key, null);
    }

    public String getString(String key, String def) {
        FDSData got = this.getData(key);
        if (got == null) {
            return def;
        }
        Object o = got.internal;
        if (o instanceof String) {
            return (String)o;
        }
        return o.toString();
    }

    public Float getFloat(String key) {
        return this.getFloat(key, null);
    }

    public Float getFloat(String key, Float def) {
        Double asDouble = this.getDouble(key, def == null ? null : Double.valueOf(def.doubleValue()));
        if (asDouble != null) {
            return Float.valueOf(asDouble.floatValue());
        }
        return null;
    }

    public Double getDouble(String key) {
        return this.getDouble(key, null);
    }

    public Double getDouble(String key, Double def) {
        FDSData got = this.getData(key);
        if (got == null) {
            return def;
        }
        Object o = got.internal;
        if (o instanceof Double) {
            return (Double)o;
        }
        if (o instanceof Float) {
            return ((Float)o).doubleValue();
        }
        try {
            return Double.parseDouble(o.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public Integer getInt(String key) {
        return this.getInt(key, null);
    }

    public Integer getInt(String key, Integer def) {
        Long asLong = this.getLong(key, def == null ? null : Long.valueOf(def.longValue()));
        if (asLong != null) {
            return asLong.intValue();
        }
        return null;
    }

    public Long getLong(String key) {
        return this.getLong(key, null);
    }

    public Long getLong(String key, Long def) {
        FDSData got = this.getData(key);
        if (got == null) {
            return def;
        }
        Object o = got.internal;
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Integer) {
            return ((Integer)o).longValue();
        }
        try {
            return Long.parseLong(o.toString());
        }
        catch (NumberFormatException numberFormatException) {
            return def;
        }
    }

    public Object getObject(String key) {
        return this.getObject(key, null);
    }

    public Object getObject(String key, Object def) {
        FDSData got = this.getData(key);
        if (got == null) {
            return def;
        }
        return got.internal;
    }

    public void set(String key, Object input) {
        this.setData(key, new FDSData(input, new ArrayList<String>()));
    }

    public void setData(String key, FDSData data) {
        int lind = key.lastIndexOf(this.sectionPathSplit);
        if (lind < 0) {
            this.setRootData(key, data);
            return;
        }
        if (lind == key.length() - 1) {
            throw new FDSInputException("Invalid SetData key: Ends in a path splitter!");
        }
        FDSSection sec = this.getSectionInternal(key.substring(0, lind), false, false);
        sec.setRootData(key.substring(lind + 1), data);
    }

    public void defaultObject(String key, Object input) {
        this.defaultData(key, new FDSData(input, new ArrayList<String>()));
    }

    public void defaultData(String key, FDSData data) {
        String k;
        int lind = key.lastIndexOf(this.sectionPathSplit);
        if (lind < 0) {
            if (this.getRootData(key) == null) {
                this.setRootData(key, data);
            }
            return;
        }
        if (lind == key.length() - 1) {
            throw new FDSInputException("Invalid SetData key: Ends in a path splitter!");
        }
        FDSSection sec = this.getSectionInternal(key.substring(0, lind), false, false);
        if (sec.getRootData(k = key.substring(lind + 1)) == null) {
            sec.setRootData(k, data);
        }
    }

    public boolean hasKey(String key) {
        return this.getData(key) != null;
    }

    public FDSData getData(String key) {
        int lind = key.lastIndexOf(this.sectionPathSplit);
        if (lind < 0) {
            return this.getRootData(key);
        }
        if (lind == key.length() - 1) {
            return null;
        }
        FDSSection sec = this.getSection(key.substring(0, lind));
        if (sec == null) {
            return null;
        }
        return sec.getRootData(key.substring(lind + 1));
    }

    public FDSData getDataLowered(String key) {
        int lind = (key = FDSUtility.toLowerCase(key)).lastIndexOf(this.sectionPathSplit);
        if (lind < 0) {
            return this.getRootDataLowered(key);
        }
        if (lind == key.length() - 1) {
            return null;
        }
        FDSSection sec = this.getSectionInternal(key.substring(0, lind), true, true);
        if (sec == null) {
            return null;
        }
        return sec.getRootDataLowered(key.substring(lind + 1));
    }

    public FDSSection getSection(String key) {
        return this.getSectionInternal(key, true, false);
    }

    public FDSSection getSectionLowered(String key) {
        return this.getSectionInternal(FDSUtility.toLowerCase(key), true, true);
    }

    private FDSSection getSectionInternal(String key, boolean allowNull, boolean lowered) {
        if (key == null || key.length() == 0) {
            return this;
        }
        String[] dat = FDSUtility.split(key, this.sectionPathSplit);
        FDSSection current = this;
        for (int i = 0; i < dat.length; ++i) {
            FDSData fdat;
            FDSData fDSData = fdat = lowered ? current.getRootDataLowered(dat[i]) : current.getRootData(dat[i]);
            if (fdat != null && fdat.internal instanceof FDSSection) {
                current = (FDSSection)fdat.internal;
                continue;
            }
            if (allowNull) {
                return null;
            }
            if (fdat != null) {
                throw new FDSInputException("Key contains non-section contents!");
            }
            FDSSection temp = new FDSSection();
            current.setRootData(dat[i], new FDSData(temp, new ArrayList<String>()));
            current = temp;
        }
        return current;
    }

    public void setRootData(String key, FDSData dat) {
        this.data.put(key, dat);
        this.dataLowered.put(FDSUtility.toLowerCase(key), dat);
    }

    public FDSData getRootData(String key) {
        return this.data.get(key);
    }

    public FDSData getRootDataLowered(String key) {
        return this.dataLowered.get(key);
    }

    public String savetoString() {
        return this.savetoString("", null);
    }

    public String savetoString(String tabs) {
        return this.savetoString(tabs, null);
    }

    public String savetoString(String tabs, String newline) {
        if (newline == null) {
            newline = "\n";
        }
        if (tabs == null) {
            tabs = "";
        }
        StringBuilder outputBuilder = new StringBuilder(this.data.size() * 100);
        for (Map.Entry<String, FDSData> entry : this.data.entrySet()) {
            String key = entry.getKey();
            FDSData dat = entry.getValue();
            for (String str : dat.precedingComments) {
                outputBuilder.append(tabs).append("#").append(str).append(newline);
            }
            outputBuilder.append(tabs).append(FDSUtility.escapeKey(key));
            if (dat.internal instanceof FDSSection) {
                outputBuilder.append(":").append(newline).append(((FDSSection)dat.internal).savetoString(tabs + "    ", newline));
                continue;
            }
            if (dat.internal instanceof byte[]) {
                outputBuilder.append("= ").append(FDSUtility.escape(dat.outputable())).append(newline);
                continue;
            }
            if (dat.internal instanceof ArrayList) {
                outputBuilder.append(":").append(newline);
                for (FDSData cdat : (ArrayList)dat.internal) {
                    for (String com : cdat.precedingComments) {
                        outputBuilder.append(tabs).append("#").append(com).append(newline);
                    }
                    outputBuilder.append(tabs);
                    if (cdat.internal instanceof byte[]) {
                        outputBuilder.append("= ");
                    } else {
                        outputBuilder.append("- ");
                    }
                    outputBuilder.append(FDSUtility.escape(cdat.outputable())).append(newline);
                }
                continue;
            }
            outputBuilder.append(": ").append(FDSUtility.escape(dat.outputable())).append(newline);
        }
        for (String str : this.postComments) {
            outputBuilder.append(tabs).append("#").append(str).append(newline);
        }
        return outputBuilder.toString();
    }
}

