/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel.utilities;

import java.time.LocalDate;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.EntityType;
import org.bukkit.inventory.ItemStack;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.targeting.SentinelTarget;
import org.mcmonkey.sentinel.utilities.SentinelAPIBreakageFix;

public class SentinelVersionCompat {
    public static final HashSet<Material> SWORD_MATERIALS = new HashSet();
    public static final HashSet<Material> PICKAXE_MATERIALS = new HashSet();
    public static final HashSet<Material> AXE_MATERIALS = new HashSet();
    public static final HashSet<Material> HELMET_MATERIALS = new HashSet();
    public static final HashSet<Material> CHESTPLATE_MATERIALS = new HashSet();
    public static final HashSet<Material> LEGGINGS_MATERIALS = new HashSet();
    public static final HashSet<Material> BOOTS_MATERIALS = new HashSet();
    public static final HashSet<Material> BOW_MATERIALS = new HashSet();
    public static final HashSet<Material> POTION_MATERIALS = new HashSet();
    public static final HashSet<Material> SKULL_MATERIALS = new HashSet();
    public static final HashSet<Material> OTHER_RANGED_MATERIALS = new HashSet();
    public static final HashSet<Material> TRANSPARENT_BLOCKS = new HashSet();
    public static final Map<Material, Double> WEAPON_DAMAGE_MULTIPLIERS = new HashMap<Material, Double>();
    public static final Map<Material, Double> ARMOR_PROTECTION_MULTIPLIERS = new HashMap<Material, Double>();
    public static final Material MATERIAL_SNOW_BALL;
    public static final Material MATERIAL_NETHER_STAR;
    public static final Material MATERIAL_BLAZE_ROD;
    public static final boolean v1_8;
    public static final boolean v1_9;
    public static final boolean v1_10;
    public static final boolean v1_11;
    public static final boolean v1_12;
    public static final boolean v1_13;
    public static final boolean v1_14;
    public static final boolean v1_15;
    public static final boolean v1_16;
    public static final boolean v1_17;
    public static final boolean v1_18;
    public static final boolean v1_19;
    public static final boolean v1_20;
    public static final boolean v1_21;
    public static final boolean vFuture;

    static void warnOldVersion(String versionName, int yearsOld, String extra) {
        SentinelPlugin.instance.getLogger().warning("The version " + versionName + " is " + yearsOld + " years old (as of 2020) and therefore cannot be supported. Sentinel will work on this version, but we will not provide support if you have running it. Please update your server to a more recent minecraft version as soon as you are able." + extra);
    }

    public static void init() {
        int currentYear = Math.min(LocalDate.now().getYear(), 2021);
        if (v1_8 && !v1_9) {
            SentinelVersionCompat.warnOldVersion("1.8", currentYear - 2014, " See also https://wiki.citizensnpcs.co/Minecraft_1.8");
        } else if (v1_9 && !v1_10) {
            SentinelVersionCompat.warnOldVersion("1.9", currentYear - 2016, "");
        } else if (v1_10 && !v1_11) {
            SentinelVersionCompat.warnOldVersion("1.10", currentYear - 2016, "");
        } else if (v1_11 && !v1_12) {
            SentinelVersionCompat.warnOldVersion("1.11", currentYear - 2016, "");
        } else if (v1_12 && !vFuture) {
            SentinelPlugin.instance.getLogger().info("Sentinel loaded on a fully supported Minecraft version. If you encounter any issues or need to ask a question, please join our Discord at https://discord.gg/Q6pZGSR and post in the '#sentinel' channel.");
        } else if (!v1_8) {
            SentinelPlugin.instance.getLogger().warning("You are running on an unrecognized (ancient?) minecraft version. This probably won't work.");
        } else {
            SentinelPlugin.instance.getLogger().warning("You are running on an unrecognized (future?) minecraft version. Support channel be guaranteed. Check if there is a newer version of Sentinel available that supports your minecraft version.");
        }
    }

    public static boolean isWeapon(Material mat) {
        return WEAPON_DAMAGE_MULTIPLIERS.containsKey(mat) || POTION_MATERIALS.contains(mat) || BOW_MATERIALS.contains(mat) || SKULL_MATERIALS.contains(mat) || mat == MATERIAL_SNOW_BALL || mat == MATERIAL_BLAZE_ROD || mat == MATERIAL_NETHER_STAR;
    }

    public static boolean isRangedWeapon(ItemStack item) {
        if (item == null) {
            return false;
        }
        Material mat = item.getType();
        return BOW_MATERIALS.contains(mat) || OTHER_RANGED_MATERIALS.contains(mat) || mat == MATERIAL_SNOW_BALL;
    }

    public static EntityType[] combine(EntityType[] a, EntityType ... b) {
        EntityType[] types = new EntityType[a.length + b.length];
        System.arraycopy(a, 0, types, 0, a.length);
        System.arraycopy(b, 0, types, a.length, b.length);
        return types;
    }

    static String[] passiveNames() {
        return new String[]{"PASSIVE_MOB", "PASSIVEMOB", "GOODMOB", "GOOD_MOB", "FRIENDLYMOB", "FRIENDLY_MOB"};
    }

    static EntityType[] v1_8_passive() {
        return new EntityType[]{EntityType.PIG, EntityType.OCELOT, EntityType.COW, EntityType.RABBIT, EntityType.SHEEP, EntityType.CHICKEN, SentinelAPIBreakageFix.ENTITY_TYPE_MUSHROOM_COW, EntityType.HORSE, EntityType.IRON_GOLEM, EntityType.SQUID, EntityType.VILLAGER, EntityType.WOLF, SentinelAPIBreakageFix.ENTITY_TYPE_SNOWMAN};
    }

    static EntityType[] v1_10_passive() {
        return SentinelVersionCompat.combine(SentinelVersionCompat.v1_8_passive(), EntityType.POLAR_BEAR);
    }

    static EntityType[] v1_11_passive() {
        return SentinelVersionCompat.combine(SentinelVersionCompat.v1_10_passive(), EntityType.DONKEY, EntityType.LLAMA, EntityType.MULE, EntityType.ZOMBIE_HORSE, EntityType.SKELETON_HORSE);
    }

    static EntityType[] v1_12_passive() {
        return SentinelVersionCompat.combine(SentinelVersionCompat.v1_11_passive(), EntityType.PARROT);
    }

    static EntityType[] v1_13_passive() {
        return SentinelVersionCompat.combine(SentinelVersionCompat.v1_12_passive(), EntityType.DOLPHIN, EntityType.COD, EntityType.SALMON, EntityType.PUFFERFISH, EntityType.TROPICAL_FISH, EntityType.TURTLE);
    }

    static EntityType[] v1_14_passive() {
        return SentinelVersionCompat.combine(SentinelVersionCompat.v1_13_passive(), EntityType.CAT, EntityType.PANDA, EntityType.TRADER_LLAMA, EntityType.WANDERING_TRADER, EntityType.FOX);
    }

    static EntityType[] v1_16_passive() {
        return SentinelVersionCompat.combine(SentinelVersionCompat.v1_14_passive(), EntityType.STRIDER);
    }

    static EntityType[] v1_17_passive() {
        return SentinelVersionCompat.combine(SentinelVersionCompat.v1_16_passive(), EntityType.GOAT, EntityType.AXOLOTL);
    }

    static EntityType[] v1_19_passive() {
        EntityType[] res = SentinelVersionCompat.combine(SentinelVersionCompat.v1_17_passive(), EntityType.TADPOLE, EntityType.FROG, EntityType.ALLAY);
        if (SentinelTarget.CAMELS != null) {
            res = SentinelVersionCompat.combine(res, EntityType.valueOf((String)"CAMEL"));
        }
        if (SentinelTarget.SNIFFERS != null) {
            res = SentinelVersionCompat.combine(res, EntityType.valueOf((String)"SNIFFER"));
        }
        return res;
    }

    static EntityType[] v1_8_monsters() {
        return new EntityType[]{EntityType.GUARDIAN, EntityType.CREEPER, EntityType.SKELETON, EntityType.ZOMBIE, EntityType.MAGMA_CUBE, EntityType.valueOf((String)"PIG_ZOMBIE"), EntityType.SILVERFISH, EntityType.BAT, EntityType.BLAZE, EntityType.GHAST, EntityType.GIANT, EntityType.SLIME, EntityType.SPIDER, EntityType.CAVE_SPIDER, EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.WITHER, EntityType.ENDER_DRAGON, EntityType.WITCH};
    }

    static EntityType[] v1_9_monsters() {
        return SentinelVersionCompat.combine(SentinelVersionCompat.v1_8_monsters(), EntityType.SHULKER);
    }

    static EntityType[] v1_11_monsters() {
        return SentinelVersionCompat.combine(SentinelVersionCompat.v1_9_monsters(), EntityType.VEX, EntityType.HUSK, EntityType.ELDER_GUARDIAN, EntityType.EVOKER, EntityType.STRAY, EntityType.ZOMBIE_VILLAGER, EntityType.WITHER_SKELETON, EntityType.VINDICATOR);
    }

    static EntityType[] v1_12_monsters() {
        return SentinelVersionCompat.combine(SentinelVersionCompat.v1_11_monsters(), EntityType.ILLUSIONER);
    }

    static EntityType[] v1_13_monsters() {
        return SentinelVersionCompat.combine(SentinelVersionCompat.v1_12_monsters(), EntityType.DROWNED, EntityType.PHANTOM);
    }

    static EntityType[] v1_14_monsters() {
        return SentinelVersionCompat.combine(SentinelVersionCompat.v1_13_monsters(), EntityType.RAVAGER, EntityType.PILLAGER);
    }

    static EntityType[] v1_15_monsters() {
        return SentinelVersionCompat.combine(SentinelVersionCompat.v1_14_monsters(), EntityType.BEE);
    }

    static EntityType[] v1_16_monsters() {
        return new EntityType[]{EntityType.GUARDIAN, EntityType.CREEPER, EntityType.SKELETON, EntityType.ZOMBIE, EntityType.MAGMA_CUBE, EntityType.SILVERFISH, EntityType.BAT, EntityType.BLAZE, EntityType.GHAST, EntityType.GIANT, EntityType.SLIME, EntityType.SPIDER, EntityType.CAVE_SPIDER, EntityType.ENDERMAN, EntityType.ENDERMITE, EntityType.WITHER, EntityType.ENDER_DRAGON, EntityType.WITCH, EntityType.SHULKER, EntityType.VEX, EntityType.HUSK, EntityType.ELDER_GUARDIAN, EntityType.EVOKER, EntityType.STRAY, EntityType.ZOMBIE_VILLAGER, EntityType.WITHER_SKELETON, EntityType.VINDICATOR, EntityType.ILLUSIONER, EntityType.DROWNED, EntityType.PHANTOM, EntityType.RAVAGER, EntityType.PILLAGER, EntityType.BEE, EntityType.HOGLIN, EntityType.PIGLIN, EntityType.ZOGLIN, EntityType.ZOMBIFIED_PIGLIN, EntityType.PIGLIN_BRUTE};
    }

    static EntityType[] v1_19_monsters() {
        return SentinelVersionCompat.combine(SentinelVersionCompat.v1_16_monsters(), EntityType.WARDEN);
    }

    public static Material getMaterial(String name) {
        try {
            return Material.valueOf((String)name);
        }
        catch (IllegalArgumentException ex) {
            SentinelPlugin.instance.getLogger().warning("Sentinel loader failed to handle material name '" + name + "', that material will not function (REPORT THIS ERROR!)");
            return Material.valueOf((String)"STICK");
        }
    }

    public static void addAllMaterials(Set<Material> set, String ... matNames) {
        for (String mat : matNames) {
            set.add(SentinelVersionCompat.getMaterial(mat));
        }
    }

    public static void allMaterialsTo(Map<Material, Double> map, Set<Material> set, Double val) {
        for (Material mat : set) {
            map.put(mat, val);
        }
    }

    static {
        String vers = Bukkit.getBukkitVersion();
        vFuture = vers.startsWith("1.22") || vers.startsWith("1.23") || vers.startsWith("1.24") || vers.startsWith("1.25") || vers.startsWith("1.26");
        v1_21 = vers.startsWith("1.21") || vFuture;
        v1_20 = vers.startsWith("1.20") || v1_21;
        v1_19 = vers.startsWith("1.19") || v1_20;
        v1_18 = vers.startsWith("1.18") || v1_19;
        v1_17 = vers.startsWith("1.17") || v1_18;
        v1_16 = vers.startsWith("1.16") || v1_17;
        v1_15 = vers.startsWith("1.15") || v1_16;
        v1_14 = vers.startsWith("1.14") || v1_15;
        v1_13 = vers.startsWith("1.13") || v1_14;
        v1_12 = vers.startsWith("1.12") || v1_13;
        v1_11 = vers.startsWith("1.11") || v1_12;
        v1_10 = vers.startsWith("1.10") || v1_11;
        v1_9 = vers.startsWith("1.9") || v1_10;
        boolean bl = v1_8 = vers.startsWith("1.8") || v1_9;
        if (v1_8 && !v1_9) {
            SentinelTarget.PASSIVE_MOBS = new SentinelTarget(SentinelVersionCompat.v1_8_passive(), SentinelVersionCompat.passiveNames());
            SentinelTarget.MOBS = new SentinelTarget(SentinelVersionCompat.combine(SentinelVersionCompat.v1_8_passive(), SentinelVersionCompat.v1_8_monsters()), "MOB");
            SentinelTarget.MONSTERS = new SentinelTarget(SentinelVersionCompat.v1_8_monsters(), "MONSTER");
        }
        if (v1_9) {
            SentinelTarget.SHULKERS = new SentinelTarget(new EntityType[]{EntityType.SHULKER}, "SHULKER");
        }
        if (v1_9 && !v1_10) {
            SentinelTarget.PASSIVE_MOBS = new SentinelTarget(SentinelVersionCompat.v1_8_passive(), SentinelVersionCompat.passiveNames());
            SentinelTarget.MOBS = new SentinelTarget(SentinelVersionCompat.combine(SentinelVersionCompat.v1_8_passive(), SentinelVersionCompat.v1_9_monsters()), "MOB");
            SentinelTarget.MONSTERS = new SentinelTarget(SentinelVersionCompat.v1_9_monsters(), "MONSTER");
        }
        if (v1_10) {
            SentinelTarget.POLAR_BEARS = new SentinelTarget(new EntityType[]{EntityType.POLAR_BEAR}, "POLARBEAR", "POLAR_BEAR");
        }
        if (v1_10 && !v1_11) {
            SentinelTarget.PASSIVE_MOBS = new SentinelTarget(SentinelVersionCompat.v1_10_passive(), SentinelVersionCompat.passiveNames());
            SentinelTarget.MOBS = new SentinelTarget(SentinelVersionCompat.combine(SentinelVersionCompat.v1_10_passive(), SentinelVersionCompat.v1_9_monsters()), "MOB");
            SentinelTarget.MONSTERS = new SentinelTarget(SentinelVersionCompat.v1_9_monsters(), "MONSTER");
        }
        if (v1_11) {
            SentinelTarget.VEXES = new SentinelTarget(new EntityType[]{EntityType.VEX}, "VEX", "VEXE");
            SentinelTarget.DONKEYS = new SentinelTarget(new EntityType[]{EntityType.DONKEY}, "DONKEY");
            SentinelTarget.LLAMAS = new SentinelTarget(new EntityType[]{EntityType.LLAMA}, "LLAMA");
            SentinelTarget.MULES = new SentinelTarget(new EntityType[]{EntityType.MULE}, "MULE");
            SentinelTarget.HUSKS = new SentinelTarget(new EntityType[]{EntityType.HUSK}, "HUSK");
            SentinelTarget.ELDER_GUARDIANS = new SentinelTarget(new EntityType[]{EntityType.ELDER_GUARDIAN}, "ELDER_GUARDIAN", "ELDERGUARDIAN");
            SentinelTarget.EVOKERS = new SentinelTarget(new EntityType[]{EntityType.EVOKER}, "EVOKER");
            SentinelTarget.SKELETON_HORSES = new SentinelTarget(new EntityType[]{EntityType.SKELETON_HORSE}, "SKELETON_HORSE", "SKELETONHORSE");
            SentinelTarget.STRAYS = new SentinelTarget(new EntityType[]{EntityType.STRAY}, "STRAY");
            SentinelTarget.ZOMBIE_VILLAGERS = new SentinelTarget(new EntityType[]{EntityType.ZOMBIE_VILLAGER}, "ZOMBIE_VILLAGER", "ZOMBIEVILLAGER");
            SentinelTarget.ZOMBIE_HORSES = new SentinelTarget(new EntityType[]{EntityType.ZOMBIE_HORSE}, "ZOMBIE_HORSE", "ZOMBIEHORSE");
            SentinelTarget.WITHER_SKELETONS = new SentinelTarget(new EntityType[]{EntityType.WITHER_SKELETON}, "WITHER_SKELETON", "WITHERSKELETON");
            SentinelTarget.VINDICATORS = new SentinelTarget(new EntityType[]{EntityType.VINDICATOR}, "VINDICATOR");
        }
        if (v1_11 && !v1_12) {
            SentinelTarget.PASSIVE_MOBS = new SentinelTarget(SentinelVersionCompat.v1_11_passive(), SentinelVersionCompat.passiveNames());
            SentinelTarget.MOBS = new SentinelTarget(SentinelVersionCompat.combine(SentinelVersionCompat.v1_11_passive(), SentinelVersionCompat.v1_11_monsters()), "MOB");
            SentinelTarget.MONSTERS = new SentinelTarget(SentinelVersionCompat.v1_11_monsters(), "MONSTER");
        }
        if (v1_12) {
            SentinelTarget.PARROTS = new SentinelTarget(new EntityType[]{EntityType.PARROT}, "PARROT");
            SentinelTarget.ILLUSIONERS = new SentinelTarget(new EntityType[]{EntityType.ILLUSIONER}, "ILLUSIONER");
        }
        if (v1_12 && !v1_13) {
            SentinelTarget.PASSIVE_MOBS = new SentinelTarget(SentinelVersionCompat.v1_12_passive(), SentinelVersionCompat.passiveNames());
            SentinelTarget.MOBS = new SentinelTarget(SentinelVersionCompat.combine(SentinelVersionCompat.v1_12_passive(), SentinelVersionCompat.v1_12_monsters()), "MOB");
            SentinelTarget.MONSTERS = new SentinelTarget(SentinelVersionCompat.v1_12_monsters(), "MONSTER");
        }
        if (v1_13) {
            SentinelTarget.DOLPHINS = new SentinelTarget(new EntityType[]{EntityType.DOLPHIN}, "DOLPHIN");
            SentinelTarget.DROWNED = new SentinelTarget(new EntityType[]{EntityType.DROWNED}, "DROWNED");
            SentinelTarget.COD = new SentinelTarget(new EntityType[]{EntityType.COD}, "COD");
            SentinelTarget.SALMON = new SentinelTarget(new EntityType[]{EntityType.SALMON}, "SALMON");
            SentinelTarget.PUFFERFISH = new SentinelTarget(new EntityType[]{EntityType.PUFFERFISH}, "PUFFERFISH", "PUFFERFISHE");
            SentinelTarget.TROPICAL_FISH = new SentinelTarget(new EntityType[]{EntityType.TROPICAL_FISH}, "TROPICAL_FISH", "TROPICALFISH", "TROPICAL_FISHE", "TROPICALFISHE");
            SentinelTarget.FISH = new SentinelTarget(new EntityType[]{EntityType.TROPICAL_FISH, EntityType.PUFFERFISH, EntityType.SALMON, EntityType.COD}, "FISH", "FISHE");
            SentinelTarget.PHANTOMS = new SentinelTarget(new EntityType[]{EntityType.PHANTOM}, "PHANTOM");
            SentinelTarget.TURTLES = new SentinelTarget(new EntityType[]{EntityType.TURTLE}, "TURTLE");
        }
        if (v1_13 && !v1_14) {
            SentinelTarget.PASSIVE_MOBS = new SentinelTarget(SentinelVersionCompat.v1_13_passive(), SentinelVersionCompat.passiveNames());
            SentinelTarget.MOBS = new SentinelTarget(SentinelVersionCompat.combine(SentinelVersionCompat.v1_13_passive(), SentinelVersionCompat.v1_13_monsters()), "MOB");
            SentinelTarget.MONSTERS = new SentinelTarget(SentinelVersionCompat.v1_13_monsters(), "MONSTER");
        }
        if (v1_14) {
            SentinelTarget.RAVAGERS = new SentinelTarget(new EntityType[]{EntityType.RAVAGER}, "RAVAGER");
            SentinelTarget.PILLAGERS = new SentinelTarget(new EntityType[]{EntityType.PILLAGER}, "PILLAGER");
            SentinelTarget.CATS = new SentinelTarget(new EntityType[]{EntityType.CAT}, "CAT");
            SentinelTarget.PANDAS = new SentinelTarget(new EntityType[]{EntityType.PANDA}, "PANDA");
            SentinelTarget.TRADER_LLAMAS = new SentinelTarget(new EntityType[]{EntityType.TRADER_LLAMA}, "TRADER_LLAMA", "TRADERLLAMA");
            SentinelTarget.WANDERING_TRADERS = new SentinelTarget(new EntityType[]{EntityType.WANDERING_TRADER}, "WANDERING_TRADER", "WANDERINGTRADER", "TRADER");
            SentinelTarget.FOXES = new SentinelTarget(new EntityType[]{EntityType.FOX}, "FOX", "FOXE");
        }
        if (v1_14 && !v1_15) {
            SentinelTarget.PASSIVE_MOBS = new SentinelTarget(SentinelVersionCompat.v1_14_passive(), SentinelVersionCompat.passiveNames());
            SentinelTarget.MOBS = new SentinelTarget(SentinelVersionCompat.combine(SentinelVersionCompat.v1_14_passive(), SentinelVersionCompat.v1_14_monsters()), "MOB");
            SentinelTarget.MONSTERS = new SentinelTarget(SentinelVersionCompat.v1_14_monsters(), "MONSTER");
            BOW_MATERIALS.add(SentinelVersionCompat.getMaterial("CROSSBOW"));
        }
        if (v1_15) {
            SentinelTarget.BEES = new SentinelTarget(new EntityType[]{EntityType.BEE}, "BEE");
        }
        if (v1_15 && !v1_16) {
            SentinelTarget.PASSIVE_MOBS = new SentinelTarget(SentinelVersionCompat.v1_14_passive(), SentinelVersionCompat.passiveNames());
            SentinelTarget.MOBS = new SentinelTarget(SentinelVersionCompat.combine(SentinelVersionCompat.v1_14_passive(), SentinelVersionCompat.v1_15_monsters()), "MOB");
            SentinelTarget.MONSTERS = new SentinelTarget(SentinelVersionCompat.v1_14_monsters(), "MONSTER");
        }
        if (!v1_16) {
            SentinelTarget.ZOMBIE_PIGMEN = new SentinelTarget(new EntityType[]{EntityType.valueOf((String)"PIG_ZOMBIE")}, "PIG_ZOMBIE", "PIGZOMBIE", "ZOMBIEPIGMAN", "ZOMBIEPIGMEN", "ZOMBIE_PIGMAN", "ZOMBIE_PIGMEN", "ZOMBIE_PIGMAN");
        }
        if (v1_16) {
            SentinelTarget.HOGLINS = new SentinelTarget(new EntityType[]{EntityType.HOGLIN}, "HOGLIN");
            SentinelTarget.PIGLINS = new SentinelTarget(new EntityType[]{EntityType.PIGLIN}, "PIGLIN");
            SentinelTarget.STRIDERS = new SentinelTarget(new EntityType[]{EntityType.STRIDER}, "STRIDER");
            SentinelTarget.ZOGLINS = new SentinelTarget(new EntityType[]{EntityType.ZOGLIN}, "ZOGLIN");
            SentinelTarget.PIGLIN_BRUTE = new SentinelTarget(new EntityType[]{EntityType.PIGLIN_BRUTE}, "PIGLIN_BRUTE");
            SentinelTarget.ZOMBIFIED_PIGLINS = new SentinelTarget(new EntityType[]{EntityType.ZOMBIFIED_PIGLIN}, "ZOMBIFIED_PIGLIN", "ZOMBIFIEDPIGLIN", "ZOMBIE_PIGLIN", "ZOMBIEPIGLIN", "PIG_ZOMBIE", "PIGZOMBIE", "ZOMBIEPIGMAN", "ZOMBIEPIGMEN", "ZOMBIE_PIGMAN", "ZOMBIE_PIGMEN", "ZOMBIE_PIGMAN");
        }
        if (v1_16 && !v1_17) {
            SentinelTarget.PASSIVE_MOBS = new SentinelTarget(SentinelVersionCompat.v1_16_passive(), SentinelVersionCompat.passiveNames());
            SentinelTarget.MOBS = new SentinelTarget(SentinelVersionCompat.combine(SentinelVersionCompat.v1_16_passive(), SentinelVersionCompat.v1_16_monsters()), "MOB");
            SentinelTarget.MONSTERS = new SentinelTarget(SentinelVersionCompat.v1_16_monsters(), "MONSTER");
        }
        if (v1_17) {
            SentinelTarget.HOGLINS = new SentinelTarget(new EntityType[]{EntityType.GOAT}, "GOAT");
            SentinelTarget.PIGLINS = new SentinelTarget(new EntityType[]{EntityType.AXOLOTL}, "AXOLOTL");
        }
        if (v1_17 && !v1_19) {
            SentinelTarget.PASSIVE_MOBS = new SentinelTarget(SentinelVersionCompat.v1_17_passive(), SentinelVersionCompat.passiveNames());
            SentinelTarget.MOBS = new SentinelTarget(SentinelVersionCompat.combine(SentinelVersionCompat.v1_17_passive(), SentinelVersionCompat.v1_16_monsters()), "MOB");
            SentinelTarget.MONSTERS = new SentinelTarget(SentinelVersionCompat.v1_16_monsters(), "MONSTER");
        }
        if (v1_19) {
            SentinelTarget.TADPOLES = new SentinelTarget(new EntityType[]{EntityType.TADPOLE}, "TADPOLE");
            SentinelTarget.FROGS = new SentinelTarget(new EntityType[]{EntityType.FROG}, "FROG");
            SentinelTarget.ALLAYS = new SentinelTarget(new EntityType[]{EntityType.ALLAY}, "ALLAY");
            SentinelTarget.WARDENS = new SentinelTarget(new EntityType[]{EntityType.WARDEN}, "WARDEN");
            try {
                SentinelTarget.CAMELS = new SentinelTarget(new EntityType[]{EntityType.valueOf((String)"CAMEL")}, "CAMEL");
                SentinelTarget.SNIFFERS = new SentinelTarget(new EntityType[]{EntityType.valueOf((String)"SNIFFER")}, "SNIFFER");
            }
            catch (Throwable throwable) {
                // empty catch block
            }
        }
        if (v1_19 && !v1_20) {
            SentinelTarget.PASSIVE_MOBS = new SentinelTarget(SentinelVersionCompat.v1_19_passive(), SentinelVersionCompat.passiveNames());
            SentinelTarget.MOBS = new SentinelTarget(SentinelVersionCompat.combine(SentinelVersionCompat.v1_19_passive(), SentinelVersionCompat.v1_19_monsters()), "MOB");
            SentinelTarget.MONSTERS = new SentinelTarget(SentinelVersionCompat.v1_19_monsters(), "MONSTER");
        }
        if (v1_20 && !v1_21) {
            SentinelTarget.PASSIVE_MOBS = new SentinelTarget(SentinelVersionCompat.v1_19_passive(), SentinelVersionCompat.passiveNames());
            SentinelTarget.MOBS = new SentinelTarget(SentinelVersionCompat.combine(SentinelVersionCompat.v1_19_passive(), SentinelVersionCompat.v1_19_monsters()), "MOB");
            SentinelTarget.MONSTERS = new SentinelTarget(SentinelVersionCompat.v1_19_monsters(), "MONSTER");
        }
        if (v1_21) {
            SentinelTarget.HOGLINS = new SentinelTarget(new EntityType[]{EntityType.BREEZE}, "BREEZE");
            SentinelTarget.HOGLINS = new SentinelTarget(new EntityType[]{EntityType.BOGGED}, "BOGGED", "BOGGEDSKELETON", "BOGGED_SKELETON");
            SentinelTarget.HOGLINS = new SentinelTarget(new EntityType[]{EntityType.ARMADILLO}, "ARMADILLO");
            SentinelTarget.PASSIVE_MOBS = new SentinelTarget(SentinelVersionCompat.v1_19_passive(), SentinelVersionCompat.passiveNames());
            SentinelTarget.MOBS = new SentinelTarget(SentinelVersionCompat.combine(SentinelVersionCompat.v1_19_passive(), SentinelVersionCompat.v1_19_monsters()), "MOB");
            SentinelTarget.MONSTERS = new SentinelTarget(SentinelVersionCompat.v1_19_monsters(), "MONSTER");
        }
        if (v1_17) {
            TRANSPARENT_BLOCKS.add(SentinelVersionCompat.getMaterial("LIGHT"));
        }
        if (v1_16) {
            SentinelVersionCompat.addAllMaterials(SWORD_MATERIALS, "NETHERITE_SWORD");
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("NETHERITE_SWORD"), 8.0);
            SentinelVersionCompat.addAllMaterials(PICKAXE_MATERIALS, "NETHERITE_PICKAXE");
            SentinelVersionCompat.addAllMaterials(AXE_MATERIALS, "NETHERITE_AXE");
            SentinelVersionCompat.addAllMaterials(HELMET_MATERIALS, "NETHERITE_HELMET");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("NETHERITE_HELMET"), 0.12);
            SentinelVersionCompat.addAllMaterials(CHESTPLATE_MATERIALS, "NETHERITE_CHESTPLATE");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("NETHERITE_CHESTPLATE"), 0.32);
            SentinelVersionCompat.addAllMaterials(LEGGINGS_MATERIALS, "NETHERITE_LEGGINGS");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("NETHERITE_LEGGINGS"), 0.24);
            SentinelVersionCompat.addAllMaterials(BOOTS_MATERIALS, "NETHERITE_BOOTS");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("NETHERITE_BOOTS"), 0.12);
        }
        if (v1_13) {
            SentinelVersionCompat.addAllMaterials(SWORD_MATERIALS, "DIAMOND_SWORD", "IRON_SWORD", "STONE_SWORD", "GOLDEN_SWORD", "WOODEN_SWORD");
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("DIAMOND_SWORD"), 7.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("IRON_SWORD"), 6.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("STONE_SWORD"), 5.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("GOLDEN_SWORD"), 4.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("WOODEN_SWORD"), 4.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("TRIDENT"), 8.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("BOOK"), 6.0);
            OTHER_RANGED_MATERIALS.add(SentinelVersionCompat.getMaterial("TRIDENT"));
            SentinelVersionCompat.addAllMaterials(PICKAXE_MATERIALS, "DIAMOND_PICKAXE", "IRON_PICKAXE", "STONE_PICKAXE", "GOLDEN_PICKAXE", "WOODEN_PICKAXE");
            SentinelVersionCompat.allMaterialsTo(WEAPON_DAMAGE_MULTIPLIERS, PICKAXE_MATERIALS, 3.0);
            SentinelVersionCompat.addAllMaterials(AXE_MATERIALS, "DIAMOND_AXE", "IRON_AXE", "STONE_AXE", "GOLDEN_AXE", "WOODEN_AXE");
            SentinelVersionCompat.allMaterialsTo(WEAPON_DAMAGE_MULTIPLIERS, AXE_MATERIALS, 9.0);
            BOW_MATERIALS.add(SentinelVersionCompat.getMaterial("BOW"));
            SentinelVersionCompat.addAllMaterials(HELMET_MATERIALS, "DIAMOND_HELMET", "GOLDEN_HELMET", "IRON_HELMET", "LEATHER_HELMET", "CHAINMAIL_HELMET", "TURTLE_HELMET");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("DIAMOND_HELMET"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("GOLDEN_HELMET"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("IRON_HELMET"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("LEATHER_HELMET"), 0.04);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("CHAINMAIL_HELMET"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("TURTLE_HELMET"), 0.08);
            SentinelVersionCompat.addAllMaterials(CHESTPLATE_MATERIALS, "DIAMOND_CHESTPLATE", "GOLDEN_CHESTPLATE", "IRON_CHESTPLATE", "LEATHER_CHESTPLATE", "CHAINMAIL_CHESTPLATE");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("DIAMOND_CHESTPLATE"), 0.32);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("GOLDEN_CHESTPLATE"), 0.2);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("IRON_CHESTPLATE"), 0.24);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("LEATHER_CHESTPLATE"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("CHAINMAIL_CHESTPLATE"), 0.2);
            SentinelVersionCompat.addAllMaterials(LEGGINGS_MATERIALS, "DIAMOND_LEGGINGS", "GOLDEN_LEGGINGS", "IRON_LEGGINGS", "LEATHER_LEGGINGS", "CHAINMAIL_LEGGINGS");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("DIAMOND_LEGGINGS"), 0.24);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("GOLDEN_LEGGINGS"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("IRON_LEGGINGS"), 0.2);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("LEATHER_LEGGINGS"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("CHAINMAIL_LEGGINGS"), 0.16);
            SentinelVersionCompat.addAllMaterials(BOOTS_MATERIALS, "DIAMOND_BOOTS", "GOLDEN_BOOTS", "IRON_BOOTS", "LEATHER_BOOTS", "CHAINMAIL_BOOTS");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("DIAMOND_BOOTS"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("GOLDEN_BOOTS"), 0.04);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("IRON_BOOTS"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("LEATHER_BOOTS"), 0.04);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("CHAINMAIL_BOOTS"), 0.04);
            SentinelVersionCompat.addAllMaterials(POTION_MATERIALS, "POTION", "LINGERING_POTION", "SPLASH_POTION");
            SentinelVersionCompat.addAllMaterials(SKULL_MATERIALS, "WITHER_SKELETON_SKULL", "WITHER_SKELETON_WALL_SKULL");
            MATERIAL_SNOW_BALL = SentinelVersionCompat.getMaterial("SNOWBALL");
            SentinelVersionCompat.addAllMaterials(TRANSPARENT_BLOCKS, "CAVE_AIR", "VOID_AIR");
        } else {
            SentinelVersionCompat.addAllMaterials(SWORD_MATERIALS, "DIAMOND_SWORD", "IRON_SWORD", "STONE_SWORD", "GOLD_SWORD", "WOOD_SWORD");
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("DIAMOND_SWORD"), 7.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("IRON_SWORD"), 6.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("STONE_SWORD"), 5.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("GOLD_SWORD"), 4.0);
            WEAPON_DAMAGE_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("WOOD_SWORD"), 4.0);
            SentinelVersionCompat.addAllMaterials(PICKAXE_MATERIALS, "DIAMOND_PICKAXE", "IRON_PICKAXE", "STONE_PICKAXE", "GOLD_PICKAXE", "WOOD_PICKAXE");
            SentinelVersionCompat.allMaterialsTo(WEAPON_DAMAGE_MULTIPLIERS, PICKAXE_MATERIALS, 2.0);
            SentinelVersionCompat.addAllMaterials(AXE_MATERIALS, "DIAMOND_AXE", "IRON_AXE", "STONE_AXE", "GOLD_AXE", "WOOD_AXE");
            SentinelVersionCompat.allMaterialsTo(WEAPON_DAMAGE_MULTIPLIERS, AXE_MATERIALS, 3.0);
            BOW_MATERIALS.add(SentinelVersionCompat.getMaterial("BOW"));
            SentinelVersionCompat.addAllMaterials(HELMET_MATERIALS, "DIAMOND_HELMET", "GOLD_HELMET", "IRON_HELMET", "LEATHER_HELMET", "CHAINMAIL_HELMET");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("DIAMOND_HELMET"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("GOLD_HELMET"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("IRON_HELMET"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("LEATHER_HELMET"), 0.04);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("CHAINMAIL_HELMET"), 0.08);
            SentinelVersionCompat.addAllMaterials(CHESTPLATE_MATERIALS, "DIAMOND_CHESTPLATE", "GOLD_CHESTPLATE", "IRON_CHESTPLATE", "LEATHER_CHESTPLATE", "CHAINMAIL_CHESTPLATE");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("DIAMOND_CHESTPLATE"), 0.32);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("GOLD_CHESTPLATE"), 0.2);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("IRON_CHESTPLATE"), 0.24);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("LEATHER_CHESTPLATE"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("CHAINMAIL_CHESTPLATE"), 0.2);
            SentinelVersionCompat.addAllMaterials(LEGGINGS_MATERIALS, "DIAMOND_LEGGINGS", "GOLD_LEGGINGS", "IRON_LEGGINGS", "LEATHER_LEGGINGS", "CHAINMAIL_LEGGINGS");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("DIAMOND_LEGGINGS"), 0.24);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("GOLD_LEGGINGS"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("IRON_LEGGINGS"), 0.2);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("LEATHER_LEGGINGS"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("CHAINMAIL_LEGGINGS"), 0.16);
            SentinelVersionCompat.addAllMaterials(BOOTS_MATERIALS, "DIAMOND_BOOTS", "GOLD_BOOTS", "IRON_BOOTS", "LEATHER_BOOTS", "CHAINMAIL_BOOTS");
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("DIAMOND_BOOTS"), 0.12);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("GOLD_BOOTS"), 0.04);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("IRON_BOOTS"), 0.08);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("LEATHER_BOOTS"), 0.04);
            ARMOR_PROTECTION_MULTIPLIERS.put(SentinelVersionCompat.getMaterial("CHAINMAIL_BOOTS"), 0.04);
            if (v1_9) {
                SentinelVersionCompat.addAllMaterials(POTION_MATERIALS, "POTION", "LINGERING_POTION", "SPLASH_POTION");
            } else {
                SentinelVersionCompat.addAllMaterials(POTION_MATERIALS, "POTION");
            }
            SentinelVersionCompat.addAllMaterials(SKULL_MATERIALS, "SKULL", "SKULL_ITEM");
            MATERIAL_SNOW_BALL = SentinelVersionCompat.getMaterial("SNOW_BALL");
        }
        MATERIAL_NETHER_STAR = SentinelVersionCompat.getMaterial("NETHER_STAR");
        MATERIAL_BLAZE_ROD = SentinelVersionCompat.getMaterial("BLAZE_ROD");
        for (Material mat : Material.values()) {
            if (mat.name().startsWith("LEGACY_") || !mat.isBlock() || !mat.isTransparent() && mat.isSolid() && !mat.name().contains("GLASS") && !mat.name().contains("LEAVES") && !mat.name().contains("FENCE") && !mat.name().contains("SAPLING")) continue;
            TRANSPARENT_BLOCKS.add(mat);
        }
        SentinelVersionCompat.addAllMaterials(TRANSPARENT_BLOCKS, "COBWEB", "IRON_BARS", "FIRE", "AIR", "BARRIER", "WATER", "LAVA");
    }
}

