/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel;

import net.citizensnpcs.api.ai.TargetType;
import net.citizensnpcs.api.ai.flocking.AlignmentBehavior;
import net.citizensnpcs.api.ai.flocking.CohesionBehavior;
import net.citizensnpcs.api.ai.flocking.FlockBehavior;
import net.citizensnpcs.api.ai.flocking.Flocker;
import net.citizensnpcs.api.ai.flocking.NPCFlock;
import net.citizensnpcs.api.ai.flocking.RadiusNPCFlock;
import net.citizensnpcs.api.ai.flocking.SeparationBehavior;
import net.citizensnpcs.api.npc.NPC;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Sound;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.event.Event;
import org.bukkit.inventory.ItemStack;
import org.bukkit.potion.PotionEffect;
import org.bukkit.potion.PotionEffectType;
import org.bukkit.util.Vector;
import org.mcmonkey.sentinel.SentinelHelperObject;
import org.mcmonkey.sentinel.SentinelIntegration;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelUtilities;
import org.mcmonkey.sentinel.events.SentinelAttackEvent;
import org.mcmonkey.sentinel.utilities.SentinelVersionCompat;

public class SentinelAttackHelper
extends SentinelHelperObject {
    public static double HIGH_INFLUENCE = 0.05;
    public static double LOW_INFLUENCE = 0.005;
    public static double FLOCK_RADIUS = 3.0;

    public void chase(LivingEntity entity) {
        if (SentinelPlugin.debugMe) {
            this.debug("Try to begin chasing " + entity.getUniqueId() + "/" + entity.getType().name());
        }
        this.sentinel.cleverTicks = 0;
        if (!this.sentinel.tryUpdateChaseTarget(entity)) {
            return;
        }
        this.sentinel.chased = true;
        this.sentinel.needsSafeReturn = true;
        if (SentinelPlugin.instance.workaroundEntityChasePathfinder) {
            Location targetLocation = entity.getLocation().clone().add(SentinelUtilities.getVelocity((Entity)entity));
            if (this.getNPC().getNavigator().getTargetType() == TargetType.LOCATION && this.getNPC().getNavigator().getTargetAsLocation() != null && this.getNPC().getNavigator().getTargetAsLocation().getWorld().equals((Object)entity.getWorld()) && this.getNPC().getNavigator().getTargetAsLocation().distanceSquared(targetLocation) < 4.0) {
                this.debug("Refuse re-chase: already chasing close");
                return;
            }
            this.debug("Chase/location accepted, begin");
            this.getNPC().getNavigator().setTarget(targetLocation.add(new Vector(SentinelUtilities.randomDecimal(-1.0, 1.0), 0.0, SentinelUtilities.randomDecimal(-1.0, 1.0))));
            Location location = entity.getEyeLocation();
        } else {
            if (this.getNPC().getNavigator().getTargetType() == TargetType.ENTITY && SentinelUtilities.getTargetFor(this.getNPC().getNavigator().getEntityTarget()).getUniqueId().equals(entity.getUniqueId())) {
                this.debug("Refuse re-chase: already chasing entity");
                return;
            }
            this.debug("Chase/entity accepted, begin");
            this.getNPC().getNavigator().setTarget((Entity)entity, false);
            this.getNPC().getNavigator().getLocalParameters().addRunCallback((Runnable)SentinelAttackHelper.generateNewFlocker(this.getNPC(), FLOCK_RADIUS));
        }
        if (!this.sentinel.disableTeleporting) {
            this.getNPC().getNavigator().getLocalParameters().stuckAction(null);
        }
        this.sentinel.autoSpeedModifier();
    }

    public static Flocker generateNewFlocker(NPC npc, double radius) {
        RadiusNPCFlock flock = new RadiusNPCFlock(radius);
        return new Flocker(npc, (NPCFlock)flock, new FlockBehavior[]{new SeparationBehavior(LOW_INFLUENCE), new CohesionBehavior(LOW_INFLUENCE), new AlignmentBehavior(HIGH_INFLUENCE)});
    }

    public void rechase() {
        if (this.sentinel.chasing != null && (this.itemHelper.isRanged() ? this.sentinel.rangedChase : this.sentinel.closeChase)) {
            if (SentinelPlugin.debugMe) {
                this.sentinel.debug("Re-chasing own current target");
            }
            this.chase(this.sentinel.chasing);
        }
    }

    public boolean seesThreatFrom(LivingEntity entity) {
        if (!this.targetingHelper.canSee(entity)) {
            return false;
        }
        if (!SentinelUtilities.isLookingTowards(this.getLivingEntity().getEyeLocation(), entity.getLocation(), 60.0f, 60.0f)) {
            return false;
        }
        double dist = this.getLivingEntity().getEyeLocation().distanceSquared(entity.getEyeLocation());
        if (dist < 25.0) {
            return true;
        }
        return SentinelVersionCompat.isRangedWeapon(SentinelUtilities.getHeldItem(entity));
    }

    public void tryDefendFrom(LivingEntity entity) {
        if (!this.itemHelper.hasShield()) {
            if (!SentinelVersionCompat.v1_9 || !this.sentinel.autoswitch) {
                return;
            }
            if (!this.itemHelper.swapToShield()) {
                return;
            }
        }
        if (this.seesThreatFrom(entity)) {
            this.sentinel.startBlocking();
        } else {
            this.sentinel.stopBlocking();
        }
    }

    public boolean tryAttack(LivingEntity target) {
        if (this.tryAttackInternal(target)) {
            return true;
        }
        LivingEntity quickTarget = this.targetingHelper.findQuickMeleeTarget();
        if (quickTarget != null) {
            if (this.itemHelper.isRanged()) {
                if (!this.sentinel.autoswitch) {
                    return false;
                }
                this.itemHelper.swapToMelee();
                if (this.itemHelper.isRanged()) {
                    return false;
                }
            }
            if (this.tryAttackInternal(quickTarget)) {
                if (this.itemHelper.isRanged() ? this.sentinel.rangedChase : this.sentinel.closeChase) {
                    this.chase(target);
                }
                return true;
            }
            if (this.itemHelper.isRanged() ? this.sentinel.rangedChase : this.sentinel.closeChase) {
                this.chase(target);
            }
        }
        return false;
    }

    public boolean rangedPreCalculation(LivingEntity entity) {
        double dist = this.getLivingEntity().getEyeLocation().distanceSquared(entity.getEyeLocation());
        if (dist < this.sentinel.projectileRange * this.sentinel.projectileRange && this.targetingHelper.canSee(entity)) {
            if (this.sentinel.timeSinceAttack < (long)this.sentinel.attackRateRanged) {
                this.debug("tryAttack ranged refused, timeSinceAttack");
                if (this.sentinel.rangedChase) {
                    this.rechase();
                }
                return true;
            }
            this.sentinel.timeSinceAttack = 0L;
            return false;
        }
        if (this.sentinel.rangedChase) {
            this.debug("tryAttack ranged refused, range or visibility");
            this.chase(entity);
            return true;
        }
        return true;
    }

    public void rangedAmmoCalculation() {
        if (this.sentinel.needsAmmo) {
            this.itemHelper.takeOne();
            this.itemHelper.grabNextItem();
        }
    }

    public boolean tryAttackInternal(LivingEntity entity) {
        if (!entity.getWorld().equals((Object)this.getLivingEntity().getWorld())) {
            return false;
        }
        if (!this.getLivingEntity().hasLineOfSight((Entity)entity)) {
            if (this.sentinel.ignoreLOS || SentinelUtilities.checkLineOfSightWithTransparency(this.getLivingEntity(), entity)) {
                if (this.itemHelper.isRanged() ? this.sentinel.rangedChase : this.sentinel.closeChase) {
                    this.chase(entity);
                }
            } else if (!this.sentinel.getNPC().getNavigator().isNavigating()) {
                this.targetingHelper.informTargetHasNoLos(entity.getUniqueId());
            }
            return false;
        }
        ++this.sentinel.stats_attackAttempts;
        double dist = this.getLivingEntity().getEyeLocation().distanceSquared(entity.getEyeLocation());
        if (SentinelPlugin.debugMe) {
            this.debug("tryAttack at range " + (int)(Math.sqrt(dist) * 0.1) * 10);
        }
        if (this.sentinel.autoswitch && dist > this.sentinel.reach * this.sentinel.reach) {
            this.itemHelper.swapToRanged();
        } else if (this.sentinel.autoswitch && dist < this.sentinel.reach * this.sentinel.reach) {
            this.itemHelper.swapToMelee();
        }
        if (!this.sentinel.tryUpdateChaseTarget(entity)) {
            this.debug("tryAttack refused, cannot update target.");
            return false;
        }
        SentinelAttackEvent sat = new SentinelAttackEvent(this.getNPC(), entity);
        Bukkit.getPluginManager().callEvent((Event)sat);
        if (sat.isCancelled()) {
            this.debug("tryAttack refused, event cancellation");
            return false;
        }
        this.targetingHelper.addTarget(entity.getUniqueId());
        for (SentinelIntegration si : SentinelPlugin.integrations) {
            if (!si.tryAttack(this.sentinel, entity)) continue;
            if (SentinelPlugin.debugMe) {
                this.debug("tryAttack overridden by integration " + si.getClass().getName());
            }
            return true;
        }
        ItemStack weapon = this.itemHelper.getHeldItem();
        if (SentinelPlugin.debugMe) {
            this.debug("tryAttack will try weapon " + (weapon == null ? "air" : weapon.getType().name()));
        }
        if (this.itemHelper.usesBow(weapon)) {
            if (this.rangedPreCalculation(entity)) {
                return false;
            }
            ItemStack item = this.itemHelper.getArrow();
            if (item != null) {
                this.weaponHelper.fireArrow(item, entity.getEyeLocation(), entity.getVelocity());
                if (this.sentinel.needsAmmo) {
                    this.itemHelper.reduceDurability();
                    this.itemHelper.takeArrow();
                    this.itemHelper.grabNextItem();
                }
                return true;
            }
        } else {
            if (this.itemHelper.usesSnowball(weapon)) {
                if (this.rangedPreCalculation(entity)) {
                    return false;
                }
                this.weaponHelper.fireSnowball(entity.getEyeLocation());
                this.rangedAmmoCalculation();
                return true;
            }
            if (this.itemHelper.usesTrident(weapon)) {
                if (this.rangedPreCalculation(entity)) {
                    return false;
                }
                this.weaponHelper.fireTrident(entity.getEyeLocation());
                this.rangedAmmoCalculation();
                return true;
            }
            if (this.itemHelper.usesPotion(weapon)) {
                if (this.rangedPreCalculation(entity)) {
                    return false;
                }
                this.weaponHelper.firePotion(SentinelUtilities.getHeldItem(this.getLivingEntity()), entity.getEyeLocation(), entity.getVelocity());
                this.rangedAmmoCalculation();
                return true;
            }
            if (this.itemHelper.usesEgg(weapon)) {
                if (this.rangedPreCalculation(entity)) {
                    return false;
                }
                this.weaponHelper.fireEgg(entity.getEyeLocation());
                this.rangedAmmoCalculation();
                return true;
            }
            if (this.itemHelper.usesLlamaSpit(weapon)) {
                if (this.rangedPreCalculation(entity)) {
                    return false;
                }
                this.weaponHelper.fireLlamaSpit(entity.getEyeLocation());
                this.rangedAmmoCalculation();
                return true;
            }
            if (this.itemHelper.usesShulkerBullet(weapon)) {
                if (this.rangedPreCalculation(entity)) {
                    return false;
                }
                this.weaponHelper.fireShulkerBullet(entity);
                this.rangedAmmoCalculation();
                return true;
            }
            if (this.itemHelper.usesPearl(weapon)) {
                if (this.rangedPreCalculation(entity)) {
                    return false;
                }
                this.weaponHelper.firePearl(entity);
                this.rangedAmmoCalculation();
                return true;
            }
            if (this.itemHelper.usesWitherSkull(weapon)) {
                if (this.rangedPreCalculation(entity)) {
                    return false;
                }
                this.weaponHelper.fireSkull(entity.getEyeLocation());
                this.rangedAmmoCalculation();
                return true;
            }
            if (this.itemHelper.usesFireball(weapon)) {
                if (this.rangedPreCalculation(entity)) {
                    return false;
                }
                this.weaponHelper.fireFireball(entity.getEyeLocation());
                this.rangedAmmoCalculation();
                return true;
            }
            if (this.itemHelper.usesFangsBook(weapon)) {
                if (this.rangedPreCalculation(entity)) {
                    return false;
                }
                this.weaponHelper.fireEvokerFangs(entity.getEyeLocation());
                this.rangedAmmoCalculation();
                return true;
            }
            if (this.itemHelper.usesLightning(weapon)) {
                if (this.rangedPreCalculation(entity)) {
                    return false;
                }
                this.sentinel.swingWeapon();
                entity.getWorld().strikeLightningEffect(entity.getLocation());
                if (SentinelPlugin.debugMe) {
                    this.debug("Lightning hits for " + this.sentinel.getDamage(false));
                }
                entity.damage(this.sentinel.getDamage(false));
                this.rangedAmmoCalculation();
                return true;
            }
            if (this.itemHelper.usesSpectral(weapon)) {
                if (this.rangedPreCalculation(entity)) {
                    return false;
                }
                if (!entity.isGlowing()) {
                    this.sentinel.swingWeapon();
                    try {
                        Sound snd = SentinelPlugin.instance.spectralSound;
                        if (snd != null) {
                            entity.getWorld().playSound(entity.getLocation(), snd, 1.0f, 1.0f);
                        }
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    entity.addPotionEffect(new PotionEffect(PotionEffectType.GLOWING, 1200, 1));
                }
                this.rangedAmmoCalculation();
                return true;
            }
            if (dist < this.sentinel.reach * this.sentinel.reach) {
                if (this.sentinel.timeSinceAttack < (long)this.sentinel.attackRate) {
                    this.debug("tryAttack melee refused, timeSinceAttack");
                    if (this.sentinel.closeChase) {
                        this.rechase();
                    }
                    return false;
                }
                this.sentinel.timeSinceAttack = 0L;
                this.debug("tryAttack melee passed!");
                this.weaponHelper.punch(entity);
                if (this.sentinel.needsAmmo && this.itemHelper.shouldTakeDura()) {
                    this.itemHelper.reduceDurability();
                    this.itemHelper.grabNextItem();
                }
                return true;
            }
            if (this.sentinel.closeChase) {
                this.debug("tryAttack melee refused, range");
                this.chase(entity);
                return false;
            }
        }
        return false;
    }
}

