/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel;

import java.util.function.Function;
import net.citizensnpcs.api.trait.trait.Inventory;
import org.bukkit.Material;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.mcmonkey.sentinel.SentinelHelperObject;
import org.mcmonkey.sentinel.SentinelIntegration;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelUtilities;
import org.mcmonkey.sentinel.utilities.SentinelVersionCompat;

public class SentinelItemHelper
extends SentinelHelperObject {
    public ItemStack getArrow() {
        ItemStack[] items;
        if (!this.getNPC().hasTrait(Inventory.class)) {
            return this.sentinel.needsAmmo ? null : new ItemStack(Material.ARROW, 1);
        }
        Inventory inv = (Inventory)this.getNPC().getOrAddTrait(Inventory.class);
        for (ItemStack item : items = inv.getContents()) {
            Material mat;
            if (item == null || (mat = item.getType()) != Material.ARROW && (!SentinelVersionCompat.v1_9 || mat != Material.TIPPED_ARROW && mat != Material.SPECTRAL_ARROW) && (!SentinelVersionCompat.v1_14 || mat != Material.FIREWORK_ROCKET)) continue;
            return item.clone();
        }
        return this.sentinel.needsAmmo ? null : new ItemStack(Material.ARROW, 1);
    }

    public void reduceDurability() {
        ItemStack item = this.getHeldItem();
        if (item != null && item.getType() != Material.AIR) {
            ItemStack toSet;
            if (item.getDurability() >= item.getType().getMaxDurability() - 1) {
                toSet = null;
            } else {
                item.setDurability((short)(item.getDurability() + 1));
                toSet = item;
            }
            if (this.getLivingEntity().getEquipment() == null) {
                return;
            }
            if (SentinelVersionCompat.v1_9) {
                this.getLivingEntity().getEquipment().setItemInMainHand(toSet);
            } else {
                this.getLivingEntity().getEquipment().setItemInHand(toSet);
            }
        }
    }

    public void takeArrow() {
        if (!this.getNPC().hasTrait(Inventory.class)) {
            return;
        }
        Inventory inv = (Inventory)this.getNPC().getOrAddTrait(Inventory.class);
        ItemStack[] items = inv.getContents();
        for (int i = 0; i < items.length; ++i) {
            Material mat;
            ItemStack item = items[i];
            if (item == null || (mat = item.getType()) != Material.ARROW && (!SentinelVersionCompat.v1_9 || mat != Material.TIPPED_ARROW && mat != Material.SPECTRAL_ARROW) && (!SentinelVersionCompat.v1_14 || mat != Material.FIREWORK_ROCKET)) continue;
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
                items[i] = item;
                inv.setContents(items);
                return;
            }
            items[i] = null;
            inv.setContents(items);
            return;
        }
    }

    public void takeOne() {
        ItemStack item = this.getHeldItem();
        if (item != null && item.getType() != Material.AIR) {
            ItemStack toSet;
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
                toSet = item;
            } else {
                toSet = null;
            }
            if (this.getLivingEntity().getEquipment() == null) {
                return;
            }
            if (SentinelVersionCompat.v1_9) {
                this.getLivingEntity().getEquipment().setItemInMainHand(toSet);
            } else {
                this.getLivingEntity().getEquipment().setItemInHand(toSet);
            }
        }
    }

    public void grabNextItem() {
        if (!this.getNPC().hasTrait(Inventory.class)) {
            return;
        }
        Inventory inv = (Inventory)this.getNPC().getOrAddTrait(Inventory.class);
        ItemStack[] items = inv.getContents();
        ItemStack held = items[0];
        if (held != null && held.getType() != Material.AIR) {
            return;
        }
        for (int i = 0; i < items.length; ++i) {
            Material mat;
            ItemStack item = items[i];
            if (item == null || !SentinelVersionCompat.isWeapon(mat = (item = item.clone()).getType())) continue;
            if (item.getAmount() > 1) {
                item.setAmount(item.getAmount() - 1);
                items[i] = item;
                items[0] = item.clone();
                items[0].setAmount(1);
                inv.setContents(items);
                item = item.clone();
                item.setAmount(1);
                return;
            }
            items[i] = new ItemStack(Material.AIR);
            items[0] = item.clone();
            inv.setContents(items);
            return;
        }
    }

    public boolean swapToShield() {
        if (!(SentinelVersionCompat.v1_9 && this.getNPC().isSpawned() && this.getNPC().hasTrait(Inventory.class))) {
            return false;
        }
        Inventory inv = (Inventory)this.getNPC().getOrAddTrait(Inventory.class);
        ItemStack[] items = inv.getContents();
        int index = -1;
        for (int i = 1; i < items.length; ++i) {
            if (items[i] == null || items[i].getType() != Material.SHIELD) continue;
            index = i;
            break;
        }
        if (index != -1 && index != 40) {
            ItemStack oldItem = SentinelUtilities.getOffhandItem(this.sentinel.getLivingEntity()).clone();
            ItemStack newItem = items[index].clone();
            items[index] = oldItem;
            if (items.length >= 40) {
                items[40] = newItem;
            }
            inv.setContents(items);
            this.sentinel.getLivingEntity().getEquipment().setItemInOffHand(newItem);
            return true;
        }
        return false;
    }

    public void swapToMatch(Function<ItemStack, Boolean> doSwap, boolean isRanged) {
        ItemStack held;
        if (!this.getNPC().isSpawned() || !this.getNPC().hasTrait(Inventory.class)) {
            return;
        }
        Inventory inv = (Inventory)this.getNPC().getOrAddTrait(Inventory.class);
        ItemStack[] items = inv.getContents();
        ItemStack itemStack = held = items[0] == null ? null : items[0].clone();
        if (doSwap.apply(held).booleanValue()) {
            return;
        }
        int bestIndex = -1;
        double bestDamage = -1.0;
        for (int i = 0; i < items.length; ++i) {
            double possibleDamage;
            if (this.sentinel.getLivingEntity() instanceof Player && i >= 36 && i <= 39 || !doSwap.apply(items[i]).booleanValue() || !((possibleDamage = this.sentinel.getDamage(isRanged, items[i])) > bestDamage)) continue;
            bestDamage = possibleDamage;
            bestIndex = i;
        }
        if (bestIndex != -1) {
            items[0] = items[bestIndex] == null ? null : items[bestIndex].clone();
            items[bestIndex] = held == null ? null : held.clone();
            inv.setContents(items);
            if (!(this.sentinel.getLivingEntity() instanceof Player)) {
                this.sentinel.getLivingEntity().getEquipment().setItemInMainHand(items[0]);
            }
            if (this.sentinel.getLivingEntity() instanceof Player && bestIndex == 40 && SentinelVersionCompat.v1_9 && this.sentinel.getLivingEntity().getEquipment() != null) {
                this.sentinel.getLivingEntity().getEquipment().setItemInOffHand(items[bestIndex]);
            }
        }
    }

    public void swapToOpenHand() {
        this.swapToMatch(i -> i == null || i.getType() == Material.AIR, false);
    }

    public void swapToRanged() {
        this.swapToMatch(i -> i != null && i.getType() != Material.AIR && this.isRanged((ItemStack)i), true);
    }

    public void swapToMelee() {
        this.swapToMatch(this::isMeleeWeapon, false);
    }

    public boolean hasShield() {
        if (SentinelVersionCompat.v1_9) {
            ItemStack item = SentinelUtilities.getOffhandItem(this.sentinel.getLivingEntity());
            return item != null && item.getType() == Material.SHIELD;
        }
        return false;
    }

    public boolean isMeleeWeapon(ItemStack item) {
        if (item == null || item.getType() == Material.AIR) {
            return false;
        }
        return SentinelVersionCompat.isWeapon((item = this.autoRedirect(item)).getType()) && !this.isRanged(item);
    }

    public boolean isRanged() {
        return this.isRanged(this.getHeldItem());
    }

    public boolean isRanged(ItemStack item) {
        if (this.usesBow(item) || this.usesFireball(item) || this.usesSnowball(item) || this.usesLightning(item) || this.usesEgg(item) || this.usesPearl(item) || this.usesWitherSkull(item) || this.usesTrident(item) || this.usesSpectral(item) || this.usesPotion(item) || this.usesLlamaSpit(item) || this.usesShulkerBullet(item)) {
            return true;
        }
        for (SentinelIntegration integration : SentinelPlugin.integrations) {
            if (!integration.itemIsRanged(this.sentinel, item)) continue;
            return true;
        }
        return false;
    }

    public ItemStack autoRedirect(ItemStack stack) {
        if (stack == null) {
            return null;
        }
        String redirect = this.sentinel.weaponRedirects.get(stack.getType().name().toLowerCase());
        if (redirect == null) {
            return stack;
        }
        Material mat = Material.valueOf((String)redirect.toUpperCase());
        ItemStack newStack = stack.clone();
        newStack.setType(mat);
        return newStack;
    }

    public ItemStack getHeldItem() {
        if (!this.getNPC().isSpawned()) {
            return null;
        }
        ItemStack stack = SentinelUtilities.getHeldItem(this.getLivingEntity());
        if (stack != null && stack.getType() != Material.AIR) {
            return this.autoRedirect(stack);
        }
        if (this.getNPC().hasTrait(Inventory.class)) {
            return this.autoRedirect(((Inventory)this.getNPC().getOrAddTrait(Inventory.class)).getContents()[0]);
        }
        return null;
    }

    public boolean usesBow(ItemStack it) {
        if (it == null) {
            return false;
        }
        if (SentinelVersionCompat.v1_14 && it.getType() == Material.CROSSBOW && this.getArrow() != null) {
            return true;
        }
        return it.getType() == Material.BOW && this.getArrow() != null;
    }

    public boolean usesFireball(ItemStack it) {
        return it != null && it.getType() == SentinelVersionCompat.MATERIAL_BLAZE_ROD;
    }

    public boolean usesSnowball(ItemStack it) {
        return it != null && it.getType() == SentinelVersionCompat.MATERIAL_SNOW_BALL;
    }

    public boolean usesLightning(ItemStack it) {
        return it != null && it.getType() == SentinelVersionCompat.MATERIAL_NETHER_STAR;
    }

    public boolean usesEgg(ItemStack it) {
        return it != null && it.getType() == Material.EGG;
    }

    public boolean usesPearl(ItemStack it) {
        return it != null && it.getType() == Material.ENDER_PEARL;
    }

    public boolean usesWitherSkull(ItemStack it) {
        if (!SentinelPlugin.instance.canUseSkull) {
            return false;
        }
        return it != null && SentinelVersionCompat.SKULL_MATERIALS.contains(it.getType());
    }

    public boolean usesTrident(ItemStack it) {
        if (!SentinelVersionCompat.v1_13) {
            return false;
        }
        return it != null && it.getType() == Material.TRIDENT;
    }

    public boolean usesSpectral(ItemStack it) {
        if (!SentinelVersionCompat.v1_10) {
            return false;
        }
        return it != null && it.getType() == Material.SPECTRAL_ARROW;
    }

    public boolean usesPotion(ItemStack it) {
        return it != null && SentinelVersionCompat.POTION_MATERIALS.contains(it.getType());
    }

    public boolean usesLlamaSpit(ItemStack it) {
        if (!SentinelVersionCompat.v1_16) {
            return false;
        }
        return it != null && it.getType() == Material.WHITE_DYE;
    }

    public boolean usesShulkerBullet(ItemStack it) {
        if (!SentinelPlugin.instance.canUseSkull) {
            return false;
        }
        if (!SentinelVersionCompat.v1_13) {
            return false;
        }
        return it != null && it.getType() == Material.SHULKER_SHELL;
    }

    public boolean usesFangsBook(ItemStack it) {
        if (!SentinelPlugin.instance.canUseSkull) {
            return false;
        }
        if (!SentinelVersionCompat.v1_13) {
            return false;
        }
        return it != null && it.getType() == Material.BOOK;
    }

    public boolean shouldTakeDura() {
        ItemStack it = this.getHeldItem();
        if (it == null) {
            return false;
        }
        Material type = it.getType();
        return SentinelVersionCompat.BOW_MATERIALS.contains(type) || SentinelVersionCompat.SWORD_MATERIALS.contains(type) || SentinelVersionCompat.PICKAXE_MATERIALS.contains(type) || SentinelVersionCompat.AXE_MATERIALS.contains(type);
    }
}

