/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel;

import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.InputStream;
import java.io.OutputStreamWriter;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.TraitInfo;
import net.citizensnpcs.api.trait.trait.Owner;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.Sound;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.EntityType;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;
import org.bukkit.plugin.java.JavaPlugin;
import org.bukkit.scheduler.BukkitRunnable;
import org.mcmonkey.sentinel.SentinelEventHandler;
import org.mcmonkey.sentinel.SentinelIntegration;
import org.mcmonkey.sentinel.SentinelTrait;
import org.mcmonkey.sentinel.SentinelUtilities;
import org.mcmonkey.sentinel.commands.SentinelCommand;
import org.mcmonkey.sentinel.integration.SentinelCrackShot;
import org.mcmonkey.sentinel.integration.SentinelFactions;
import org.mcmonkey.sentinel.integration.SentinelHealth;
import org.mcmonkey.sentinel.integration.SentinelNPCOwnedBy;
import org.mcmonkey.sentinel.integration.SentinelPermissions;
import org.mcmonkey.sentinel.integration.SentinelPotion;
import org.mcmonkey.sentinel.integration.SentinelSBScore;
import org.mcmonkey.sentinel.integration.SentinelSBTeams;
import org.mcmonkey.sentinel.integration.SentinelSimpleClans;
import org.mcmonkey.sentinel.integration.SentinelSimplePets;
import org.mcmonkey.sentinel.integration.SentinelSquads;
import org.mcmonkey.sentinel.integration.SentinelTowny;
import org.mcmonkey.sentinel.integration.SentinelUUID;
import org.mcmonkey.sentinel.integration.SentinelWar;
import org.mcmonkey.sentinel.metrics.BStatsMetricsLite;
import org.mcmonkey.sentinel.metrics.StatsRecord;
import org.mcmonkey.sentinel.targeting.SentinelTarget;
import org.mcmonkey.sentinel.utilities.ConfigUpdater;
import org.mcmonkey.sentinel.utilities.SentinelNMSHelper;
import org.mcmonkey.sentinel.utilities.SentinelVersionCompat;
import org.mcmonkey.sentinel.utilities.SentinelWorldGuardHelper;
import org.mcmonkey.sentinel.utilities.VelocityTracker;

public class SentinelPlugin
extends JavaPlugin {
    public static HashSet<String> validEventTargets = new HashSet<String>(Arrays.asList("pvp", "pve", "pv", "pvnpc", "pvsentinel", "guarded_fight", "eve", "ev", "message", "npcvnpc"));
    public static HashMap<String, SentinelTarget> targetOptions = new HashMap();
    public static HashMap<EntityType, HashSet<SentinelTarget>> entityToTargets = new HashMap();
    public static final HashMap<String, SentinelIntegration> integrationPrefixMap = new HashMap();
    public static final ArrayList<SentinelIntegration> integrations = new ArrayList();
    public static SentinelPlugin instance;
    public ArrayList<SentinelTrait> currentSentinelNPCs = new ArrayList();
    public Permission vaultPerms;
    public long tickTimeTotal = 0L;
    public double maxHealth;
    public int cleverTicks;
    public boolean canUseSkull;
    public boolean blockEvents;
    public boolean alternateDamage;
    public boolean workaroundDamage;
    public boolean doNativeAttack;
    public double minShootSpeed;
    public boolean workaroundDrops;
    public boolean deathMessages;
    public Sound spectralSound;
    public boolean ignoreInvisible;
    public int guardDistanceMinimum;
    public int guardDistanceSelectionRange;
    public boolean workaroundEntityChasePathfinder;
    public boolean autoCorrectpathfinderMode;
    @Deprecated
    public boolean protectFromIgnores;
    public int tickRate = 10;
    public int runAwayTime;
    public boolean noGuardDamage;
    public boolean blockSunburn;
    public boolean preventExplosionBlockDamage;
    public int arrowCleanupTime;
    public boolean hasWorldGuard;
    public boolean enhanceLosTraces;
    public boolean allowArmorStandTargets;
    public static boolean debugMe;

    public ArrayList<SentinelTrait> cleanCurrentList() {
        ArrayList<SentinelTrait> npcs = SentinelPlugin.instance.currentSentinelNPCs;
        for (int i = 0; i < npcs.size(); ++i) {
            if (npcs.get(i).validateOnList()) continue;
            --i;
        }
        return npcs;
    }

    public void tryGetPerms() {
        if (Bukkit.getServer().getPluginManager().getPlugin("Vault") == null) {
            return;
        }
        try {
            RegisteredServiceProvider rsp = Bukkit.getServer().getServicesManager().getRegistration(Permission.class);
            this.vaultPerms = (Permission)rsp.getProvider();
            this.getLogger().info("Vault linked! Group targets will work.");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void registerIntegration(SentinelIntegration integration) {
        integrations.add(integration);
        for (String prefix : integration.getTargetPrefixes()) {
            integrationPrefixMap.put(prefix, integration);
            SentinelCommand.addTargetTabCompletions.add(prefix + ":");
        }
    }

    private double findMaxHealth() {
        try {
            Class<?> clazz = Class.forName("org.spigotmc.SpigotConfig");
            Field maxHealthField = clazz.getField("maxHealth");
            maxHealthField.setAccessible(true);
            return maxHealthField.getDouble(null);
        }
        catch (Throwable ex) {
            this.getLogger().warning("Cannot find SpigotConfig to read the server's max health value.");
            ex.printStackTrace();
            return this.getConfig().getDouble("random.max health", 2000.0);
        }
    }

    public void loadConfigSettings() {
        this.reloadConfig();
        this.cleverTicks = this.getConfig().getInt("random.clever ticks", 10);
        this.canUseSkull = this.getConfig().getBoolean("random.skull allowed", true);
        this.blockEvents = this.getConfig().getBoolean("random.workaround bukkit events", false);
        this.alternateDamage = this.getConfig().getBoolean("random.enforce damage", false);
        this.workaroundDamage = this.getConfig().getBoolean("random.workaround damage", false);
        this.doNativeAttack = this.getConfig().getBoolean("random.do native attacks", true);
        this.minShootSpeed = this.getConfig().getDouble("random.shoot speed minimum", 20.0);
        this.workaroundDrops = this.getConfig().getBoolean("random.workaround drops", false) || this.blockEvents;
        this.deathMessages = this.getConfig().getBoolean("random.death messages", true);
        this.enhanceLosTraces = this.getConfig().getBoolean("random.enhance los traces", true);
        try {
            this.spectralSound = Sound.valueOf((String)this.getConfig().getString("random.spectral sound", "ENTITY_VILLAGER_YES"));
        }
        catch (Throwable e) {
            this.getLogger().warning("Sentinel Configuration value 'random.spectral sound' is set to an invalid sound name. This is usually an ignorable issue.");
        }
        this.ignoreInvisible = this.getConfig().getBoolean("random.ignore invisible targets");
        this.guardDistanceMinimum = this.getConfig().getInt("random.guard follow distance.minimum", 7);
        this.guardDistanceSelectionRange = this.getConfig().getInt("random.guard follow distance.selection range", 4);
        this.workaroundEntityChasePathfinder = this.getConfig().getBoolean("random.workaround entity chase pathfinder", true);
        this.protectFromIgnores = this.getConfig().getBoolean("random.protected", false);
        this.runAwayTime = this.getConfig().getInt("random.run away time");
        this.maxHealth = this.findMaxHealth();
        this.noGuardDamage = this.getConfig().getBoolean("random.no guard damage", true);
        this.arrowCleanupTime = this.getConfig().getInt("random.arrow cleanup time", 200);
        this.blockSunburn = this.getConfig().getBoolean("random.block sunburn", true);
        this.preventExplosionBlockDamage = this.getConfig().getBoolean("random.prevent explosion block damage", true);
        this.tickRate = this.getConfig().getInt("update rate", 10);
        this.autoCorrectpathfinderMode = this.getConfig().getBoolean("random.auto correct pathfinder mode", true);
        this.allowArmorStandTargets = this.getConfig().getBoolean("random.allow armor stand targets", false);
    }

    public void onEnable() {
        Object properConfigString;
        this.getLogger().info("Sentinel loading...");
        instance = this;
        this.getLogger().info("Running on java version: " + System.getProperty("java.version"));
        SentinelVersionCompat.init();
        CitizensAPI.getTraitFactory().registerTrait(TraitInfo.create(SentinelTrait.class).withName("sentinel"));
        this.saveDefaultConfig();
        try {
            InputStream properConfig = SentinelPlugin.class.getResourceAsStream("/config.yml");
            properConfigString = SentinelUtilities.streamToString(properConfig);
            properConfig.close();
            FileInputStream currentConfig = new FileInputStream(this.getDataFolder() + "/config.yml");
            String currentConfigString = SentinelUtilities.streamToString(currentConfig);
            currentConfig.close();
            String updated = ConfigUpdater.updateConfig(currentConfigString, (String)properConfigString);
            if (updated != null) {
                this.getLogger().info("Your config file is outdated. Automatically updating it...");
                FileOutputStream configOutput = new FileOutputStream(this.getDataFolder() + "/config.yml");
                OutputStreamWriter writer = new OutputStreamWriter(configOutput);
                writer.write(updated);
                writer.close();
                configOutput.close();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.loadConfigSettings();
        BukkitRunnable postLoad = new BukkitRunnable(){

            public void run() {
                for (NPC npc : CitizensAPI.getNPCRegistry()) {
                    if (npc.isSpawned() || !npc.hasTrait(SentinelTrait.class)) continue;
                    SentinelTrait sentinel = (SentinelTrait)npc.getOrAddTrait(SentinelTrait.class);
                    if (sentinel.respawnTime <= 0L) continue;
                    if (sentinel.spawnPoint == null && npc.getStoredLocation() == null) {
                        SentinelPlugin.this.getLogger().warning("NPC " + npc.getId() + " has a null spawn point and can't be spawned. Perhaps the world was deleted?");
                        continue;
                    }
                    npc.spawn(sentinel.spawnPoint == null ? npc.getStoredLocation() : sentinel.spawnPoint);
                }
            }
        };
        postLoad.runTaskLater((Plugin)this, 40L);
        new SentinelCommand().buildCommandHandler(this.getCommand("sentinel"));
        Bukkit.getPluginManager().registerEvents((Listener)new SentinelEventHandler(), (Plugin)this);
        try {
            properConfigString = new BStatsMetricsLite((Plugin)this);
        }
        catch (Throwable e) {
            e.printStackTrace();
        }
        new BukkitRunnable(){

            public void run() {
                if (!SentinelPlugin.this.getConfig().getBoolean("stats_opt_out", false)) {
                    StatsRecord.trigger();
                }
            }
        }.runTaskTimer((Plugin)this, 200L, 72000L);
        this.tryGetPerms();
        this.registerIntegration(new SentinelHealth());
        this.registerIntegration(new SentinelNPCOwnedBy());
        this.registerIntegration(new SentinelPermissions());
        this.registerIntegration(new SentinelPotion());
        this.registerIntegration(new SentinelSBScore());
        this.registerIntegration(new SentinelSBTeams());
        this.registerIntegration(new SentinelSquads());
        this.registerIntegration(new SentinelUUID());
        if (Bukkit.getPluginManager().getPlugin("Towny") != null) {
            try {
                this.registerIntegration(new SentinelTowny());
                this.getLogger().info("Sentinel found Towny! Adding support for it!");
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        if (Bukkit.getPluginManager().getPlugin("Factions") != null) {
            boolean canLoad = false;
            try {
                if (Class.forName("com.massivecraft.factions.RelationParticipator") != null) {
                    canLoad = true;
                }
            }
            catch (ClassNotFoundException ex) {
                this.getLogger().warning("You are running an unsupported fork of Factions that has listed itself as Factions. Sentinel will not load the integration for it. Please inform the developer of your Factions fork to set the plugin name and classpath to their own plugin, to avoid issues with plugins built for the official version of Factions.");
            }
            if (canLoad) {
                try {
                    this.registerIntegration(new SentinelFactions());
                    this.getLogger().info("Sentinel found Factions! Adding support for it!");
                }
                catch (Throwable ex) {
                    ex.printStackTrace();
                }
            }
        }
        if (Bukkit.getPluginManager().getPlugin("CrackShot") != null) {
            try {
                this.registerIntegration(new SentinelCrackShot());
                this.getLogger().info("Sentinel found CrackShot! Adding support for it!");
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        if (Bukkit.getPluginManager().getPlugin("SimpleClans") != null) {
            try {
                this.registerIntegration(new SentinelSimpleClans());
                this.getLogger().info("Sentinel found SimpleClans! Adding support for it!");
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        if (Bukkit.getPluginManager().getPlugin("War") != null) {
            try {
                this.registerIntegration(new SentinelWar());
                this.getLogger().info("Sentinel found War! Adding support for it!");
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        if (Bukkit.getPluginManager().getPlugin("SimplePets") != null) {
            try {
                this.registerIntegration(new SentinelSimplePets());
                this.getLogger().info("Sentinel found SimplePets! Adding support for it!");
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        if (Bukkit.getPluginManager().getPlugin("WorldGuard") != null) {
            try {
                new SentinelWorldGuardHelper();
                this.hasWorldGuard = true;
                this.getLogger().info("Sentinel found WorldGuard! Adding support for it!");
            }
            catch (Throwable ex) {
                ex.printStackTrace();
            }
        }
        new BukkitRunnable(){

            public void run() {
                ++SentinelPlugin.this.tickTimeTotal;
            }
        }.runTaskTimer((Plugin)this, 1L, 1L);
        Bukkit.getScheduler().scheduleSyncRepeatingTask((Plugin)this, VelocityTracker::runAll, 20L, 20L);
        SentinelNMSHelper.init();
        this.getLogger().info("Sentinel loaded!");
    }

    public void onDisable() {
        this.getLogger().info("Sentinel unloading...");
        this.getLogger().info("Sentinel unloaded!");
    }

    public SentinelTrait getSentinelFor(CommandSender sender) {
        NPC npc = CitizensAPI.getDefaultNPCSelector().getSelected(sender);
        if (npc == null) {
            return null;
        }
        return (SentinelTrait)npc.getTraitNullable(SentinelTrait.class);
    }

    public String getOwner(NPC npc) {
        return this.getOwner(npc, "Server/Unknown");
    }

    public String getOwner(NPC npc, String defName) {
        Owner trait = (Owner)npc.getOrAddTrait(Owner.class);
        if (trait.getOwnerId() == null) {
            return trait.getOwner();
        }
        OfflinePlayer player = Bukkit.getOfflinePlayer((UUID)trait.getOwnerId());
        if (player == null || !player.hasPlayedBefore() || player.getName() == null) {
            return defName;
        }
        return player.getName();
    }

    static {
        debugMe = false;
        for (EntityType type : EntityType.values()) {
            entityToTargets.put(type, new HashSet());
        }
    }
}

