/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel.commands;

import java.text.DecimalFormat;
import java.text.DecimalFormatSymbols;
import java.util.Locale;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.util.Paginator;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelTrait;
import org.mcmonkey.sentinel.commands.SentinelCommand;

public class SentinelInfoCommands {
    private static DecimalFormat twoDigitFormat = new DecimalFormat("0.00", new DecimalFormatSymbols(Locale.US));

    @Command(aliases={"sentinel"}, usage="info", desc="Shows info on the current NPC.", modifiers={"info"}, permission="sentinel.info", min=1, max=2)
    @Requirements(livingEntity=true, ownership=true, traits={SentinelTrait.class})
    public void info(CommandContext args, CommandSender sender, SentinelTrait sentinel) {
        OfflinePlayer player;
        String guardName = null;
        LivingEntity guarded = sentinel.getGuardingEntity();
        if (guarded != null) {
            guardName = guarded.getName();
        } else if (sentinel.guardedNPC >= 0 && CitizensAPI.getNPCRegistry().getById(sentinel.guardedNPC) != null) {
            guardName = "NPC " + sentinel.guardedNPC + ": " + CitizensAPI.getNPCRegistry().getById(sentinel.guardedNPC).getFullName();
        } else if (sentinel.getGuarding() != null && (player = Bukkit.getOfflinePlayer((UUID)sentinel.getGuarding())) != null && player.getName() != null) {
            guardName = player.getName();
        }
        Paginator paginator = new Paginator().header(SentinelCommand.prefixGood + sentinel.getNPC().getFullName()).enablePageSwitcher("/sentinel info $page");
        SentinelInfoCommands.addLineIfNeeded(paginator, "Owned by", SentinelPlugin.instance.getOwner(sentinel.getNPC(), ""));
        SentinelInfoCommands.addLineIfNeeded(paginator, "Guarding", guardName);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Damage", sentinel.damage + SentinelCommand.colorBasic + " Calculated: " + SentinelCommand.colorEmphasis + sentinel.getDamage(true));
        SentinelInfoCommands.addLineIfNeeded(paginator, "Armor", sentinel.armor + (sentinel.getNPC().isSpawned() ? SentinelCommand.colorBasic + " Calculated: " + SentinelCommand.colorEmphasis + sentinel.getArmor(sentinel.getLivingEntity()) : ""));
        SentinelInfoCommands.addLineIfNeeded(paginator, "Health", (sentinel.getNPC().isSpawned() ? sentinel.getLivingEntity().getHealth() + "/" : "") + sentinel.health);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Range", sentinel.range);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Avoidance Range", sentinel.avoidRange);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Attack Rate", (double)sentinel.attackRate / 20.0);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Ranged Attack Rate", (double)sentinel.attackRateRanged / 20.0);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Heal Rate", (double)sentinel.healRate / 20.0);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Respawn Time", (double)sentinel.respawnTime / 20.0);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Reaction Slowdown", (double)sentinel.reactionSlowdown / 20.0);
        float walkSpeed = sentinel.getNPC().getNavigator().getDefaultParameters().speedModifier();
        SentinelInfoCommands.addLineIfNeeded(paginator, "Move Speed", SentinelCommand.colorBasic + "Walking: " + SentinelCommand.colorEmphasis + walkSpeed + SentinelCommand.colorBasic + ", Attacking: " + SentinelCommand.colorEmphasis + sentinel.speed);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Accuracy", sentinel.accuracy);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Reach", sentinel.reach);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Projectile Range", sentinel.projectileRange);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Greeting", sentinel.greetingText);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Warning", sentinel.warningText);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Greeting Range", sentinel.greetRange);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Greeting Rate", sentinel.greetRate);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Guard Distance Minimum", sentinel.guardDistanceMinimum);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Guard Selection Range", sentinel.guardSelectionRange);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Invincibility Enabled", sentinel.invincible);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Protected Enabled", sentinel.protectFromIgnores);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Protect From Range", sentinel.protectFromRange);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Fightback Enabled", sentinel.fightback);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Ranged Chasing Enabled", sentinel.rangedChase);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Close-Quarters Chasing Enabled", sentinel.closeChase);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Maximum chase range", sentinel.chaseRange);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Safe-Shot Enabled", sentinel.safeShot);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Enemy-Drops Enabled", sentinel.enemyDrops);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Enemy Target Time", (double)sentinel.enemyTargetTime / 20.0);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Autoswitch Enabled", sentinel.autoswitch);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Needs-Ammo Enabled", sentinel.needsAmmo);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Realistic Targeting Enabled", sentinel.realistic);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Knockback allowed", sentinel.allowKnockback);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Run-Away Enabled", sentinel.runaway);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Squad", sentinel.squad);
        SentinelInfoCommands.addLineIfNeeded(paginator, "Spawnpoint", sentinel.spawnPoint == null ? "" : sentinel.spawnPoint.toVector().toBlockVector().toString());
        SentinelInfoCommands.addLineIfNeeded(paginator, "Per-weapon damage values", sentinel.weaponDamage.toString());
        SentinelInfoCommands.addLineIfNeeded(paginator, "Weapon redirections", sentinel.weaponRedirects.toString());
        SentinelInfoCommands.addLineIfNeeded(paginator, "Drops", sentinel.drops == null ? "" : Integer.valueOf(sentinel.drops.size()));
        SentinelInfoCommands.addLineIfNeeded(paginator, "Death XP", sentinel.deathXP);
        if (SentinelPlugin.instance.hasWorldGuard) {
            SentinelInfoCommands.addLineIfNeeded(paginator, "WorldGuard region limit", sentinel.worldguardRegion);
        }
        int page = 1;
        if (args.argsLength() == 2) {
            try {
                page = args.getInteger(1);
            }
            catch (NumberFormatException ex) {
                sender.sendMessage(SentinelCommand.prefixBad + "First argument must be a valid page number.");
            }
        }
        paginator.sendPage(sender, page);
    }

    private static void addLineIfNeeded(Paginator paginator, String name, Object value) {
        if (value == null || value instanceof String && (((String)value).isEmpty() || value.equals("{}"))) {
            return;
        }
        paginator.addLine(SentinelCommand.prefixGood + name + ": " + SentinelCommand.colorEmphasis + value);
    }

    @Command(aliases={"sentinel"}, usage="stats", desc="Shows statistics about the current NPC.", modifiers={"stats"}, permission="sentinel.info", min=1, max=1)
    @Requirements(livingEntity=true, ownership=true, traits={SentinelTrait.class})
    public void stats(CommandContext args, CommandSender sender, SentinelTrait sentinel) {
        sender.sendMessage(SentinelCommand.prefixGood + ChatColor.RESET + sentinel.getNPC().getFullName() + SentinelCommand.colorBasic + ": owned by " + ChatColor.RESET + SentinelPlugin.instance.getOwner(sentinel.getNPC()));
        sender.sendMessage(SentinelCommand.prefixGood + "Arrows fired: " + SentinelCommand.colorEmphasis + sentinel.stats_arrowsFired);
        sender.sendMessage(SentinelCommand.prefixGood + "Potions thrown: " + SentinelCommand.colorEmphasis + sentinel.stats_potionsThrown);
        sender.sendMessage(SentinelCommand.prefixGood + "Fireballs launched: " + SentinelCommand.colorEmphasis + sentinel.stats_fireballsFired);
        sender.sendMessage(SentinelCommand.prefixGood + "Snowballs thrown: " + SentinelCommand.colorEmphasis + sentinel.stats_snowballsThrown);
        sender.sendMessage(SentinelCommand.prefixGood + "Eggs thrown: " + SentinelCommand.colorEmphasis + sentinel.stats_eggsThrown);
        sender.sendMessage(SentinelCommand.prefixGood + "Pearls used: " + SentinelCommand.colorEmphasis + sentinel.stats_pearlsUsed);
        sender.sendMessage(SentinelCommand.prefixGood + "Skulls thrown: " + SentinelCommand.colorEmphasis + sentinel.stats_skullsThrown);
        sender.sendMessage(SentinelCommand.prefixGood + "Llama spits spat: " + SentinelCommand.colorEmphasis + sentinel.stats_llamaSpitShot);
        sender.sendMessage(SentinelCommand.prefixGood + "Shulker bullets shot: " + SentinelCommand.colorEmphasis + sentinel.stats_shulkerBulletsShot);
        sender.sendMessage(SentinelCommand.prefixGood + "Evoker fangs spawned: " + SentinelCommand.colorEmphasis + sentinel.stats_evokerFangsSpawned);
        sender.sendMessage(SentinelCommand.prefixGood + "Punches: " + SentinelCommand.colorEmphasis + sentinel.stats_punches);
        sender.sendMessage(SentinelCommand.prefixGood + "Times spawned: " + SentinelCommand.colorEmphasis + sentinel.stats_timesSpawned);
        sender.sendMessage(SentinelCommand.prefixGood + "Damage Given: " + SentinelCommand.colorEmphasis + sentinel.stats_damageGiven);
        sender.sendMessage(SentinelCommand.prefixGood + "Damage Taken: " + SentinelCommand.colorEmphasis + sentinel.stats_damageTaken);
        double minutesSpawned = (double)sentinel.stats_ticksSpawned / 1200.0;
        sender.sendMessage(SentinelCommand.prefixGood + "Minutes spawned: " + SentinelCommand.colorEmphasis + twoDigitFormat.format(minutesSpawned));
    }

    @Command(aliases={"sentinel"}, usage="debug", desc="Toggles debugging.", modifiers={"debug"}, permission="sentinel.debug", min=1, max=1)
    public void debug(CommandContext args, CommandSender sender) {
        SentinelPlugin.debugMe = !SentinelPlugin.debugMe;
        sender.sendMessage(SentinelCommand.prefixGood + "Toggled: " + SentinelPlugin.debugMe + "!");
    }

    @Command(aliases={"sentinel"}, usage="reload", desc="Reloads the configuration file.", modifiers={"reload"}, permission="sentinel.reload", min=1, max=1)
    public void reload(CommandContext args, CommandSender sender) {
        SentinelPlugin.instance.loadConfigSettings();
        sender.sendMessage(SentinelCommand.prefixGood + "Reloaded the config file.");
    }
}

