/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel.targeting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.ChatColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Mob;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.player.AsyncPlayerChatEvent;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.projectiles.ProjectileSource;
import org.mcmonkey.sentinel.SentinelIntegration;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelTrait;
import org.mcmonkey.sentinel.SentinelUtilities;
import org.mcmonkey.sentinel.commands.SentinelCommand;
import org.mcmonkey.sentinel.targeting.SentinelTarget;
import org.mcmonkey.sentinel.targeting.SentinelTargetLabel;

public class SentinelTargetList {
    public HashSet<SentinelTarget> targetsProcessed = new HashSet();
    public HashMap<String, ArrayList<CachedOtherTarget>> otherTargetCache = new HashMap();
    private int otherTargetSize = 0;
    public ArrayList<LivingEntity> tempTargeted = new ArrayList();
    @Persist(value="targets")
    public ArrayList<String> targets = new ArrayList();
    @Persist(value="byPlayerName")
    public ArrayList<String> byPlayerName = new ArrayList();
    @Persist(value="byNpcName")
    public ArrayList<String> byNpcName = new ArrayList();
    @Persist(value="byEntityName")
    public ArrayList<String> byEntityName = new ArrayList();
    @Persist(value="byHeldItem")
    public ArrayList<String> byHeldItem = new ArrayList();
    @Persist(value="byOffhandItem")
    public ArrayList<String> byOffhandItem = new ArrayList();
    @Persist(value="byEquippedItem")
    public ArrayList<String> byEquippedItem = new ArrayList();
    @Persist(value="byInventoryItem")
    public ArrayList<String> byInventoryItem = new ArrayList();
    @Persist(value="byGroup")
    public ArrayList<String> byGroup = new ArrayList();
    @Persist(value="byEvent")
    public ArrayList<String> byEvent = new ArrayList();
    @Persist(value="byStatus")
    public ArrayList<String> byStatus = new ArrayList();
    @Persist(value="byOther")
    public ArrayList<String> byOther = new ArrayList();
    @Persist(value="byAllInOne")
    public ArrayList<SentinelTargetList> byAllInOne = new ArrayList();
    @Persist(value="byMultiple")
    public ArrayList<SentinelTargetList> byMultiple = new ArrayList();

    public SentinelTargetList duplicate() {
        SentinelTargetList result = new SentinelTargetList();
        result.targets.addAll(this.targets);
        result.byPlayerName.addAll(this.byPlayerName);
        result.byNpcName.addAll(this.byNpcName);
        result.byEntityName.addAll(this.byEntityName);
        result.byHeldItem.addAll(this.byHeldItem);
        result.byOffhandItem.addAll(this.byOffhandItem);
        result.byEquippedItem.addAll(this.byEquippedItem);
        result.byInventoryItem.addAll(this.byInventoryItem);
        result.byGroup.addAll(this.byGroup);
        result.byEvent.addAll(this.byEvent);
        result.byStatus.addAll(this.byStatus);
        result.byOther.addAll(this.byOther);
        result.byMultiple.addAll(this.byMultiple);
        result.byAllInOne.addAll(this.byAllInOne);
        return result;
    }

    public void init() {
        this.recalculateTargetsCache();
        for (String str : new ArrayList<String>(this.byEvent)) {
            if (!str.startsWith("message,")) continue;
            this.byEvent.remove(str);
            this.byEvent.add("message:" + str.substring("message,".length()));
        }
    }

    public boolean isTarget(LivingEntity entity, SentinelTrait sentinel) {
        this.checkRecalculateTargetsCache();
        if (this.targetsProcessed.contains(SentinelTarget.OWNER) && SentinelUtilities.uuidEquals(entity.getUniqueId(), ((Owner)sentinel.getNPC().getOrAddTrait(Owner.class)).getOwnerId())) {
            return true;
        }
        return this.isTargetNoCache(entity);
    }

    public boolean isTarget(LivingEntity entity) {
        this.checkRecalculateTargetsCache();
        return this.isTargetNoCache(entity);
    }

    public boolean isTargetNoCache(LivingEntity entity) {
        if (this.totalTargetsCount() == 0) {
            return false;
        }
        if (entity.getEquipment() != null) {
            if (SentinelUtilities.isItemTarget(SentinelUtilities.getHeldItem(entity), this.byHeldItem)) {
                return true;
            }
            if (SentinelUtilities.isItemTarget(SentinelUtilities.getOffhandItem(entity), this.byOffhandItem)) {
                return true;
            }
            if (!this.byEquippedItem.isEmpty()) {
                if (SentinelUtilities.isItemTarget(entity.getEquipment().getHelmet(), this.byEquippedItem)) {
                    return true;
                }
                if (SentinelUtilities.isItemTarget(entity.getEquipment().getChestplate(), this.byEquippedItem)) {
                    return true;
                }
                if (SentinelUtilities.isItemTarget(entity.getEquipment().getLeggings(), this.byEquippedItem)) {
                    return true;
                }
                if (SentinelUtilities.isItemTarget(entity.getEquipment().getBoots(), this.byEquippedItem)) {
                    return true;
                }
            }
        }
        if (entity instanceof InventoryHolder && !this.byInventoryItem.isEmpty()) {
            for (ItemStack item : ((InventoryHolder)entity).getInventory().getStorageContents()) {
                if (!SentinelUtilities.isItemTarget(item, this.byInventoryItem)) continue;
                return true;
            }
        }
        for (ArrayList arrayList : this.otherTargetCache.values()) {
            for (CachedOtherTarget target : arrayList) {
                if (!target.integration.isTarget(entity, target.prefix, target.value)) continue;
                return true;
            }
        }
        for (SentinelTargetList sentinelTargetList : this.byAllInOne) {
            SentinelTargetList subList = sentinelTargetList.duplicate();
            subList.recalculateCacheNoClear();
            if (SentinelPlugin.debugMe) {
                SentinelPlugin.instance.getLogger().info("All-In-One Debug: " + subList.totalTargetsCount() + " at start: " + subList.toMultiTargetString());
            }
            while (subList.ifIsTargetDeleteTarget(entity)) {
            }
            if (subList.totalTargetsCount() == 0) {
                return true;
            }
            if (!SentinelPlugin.debugMe) continue;
            SentinelPlugin.instance.getLogger().info("All-In-One Debug: " + subList.totalTargetsCount() + " left: " + subList.toMultiTargetString());
        }
        if (entity.hasMetadata("NPC")) {
            if (this.targetsProcessed.contains(SentinelTarget.NPCS)) {
                return true;
            }
            NPC theNPC = CitizensAPI.getNPCRegistry().getNPC((Entity)entity);
            if (theNPC == null) {
                return false;
            }
            return SentinelUtilities.isRegexTargeted(theNPC.getName(), this.byNpcName);
        }
        if (entity instanceof Player) {
            if (SentinelUtilities.isRegexTargeted(((Player)entity).getName(), this.byPlayerName)) {
                return true;
            }
            if (SentinelPlugin.instance.vaultPerms != null) {
                for (String string : this.byGroup) {
                    if (!SentinelPlugin.instance.vaultPerms.playerInGroup((Player)entity, string)) continue;
                    return true;
                }
            }
        } else if (SentinelUtilities.isRegexTargeted(entity.getCustomName() == null ? entity.getType().name() : entity.getCustomName(), this.byEntityName)) {
            return true;
        }
        if (this.byStatus.contains("angry") && entity instanceof Mob && ((Mob)entity).getTarget() != null) {
            return true;
        }
        if (this.byStatus.contains("passive") && entity instanceof Mob && ((Mob)entity).getTarget() == null) {
            return true;
        }
        HashSet<SentinelTarget> possible = SentinelPlugin.entityToTargets.get(entity.getType());
        if (possible != null) {
            for (SentinelTarget poss : possible) {
                if (!this.targetsProcessed.contains(poss)) continue;
                return true;
            }
        }
        return false;
    }

    public boolean ifIsTargetDeleteTarget(LivingEntity entity) {
        Object match;
        if (this.totalTargetsCount() == 0) {
            return false;
        }
        if (entity.getEquipment() != null) {
            match = SentinelUtilities.getItemTarget(SentinelUtilities.getHeldItem(entity), this.byHeldItem);
            if (match != null) {
                this.byHeldItem.remove(match);
                return true;
            }
            match = SentinelUtilities.getItemTarget(SentinelUtilities.getOffhandItem(entity), this.byOffhandItem);
            if (match != null) {
                this.byOffhandItem.remove(match);
                return true;
            }
            if (!this.byEquippedItem.isEmpty()) {
                match = SentinelUtilities.getItemTarget(entity.getEquipment().getHelmet(), this.byEquippedItem);
                if (match != null) {
                    this.byEquippedItem.remove(match);
                    return true;
                }
                match = SentinelUtilities.getItemTarget(entity.getEquipment().getChestplate(), this.byEquippedItem);
                if (match != null) {
                    this.byEquippedItem.remove(match);
                    return true;
                }
                match = SentinelUtilities.getItemTarget(entity.getEquipment().getLeggings(), this.byEquippedItem);
                if (match != null) {
                    this.byEquippedItem.remove(match);
                    return true;
                }
                match = SentinelUtilities.getItemTarget(entity.getEquipment().getBoots(), this.byEquippedItem);
                if (match != null) {
                    this.byEquippedItem.remove(match);
                    return true;
                }
            }
        }
        if (entity instanceof InventoryHolder && !this.byInventoryItem.isEmpty()) {
            for (ItemStack item : ((InventoryHolder)entity).getInventory().getStorageContents()) {
                String match2 = SentinelUtilities.getItemTarget(item, this.byInventoryItem);
                if (match2 == null) continue;
                this.byInventoryItem.remove(match2);
                return true;
            }
        }
        for (Map.Entry entry : this.otherTargetCache.entrySet()) {
            for (CachedOtherTarget target : (ArrayList)entry.getValue()) {
                if (!target.integration.isTarget(entity, target.prefix, target.value)) continue;
                this.byOther.remove(target.prefix + ":" + target.value);
                this.recalculateCacheNoClear();
                return true;
            }
        }
        for (SentinelTargetList sentinelTargetList : this.byAllInOne) {
            SentinelTargetList subList = sentinelTargetList.duplicate();
            subList.recalculateCacheNoClear();
            while (subList.ifIsTargetDeleteTarget(entity)) {
            }
            if (subList.totalTargetsCount() != 0) continue;
            this.byAllInOne.remove(sentinelTargetList);
            return true;
        }
        if (entity.hasMetadata("NPC")) {
            if (this.targetsProcessed.contains(SentinelTarget.NPCS)) {
                for (String string : this.targets) {
                    if (SentinelTarget.forName(string) != SentinelTarget.NPCS) continue;
                    this.targets.remove(string);
                    this.recalculateCacheNoClear();
                    return true;
                }
                this.targetsProcessed.remove(SentinelTarget.NPCS);
                return true;
            }
            match = SentinelUtilities.getRegexTarget(CitizensAPI.getNPCRegistry().getNPC((Entity)entity).getName(), this.byNpcName);
            if (match != null) {
                this.byNpcName.remove(match);
                return true;
            }
            return false;
        }
        if (entity instanceof Player) {
            match = SentinelUtilities.getRegexTarget(((Player)entity).getName(), this.byPlayerName);
            if (match != null) {
                this.byPlayerName.remove(match);
                return true;
            }
            if (SentinelPlugin.instance.vaultPerms != null) {
                for (String group : this.byGroup) {
                    if (!SentinelPlugin.instance.vaultPerms.playerInGroup((Player)entity, group)) continue;
                    this.byGroup.remove(group);
                    return true;
                }
            }
        } else {
            match = SentinelUtilities.getRegexTarget(entity.getCustomName() == null ? entity.getType().name() : entity.getCustomName(), this.byEntityName);
            if (match != null) {
                this.byEntityName.remove(match);
                return true;
            }
        }
        if (this.byStatus.contains("angry") && entity instanceof Mob && ((Mob)entity).getTarget() != null) {
            this.byStatus.remove("angry");
            return true;
        }
        if (this.byStatus.contains("passive") && entity instanceof Mob && ((Mob)entity).getTarget() == null) {
            this.byStatus.remove("passive");
            return true;
        }
        HashSet<SentinelTarget> possible = SentinelPlugin.entityToTargets.get(entity.getType());
        for (SentinelTarget poss : possible) {
            if (!this.targetsProcessed.contains(poss)) continue;
            for (String target : this.targets) {
                if (SentinelTarget.forName(target) != poss) continue;
                this.targets.remove(target);
                this.recalculateCacheNoClear();
                return true;
            }
            this.targetsProcessed.remove(poss);
            return true;
        }
        return false;
    }

    public void fillListFromKey(ArrayList<String> list, DataKey key) {
        for (DataKey listEntry : key.getSubKeys()) {
            list.add(listEntry.getRaw("").toString());
        }
    }

    public void updateOld(DataKey key, String name) {
        if (name.equals("playerName")) {
            this.fillListFromKey(this.byPlayerName, key);
        } else if (name.equals("npcName")) {
            this.fillListFromKey(this.byNpcName, key);
        } else if (name.equals("entityName")) {
            this.fillListFromKey(this.byEntityName, key);
        } else if (name.equals("heldItem")) {
            this.fillListFromKey(this.byHeldItem, key);
        } else if (name.equals("group")) {
            this.fillListFromKey(this.byGroup, key);
        } else if (name.equals("event")) {
            this.fillListFromKey(this.byEvent, key);
        } else if (name.equals("other")) {
            this.fillListFromKey(this.byOther, key);
        }
    }

    public boolean isEventTarget(SentinelTrait sentinel, AsyncPlayerChatEvent event) {
        if (!sentinel.targetingHelper.canSee((LivingEntity)event.getPlayer())) {
            return false;
        }
        for (String str : this.byEvent) {
            if (!str.startsWith("message:")) continue;
            String messageCheck = str.substring("message:".length());
            if (!event.getMessage().toLowerCase().contains(messageCheck.toLowerCase())) continue;
            return true;
        }
        return false;
    }

    public boolean isReverseEventTarget(SentinelTrait sentinel, EntityDamageByEntityEvent event) {
        return this.byEvent.contains("guarded_fight") && sentinel.getGuarding() != null && SentinelUtilities.uuidEquals(event.getDamager().getUniqueId(), sentinel.getGuarding());
    }

    public boolean isEventTarget(EntityDamageByEntityEvent event, SentinelTrait sentinel) {
        ProjectileSource source;
        Entity damager = event.getDamager();
        if (event.getDamager() instanceof Projectile && (source = ((Projectile)event.getDamager()).getShooter()) instanceof Entity) {
            damager = (Entity)source;
        }
        boolean damagerIsNPC = CitizensAPI.getNPCRegistry().isNPC(damager);
        if (damager.equals((Object)event.getEntity())) {
            return false;
        }
        for (String evt : this.byEvent) {
            SentinelTargetLabel label;
            SentinelTargetList list;
            if (evt.equals("pvp") && event.getEntity() instanceof Player && damager instanceof Player && !damagerIsNPC && !CitizensAPI.getNPCRegistry().isNPC(event.getEntity())) {
                return true;
            }
            if (evt.equals("pve") && !(event.getEntity() instanceof Player) && damager instanceof Player && !damagerIsNPC && event.getEntity() instanceof LivingEntity) {
                return true;
            }
            if (evt.equals("eve") && !(damager instanceof Player) && !damagerIsNPC && !(event.getEntity() instanceof Player) && event.getEntity() instanceof LivingEntity) {
                return true;
            }
            if (evt.equals("pvnpc") && event.getEntity() instanceof LivingEntity && damager instanceof Player && !damagerIsNPC && CitizensAPI.getNPCRegistry().isNPC(event.getEntity())) {
                return true;
            }
            if (evt.equals("pvsentinel") && event.getEntity() instanceof LivingEntity && damager instanceof Player && !damagerIsNPC && CitizensAPI.getNPCRegistry().isNPC(event.getEntity()) && CitizensAPI.getNPCRegistry().getNPC(event.getEntity()).hasTrait(SentinelTrait.class)) {
                return true;
            }
            if (evt.equals("npcvnpc") && CitizensAPI.getNPCRegistry().isNPC(damager) && CitizensAPI.getNPCRegistry().isNPC(event.getEntity())) {
                return true;
            }
            if (!evt.contains(":")) continue;
            int colon = evt.indexOf(58);
            String prefix = evt.substring(0, colon);
            String value = evt.substring(colon + 1);
            if (prefix.equals("pv") && !damagerIsNPC) {
                list = new SentinelTargetList();
                label = new SentinelTargetLabel(value);
                if (label.isValidTarget()) {
                    label.addToList(list);
                    if (!(damager instanceof Player) || !(event.getEntity() instanceof LivingEntity) || !list.isTarget((LivingEntity)event.getEntity(), sentinel)) continue;
                    return true;
                }
                sentinel.debug("Invalid event:pv: target label: " + value);
                continue;
            }
            if (!prefix.equals("ev") || damagerIsNPC) continue;
            list = new SentinelTargetList();
            label = new SentinelTargetLabel(value);
            if (label.isValidTarget()) {
                label.addToList(list);
                if (!(event.getEntity() instanceof LivingEntity) || !list.isTarget((LivingEntity)event.getEntity(), sentinel)) continue;
                return true;
            }
            sentinel.debug("Invalid event:ev: target label: " + value);
        }
        return false;
    }

    public void checkRecalculateTargetsCache() {
        if (this.targets.size() != this.targetsProcessed.size() || this.byOther.size() != this.otherTargetSize) {
            this.recalculateTargetsCache();
        }
    }

    public void recalculateCacheNoClear() {
        this.targetsProcessed.clear();
        for (String target : this.targets) {
            this.targetsProcessed.add(SentinelTarget.forName(target));
        }
        this.otherTargetCache.clear();
        for (String otherTarget : this.byOther) {
            int colon = otherTarget.indexOf(58);
            String before = otherTarget.substring(0, colon);
            String after = otherTarget.substring(colon + 1);
            SentinelIntegration integration = SentinelPlugin.integrationPrefixMap.get(before);
            if (integration == null) continue;
            ArrayList<CachedOtherTarget> subList = this.otherTargetCache.get(before);
            if (subList == null) {
                subList = new ArrayList();
                this.otherTargetCache.put(before, subList);
            }
            CachedOtherTarget targ = new CachedOtherTarget();
            targ.integration = integration;
            targ.prefix = before;
            targ.value = after;
            subList.add(targ);
        }
        this.otherTargetSize = this.byOther.size();
    }

    public void recalculateTargetsCache() {
        this.recalculateCacheNoClear();
        this.targets.clear();
        for (SentinelTarget target : this.targetsProcessed) {
            this.targets.add(target.name());
        }
    }

    public int totalTargetsCount() {
        return this.targets.size() + this.byPlayerName.size() + this.byNpcName.size() + this.byEntityName.size() + this.byHeldItem.size() + this.byOffhandItem.size() + this.byEquippedItem.size() + this.byInventoryItem.size() + this.byGroup.size() + this.byEvent.size() + this.byStatus.size() + this.byOther.size() + this.byAllInOne.size();
    }

    private static void addList(StringBuilder builder, ArrayList<String> strs, String prefix) {
        if (!strs.isEmpty()) {
            for (String str : strs) {
                if (prefix != null) {
                    builder.append(prefix).append(":");
                }
                builder.append(str).append(SentinelCommand.colorBasic).append(" ").append('\u0001').append(" ").append(SentinelCommand.colorEmphasis);
            }
        }
    }

    public String toComboString() {
        StringBuilder sb = new StringBuilder();
        SentinelTargetList.addList(sb, this.targets, null);
        SentinelTargetList.addList(sb, this.byPlayerName, "player");
        SentinelTargetList.addList(sb, this.byNpcName, "npc");
        SentinelTargetList.addList(sb, this.byEntityName, "entityname");
        SentinelTargetList.addList(sb, this.byHeldItem, "helditem");
        SentinelTargetList.addList(sb, this.byOffhandItem, "offhand");
        SentinelTargetList.addList(sb, this.byEquippedItem, "equipped");
        SentinelTargetList.addList(sb, this.byInventoryItem, "in_inventory");
        SentinelTargetList.addList(sb, this.byGroup, "group");
        SentinelTargetList.addList(sb, this.byEvent, "event");
        SentinelTargetList.addList(sb, this.byStatus, "status");
        SentinelTargetList.addList(sb, this.byOther, null);
        if (!this.byAllInOne.isEmpty()) {
            for (SentinelTargetList list : this.byAllInOne) {
                sb.append("allinone:").append(list.toAllInOneString()).append(SentinelCommand.colorBasic).append(" ").append('\u0001').append(" ").append(SentinelCommand.colorEmphasis);
            }
        }
        if (sb.length() == 0) {
            return "";
        }
        return sb.substring(0, sb.length() - (SentinelCommand.colorBasic + " . " + SentinelCommand.colorEmphasis).length());
    }

    private static void addRemovableString(ArrayList<String> output, ArrayList<String> targets, String prefix) {
        for (String target : targets) {
            if (prefix == null) {
                output.add(target.toLowerCase());
                continue;
            }
            output.add(prefix + ":" + target.toLowerCase());
        }
    }

    public List<String> getTargetRemovableStrings() {
        ArrayList<String> output = new ArrayList<String>();
        SentinelTargetList.addRemovableString(output, this.targets, null);
        SentinelTargetList.addRemovableString(output, this.byPlayerName, "player");
        SentinelTargetList.addRemovableString(output, this.byNpcName, "npc");
        SentinelTargetList.addRemovableString(output, this.byEntityName, "entityname");
        SentinelTargetList.addRemovableString(output, this.byHeldItem, "helditem");
        SentinelTargetList.addRemovableString(output, this.byOffhandItem, "offhand");
        SentinelTargetList.addRemovableString(output, this.byEquippedItem, "equipped");
        SentinelTargetList.addRemovableString(output, this.byInventoryItem, "in_inventory");
        SentinelTargetList.addRemovableString(output, this.byGroup, "group");
        SentinelTargetList.addRemovableString(output, this.byEvent, "event");
        SentinelTargetList.addRemovableString(output, this.byStatus, "status");
        SentinelTargetList.addRemovableString(output, this.byOther, null);
        for (SentinelTargetList list : this.byAllInOne) {
            output.add("allinone:" + ChatColor.stripColor((String)list.toAllInOneString().toLowerCase().replace(" ", "")));
        }
        for (SentinelTargetList list : this.byMultiple) {
            output.add("multi:" + ChatColor.stripColor((String)list.toMultiTargetString().toLowerCase().replace(" ", "")));
        }
        return output;
    }

    public String toMultiTargetString() {
        return this.toComboString().replace('\u0001', ',');
    }

    public String toAllInOneString() {
        return this.toComboString().replace('\u0001', '|');
    }

    public static class CachedOtherTarget {
        public SentinelIntegration integration;
        public String prefix;
        public String value;
    }
}

