/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel;

import java.util.AbstractMap;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.UUID;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.ai.StuckAction;
import net.citizensnpcs.api.ai.TeleportStuckAction;
import net.citizensnpcs.api.event.DespawnReason;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.persistence.Persister;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.trait.waypoint.WanderWaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoint;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import net.citizensnpcs.trait.waypoint.Waypoints;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.PlayerAnimation;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.configuration.file.FileConfiguration;
import org.bukkit.entity.Arrow;
import org.bukkit.entity.Enderman;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.IronGolem;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.entity.Projectile;
import org.bukkit.event.Event;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.PlayerDeathEvent;
import org.bukkit.event.player.PlayerMoveEvent;
import org.bukkit.event.player.PlayerTeleportEvent;
import org.bukkit.inventory.ItemStack;
import org.bukkit.plugin.Plugin;
import org.bukkit.projectiles.ProjectileSource;
import org.bukkit.scheduler.BukkitRunnable;
import org.bukkit.util.Vector;
import org.mcmonkey.sentinel.SentinelAttackHelper;
import org.mcmonkey.sentinel.SentinelItemHelper;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelUtilities;
import org.mcmonkey.sentinel.SentinelWeaponHelper;
import org.mcmonkey.sentinel.commands.SentinelCommand;
import org.mcmonkey.sentinel.events.SentinelChaseEndEvent;
import org.mcmonkey.sentinel.events.SentinelChaseNewTargetEvent;
import org.mcmonkey.sentinel.events.SentinelCombatStateChangeEvent;
import org.mcmonkey.sentinel.events.SentinelWantsToPathEvent;
import org.mcmonkey.sentinel.targeting.SentinelTarget;
import org.mcmonkey.sentinel.targeting.SentinelTargetLabel;
import org.mcmonkey.sentinel.targeting.SentinelTargetList;
import org.mcmonkey.sentinel.targeting.SentinelTargetingHelper;
import org.mcmonkey.sentinel.utilities.SentinelAPIBreakageFix;
import org.mcmonkey.sentinel.utilities.SentinelNMSHelper;
import org.mcmonkey.sentinel.utilities.SentinelVersionCompat;

public class SentinelTrait
extends Trait {
    public static final double healthMin = 0.01;
    public static final int attackRateMax = 2000;
    public static final int healRateMax = 2000;
    public SentinelTargetingHelper targetingHelper;
    public SentinelItemHelper itemHelper;
    public SentinelWeaponHelper weaponHelper;
    public SentinelAttackHelper attackHelper;
    @Persist(value="stats_ticksSpawned")
    public long stats_ticksSpawned = 0L;
    @Persist(value="stats_timesSpawned")
    public long stats_timesSpawned = 0L;
    @Persist(value="stats_arrowsFired")
    public long stats_arrowsFired = 0L;
    @Persist(value="stats_potionsThrow")
    public long stats_potionsThrown = 0L;
    @Persist(value="stats_fireballsFired")
    public long stats_fireballsFired = 0L;
    @Persist(value="stats_snowballsThrown")
    public long stats_snowballsThrown = 0L;
    @Persist(value="stats_eggsThrown")
    public long stats_eggsThrown = 0L;
    @Persist(value="stats_skullsThrown")
    public long stats_skullsThrown = 0L;
    @Persist(value="stats_llamaSpitShot")
    public long stats_llamaSpitShot = 0L;
    @Persist(value="stats_shulkerBulletsShot")
    public long stats_shulkerBulletsShot = 0L;
    @Persist(value="stats_evokerFangsSpawned")
    public long stats_evokerFangsSpawned = 0L;
    @Persist(value="stats_pearlsUsed")
    public long stats_pearlsUsed = 0L;
    @Persist(value="stats_punches")
    public long stats_punches = 0L;
    @Persist(value="stats_attackAttempts")
    public long stats_attackAttempts = 0L;
    @Persist(value="stats_damageTaken")
    public double stats_damageTaken = 0.0;
    @Persist(value="stats_damageGiven")
    public double stats_damageGiven = 0.0;
    @Persist(value="allTargets")
    public SentinelTargetList allTargets = new SentinelTargetList();
    @Persist(value="allIgnores")
    public SentinelTargetList allIgnores = new SentinelTargetList();
    @Persist(value="allAvoids")
    public SentinelTargetList allAvoids = new SentinelTargetList();
    @Persist
    public double avoidRange = 10.0;
    @Persist(value="range")
    public double range = 20.0;
    @Persist(value="damage")
    public double damage = -1.0;
    @Persist(value="armor")
    public double armor = -1.0;
    @Persist(value="health")
    public double health = 20.0;
    @Persist(value="ranged_chase")
    public boolean rangedChase = false;
    @Persist(value="close_chase")
    public boolean closeChase = true;
    @Persist(value="invincible")
    public boolean invincible = false;
    @Persist(value="protected")
    public boolean protectFromIgnores = false;
    @Persist(value="protectFromRange")
    public double protectFromRange = 0.0;
    @Persist(value="fightback")
    public boolean fightback = true;
    @Persist(value="runaway")
    public boolean runaway = false;
    @Persist(value="attackRate")
    public int attackRate = 30;
    @Persist(value="attackRateRanged")
    public int attackRateRanged = 30;
    @Persist(value="healRate")
    public int healRate = 100;
    @Persist(value="guardingUpper")
    public long guardingUpper = 0L;
    @Persist(value="guardingLower")
    public long guardingLower = 0L;
    @Persist(value="guardedNPC")
    public int guardedNPC = -1;
    @Persist(value="needsAmmo")
    public boolean needsAmmo = false;
    @Persist(value="safeShot")
    public boolean safeShot = true;
    @Persist(value="respawnTime")
    public long respawnTime = 100L;
    @Persist(value="chaseRange")
    public double chaseRange = 100.0;
    @Persist(value="spawnPoint")
    public Location spawnPoint = null;
    @Persist(value="avoidReturnPoint")
    public Location avoidReturnPoint = null;
    @Persist(value="drops")
    public ArrayList<ItemStack> drops = new ArrayList();
    @Persist(value="dropChances")
    public ArrayList<Double> dropChances = new ArrayList();
    @Persist(value="enemyDrops")
    public boolean enemyDrops = false;
    @Persist(value="enemyTargetTime")
    public long enemyTargetTime = 0L;
    @Persist(value="speed")
    public double speed = 1.0;
    @Persist(value="warning_text")
    public String warningText = "";
    @Persist(value="greeting_text")
    public String greetingText = "";
    @Persist(value="greet_range")
    public double greetRange = 10.0;
    @Persist(value="greet_rate")
    public int greetRate = 100;
    @Persist(value="autoswitch")
    public boolean autoswitch = false;
    @Persist(value="squad")
    public String squad = null;
    @Persist(value="accuracy")
    public double accuracy = 0.0;
    @Persist(value="realistic")
    public boolean realistic = false;
    @Persist(value="ignore_los")
    public boolean ignoreLOS = false;
    @Persist(value="reach")
    public double reach = 3.0;
    @Persist(value="projectileRange")
    public double projectileRange = 100.0;
    @Persist(value="guard_distance_minimum")
    public double guardDistanceMinimum = 7.0;
    @Persist(value="guard_selection_range")
    public double guardSelectionRange = 4.0;
    @Persist(value="retain_target")
    public boolean retainTarget = false;
    @Persist(value="weapon_damage_map")
    public HashMap<String, Double> weaponDamage = new HashMap();
    @Persist(value="weapon_redirect_map")
    public HashMap<String, String> weaponRedirects = new HashMap();
    @Persist(value="disable_teleporting")
    public boolean disableTeleporting = false;
    @Persist(value="reaction_slowdown")
    public int reactionSlowdown = 0;
    @Persist(value="allow_knockback")
    public boolean allowKnockback = true;
    @Persist(value="worldguard_region")
    public String worldguardRegion = null;
    @Persist(value="death_xp")
    public int deathXP = 0;
    public Object worldguardRegionCache = null;
    public LivingEntity chasing = null;
    public boolean isBlocking = false;
    private boolean canEnforce = false;
    private static EntityDamageEvent.DamageModifier[] modifiersToZero;
    public int ticksSinceLastBurn = 0;
    public long shieldAxeCooldown = 0L;
    private static Vector VECTOR_ZERO;
    private boolean hasShownFreshInitWarn = false;
    private EntityDamageByEntityEvent damageDeDup = null;
    public HashSet<UUID> greetedAlready = new HashSet();
    public HashMap<UUID, Long> lastGreetTime = new HashMap();
    public long timeSinceAttack = 0L;
    public long timeSinceHeal = 0L;
    int cleverTicks = 0;
    public boolean chased = false;
    private boolean visionMarked;
    public int ticksCountGuard = 0;
    public boolean needsToUnpause = false;
    public boolean otherBehaviorPaused = false;
    public Location pathingTo = null;
    public boolean needsSafeReturn = true;
    public int arrowResetTicker = 0;
    private Location lastLocationOnUpdate;
    private int ticksSinceMoved = 0;
    private boolean didCorrection = false;
    private static final double MAX_DIST = 1.0E8;
    public int cTick = 0;
    public BukkitRunnable respawnMe;
    public UUID lastEntityUUID;
    public HashSet<UUID> needsDropsClear = new HashSet();

    public SentinelTrait() {
        super("sentinel");
        this.targetingHelper = new SentinelTargetingHelper();
        this.itemHelper = new SentinelItemHelper();
        this.weaponHelper = new SentinelWeaponHelper();
        this.attackHelper = new SentinelAttackHelper();
        this.targetingHelper.setTraitObject(this);
        this.itemHelper.setTraitObject(this);
        this.weaponHelper.setTraitObject(this);
        this.attackHelper.setTraitObject(this);
    }

    public void load(final DataKey key) {
        new BukkitRunnable(){

            public void run() {
                SentinelTrait.this.updateOld(key);
            }
        }.runTaskLater((Plugin)SentinelPlugin.instance, 1L);
    }

    public void save(DataKey key) {
        for (DataKey subkey : key.getSubKeys()) {
            if (!subkey.name().equals("targets") && !subkey.name().equals("ignores") && !subkey.name().endsWith("Targets") && !subkey.name().endsWith("Ignores")) continue;
            key.removeKey(subkey.name());
        }
    }

    public void updateOld(DataKey key) {
        for (DataKey subkey : key.getSubKeys()) {
            if (subkey.name().equals("targets")) {
                for (DataKey listEntry : subkey.getSubKeys()) {
                    this.allTargets.targets.add(listEntry.getRaw("").toString());
                }
                this.allTargets.recalculateTargetsCache();
            } else if (subkey.name().equals("ignores")) {
                for (DataKey listEntry : subkey.getSubKeys()) {
                    this.allIgnores.targets.add(listEntry.getRaw("").toString());
                }
                this.allIgnores.recalculateTargetsCache();
            }
            if (subkey.name().endsWith("Targets")) {
                this.allTargets.updateOld(subkey, subkey.name().substring(0, subkey.name().length() - "Targets".length()));
                continue;
            }
            if (!subkey.name().endsWith("Ignores")) continue;
            this.allIgnores.updateOld(subkey, subkey.name().substring(0, subkey.name().length() - "Ignores".length()));
        }
    }

    public void addTarget(String target) {
        new SentinelTargetLabel(target).addToList(this.allTargets);
    }

    public void addIgnore(String target) {
        new SentinelTargetLabel(target).addToList(this.allIgnores);
    }

    public void addAvoid(String target) {
        new SentinelTargetLabel(target).addToList(this.allAvoids);
    }

    public void removeTarget(String target) {
        new SentinelTargetLabel(target).removeFromList(this.allTargets);
    }

    public void removeIgnore(String target) {
        new SentinelTargetLabel(target).removeFromList(this.allIgnores);
    }

    public void removeAvoid(String target) {
        new SentinelTargetLabel(target).removeFromList(this.allAvoids);
    }

    public void startBlocking() {
        if (!(this.npc.isSpawned() && this.getLivingEntity() instanceof Player && this.itemHelper.hasShield() && this.shieldAxeCooldown <= this.stats_ticksSpawned)) {
            if (this.isBlocking) {
                this.stopBlocking();
            }
            return;
        }
        if (SentinelPlugin.debugMe && !this.isBlocking) {
            this.debug("I'm scared! I'll block with my shield!");
        }
        this.isBlocking = true;
        PlayerAnimation.START_USE_OFFHAND_ITEM.play((Player)this.getLivingEntity());
        this.autoSpeedModifier();
    }

    public void stopBlocking() {
        if (!this.isBlocking) {
            return;
        }
        if (SentinelPlugin.debugMe) {
            this.debug("I'll put my shield down.");
        }
        this.isBlocking = false;
        if (!(this.npc.isSpawned() && this.getLivingEntity() instanceof Player && this.itemHelper.hasShield())) {
            return;
        }
        PlayerAnimation.STOP_USE_ITEM.play((Player)this.getLivingEntity());
        this.autoSpeedModifier();
    }

    public void autoSpeedModifier() {
        if (!this.getNPC().getNavigator().isNavigating()) {
            return;
        }
        double speedMod = this.isBlocking ? 0.6 : 1.0;
        this.getNPC().getNavigator().getLocalParameters().speedModifier((float)(this.speed * speedMod));
    }

    public UUID getGuarding() {
        NPC npc;
        if (this.guardedNPC >= 0 && (npc = CitizensAPI.getNPCRegistry().getById(this.guardedNPC)) != null) {
            return npc.getUniqueId();
        }
        if (this.guardingLower == 0L && this.guardingUpper == 0L) {
            return null;
        }
        return new UUID(this.guardingUpper, this.guardingLower);
    }

    public void setGuarding(int npcID) {
        this.guardingUpper = 0L;
        this.guardingLower = 0L;
        this.guardedNPC = npcID;
    }

    public void setGuarding(UUID uuid) {
        this.guardedNPC = -1;
        if (uuid == null) {
            this.guardingUpper = 0L;
            this.guardingLower = 0L;
        } else {
            this.guardingUpper = uuid.getMostSignificantBits();
            this.guardingLower = uuid.getLeastSignificantBits();
        }
    }

    public void whenImHurt(EntityDamageEvent event) {
        if (SentinelPlugin.debugMe) {
            this.debug("I'm hurt! By " + event.getCause().name() + " for " + event.getFinalDamage() + " hp");
        }
        switch (event.getCause()) {
            case FIRE: 
            case FIRE_TICK: 
            case LAVA: 
            case MELTING: {
                if (this.ticksSinceLastBurn <= 20) {
                    event.setDamage(0.0);
                    event.setCancelled(true);
                    return;
                }
                this.ticksSinceLastBurn = 0;
            }
        }
    }

    public boolean hitIsBlocked(Entity damager) {
        ItemStack held;
        if (!this.isBlocking) {
            return false;
        }
        if (!this.itemHelper.hasShield()) {
            this.isBlocking = false;
            return false;
        }
        if (!SentinelUtilities.isLookingTowards(this.getLivingEntity().getEyeLocation(), damager.getLocation(), 45.0f, 45.0f)) {
            return false;
        }
        if (SentinelVersionCompat.v1_14 && damager instanceof Arrow && ((Arrow)damager).getPierceLevel() > 0) {
            return false;
        }
        if (this.stats_ticksSpawned < this.shieldAxeCooldown) {
            return false;
        }
        ItemStack itemStack = held = damager instanceof LivingEntity ? SentinelUtilities.getHeldItem((LivingEntity)damager) : null;
        if (held != null && SentinelVersionCompat.AXE_MATERIALS.contains(held.getType()) && (!(damager instanceof Player) || ((Player)damager).isSprinting() || SentinelUtilities.random.nextInt(4) == 1)) {
            this.shieldAxeCooldown = this.stats_ticksSpawned + 100L;
        }
        return true;
    }

    public void whenAttacksAreHappeningToMe(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!this.getNPC().isSpawned()) {
            return;
        }
        if (!this.hasShownFreshInitWarn && this.stats_ticksSpawned < 6000L && this.fightback && event.getDamager() instanceof Player && ((Owner)this.npc.getOrAddTrait(Owner.class)).isOwnedBy(event.getDamager().getUniqueId()) && CitizensAPI.getDefaultNPCSelector().getSelected((CommandSender)event.getDamager()) == this.npc) {
            this.hasShownFreshInitWarn = true;
            if (this.allIgnores.totalTargetsCount() == 1 && this.allIgnores.targetsProcessed.contains(SentinelTarget.OWNER)) {
                event.getDamager().sendMessage(SentinelCommand.prefixGood + "Notice: if this is your first time setting up this NPC, don't forget to use " + SentinelCommand.colorEmphasis + "/sentinel removeignore owner" + SentinelCommand.colorBasic + " once you're done configuring the NPC, if you want it to be able to attack you.");
            }
        }
        double armorLevel = this.getArmor(this.getLivingEntity());
        if (this.hitIsBlocked(event.getDamager())) {
            armorLevel = (1.0 - armorLevel) * 0.5 + armorLevel;
        }
        if (!event.isApplicable(EntityDamageEvent.DamageModifier.ARMOR)) {
            event.setDamage(EntityDamageEvent.DamageModifier.BASE, (1.0 - armorLevel) * event.getDamage(EntityDamageEvent.DamageModifier.BASE));
        } else {
            event.setDamage(EntityDamageEvent.DamageModifier.ARMOR, -armorLevel * event.getDamage(EntityDamageEvent.DamageModifier.BASE));
        }
        for (EntityDamageEvent.DamageModifier modifier : modifiersToZero) {
            if (!event.isApplicable(modifier)) continue;
            event.setDamage(modifier, 0.0);
        }
        if (!this.allowKnockback) {
            this.getLivingEntity().setVelocity(VECTOR_ZERO);
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SentinelPlugin.instance, () -> {
                if (this.npc.isSpawned()) {
                    this.getLivingEntity().setVelocity(VECTOR_ZERO);
                }
            }, 1L);
        }
    }

    public void whenAttacksAreHappeningFromMe(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!this.npc.isSpawned()) {
            return;
        }
        if (SentinelPlugin.debugMe) {
            this.debug("Damage from me to " + event.getEntityType().name() + " of cause " + event.getCause().name());
        }
        if (SentinelVersionCompat.v1_9 && event.getCause() == EntityDamageEvent.DamageCause.ENTITY_SWEEP_ATTACK) {
            this.debug("Discard sweep damage");
            event.setCancelled(true);
            return;
        }
        if (SentinelPlugin.instance.alternateDamage) {
            if (this.canEnforce) {
                this.canEnforce = false;
                this.whenAttacksHappened(event);
                if (!event.isCancelled()) {
                    ((LivingEntity)event.getEntity()).damage(event.getFinalDamage());
                    if (event.getEntity() instanceof LivingEntity) {
                        this.weaponHelper.knockback((LivingEntity)event.getEntity(), 1.0f);
                    }
                }
                if (SentinelPlugin.debugMe) {
                    this.debug("enforce damage value to " + event.getFinalDamage());
                }
            } else {
                this.debug("refuse damage enforcement");
            }
            event.setDamage(0.0);
            event.setCancelled(true);
            return;
        }
        double damage = this.getDamage(false);
        if (SentinelPlugin.debugMe) {
            this.debug("correct base damage to " + damage);
        }
        event.setDamage(EntityDamageEvent.DamageModifier.BASE, damage);
    }

    public void whenAttacksAreHappeningFromMyArrow(EntityDamageByEntityEvent event) {
        if (event.isCancelled()) {
            return;
        }
        if (!this.npc.isSpawned()) {
            return;
        }
        if (SentinelPlugin.debugMe) {
            this.debug("Damage from my projectile to " + event.getEntityType().name() + " of cause " + event.getCause().name());
        }
        if (SentinelPlugin.instance.alternateDamage) {
            if (this.canEnforce) {
                this.canEnforce = false;
                this.whenAttacksHappened(event);
                if (!event.isCancelled()) {
                    ((LivingEntity)event.getEntity()).damage(this.getDamage(true));
                    if (event.getEntity() instanceof LivingEntity) {
                        this.weaponHelper.knockback((LivingEntity)event.getEntity(), 1.0f);
                    }
                }
                if (SentinelPlugin.debugMe) {
                    this.debug("enforce damage value to " + this.getDamage(true));
                }
            } else if (SentinelPlugin.debugMe) {
                this.debug("refuse damage enforcement");
            }
            event.setDamage(0.0);
            event.setCancelled(true);
            return;
        }
        double dam = this.getDamage(true);
        if (this.damage < 0.0 && SentinelUtilities.approxEquals(dam, 1.0)) {
            return;
        }
        double modder = event.getDamage(EntityDamageEvent.DamageModifier.BASE);
        double rel = modder == 0.0 ? 1.0 : dam / modder;
        event.setDamage(EntityDamageEvent.DamageModifier.BASE, dam);
        for (EntityDamageEvent.DamageModifier mod : EntityDamageEvent.DamageModifier.values()) {
            if (mod == EntityDamageEvent.DamageModifier.BASE || !event.isApplicable(mod)) continue;
            event.setDamage(mod, event.getDamage(mod) * rel);
            if (!SentinelPlugin.debugMe) continue;
            this.debug("Set damage for " + mod + " to " + event.getDamage(mod));
        }
    }

    public void whenAttacksHappened(EntityDamageByEntityEvent event) {
        boolean isMe;
        ProjectileSource source;
        if (!this.npc.isSpawned()) {
            return;
        }
        if (event.isCancelled()) {
            return;
        }
        if (event == this.damageDeDup) {
            return;
        }
        this.damageDeDup = event;
        Entity damager = event.getDamager();
        LivingEntity projectileSource = null;
        if (damager instanceof Projectile && (source = ((Projectile)damager).getShooter()) instanceof LivingEntity) {
            projectileSource = (LivingEntity)source;
            damager = projectileSource;
        }
        if ((isMe = event.getEntity().getUniqueId().equals(this.getLivingEntity().getUniqueId())) && (SentinelPlugin.instance.protectFromIgnores || this.protectFromIgnores)) {
            if (damager instanceof LivingEntity && this.targetingHelper.isIgnored((LivingEntity)damager)) {
                event.setCancelled(true);
                return;
            }
            if (projectileSource != null && this.targetingHelper.isIgnored(projectileSource)) {
                event.setCancelled(true);
                return;
            }
        }
        if (isMe && this.protectFromRange > 0.0) {
            Location loc1 = damager.getLocation();
            Location loc2 = this.getLivingEntity().getLocation();
            if (loc1.getWorld() != loc2.getWorld() || loc1.distanceSquared(loc2) > this.protectFromRange * this.protectFromRange) {
                event.setCancelled(true);
                return;
            }
        }
        boolean isKilling = event.getEntity() instanceof LivingEntity && event.getFinalDamage() >= ((LivingEntity)event.getEntity()).getHealth();
        boolean isFriend = this.getGuarding() != null && SentinelUtilities.uuidEquals(event.getEntity().getUniqueId(), this.getGuarding());
        boolean attackerIsMe = damager.getUniqueId().equals(this.getLivingEntity().getUniqueId());
        if (projectileSource != null && projectileSource.getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            attackerIsMe = true;
        }
        if (isMe || isFriend) {
            if (attackerIsMe) {
                if (SentinelPlugin.debugMe) {
                    this.debug("Ignoring damage I did to " + (isMe ? "myself." : "my friend."));
                }
                event.setCancelled(true);
                return;
            }
            if (this.getGuarding() != null && SentinelUtilities.uuidEquals(damager.getUniqueId(), this.getGuarding())) {
                if (isMe && SentinelPlugin.instance.noGuardDamage) {
                    this.debug("Ignoring damage from the player we're guarding.");
                    event.setCancelled(true);
                }
                return;
            }
            if (isMe) {
                this.stats_damageTaken += event.getFinalDamage();
                if (this.runaway) {
                    this.debug("Ow! They hit me! Run!");
                    this.targetingHelper.addAvoid(damager.getUniqueId());
                }
            }
            if (this.fightback && damager instanceof LivingEntity && !this.targetingHelper.isIgnored((LivingEntity)damager)) {
                if (SentinelPlugin.debugMe) {
                    this.debug("Fighting back against attacker: " + damager.getUniqueId() + "! They hurt " + (isMe ? "me!" : "my friend!"));
                }
                this.targetingHelper.addTarget(damager.getUniqueId());
                if (this.chasing == null && (this.itemHelper.isRanged() ? this.rangedChase : this.closeChase)) {
                    this.attackHelper.chase((LivingEntity)damager);
                }
            }
            if (SentinelPlugin.debugMe && isMe) {
                this.debug("Took damage of " + event.getFinalDamage() + " with currently remaining health " + this.getLivingEntity().getHealth() + (isKilling ? ". This will kill me." : "."));
            }
            if (isKilling && isMe && SentinelPlugin.instance.blockEvents) {
                this.debug("Died! Applying death workaround (due to config setting)");
                this.generalDeathHandler(this.getLivingEntity());
                this.npc.despawn(DespawnReason.PLUGIN);
                event.setCancelled(true);
                return;
            }
            return;
        }
        if (attackerIsMe) {
            if (this.safeShot && !this.targetingHelper.shouldTarget((LivingEntity)event.getEntity())) {
                event.setCancelled(true);
                return;
            }
            this.stats_damageGiven += event.getFinalDamage();
            if (!this.enemyDrops && event.getEntity().getType() != EntityType.PLAYER) {
                this.needsDropsClear.add(event.getEntity().getUniqueId());
                if (SentinelPlugin.debugMe) {
                    this.debug("This " + event.getEntity().getType() + " with id " + event.getEntity().getUniqueId() + " is being tracked for potential drops removal.");
                }
            }
            return;
        }
    }

    public void whenAnEnemyDies(UUID dead) {
        this.targetingHelper.removeTargetNoBounce(dead);
        this.targetingHelper.currentAvoids.remove(dead);
        if (this.chasing != null && this.chasing.getUniqueId().equals(dead)) {
            this.tryUpdateChaseTarget(null);
        }
        Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SentinelPlugin.instance, () -> {
            this.targetingHelper.removeTargetNoBounce(dead);
            this.targetingHelper.currentAvoids.remove(dead);
        }, 4L);
    }

    public void onAttach() {
        FileConfiguration config = SentinelPlugin.instance.getConfig();
        this.attackRate = config.getInt("sentinel defaults.attack rate", 30);
        this.healRate = config.getInt("sentinel defaults.heal rate", 100);
        this.respawnTime = config.getInt("sentinel defaults.respawn time", 100);
        this.rangedChase = config.getBoolean("sentinel defaults.ranged chase target", false);
        this.closeChase = config.getBoolean("sentinel defaults.close chase target", true);
        this.armor = config.getDouble("sentinel defaults.armor", -1.0);
        this.damage = config.getDouble("sentinel defaults.damage", -1.0);
        this.health = config.getDouble("sentinel defaults.health", 20.0);
        if (this.npc.isSpawned()) {
            this.getLivingEntity().setMaxHealth(this.health);
            this.getLivingEntity().setHealth(this.health);
        }
        this.setInvincible(config.getBoolean("sentinel defaults.invincible", false));
        this.protectFromIgnores = config.getBoolean("sentinel defaults.protected", false);
        this.fightback = config.getBoolean("sentinel defaults.fightback", true);
        this.needsAmmo = config.getBoolean("sentinel defaults.needs ammo", false);
        this.safeShot = config.getBoolean("sentinel defaults.safe shot", true);
        this.enemyDrops = config.getBoolean("sentinel defaults.enemy drops", false);
        this.enemyTargetTime = config.getInt("sentinel defaults.enemy target time", 0);
        this.speed = config.getDouble("sentinel defaults.speed", 1.5);
        if (this.speed <= 0.0) {
            this.speed = 1.0;
        }
        this.autoswitch = config.getBoolean("sentinel defaults.autoswitch", false);
        this.allIgnores.targets.add(SentinelTarget.OWNER.name());
        this.allIgnores.recalculateTargetsCache();
        this.reach = config.getDouble("sentinel defaults.reach", 3.0);
        this.projectileRange = config.getDouble("sentinel defaults.projectile range", 100.0);
        this.avoidRange = config.getDouble("sentinel defaults.avoid range", 10.0);
        this.runaway = config.getBoolean("sentinel defaults.runaway", false);
        this.greetRange = config.getDouble("sentinel defaults.greet range", 10.0);
        this.greetRate = config.getInt("sentinel defaults.greet rate", 100);
        this.retainTarget = config.getBoolean("random.retain target", false);
        this.reactionSlowdown = config.getInt("sentinel defaults.reaction slowdown", 0);
        this.deathXP = config.getInt("sentinel defaults.death xp", 0);
        this.allowKnockback = config.getBoolean("sentinel defaults.allow knockback", true);
        this.guardDistanceMinimum = SentinelPlugin.instance.guardDistanceMinimum;
        this.guardSelectionRange = SentinelPlugin.instance.guardDistanceSelectionRange;
        if (this.npc.isSpawned()) {
            SentinelPlugin.instance.currentSentinelNPCs.add(this);
            this.lastEntityUUID = this.getLivingEntity().getUniqueId();
        }
    }

    public void onRemove() {
        SentinelPlugin.instance.currentSentinelNPCs.remove((Object)this);
        if (!this.invincible) {
            this.npc.setProtected(true);
        }
    }

    public void useItem() {
        if (this.npc.isSpawned() && this.getLivingEntity() instanceof Player && SentinelVersionCompat.v1_9) {
            PlayerAnimation.START_USE_MAINHAND_ITEM.play((Player)this.getLivingEntity());
            BukkitRunnable runner = new BukkitRunnable(){

                public void run() {
                    if (SentinelTrait.this.npc.isSpawned() && SentinelTrait.this.getLivingEntity() instanceof Player) {
                        PlayerAnimation.STOP_USE_ITEM.play((Player)SentinelTrait.this.getLivingEntity());
                    }
                }
            };
            runner.runTaskLater((Plugin)SentinelPlugin.instance, 10L);
        }
    }

    public void swingWeapon() {
        if (!this.npc.isSpawned()) {
            return;
        }
        if (this.getLivingEntity() instanceof Player) {
            PlayerAnimation.ARM_SWING.play((Player)this.getLivingEntity());
        } else if (this.getLivingEntity() instanceof IronGolem) {
            SentinelNMSHelper.animateIronGolemSwing((IronGolem)this.getLivingEntity());
        } else if (SentinelVersionCompat.v1_15) {
            this.getLivingEntity().swingMainHand();
        }
    }

    public double firingMinimumRange() {
        EntityType type = this.getLivingEntity().getType();
        if (type == EntityType.WITHER || type == EntityType.GHAST) {
            return 8.0;
        }
        if (type == EntityType.BLAZE) {
            return 3.0;
        }
        if (type == EntityType.PLAYER && SentinelVersionCompat.v1_16) {
            return 0.1;
        }
        return 2.0;
    }

    public AbstractMap.SimpleEntry<Location, Vector> getLaunchDetail(Location target, Vector lead) {
        this.faceLocation(target);
        Location start = this.getLivingEntity().getEyeLocation().clone().add(this.getLivingEntity().getEyeLocation().getDirection().multiply(this.firingMinimumRange()));
        return SentinelUtilities.getLaunchDetail(start, target, lead);
    }

    public double randomAcc() {
        return SentinelUtilities.random.nextDouble() * this.accuracy * 2.0 - this.accuracy;
    }

    public Vector fixForAcc(Vector input) {
        if (Double.isInfinite(input.getX()) || Double.isNaN(input.getX())) {
            return new Vector(0, 0, 0);
        }
        return new Vector(input.getX() + this.randomAcc(), input.getY() + this.randomAcc(), input.getZ() + this.randomAcc());
    }

    public void faceLocation(Location l) {
        Location faceTowards = l.clone().subtract(0.0, this.getLivingEntity().getEyeHeight(), 0.0);
        Vector validator = l.toVector().subtract(this.getLivingEntity().getLocation().toVector());
        if (validator.lengthSquared() < 0.1 || Math.abs(validator.getX()) + Math.abs(validator.getZ()) < 0.01) {
            return;
        }
        this.npc.faceLocation(faceTowards);
        if (this.npc.getNavigator().isNavigating()) {
            // empty if block
        }
    }

    public double getDamage() {
        return this.getDamage(false);
    }

    public double getDamage(boolean forRangedAttacks) {
        ItemStack weapon = this.itemHelper.getHeldItem();
        return this.getDamage(forRangedAttacks, weapon);
    }

    public double getDamage(boolean forRangedAttacks, ItemStack weapon) {
        if (weapon == null) {
            if (this.damage >= 0.0) {
                return this.damage;
            }
            return 1.0;
        }
        Double customDamage = this.weaponDamage.get(weapon.getType().name().toLowerCase());
        if (customDamage != null) {
            this.damage = customDamage;
        }
        if (this.damage >= 0.0) {
            return this.damage;
        }
        double multiplier = 1.0;
        multiplier += weapon.getItemMeta() == null || !weapon.getItemMeta().hasEnchant(SentinelAPIBreakageFix.ENCHANTMENT_DAMAGE_ALL) ? 0.0 : (double)weapon.getItemMeta().getEnchantLevel(SentinelAPIBreakageFix.ENCHANTMENT_DAMAGE_ALL) * 0.2;
        Material weaponType = weapon.getType();
        if (SentinelVersionCompat.BOW_MATERIALS.contains(weaponType)) {
            if (!forRangedAttacks) {
                return 1.0;
            }
            return 6.0 * (1.0 + (weapon.getItemMeta() == null || !weapon.getItemMeta().hasEnchant(SentinelAPIBreakageFix.ENCHANTMENT_ARROW_DAMAGE) ? 0.0 : (double)weapon.getItemMeta().getEnchantLevel(SentinelAPIBreakageFix.ENCHANTMENT_ARROW_DAMAGE) * 0.3));
        }
        Double damageMult = SentinelVersionCompat.WEAPON_DAMAGE_MULTIPLIERS.get(weaponType);
        if (damageMult == null) {
            return multiplier;
        }
        return multiplier * damageMult;
    }

    public double getArmor(LivingEntity ent) {
        if (this.armor < 0.0) {
            ItemStack boots;
            Double bootsAdder;
            ItemStack leggings;
            Double leggingsAdder;
            ItemStack chestplate;
            Double chestplateAdder;
            Double helmetAdder;
            if (ent.getEquipment() == null) {
                return 0.0;
            }
            double baseArmor = 0.0;
            ItemStack helmet = ent.getEquipment().getHelmet();
            Double d = helmetAdder = helmet == null ? null : SentinelVersionCompat.ARMOR_PROTECTION_MULTIPLIERS.get(helmet.getType());
            if (helmetAdder != null) {
                baseArmor += helmetAdder.doubleValue();
            }
            Double d2 = chestplateAdder = (chestplate = ent.getEquipment().getChestplate()) == null ? null : SentinelVersionCompat.ARMOR_PROTECTION_MULTIPLIERS.get(chestplate.getType());
            if (chestplateAdder != null) {
                baseArmor += chestplateAdder.doubleValue();
            }
            Double d3 = leggingsAdder = (leggings = ent.getEquipment().getLeggings()) == null ? null : SentinelVersionCompat.ARMOR_PROTECTION_MULTIPLIERS.get(leggings.getType());
            if (leggingsAdder != null) {
                baseArmor += leggingsAdder.doubleValue();
            }
            Double d4 = bootsAdder = (boots = ent.getEquipment().getBoots()) == null ? null : SentinelVersionCompat.ARMOR_PROTECTION_MULTIPLIERS.get(boots.getType());
            if (bootsAdder != null) {
                baseArmor += bootsAdder.doubleValue();
            }
            return Math.min(baseArmor, 0.8);
        }
        return this.armor;
    }

    public LivingEntity getLivingEntity() {
        return (LivingEntity)this.npc.getEntity();
    }

    public void specialMarkVision() {
        if (SentinelPlugin.debugMe && !this.visionMarked) {
            this.debug("Target! I see you, " + (this.chasing == null ? "(Unknown)" : this.chasing.getName()));
        }
        if (SentinelVersionCompat.v1_11 && this.getLivingEntity().getType() == EntityType.SHULKER) {
            NMS.setPeekShulker((Entity)this.getLivingEntity(), (int)100);
        } else if (this.getLivingEntity().getType() == EntityType.ENDERMAN) {
            SentinelNMSHelper.setEndermanAngry((Enderman)this.getLivingEntity(), true);
        }
        this.visionMarked = true;
    }

    public void specialUnmarkVision() {
        if (SentinelPlugin.debugMe && this.visionMarked) {
            this.debug("Goodbye, visible target " + (this.chasing == null ? "(Unknown)" : this.chasing.getName()));
        }
        if (SentinelVersionCompat.v1_11 && this.getLivingEntity().getType() == EntityType.SHULKER) {
            NMS.setPeekShulker((Entity)this.getLivingEntity(), (int)0);
        } else if (this.getLivingEntity().getType() == EntityType.ENDERMAN) {
            SentinelNMSHelper.setEndermanAngry((Enderman)this.getLivingEntity(), false);
        }
        if (this.autoswitch) {
            this.itemHelper.swapToOpenHand();
        }
        this.visionMarked = false;
    }

    public boolean canPathTo(Location loc) {
        double crsq = this.chaseRange * this.chaseRange;
        Location near = this.nearestPathPoint();
        if (crsq > 0.0 && near != null && near.distanceSquared(loc) > crsq) {
            return false;
        }
        SentinelWantsToPathEvent event = new SentinelWantsToPathEvent(this.getNPC(), loc);
        Bukkit.getPluginManager().callEvent((Event)event);
        return !event.isCancelled();
    }

    public void pathTo(Location target) {
        if (!this.canPathTo(target)) {
            return;
        }
        this.pauseWaypoints();
        this.pathingTo = target;
        this.getNPC().getNavigator().setTarget(target);
        this.npc.getNavigator().getLocalParameters().distanceMargin(1.5);
        this.autoSpeedModifier();
        this.tryUpdateChaseTarget(null);
        this.needsSafeReturn = true;
    }

    public void pauseWaypoints() {
        this.otherBehaviorPaused = true;
        Waypoints wp = (Waypoints)this.npc.getTraitNullable(Waypoints.class);
        if (wp != null && wp.getCurrentProvider() != null) {
            if (!wp.getCurrentProvider().isPaused()) {
                wp.getCurrentProvider().setPaused(true);
            }
            this.needsToUnpause = true;
            this.needsSafeReturn = true;
        }
        Bukkit.getPluginManager().callEvent((Event)new SentinelCombatStateChangeEvent(this.getNPC(), true));
    }

    public void unpauseWaypoints() {
        this.otherBehaviorPaused = false;
        if (this.needsToUnpause && this.npc.hasTrait(Waypoints.class)) {
            Waypoints wp = (Waypoints)this.npc.getOrAddTrait(Waypoints.class);
            if (wp.getCurrentProvider() != null) {
                wp.getCurrentProvider().setPaused(false);
            }
            this.needsToUnpause = false;
        }
        Bukkit.getPluginManager().callEvent((Event)new SentinelCombatStateChangeEvent(this.getNPC(), false));
    }

    public LivingEntity getGuardingEntity() {
        Entity entity;
        NPC npc;
        if (this.guardedNPC >= 0 && (npc = CitizensAPI.getNPCRegistry().getById(this.guardedNPC)) != null && npc.isSpawned()) {
            return (LivingEntity)npc.getEntity();
        }
        UUID guardId = this.getGuarding();
        if (guardId == null) {
            return null;
        }
        Player player = Bukkit.getPlayer((UUID)guardId);
        if (player != null) {
            return player;
        }
        if (SentinelVersionCompat.v1_12 && (entity = Bukkit.getEntity((UUID)guardId)) instanceof LivingEntity) {
            return (LivingEntity)entity;
        }
        return null;
    }

    public void runUpdate() {
        Location near;
        if (this.lastLocationOnUpdate == null || !this.lastLocationOnUpdate.getWorld().equals((Object)this.getLivingEntity().getWorld()) || this.lastLocationOnUpdate.distanceSquared(this.getLivingEntity().getLocation()) > 0.1) {
            this.ticksSinceMoved = 0;
            this.lastLocationOnUpdate = this.getLivingEntity().getLocation();
        } else if (this.npc.getNavigator().isNavigating()) {
            this.ticksSinceMoved += SentinelPlugin.instance.tickRate;
            if (this.ticksSinceMoved > 100 && !this.npc.getNavigator().getDefaultParameters().useNewPathfinder() && !this.didCorrection && this.spawnPoint != null && this.lastLocationOnUpdate.distanceSquared(this.spawnPoint) < 1.0) {
                this.didCorrection = true;
                String prefix = SentinelCommand.prefixBad + "NPC " + this.npc.getId() + " (" + this.npc.getName() + SentinelCommand.colorBad + ") ";
                if (SentinelPlugin.instance.autoCorrectpathfinderMode) {
                    SentinelUtilities.broadcastToSelected(this.npc, prefix + "is unable to move - likely due to a minecraft navigator bug, and so will have its pathfinder mode autocorrected to use-new-finder=true (if you don't want this correction logic, disable Config option 'auto correct pathfinder mode'). Consider enabling 'use-new-finder: true' in your 'plugins/Citizens/config.yml'.");
                    this.npc.getNavigator().getDefaultParameters().useNewPathfinder(true);
                } else {
                    SentinelUtilities.broadcastToSelected(this.npc, prefix + "is unable to move due to a minecraft navigator bug, but auto-correction of this bug is disabled in your config.");
                }
            }
        } else {
            this.ticksSinceMoved = 0;
        }
        this.canEnforce = true;
        this.ticksSinceLastBurn += SentinelPlugin.instance.tickRate;
        this.timeSinceAttack += (long)SentinelPlugin.instance.tickRate;
        this.timeSinceHeal += (long)SentinelPlugin.instance.tickRate;
        LivingEntity guarded = this.getGuardingEntity();
        if (this.getLivingEntity().getLocation().getY() <= (double)SentinelUtilities.getMinWorldHeight(this.getLivingEntity().getWorld())) {
            if (SentinelPlugin.debugMe) {
                this.debug("Injuring self, I'm below the map!");
            }
            this.getLivingEntity().damage(1.0);
            if (!this.npc.isSpawned()) {
                if (guarded != null && this.respawnTime > 0L && this.respawnMe == null) {
                    this.npc.spawn(guarded.getLocation());
                }
                return;
            }
        }
        if (this.health != this.getLivingEntity().getMaxHealth()) {
            this.getLivingEntity().setMaxHealth(this.health);
        }
        if (this.healRate > 0 && this.timeSinceHeal > (long)this.healRate && this.getLivingEntity().getHealth() < this.health) {
            this.getLivingEntity().setHealth(Math.min(this.getLivingEntity().getHealth() + 1.0, this.health));
            this.timeSinceHeal = 0L;
        }
        if (SentinelVersionCompat.v1_16 && this.arrowResetTicker++ > 100) {
            this.arrowResetTicker = 0;
            if (this.getLivingEntity().getArrowsInBody() > 0) {
                this.getLivingEntity().setArrowsInBody(Math.max(0, this.getLivingEntity().getArrowsInBody() / 2 - 1));
            }
        }
        if (!this.npc.getNavigator().isNavigating()) {
            this.pathingTo = null;
        }
        if (guarded != null || this.chasing != null || this.pathingTo != null) {
            if (!this.otherBehaviorPaused) {
                this.pauseWaypoints();
            }
        } else if (this.otherBehaviorPaused) {
            this.unpauseWaypoints();
        }
        this.targetingHelper.updateTargets();
        this.targetingHelper.updateAvoids();
        boolean goHome = this.chased;
        if (!(this.chasing == null || this.chasing.isValid() && this.targetingHelper.shouldTarget(this.chasing))) {
            this.tryUpdateChaseTarget(null);
        }
        this.targetingHelper.processAllMultiTargets();
        LivingEntity target = this.targetingHelper.findBestTarget();
        if (target != null) {
            if (SentinelPlugin.debugMe) {
                this.debug("target selected to be " + target.getName());
            }
            if (this.canPathTo(target.getLocation())) {
                if (SentinelPlugin.debugMe) {
                    near = this.nearestPathPoint();
                    this.debug("Attack target within range of safe zone: " + (near == null ? "Any" : Double.valueOf(near.distanceSquared(target.getLocation()))));
                }
                if (this.chasing == null) {
                    this.specialMarkVision();
                }
                if (this.tryUpdateChaseTarget(target)) {
                    this.needsSafeReturn = true;
                    this.cleverTicks = 0;
                    this.attackHelper.tryDefendFrom(target);
                    this.attackHelper.tryAttack(target);
                    goHome = false;
                }
            } else {
                this.debug("Actually, that target is bad!");
                this.specialUnmarkVision();
                target = null;
                this.tryUpdateChaseTarget(null);
                this.cleverTicks = 0;
            }
        } else if (this.chasing != null && this.chasing.isValid()) {
            this.needsSafeReturn = true;
            if (this.targetingHelper.canSee(this.chasing) && SentinelPlugin.instance.workaroundEntityChasePathfinder) {
                this.attackHelper.rechase();
            }
            ++this.cleverTicks;
            if (this.cleverTicks >= SentinelPlugin.instance.cleverTicks) {
                this.specialUnmarkVision();
                this.tryUpdateChaseTarget(null);
            } else if (this.canPathTo(this.chasing.getLocation())) {
                this.attackHelper.tryDefendFrom(this.chasing);
                this.attackHelper.tryAttack(this.chasing);
                goHome = false;
            }
        } else if (this.chasing == null) {
            this.specialUnmarkVision();
        }
        if (guarded != null) {
            double dist;
            Location myLoc = this.getLivingEntity().getLocation();
            Location theirLoc = guarded.getLocation();
            double d = dist = theirLoc.getWorld().equals((Object)myLoc.getWorld()) ? myLoc.distanceSquared(theirLoc) : 1.0E8;
            if (dist > 3600.0 && !this.disableTeleporting) {
                this.npc.teleport(guarded.getLocation(), PlayerTeleportEvent.TeleportCause.PLUGIN);
            }
            if (dist > this.guardDistanceMinimum * this.guardDistanceMinimum) {
                this.ticksCountGuard += SentinelPlugin.instance.tickRate;
                if (this.ticksCountGuard >= 30) {
                    this.ticksCountGuard = 0;
                    this.npc.getNavigator().getDefaultParameters().range(100.0f);
                    if (!this.disableTeleporting) {
                        this.npc.getNavigator().getDefaultParameters().stuckAction((StuckAction)TeleportStuckAction.INSTANCE);
                    }
                    Location picked = SentinelUtilities.pickNear(guarded.getLocation(), this.guardSelectionRange);
                    if (SentinelPlugin.debugMe) {
                        this.debug("Guard movement chosen to go to " + picked.toVector().toBlockVector().toString());
                    }
                    this.npc.getNavigator().setTarget(picked);
                    this.autoSpeedModifier();
                    this.npc.getNavigator().getLocalParameters().distanceMargin(this.guardDistanceMinimum * 0.75);
                    this.chased = true;
                }
            }
            this.needsSafeReturn = true;
            goHome = false;
        }
        this.targetingHelper.processAvoidance();
        if (this.pathingTo != null) {
            goHome = false;
            this.needsSafeReturn = true;
        }
        if (this.isBlocking && target == null && this.chasing == null) {
            this.stopBlocking();
        }
        if (goHome && this.chaseRange > 0.0 && target == null && this.needsSafeReturn) {
            near = this.nearestPathPoint();
            if (!(near == null || this.chasing != null && this.canPathTo(this.chasing.getLocation()))) {
                if (SentinelPlugin.debugMe) {
                    this.debug("Returning to nearest path point.");
                }
                if (!this.disableTeleporting) {
                    this.npc.getNavigator().getDefaultParameters().stuckAction((StuckAction)TeleportStuckAction.INSTANCE);
                }
                this.npc.getNavigator().setTarget(near);
                this.autoSpeedModifier();
                this.needsSafeReturn = false;
                this.chased = false;
                this.tryUpdateChaseTarget(null);
            } else {
                if (this.pathingTo == null && this.npc.getNavigator().isNavigating() && guarded == null) {
                    this.npc.getNavigator().cancelNavigation();
                    this.needsSafeReturn = false;
                }
                if (SentinelPlugin.debugMe && near != null && near.distanceSquared(this.getLivingEntity().getLocation()) > 9.0) {
                    this.debug("I'll just stand here and hope they come out...");
                }
            }
        } else if (this.chasing == null && guarded == null && this.pathingTo == null && this.needsSafeReturn) {
            if (this.npc.getNavigator().isNavigating()) {
                this.debug("Cancelling navigation, combat is over.");
                this.npc.getNavigator().cancelNavigation();
            }
            this.needsSafeReturn = false;
        }
    }

    public Location getGuardZone() {
        Location goal;
        LivingEntity guarded = this.getGuardingEntity();
        if (guarded != null) {
            return guarded.getLocation();
        }
        if (this.chaseRange > 0.0 && (goal = this.nearestPathPoint()) != null) {
            return goal;
        }
        return this.getLivingEntity().getLocation();
    }

    public Location nearestPathPoint() {
        if (!this.npc.hasTrait(Waypoints.class)) {
            return null;
        }
        if (this.getGuarding() != null) {
            return null;
        }
        Location baseloc = this.getLivingEntity().getLocation();
        Location nearest = null;
        double dist = 1.0E8;
        Waypoints wp = (Waypoints)this.npc.getOrAddTrait(Waypoints.class);
        if (wp.getCurrentProvider() == null) {
            return null;
        }
        if (wp.getCurrentProvider() instanceof WaypointProvider.EnumerableWaypointProvider) {
            for (Waypoint wayp : ((WaypointProvider.EnumerableWaypointProvider)wp.getCurrentProvider()).waypoints()) {
                double d;
                Location l = wayp.getLocation();
                if (!l.getWorld().equals((Object)baseloc.getWorld()) || !((d = baseloc.distanceSquared(l)) < dist)) continue;
                dist = d;
                nearest = l;
            }
        } else if (wp.getCurrentProvider() instanceof WanderWaypointProvider) {
            for (Location loc : ((WanderWaypointProvider)wp.getCurrentProvider()).getRegionCentres()) {
                double d;
                if (!loc.getWorld().equals((Object)baseloc.getWorld()) || !((d = baseloc.distanceSquared(loc)) < dist)) continue;
                dist = d;
                nearest = loc;
            }
        } else {
            return null;
        }
        return nearest;
    }

    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        ++this.stats_ticksSpawned;
        ++this.cTick;
        if (this.cTick >= SentinelPlugin.instance.tickRate) {
            this.cTick = 0;
            this.runUpdate();
        }
    }

    public void onSpawn() {
        this.debug("Spawned.");
        this.isBlocking = false;
        this.lastEntityUUID = this.getLivingEntity().getUniqueId();
        ++this.stats_timesSpawned;
        this.setHealth(this.health);
        this.setInvincible(this.invincible);
        if (this.respawnMe != null) {
            this.respawnMe.cancel();
            this.respawnMe = null;
        }
        SentinelPlugin.instance.currentSentinelNPCs.add(this);
    }

    public void sayTo(Player player, String message) {
        player.sendMessage(SentinelCommand.colorEmphasis + "[" + this.npc.getName() + "]: " + SentinelCommand.colorBasic + message);
    }

    public void onPlayerTeleports(final PlayerTeleportEvent event) {
        if (event.getFrom().getWorld().equals((Object)event.getTo().getWorld())) {
            if (!this.disableTeleporting) {
                this.npc.teleport(event.getTo(), PlayerTeleportEvent.TeleportCause.PLUGIN);
            }
        } else {
            event.getFrom().getChunk().load();
            event.getTo().getChunk().load();
            Bukkit.getScheduler().runTaskLater((Plugin)SentinelPlugin.instance, new Runnable(){

                @Override
                public void run() {
                    if (!event.getPlayer().getWorld().equals((Object)event.getTo().getWorld())) {
                        return;
                    }
                    event.getFrom().getChunk().load();
                    event.getTo().getChunk().load();
                    SentinelTrait.this.npc.spawn(event.getTo());
                }
            }, 1L);
        }
    }

    public void onPlayerMovesInRange(PlayerMoveEvent event) {
        if (!event.getTo().getWorld().equals((Object)this.getLivingEntity().getLocation().getWorld())) {
            return;
        }
        double dist = event.getTo().distanceSquared(this.getLivingEntity().getLocation());
        boolean known = this.greetedAlready.contains(event.getPlayer().getUniqueId());
        if (dist < this.greetRange * this.greetRange && !known && this.targetingHelper.canSee((LivingEntity)event.getPlayer())) {
            this.greetedAlready.add(event.getPlayer().getUniqueId());
            Long lastGreet = this.lastGreetTime.get(event.getPlayer().getUniqueId());
            if (lastGreet != null && lastGreet + (long)this.greetRate > this.stats_ticksSpawned) {
                return;
            }
            this.lastGreetTime.put(event.getPlayer().getUniqueId(), this.stats_ticksSpawned);
            boolean enemy = this.targetingHelper.shouldTarget((LivingEntity)event.getPlayer());
            if (enemy && this.warningText != null && this.warningText.length() > 0) {
                this.sayTo(event.getPlayer(), this.warningText);
            } else if (!enemy && this.greetingText != null && this.greetingText.length() > 0) {
                this.sayTo(event.getPlayer(), this.greetingText);
            }
        } else if (dist >= this.greetRange * this.greetRange + 1.0 && known) {
            this.greetedAlready.remove(event.getPlayer().getUniqueId());
        }
    }

    public void whenSomethingMightDie(UUID mightDie) {
        if (!this.needsDropsClear.contains(mightDie)) {
            return;
        }
        if (SentinelPlugin.debugMe) {
            this.debug("ID " + mightDie + " is no longer being tracked.");
        }
        this.needsDropsClear.remove(mightDie);
    }

    public void debug(String message) {
        if (SentinelPlugin.debugMe) {
            SentinelPlugin.instance.getLogger().info("Sentinel Debug: " + this.npc.getId() + "/" + this.npc.getName() + ": " + message);
        }
    }

    public List<ItemStack> getDrops() {
        ArrayList<ItemStack> items = new ArrayList<ItemStack>(this.drops.size());
        if (this.dropChances.isEmpty()) {
            for (ItemStack item : this.drops) {
                items.add(item.clone());
            }
            return items;
        }
        for (int i = 0; i < this.drops.size(); ++i) {
            if (i < this.dropChances.size()) {
                double chance = this.dropChances.get(i);
                if (SentinelUtilities.random.nextDouble() > chance) continue;
            }
            items.add(this.drops.get(i).clone());
        }
        return items;
    }

    public void whenWeDie(EntityDeathEvent event) {
        if (SentinelPlugin.debugMe) {
            this.debug("Died! Death event received.");
        }
        event.getDrops().clear();
        if (event instanceof PlayerDeathEvent) {
            PlayerDeathEvent pEvent = (PlayerDeathEvent)event;
            if (!SentinelPlugin.instance.deathMessages) {
                pEvent.setDeathMessage(null);
            } else if (this.npc.requiresNameHologram() && pEvent.getDeathMessage() != null) {
                pEvent.setDeathMessage(pEvent.getDeathMessage().replace(event.getEntity().getName(), this.npc.getFullName()));
            }
        }
        if (!SentinelPlugin.instance.workaroundDrops) {
            event.getDrops().addAll(this.getDrops());
        }
        event.setDroppedExp(this.deathXP);
        this.generalDeathHandler(event.getEntity());
    }

    public void generalDeathHandler(LivingEntity entity) {
        if (this.spawnPoint != null) {
            ((CurrentLocation)this.npc.getOrAddTrait(CurrentLocation.class)).setLocation(this.spawnPoint.clone());
        }
        if (SentinelPlugin.instance.workaroundDrops) {
            for (ItemStack item : this.getDrops()) {
                entity.getWorld().dropItemNaturally(entity.getLocation(), item);
            }
        }
        this.onDeath();
    }

    public void whenSomethingDies(EntityDeathEvent event) {
        UUID id = event.getEntity().getUniqueId();
        if (this.needsDropsClear.contains(id)) {
            this.needsDropsClear.remove(id);
            if (event.getEntity().getType() != EntityType.PLAYER) {
                if (SentinelPlugin.debugMe) {
                    this.debug("A " + event.getEntity().getType() + " with id " + id + " died. Clearing its drops.");
                }
                event.getDrops().clear();
                event.setDroppedExp(0);
            }
        } else if (SentinelPlugin.debugMe) {
            this.debug("A " + event.getEntity().getType() + " with id " + id + " died, but that's none of my business.");
        }
        this.targetingHelper.removeTarget(id);
    }

    public void onDeath() {
        this.greetedAlready.clear();
        this.targetingHelper.currentTargets.clear();
        this.targetingHelper.currentAvoids.clear();
        if (this.respawnTime < 0L) {
            BukkitRunnable removeMe = new BukkitRunnable(){

                public void run() {
                    SentinelTrait.this.npc.destroy();
                }
            };
            removeMe.runTaskLater((Plugin)SentinelPlugin.instance, 1L);
        } else if (this.respawnTime > 0L) {
            final long rsT = this.respawnTime;
            this.respawnMe = new BukkitRunnable(){
                long timer = 0L;

                public void run() {
                    if (CitizensAPI.getNPCRegistry().getById(SentinelTrait.this.npc.getId()) != null) {
                        if (SentinelTrait.this.npc.isSpawned()) {
                            this.cancel();
                            SentinelTrait.this.respawnMe = null;
                            return;
                        }
                        if (this.timer >= rsT) {
                            if (SentinelTrait.this.spawnPoint == null && SentinelTrait.this.npc.getStoredLocation() == null) {
                                SentinelPlugin.instance.getLogger().warning("NPC " + SentinelTrait.this.npc.getId() + " has a null spawn point and can't be spawned. Perhaps the world was deleted?");
                                this.cancel();
                                return;
                            }
                            SentinelTrait.this.npc.spawn(SentinelTrait.this.spawnPoint == null ? SentinelTrait.this.npc.getStoredLocation() : SentinelTrait.this.spawnPoint);
                            this.cancel();
                            SentinelTrait.this.respawnMe = null;
                            return;
                        }
                        this.timer += 10L;
                    } else {
                        SentinelTrait.this.respawnMe = null;
                        this.cancel();
                        return;
                    }
                }
            };
            this.respawnMe.runTaskTimer((Plugin)SentinelPlugin.instance, 10L, 10L);
        } else {
            ((Spawned)this.npc.getOrAddTrait(Spawned.class)).setSpawned(false);
        }
    }

    public void onDespawn() {
        this.debug("Despawned.");
        this.targetingHelper.currentTargets.clear();
        this.targetingHelper.currentAvoids.clear();
        SentinelPlugin.instance.currentSentinelNPCs.remove((Object)this);
    }

    public void setHealth(double heal) {
        this.health = heal;
        if (this.npc.isSpawned()) {
            if (SentinelPlugin.debugMe) {
                this.debug("Setting spawned NPC health to " + this.health);
            }
            this.getLivingEntity().setMaxHealth(this.health);
            this.getLivingEntity().setHealth(this.health);
        }
    }

    public void setInvincible(boolean inv) {
        this.invincible = inv;
        this.npc.setProtected(this.invincible);
    }

    public boolean validateOnList() {
        if (this.npc == null || !this.npc.isSpawned() || this.getLivingEntity() == null) {
            SentinelPlugin.instance.currentSentinelNPCs.remove((Object)this);
            return false;
        }
        return true;
    }

    public boolean tryUpdateChaseTarget(LivingEntity newTarget) {
        if (newTarget == this.chasing) {
            return true;
        }
        if (newTarget == null) {
            SentinelChaseEndEvent event = new SentinelChaseEndEvent(this.npc);
            Bukkit.getPluginManager().callEvent((Event)event);
            if (event.cancelled) {
                this.debug("ChaseEndEvent cancelled");
                return false;
            }
            this.chasing = null;
            return true;
        }
        SentinelChaseNewTargetEvent event = new SentinelChaseNewTargetEvent(this.npc, newTarget);
        Bukkit.getPluginManager().callEvent((Event)event);
        if (event.cancelled) {
            this.debug("ChaseNewTarget event cancelled");
            return false;
        }
        if (newTarget != event.newTarget) {
            this.debug("ChaseNewTarget modified externally to different target");
        }
        this.chasing = event.newTarget;
        if (this.chasing == null) {
            this.debug("ChaseNewTarget event modified to null externally");
            return false;
        }
        return true;
    }

    static {
        PersistenceLoader.registerPersistDelegate(SentinelTargetList.class, SentinelTargetListPersister.class);
        modifiersToZero = new EntityDamageEvent.DamageModifier[]{EntityDamageEvent.DamageModifier.HARD_HAT, EntityDamageEvent.DamageModifier.BLOCKING, EntityDamageEvent.DamageModifier.RESISTANCE, EntityDamageEvent.DamageModifier.MAGIC, EntityDamageEvent.DamageModifier.ABSORPTION};
        VECTOR_ZERO = new Vector(0, 0, 0);
    }

    public static class SentinelTargetListPersister
    implements Persister<SentinelTargetList> {
        public SentinelTargetList create(DataKey dataKey) {
            SentinelTargetList list = (SentinelTargetList)PersistenceLoader.load((Object)new SentinelTargetList(), (DataKey)dataKey);
            list.init();
            return list;
        }

        public void save(SentinelTargetList o, DataKey dataKey) {
            PersistenceLoader.save((Object)o, (DataKey)dataKey);
        }
    }
}

