/*
 * Decompiled with CFR 0.152.
 */
package org.mcmonkey.sentinel.targeting;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.UUID;
import net.citizensnpcs.api.ai.NavigatorParameters;
import net.citizensnpcs.api.astar.AStarGoal;
import net.citizensnpcs.api.astar.AStarMachine;
import net.citizensnpcs.api.astar.AStarNode;
import net.citizensnpcs.api.astar.pathfinder.BlockSource;
import net.citizensnpcs.api.astar.pathfinder.ChunkBlockSource;
import net.citizensnpcs.api.astar.pathfinder.Path;
import net.citizensnpcs.api.astar.pathfinder.VectorGoal;
import net.citizensnpcs.api.astar.pathfinder.VectorNode;
import org.bukkit.Bukkit;
import org.bukkit.GameMode;
import org.bukkit.Location;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;
import org.mcmonkey.sentinel.SentinelCurrentTarget;
import org.mcmonkey.sentinel.SentinelHelperObject;
import org.mcmonkey.sentinel.SentinelPlugin;
import org.mcmonkey.sentinel.SentinelTrait;
import org.mcmonkey.sentinel.SentinelUtilities;
import org.mcmonkey.sentinel.events.SentinelNoMoreTargetsEvent;
import org.mcmonkey.sentinel.targeting.SentinelTargetList;

public class SentinelTargetingHelper
extends SentinelHelperObject {
    public HashMap<UUID, SentinelCurrentTarget> currentTargets = new HashMap();
    public HashMap<UUID, SentinelCurrentTarget> currentAvoids = new HashMap();
    private ArrayList<LivingEntity> avoidanceList = new ArrayList();
    private double[] threatDists = new double[36];
    private static Vector[] directionReferenceVectors = new Vector[36];
    private static AStarMachine ASTAR;
    private static NavigatorParameters parameters;

    public boolean canSee(LivingEntity entity) {
        if (!this.getLivingEntity().getWorld().equals((Object)entity.getWorld())) {
            return false;
        }
        if (this.getLivingEntity().getEyeLocation().distanceSquared(entity.getEyeLocation()) > this.sentinel.range * this.sentinel.range) {
            return false;
        }
        if (this.sentinel.realistic && !SentinelUtilities.isLookingTowards(this.getLivingEntity().getEyeLocation(), entity.getLocation(), 90.0f, 110.0f)) {
            return false;
        }
        return this.sentinel.ignoreLOS || SentinelUtilities.checkLineOfSightWithTransparency(this.getLivingEntity(), entity);
    }

    public boolean shouldTarget(LivingEntity entity) {
        if (entity.getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            return false;
        }
        if (entity.getType() == EntityType.ARMOR_STAND && !SentinelPlugin.instance.allowArmorStandTargets) {
            return false;
        }
        return this.isTargeted(entity) && !this.isIgnored(entity);
    }

    public boolean shouldAvoid(LivingEntity entity) {
        if (entity.getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            return false;
        }
        if (entity.getType() == EntityType.ARMOR_STAND && !SentinelPlugin.instance.allowArmorStandTargets) {
            return false;
        }
        return this.isAvoided(entity) && !this.isIgnored(entity);
    }

    public void addAvoid(UUID id) {
        if (id.equals(this.getLivingEntity().getUniqueId())) {
            return;
        }
        if (!(SentinelUtilities.getEntityForID(id) instanceof LivingEntity)) {
            return;
        }
        this.ensureTargetDirect(this.currentAvoids, SentinelPlugin.instance.runAwayTime, id);
    }

    public void addTarget(UUID id) {
        if (id.equals(this.getLivingEntity().getUniqueId())) {
            return;
        }
        if (!(SentinelUtilities.getEntityForID(id) instanceof LivingEntity)) {
            return;
        }
        this.addTargetNoBounce(id);
        if (this.sentinel.squad != null) {
            for (SentinelTrait squadMate : SentinelPlugin.instance.cleanCurrentList()) {
                if (squadMate.squad == null || !squadMate.squad.equals(this.sentinel.squad)) continue;
                squadMate.targetingHelper.addTargetNoBounce(id);
            }
        }
    }

    public boolean removeTarget(UUID id) {
        boolean removed = this.removeTargetNoBounce(id);
        if (removed && this.sentinel.squad != null) {
            for (SentinelTrait squadMate : SentinelPlugin.instance.cleanCurrentList()) {
                if (squadMate.squad == null || !squadMate.squad.equals(this.sentinel.squad)) continue;
                squadMate.targetingHelper.removeTargetNoBounce(id);
            }
        }
        return removed;
    }

    public boolean removeTargetNoBounce(UUID target) {
        if (this.currentTargets.remove(target) != null) {
            if (this.currentTargets.isEmpty()) {
                Bukkit.getPluginManager().callEvent((Event)new SentinelNoMoreTargetsEvent(this.getNPC()));
            }
            return true;
        }
        return false;
    }

    private void ensureTargetDirect(HashMap<UUID, SentinelCurrentTarget> set, long time, UUID id) {
        SentinelCurrentTarget target = set.get(id);
        if (target == null) {
            target = new SentinelCurrentTarget();
            target.targetID = id;
            target.hasLos = true;
            set.put(id, target);
        }
        target.ticksLeft = time;
    }

    public void informTargetHasNoLos(UUID id) {
        SentinelCurrentTarget target = this.currentTargets.get(id);
        if (target != null) {
            target.hasLos = false;
        }
    }

    public void addTargetNoBounce(UUID id) {
        if (this.sentinel.reactionSlowdown == 0) {
            this.ensureTargetDirect(this.currentTargets, this.sentinel.enemyTargetTime, id);
        } else {
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SentinelPlugin.instance, () -> this.ensureTargetDirect(this.currentTargets, this.sentinel.enemyTargetTime, id), (long)this.sentinel.reactionSlowdown);
        }
    }

    public boolean isInvisible(LivingEntity entity) {
        return !this.currentTargets.containsKey(entity.getUniqueId()) && SentinelUtilities.isInvisible(entity);
    }

    public boolean isIgnored(LivingEntity entity) {
        if (SentinelTargetingHelper.isUntargetable((Entity)entity)) {
            return true;
        }
        if (this.isInvisible(entity)) {
            return true;
        }
        if (entity.getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            return true;
        }
        if (entity.getType() == EntityType.ARMOR_STAND && !SentinelPlugin.instance.allowArmorStandTargets) {
            return true;
        }
        if (this.sentinel.getGuarding() != null && SentinelUtilities.uuidEquals(entity.getUniqueId(), this.sentinel.getGuarding())) {
            return true;
        }
        return this.sentinel.allIgnores.isTarget(entity, this.sentinel);
    }

    public boolean isTargeted(LivingEntity entity) {
        if (this.isInvisible(entity)) {
            return false;
        }
        if (entity.getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            return false;
        }
        if (this.sentinel.getGuarding() != null && SentinelUtilities.uuidEquals(entity.getUniqueId(), this.sentinel.getGuarding())) {
            return false;
        }
        if (SentinelTargetingHelper.isUntargetable((Entity)entity)) {
            return false;
        }
        if (this.currentTargets.containsKey(entity.getUniqueId())) {
            return true;
        }
        return this.sentinel.allTargets.isTarget(entity, this.sentinel);
    }

    public boolean isAvoided(LivingEntity entity) {
        if (this.isInvisible(entity)) {
            return false;
        }
        if (entity.getUniqueId().equals(this.getLivingEntity().getUniqueId())) {
            return false;
        }
        if (this.sentinel.getGuarding() != null && SentinelUtilities.uuidEquals(entity.getUniqueId(), this.sentinel.getGuarding())) {
            return false;
        }
        if (this.currentAvoids.containsKey(entity.getUniqueId())) {
            return true;
        }
        return this.sentinel.allAvoids.isTarget(entity, this.sentinel);
    }

    public void processAvoidance() {
        this.avoidanceList.clear();
        if (this.currentAvoids.isEmpty() && this.sentinel.allAvoids.totalTargetsCount() == 0) {
            return;
        }
        double range = this.sentinel.avoidRange + 10.0;
        for (Entity entity : this.getLivingEntity().getWorld().getNearbyEntities(this.getLivingEntity().getLocation(), range, 16.0, range)) {
            if (!(entity instanceof LivingEntity) || !this.shouldAvoid((LivingEntity)entity) || !this.currentAvoids.containsKey(entity.getUniqueId()) && !this.canSee((LivingEntity)entity)) continue;
            this.avoidanceList.add((LivingEntity)entity);
            this.addAvoid(entity.getUniqueId());
        }
        if (this.avoidanceList.isEmpty()) {
            return;
        }
        Location runTo = this.findBestRunSpot();
        if (runTo != null) {
            this.sentinel.pathTo(runTo);
            if (SentinelPlugin.debugMe) {
                this.sentinel.debug("Running from threats, movement vector: " + runTo.clone().subtract(this.getLivingEntity().getLocation()).toVector().toBlockVector().toString());
            }
        } else {
            this.sentinel.debug("I have nowhere to run!");
        }
    }

    public Location findBestRunSpot() {
        if (this.sentinel.avoidReturnPoint != null && this.sentinel.avoidReturnPoint.getWorld().equals((Object)this.getLivingEntity().getWorld())) {
            this.sentinel.debug("I have an avoid return point, I'll go there");
            return this.sentinel.avoidReturnPoint.clone();
        }
        Location pos = this.sentinel.getGuardZone();
        if (!pos.getWorld().equals((Object)this.getLivingEntity().getWorld())) {
            this.sentinel.debug("Run spot out-of-world, must teleport away!");
            this.getNPC().getNavigator().cancelNavigation();
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SentinelPlugin.instance, () -> this.getLivingEntity().teleport(this.sentinel.getGuardZone()), 1L);
            return null;
        }
        LivingEntity closestThreat = null;
        double threatRangeSquared = 1000000.0;
        for (LivingEntity entity : this.avoidanceList) {
            double dist = entity.getLocation().distanceSquared(pos);
            if (!(dist < threatRangeSquared)) continue;
            closestThreat = entity;
            threatRangeSquared = dist;
        }
        if (closestThreat == null) {
            this.sentinel.debug("No threats in range, actually I won't run away");
            return null;
        }
        if (threatRangeSquared >= this.sentinel.avoidRange * this.sentinel.avoidRange) {
            this.sentinel.debug("Threats are getting close... holding my post.");
            return pos.clone();
        }
        this.sentinel.debug("I'll just pick a direction to run in I guess...");
        return this.runDirection(pos);
    }

    public static Location findSpotForRunDirection(Location start, double distance, Vector direction) {
        VectorNode startNode;
        VectorGoal goal = new VectorGoal(start.clone().add(direction.clone().multiply(distance)), 4.0f);
        Path resultPath = (Path)ASTAR.runFully((AStarGoal)goal, (AStarNode)(startNode = new VectorNode(goal, start, (BlockSource)new ChunkBlockSource(start, (float)distance + 10.0f), parameters)), (int)(distance * 50.0));
        if (resultPath == null || resultPath.isComplete()) {
            return null;
        }
        Vector current = resultPath.getCurrentVector();
        while (!resultPath.isComplete()) {
            current = resultPath.getCurrentVector();
            resultPath.update(null);
        }
        return current.toLocation(start.getWorld());
    }

    public Location runDirection(Location center) {
        int i;
        for (int i2 = 0; i2 < 36; ++i2) {
            this.threatDists[i2] = 1000000.0;
        }
        double range = this.sentinel.avoidRange;
        Vector centerVec = center.toVector();
        for (LivingEntity entity : this.avoidanceList) {
            Vector relative = entity.getLocation().toVector().subtract(centerVec);
            for (i = 0; i < 36; ++i) {
                double dist = relative.distanceSquared(directionReferenceVectors[i].clone().multiply(range));
                if (!(dist < this.threatDists[i])) continue;
                this.threatDists[i] = dist;
            }
        }
        double longestDistance = 0.0;
        Location runTo = null;
        for (i = 0; i < 36; ++i) {
            Location newRunTo;
            if (!(this.threatDists[i] > longestDistance) || (newRunTo = SentinelTargetingHelper.findSpotForRunDirection(center, range, directionReferenceVectors[i].clone())) == null) continue;
            runTo = newRunTo;
            longestDistance = this.threatDists[i];
        }
        if (SentinelPlugin.debugMe) {
            SentinelPlugin.instance.getLogger().info("(TEMP) Run to get threat distance: " + longestDistance + " to " + runTo + " from " + center.toVector());
        }
        return runTo;
    }

    public LivingEntity findBestTarget() {
        double dist;
        boolean ignoreGlow = this.itemHelper.usesSpectral(this.itemHelper.getHeldItem());
        double rangesquared = this.sentinel.range * this.sentinel.range;
        double crsq = this.sentinel.chaseRange * this.sentinel.chaseRange;
        Location pos = this.sentinel.getGuardZone();
        if (!pos.getWorld().equals((Object)this.getLivingEntity().getWorld())) {
            this.getNPC().getNavigator().cancelNavigation();
            Bukkit.getScheduler().scheduleSyncDelayedTask((Plugin)SentinelPlugin.instance, () -> this.getLivingEntity().teleport(this.sentinel.getGuardZone()), 1L);
            return null;
        }
        if (this.sentinel.chasing != null && this.sentinel.retainTarget && (dist = this.sentinel.chasing.getEyeLocation().distanceSquared(pos)) < crsq && this.shouldTarget(this.sentinel.chasing) && this.sentinel.canPathTo(this.sentinel.chasing.getLocation())) {
            return this.sentinel.chasing;
        }
        LivingEntity closest = null;
        boolean wasLos = false;
        for (Entity loopEnt : this.getLivingEntity().getWorld().getNearbyEntities(pos, this.sentinel.range, this.sentinel.range, this.sentinel.range)) {
            boolean hasLos;
            if (!(loopEnt instanceof LivingEntity)) continue;
            LivingEntity ent = (LivingEntity)loopEnt;
            if (ignoreGlow && ent.isGlowing() || ent.isDead()) continue;
            double dist2 = ent.getEyeLocation().distanceSquared(pos);
            SentinelCurrentTarget curTarg = null;
            if (dist2 < crsq && dist2 < rangesquared && (curTarg = this.currentTargets.get(ent.getUniqueId())) != null && !this.sentinel.canPathTo(ent.getLocation())) {
                curTarg = null;
            }
            if (curTarg == null && (!(dist2 < rangesquared) || !this.shouldTarget(ent)) || !(hasLos = this.canSee(ent)) && (curTarg == null || !curTarg.hasLos)) continue;
            if (hasLos && curTarg != null) {
                curTarg.hasLos = true;
            }
            if (curTarg == null && this.sentinel.reactionSlowdown != 0) {
                this.addTarget(ent.getUniqueId());
                continue;
            }
            if (wasLos && !hasLos) continue;
            rangesquared = dist2;
            closest = ent;
            wasLos = hasLos;
        }
        if (closest != null) {
            this.addTarget(closest.getUniqueId());
        }
        return closest;
    }

    public void processAllMultiTargets() {
        this.processMultiTargets(this.sentinel.allTargets, TargetListType.TARGETS);
        this.processMultiTargets(this.sentinel.allAvoids, TargetListType.AVOIDS);
    }

    public void processMultiTargets(SentinelTargetList baseList, TargetListType type) {
        if (type == null) {
            return;
        }
        if (baseList.byMultiple.isEmpty()) {
            return;
        }
        ArrayList<SentinelTargetList> subList = new ArrayList<SentinelTargetList>(baseList.byMultiple.size());
        for (SentinelTargetList list : baseList.byMultiple) {
            SentinelTargetList toAdd = list.duplicate();
            toAdd.recalculateCacheNoClear();
            subList.add(toAdd);
            if (!SentinelPlugin.debugMe) continue;
            SentinelPlugin.instance.getLogger().info("Multi-Target Debug: " + toAdd.totalTargetsCount() + " at start: " + toAdd.toMultiTargetString());
        }
        Location pos = this.sentinel.getGuardZone();
        for (Entity loopEnt : this.getLivingEntity().getWorld().getNearbyEntities(pos, this.sentinel.range, this.sentinel.range, this.sentinel.range)) {
            LivingEntity ent;
            if (!(loopEnt instanceof LivingEntity) || (ent = (LivingEntity)loopEnt).isDead() || this.isIgnored(ent) || !this.canSee(ent)) continue;
            for (SentinelTargetList lister : subList) {
                if (!lister.ifIsTargetDeleteTarget(ent)) continue;
                if (SentinelPlugin.debugMe) {
                    SentinelPlugin.instance.getLogger().info("Multi-Target Debug: " + ent.getName() + " (" + ent.getType().name() + ") checked off for a list.");
                }
                lister.tempTargeted.add(ent);
                if (lister.totalTargetsCount() != 0) continue;
                if (SentinelPlugin.debugMe) {
                    SentinelPlugin.instance.getLogger().info("Multi-Target Debug: " + lister.totalTargetsCount() + " completed: " + lister.toMultiTargetString());
                }
                for (LivingEntity subEnt : lister.tempTargeted) {
                    if (type == TargetListType.TARGETS) {
                        this.addTarget(subEnt.getUniqueId());
                        continue;
                    }
                    if (type != TargetListType.AVOIDS) continue;
                    this.addAvoid(subEnt.getUniqueId());
                }
            }
        }
    }

    public LivingEntity findQuickMeleeTarget() {
        double range = this.sentinel.reach * 0.75;
        Location pos = this.getLivingEntity().getEyeLocation();
        for (Entity loopEnt : this.getLivingEntity().getWorld().getNearbyEntities(pos, range, range, range)) {
            if (!(loopEnt instanceof LivingEntity) || !this.shouldTarget((LivingEntity)loopEnt) || !this.canSee((LivingEntity)loopEnt)) continue;
            return (LivingEntity)loopEnt;
        }
        return null;
    }

    public void updateAvoids() {
        for (SentinelCurrentTarget curTarg : new ArrayList<SentinelCurrentTarget>(this.currentAvoids.values())) {
            Entity e = SentinelUtilities.getEntityForID(curTarg.targetID);
            if (e == null) {
                this.currentAvoids.remove(curTarg.targetID);
                continue;
            }
            if (e.isDead()) {
                this.currentAvoids.remove(curTarg.targetID);
                continue;
            }
            if (curTarg.ticksLeft <= 0L) continue;
            curTarg.ticksLeft -= (long)SentinelPlugin.instance.tickRate;
            if (curTarg.ticksLeft > 0L) continue;
            this.currentAvoids.remove(curTarg.targetID);
        }
    }

    public static boolean isUntargetable(Entity e) {
        GameMode mode;
        if (e == null) {
            return true;
        }
        if (e.isDead()) {
            return true;
        }
        return e instanceof Player && ((mode = ((Player)e).getGameMode()) == GameMode.CREATIVE || mode == GameMode.SPECTATOR);
    }

    public void updateTargets() {
        for (SentinelCurrentTarget curTarg : new ArrayList<SentinelCurrentTarget>(this.currentTargets.values())) {
            Entity e = SentinelUtilities.getEntityForID(curTarg.targetID);
            if (SentinelTargetingHelper.isUntargetable(e)) {
                this.removeTargetNoBounce(curTarg.targetID);
                continue;
            }
            if (!e.getWorld().equals((Object)this.getLivingEntity().getWorld())) {
                this.removeTargetNoBounce(curTarg.targetID);
                continue;
            }
            double d = e.getLocation().distanceSquared(this.getLivingEntity().getLocation());
            if (d > this.sentinel.range * this.sentinel.range * 4.0 && d > this.sentinel.chaseRange * this.sentinel.chaseRange * 4.0) {
                this.removeTargetNoBounce(curTarg.targetID);
                continue;
            }
            if (e instanceof LivingEntity && this.isIgnored((LivingEntity)e)) {
                this.removeTargetNoBounce(curTarg.targetID);
                continue;
            }
            if (curTarg.ticksLeft <= 0L) continue;
            curTarg.ticksLeft -= (long)SentinelPlugin.instance.tickRate;
            if (curTarg.ticksLeft > 0L) continue;
            this.removeTargetNoBounce(curTarg.targetID);
        }
        if (this.sentinel.chasing != null && !this.currentTargets.containsKey(this.sentinel.chasing.getUniqueId()) && this.sentinel.tryUpdateChaseTarget(null)) {
            this.getNPC().getNavigator().cancelNavigation();
        }
    }

    static {
        for (int i = 0; i < 36; ++i) {
            double yaw = i * 10;
            SentinelTargetingHelper.directionReferenceVectors[i] = new Vector(Math.sin(-yaw * (Math.PI / 180)), 0.0, Math.cos(yaw * (Math.PI / 180)));
        }
        ASTAR = AStarMachine.createWithDefaultStorage();
        parameters = new NavigatorParameters();
    }

    public static enum TargetListType {
        TARGETS,
        IGNORES,
        AVOIDS;

    }
}

