/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.google.common.base.Splitter;
import net.citizensnpcs.Settings;
import net.minecraft.server.Packet;
import org.apache.commons.lang.Validate;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.World;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Player;

public class Util {
    private Util() {
    }

    public static boolean isSettingFulfilled(Player player, Settings.Setting setting) {
        String parts = setting.asString();
        if (parts.contains("*")) {
            return true;
        }
        for (String part : Splitter.on((char)',').split((CharSequence)parts)) {
            if (Material.matchMaterial((String)part) != player.getItemInHand().getType()) continue;
            return true;
        }
        return false;
    }

    public static void sendToOnline(Packet ... packets) {
        Validate.notNull((Object)packets, (String)"packets cannot be null");
        for (Player player : Bukkit.getOnlinePlayers()) {
            if (player == null || !player.isOnline()) continue;
            for (Packet packet : packets) {
                ((CraftPlayer)player).getHandle().netServerHandler.sendPacket(packet);
            }
        }
    }

    public static void sendPacketNearby(Location location, Packet packet, double radius) {
        radius *= radius;
        World world = location.getWorld();
        for (Player ply : Bukkit.getServer().getOnlinePlayers()) {
            if (ply == null || world != ply.getWorld() || location.distanceSquared(ply.getLocation()) > radius) continue;
            ((CraftPlayer)ply).getHandle().netServerHandler.sendPacket(packet);
        }
    }
}

