/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.entity.Villager;

public class VillagerProfession
extends Trait {
    private final NPC npc;
    private Villager.Profession profession = Villager.Profession.FARMER;

    public VillagerProfession(NPC npc) {
        this.npc = npc;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        try {
            this.profession = Villager.Profession.valueOf((String)key.getString(""));
        }
        catch (IllegalArgumentException ex) {
            throw new NPCLoadException("Invalid profession.");
        }
    }

    @Override
    public void onNPCSpawn() {
        if (this.npc.getBukkitEntity() instanceof Villager) {
            ((Villager)this.npc.getBukkitEntity()).setProfession(this.profession);
        }
    }

    @Override
    public void save(DataKey key) {
        key.setString("", this.profession.name());
    }

    public void setProfession(Villager.Profession profession) {
        this.profession = profession;
        if (this.npc.getBukkitEntity() instanceof Villager) {
            ((Villager)this.npc.getBukkitEntity()).setProfession(profession);
        }
    }

    public String toString() {
        return "Profession{" + this.profession + "}";
    }
}

