/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.ai;

import com.google.common.collect.Lists;
import java.lang.ref.WeakReference;
import java.util.Iterator;
import java.util.List;
import net.citizensnpcs.api.ai.AI;
import net.citizensnpcs.api.ai.Goal;
import net.citizensnpcs.api.ai.NavigationCallback;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.MCNavigationStrategy;
import net.citizensnpcs.npc.ai.MCTargetStrategy;
import net.citizensnpcs.npc.ai.PathStrategy;
import org.bukkit.Location;
import org.bukkit.entity.LivingEntity;

public class CitizensAI
implements AI {
    private final List<WeakReference<NavigationCallback>> callbacks = Lists.newArrayList();
    private PathStrategy executing;
    private final List<GoalEntry> executingGoals = Lists.newArrayList();
    private final List<GoalEntry> goals = Lists.newArrayList();
    private List<Goal> toRemove = null;
    private final CitizensNPC npc;
    private boolean paused;

    public CitizensAI(CitizensNPC npc) {
        this.npc = npc;
    }

    @Override
    public void addGoal(int priority, Goal goal) {
        if (this.goals.contains(goal)) {
            return;
        }
        this.goals.add(new GoalEntry(priority, goal));
    }

    @Override
    public void cancelDestination() {
        if (this.executing == null) {
            return;
        }
        this.executing = null;
        for (int i = 0; i < this.callbacks.size(); ++i) {
            NavigationCallback next = (NavigationCallback)this.callbacks.get(i).get();
            if (next != null && !next.onCancel(this, NavigationCallback.CancelReason.CANCEL)) continue;
            this.callbacks.remove(i);
        }
    }

    @Override
    public boolean hasDestination() {
        return this.executing != null;
    }

    private boolean isGoalAllowable(GoalEntry test) {
        for (int i = 0; i < this.goals.size(); ++i) {
            GoalEntry item = this.goals.get(i);
            if (item == test || test.getPriority() < item.getPriority() || test.getGoal().isCompatibleWith(item.getGoal()) || !this.executingGoals.contains(item)) continue;
            return false;
        }
        return true;
    }

    public void pause() {
        this.paused = true;
    }

    @Override
    public void registerNavigationCallback(NavigationCallback callback) {
        if (!this.callbacks.contains(callback)) {
            this.callbacks.add(new WeakReference<NavigationCallback>(callback));
            callback.onAttach(this);
        }
    }

    @Override
    public void removeGoal(Goal goal) {
        if (this.toRemove == null) {
            this.toRemove = Lists.newArrayList();
        }
        this.toRemove.add(goal);
    }

    public void resume() {
        this.paused = false;
    }

    @Override
    public void setDestination(Location destination) {
        if (destination == null) {
            throw new IllegalArgumentException("destination cannot be null");
        }
        if (!this.npc.isSpawned()) {
            throw new IllegalStateException("npc is not spawned");
        }
        if (destination.getWorld() != this.npc.getBukkitEntity().getWorld()) {
            throw new IllegalArgumentException("location is not in the same world");
        }
        boolean replaced = this.executing != null;
        this.executing = new MCNavigationStrategy(this.npc, destination);
        for (int i = 0; i < this.callbacks.size(); ++i) {
            NavigationCallback next = (NavigationCallback)this.callbacks.get(i).get();
            if (next != null && (!replaced || !next.onCancel(this, NavigationCallback.CancelReason.REPLACE)) && !next.onBegin(this)) continue;
            this.callbacks.remove(i);
        }
    }

    @Override
    public void setTarget(LivingEntity target, boolean aggressive) {
        if (target == null) {
            throw new IllegalArgumentException("target cannot be null");
        }
        boolean replaced = this.executing != null;
        this.executing = new MCTargetStrategy(this.npc, target, aggressive);
        for (int i = 0; i < this.callbacks.size(); ++i) {
            NavigationCallback next = (NavigationCallback)this.callbacks.get(i).get();
            if (next != null && (!replaced || !next.onCancel(this, NavigationCallback.CancelReason.REPLACE)) && !next.onBegin(this)) continue;
            this.callbacks.remove(i);
        }
    }

    public void update() {
        int i;
        if (this.paused || !this.npc.isSpawned()) {
            return;
        }
        if (this.executing != null && this.executing.update()) {
            this.executing = null;
            for (i = 0; i < this.callbacks.size(); ++i) {
                NavigationCallback next = (NavigationCallback)this.callbacks.get(i).get();
                if (next != null && !next.onCompletion(this)) continue;
                this.callbacks.remove(i);
            }
        }
        this.removeGoals();
        for (i = 0; i < this.goals.size(); ++i) {
            GoalEntry entry = this.goals.get(i);
            boolean executing = this.executingGoals.contains(entry);
            if (executing) {
                if (entry.getGoal().continueExecuting() && this.isGoalAllowable(entry)) continue;
                entry.getGoal().reset();
                this.executingGoals.remove(entry);
                continue;
            }
            if (!entry.getGoal().shouldExecute() || !this.isGoalAllowable(entry)) continue;
            entry.getGoal().start();
            this.executingGoals.add(entry);
        }
        for (i = 0; i < this.executingGoals.size(); ++i) {
            this.executingGoals.get(i).getGoal().update();
        }
    }

    private void removeGoals() {
        if (this.toRemove == null) {
            return;
        }
        for (Goal goal : this.toRemove) {
            GoalEntry entry;
            Iterator<GoalEntry> itr = this.executingGoals.iterator();
            while (itr.hasNext()) {
                entry = itr.next();
                if (!entry.getGoal().equals(goal)) continue;
                entry.getGoal().reset();
                itr.remove();
            }
            itr = this.goals.iterator();
            while (itr.hasNext()) {
                entry = itr.next();
                if (!entry.getGoal().equals(goal)) continue;
                itr.remove();
            }
        }
        this.toRemove = null;
    }

    public static class GoalEntry
    implements Comparable<GoalEntry> {
        private final Goal goal;
        private final int priority;

        public GoalEntry(int priority, Goal goal) {
            this.priority = priority;
            this.goal = goal;
        }

        @Override
        public int compareTo(GoalEntry o) {
            return o.priority > this.priority ? 1 : (o.priority < this.priority ? -1 : 0);
        }

        public Goal getGoal() {
            return this.goal;
        }

        public int getPriority() {
            return this.priority;
        }

        public int hashCode() {
            return 31 + (this.goal == null ? 0 : this.goal.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            GoalEntry other = (GoalEntry)obj;
            return !(this.goal == null ? other.goal != null : !this.goal.equals(other.goal));
        }
    }
}

