/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait;

import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.DyeColor;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Sheep;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.SheepDyeWoolEvent;

public class WoolColor
extends Trait
implements Listener {
    private DyeColor color = DyeColor.WHITE;
    private final NPC npc;
    boolean sheep = false;

    public WoolColor(NPC npc) {
        this.npc = npc;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        try {
            this.color = DyeColor.valueOf((String)key.getString(""));
        }
        catch (Exception ex) {
            this.color = DyeColor.WHITE;
        }
    }

    @Override
    public void onNPCSpawn() {
        if (this.npc.getBukkitEntity() instanceof Sheep) {
            ((Sheep)this.npc.getBukkitEntity()).setColor(this.color);
            this.sheep = true;
        } else {
            this.sheep = false;
        }
    }

    @EventHandler
    public void onSheepDyeWool(SheepDyeWoolEvent event) {
        if (this.npc.equals(CitizensAPI.getNPCRegistry().getNPC((Entity)event.getEntity()))) {
            event.setCancelled(true);
        }
    }

    @Override
    public void save(DataKey key) {
        key.setString("", this.color.name());
    }

    public void setColor(DyeColor color) {
        this.color = color;
        if (this.sheep) {
            ((Sheep)this.npc.getBukkitEntity()).setColor(color);
        }
    }

    public String toString() {
        return "WoolColor{" + this.color.name() + "}";
    }
}

