/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import com.google.common.collect.Iterables;
import java.io.File;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import net.citizensnpcs.CitizensDisableEvent;
import net.citizensnpcs.EventListen;
import net.citizensnpcs.Metrics;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.CitizensPlugin;
import net.citizensnpcs.api.event.CitizensReloadEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.scripting.EventRegistrar;
import net.citizensnpcs.api.scripting.ObjectProvider;
import net.citizensnpcs.api.scripting.ScriptCompiler;
import net.citizensnpcs.api.trait.TraitManager;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.DatabaseStorage;
import net.citizensnpcs.api.util.NBTStorage;
import net.citizensnpcs.api.util.Storage;
import net.citizensnpcs.api.util.YamlStorage;
import net.citizensnpcs.command.Command;
import net.citizensnpcs.command.CommandManager;
import net.citizensnpcs.command.Injector;
import net.citizensnpcs.command.command.AdminCommands;
import net.citizensnpcs.command.command.EditorCommands;
import net.citizensnpcs.command.command.HelpCommands;
import net.citizensnpcs.command.command.NPCCommands;
import net.citizensnpcs.command.command.ScriptCommands;
import net.citizensnpcs.command.exception.CommandException;
import net.citizensnpcs.command.exception.CommandUsageException;
import net.citizensnpcs.command.exception.ServerCommandException;
import net.citizensnpcs.command.exception.UnhandledCommandException;
import net.citizensnpcs.command.exception.WrappedCommandException;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.CitizensNPCRegistry;
import net.citizensnpcs.npc.CitizensTraitManager;
import net.citizensnpcs.npc.NPCSelector;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.java.JavaPlugin;

public class Citizens
extends JavaPlugin
implements CitizensPlugin {
    private final CommandManager commands = new CommandManager();
    private boolean compatible;
    private Settings config;
    private ClassLoader contextClassLoader;
    private CitizensNPCRegistry npcRegistry;
    private Storage saves;
    private NPCSelector selector;
    private CitizensTraitManager traitManager;
    private static final String COMPATIBLE_MC_VERSION = "1.2.5";

    private void despawnNPCs() {
        Iterator<NPC> itr = this.npcRegistry.iterator();
        while (itr.hasNext()) {
            NPC npc = itr.next();
            itr.remove();
            npc.despawn();
        }
    }

    public Iterable<Command> getCommands(String base) {
        return this.commands.getCommands(base);
    }

    @Override
    public NPCRegistry getNPCRegistry() {
        return this.npcRegistry;
    }

    public NPCSelector getNPCSelector() {
        return this.selector;
    }

    @Override
    public File getScriptFolder() {
        return new File(this.getDataFolder(), "scripts");
    }

    @Override
    public TraitManager getTraitManager() {
        return this.traitManager;
    }

    public boolean onCommand(CommandSender sender, org.bukkit.command.Command cmd, String cmdName, String[] args) {
        block10: {
            try {
                String modifier;
                String[] split = new String[args.length + 1];
                System.arraycopy(args, 0, split, 1, args.length);
                split[0] = cmd.getName().toLowerCase();
                String string = modifier = args.length > 0 ? args[0] : "";
                if (!this.commands.hasCommand(split[0], modifier) && !modifier.isEmpty()) {
                    return this.suggestClosestModifier(sender, split[0], modifier);
                }
                NPC npc = this.selector.getSelected(sender);
                try {
                    this.commands.execute(split, sender, sender, npc);
                }
                catch (ServerCommandException ex) {
                    Messaging.send(sender, "You must be in-game to execute that command.");
                }
                catch (CommandUsageException ex) {
                    Messaging.sendError(sender, ex.getMessage());
                    Messaging.sendError(sender, ex.getUsage());
                }
                catch (WrappedCommandException ex) {
                    throw ex.getCause();
                }
                catch (UnhandledCommandException ex) {
                    return false;
                }
                catch (CommandException ex) {
                    Messaging.sendError(sender, ex.getMessage());
                }
            }
            catch (NumberFormatException ex) {
                Messaging.sendError(sender, "That is not a valid number.");
            }
            catch (Throwable ex) {
                ex.printStackTrace();
                if (!(sender instanceof Player)) break block10;
                Messaging.sendError(sender, "Please report this error: [See console]");
                Messaging.sendError(sender, ex.getClass().getName() + ": " + ex.getMessage());
            }
        }
        return true;
    }

    public void onDisable() {
        Bukkit.getPluginManager().callEvent((Event)new CitizensDisableEvent());
        this.tearDownScripting();
        if (this.compatible) {
            this.save();
            this.despawnNPCs();
            this.npcRegistry = null;
        }
        Messaging.logF("v%s disabled.", this.getDescription().getVersion());
    }

    public void onEnable() {
        String mcVersion = ((CraftServer)this.getServer()).getServer().getVersion();
        this.compatible = mcVersion.startsWith(COMPATIBLE_MC_VERSION);
        if (!this.compatible) {
            Messaging.severeF("v%s is not compatible with Minecraft v%s. Disabling.", this.getDescription().getVersion(), mcVersion);
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
            return;
        }
        this.registerScriptHelpers();
        this.config = new Settings(this.getDataFolder());
        this.setupStorage();
        this.npcRegistry = new CitizensNPCRegistry(this.saves);
        this.traitManager = new CitizensTraitManager();
        this.selector = new NPCSelector(this);
        CitizensAPI.setImplementation(this);
        this.getServer().getPluginManager().registerEvents((Listener)new EventListen(), (Plugin)this);
        this.registerCommands();
        Messaging.logF("v%s enabled.", this.getDescription().getVersion());
        if (this.getServer().getScheduler().scheduleSyncDelayedTask((Plugin)this, new Runnable(){

            @Override
            public void run() {
                Citizens.this.setupNPCs();
                this.startMetrics();
            }

            private void startMetrics() {
                new Thread(){

                    @Override
                    public void run() {
                        try {
                            Metrics metrics = new Metrics(Citizens.this);
                            if (metrics.isOptOut()) {
                                return;
                            }
                            metrics.addCustomData(new Metrics.Plotter("Total NPCs"){

                                @Override
                                public int getValue() {
                                    return Iterables.size((Iterable)Citizens.this.npcRegistry);
                                }
                            });
                            Citizens.this.traitManager.addPlotters(metrics.createGraph("traits"));
                            metrics.start();
                            Messaging.log("Metrics started.");
                        }
                        catch (IOException e) {
                            Messaging.logF("Unable to start metrics: %s.", e.getMessage());
                        }
                    }
                }.start();
            }
        }) == -1) {
            Messaging.severe("Issue enabling plugin. Disabling.");
            this.getServer().getPluginManager().disablePlugin((Plugin)this);
        }
    }

    @Override
    public void onImplementationChanged() {
        Messaging.severe("Citizens implementation changed, disabling plugin.");
        Bukkit.getPluginManager().disablePlugin((Plugin)this);
    }

    private void registerCommands() {
        this.commands.setInjector(new Injector(this));
        this.commands.register(AdminCommands.class);
        this.commands.register(EditorCommands.class);
        this.commands.register(HelpCommands.class);
        this.commands.register(NPCCommands.class);
        this.commands.register(ScriptCommands.class);
    }

    private void registerScriptHelpers() {
        this.setupScripting();
        ScriptCompiler compiler = CitizensAPI.getScriptCompiler();
        compiler.registerGlobalContextProvider(new EventRegistrar(this));
        compiler.registerGlobalContextProvider(new ObjectProvider("plugin", this));
    }

    public void reload() throws NPCLoadException {
        Editor.leaveAll();
        this.config.reload();
        this.despawnNPCs();
        this.setupNPCs();
        this.getServer().getPluginManager().callEvent((Event)new CitizensReloadEvent());
    }

    public void save() {
        for (NPC npc : this.npcRegistry) {
            ((CitizensNPC)npc).save(this.saves.getKey("npc." + npc.getId()));
        }
        this.saves.save();
    }

    private void setupNPCs() {
        this.saves.load();
        int created = 0;
        int spawned = 0;
        for (DataKey key : this.saves.getKey("npc").getIntegerSubKeys()) {
            int id = Integer.parseInt(key.name());
            if (!key.keyExists("name")) {
                Messaging.logF("Could not find a name for the NPC with ID '%s'.", id);
                continue;
            }
            String unparsedEntityType = key.getString("traits.type", "PLAYER");
            EntityType type = EntityType.fromName((String)unparsedEntityType);
            if (type == null) {
                try {
                    type = EntityType.valueOf((String)unparsedEntityType);
                }
                catch (IllegalArgumentException ex) {
                    Messaging.logF("NPC type '%s' was not recognized. Did you spell it correctly?", unparsedEntityType);
                    continue;
                }
            }
            NPC npc = this.npcRegistry.createNPC(type, id, key.getString("name"));
            ((CitizensNPC)npc).load(key);
            ++created;
            if (!npc.isSpawned()) continue;
            ++spawned;
        }
        Messaging.logF("Loaded %d NPCs (%d spawned).", created, spawned);
    }

    private void setupScripting() {
        this.contextClassLoader = Thread.currentThread().getContextClassLoader();
        Thread.currentThread().setContextClassLoader(this.getClassLoader());
    }

    private void setupStorage() {
        String type = Settings.Setting.STORAGE_TYPE.asString();
        if (type.equalsIgnoreCase("db") || type.equalsIgnoreCase("database")) {
            try {
                this.saves = new DatabaseStorage(Settings.Setting.DATABASE_DRIVER.asString(), Settings.Setting.DATABASE_URL.asString(), Settings.Setting.DATABASE_USERNAME.asString(), Settings.Setting.DATABASE_PASSWORD.asString());
            }
            catch (SQLException e) {
                e.printStackTrace();
                Messaging.log("Unable to connect to database, falling back to YAML");
            }
        } else if (type.equalsIgnoreCase("nbt")) {
            this.saves = new NBTStorage(this.getDataFolder() + File.separator + Settings.Setting.STORAGE_FILE.asString(), "Citizens NPC Storage");
        }
        if (this.saves == null) {
            this.saves = new YamlStorage(this.getDataFolder() + File.separator + Settings.Setting.STORAGE_FILE.asString(), "Citizens NPC Storage");
        }
        Messaging.logF("Save method set to %s.", this.saves.toString());
    }

    private boolean suggestClosestModifier(CommandSender sender, String command, String modifier) {
        int minDist = Integer.MAX_VALUE;
        String closest = "";
        for (String string : this.commands.getAllCommandModifiers(command)) {
            int distance = StringHelper.getLevenshteinDistance(modifier, string);
            if (minDist <= distance) continue;
            minDist = distance;
            closest = string;
        }
        if (!closest.isEmpty()) {
            sender.sendMessage(ChatColor.GRAY + "Unknown command. Did you mean:");
            sender.sendMessage(StringHelper.wrap(" /") + command + " " + StringHelper.wrap(closest));
            return true;
        }
        return false;
    }

    private void tearDownScripting() {
        Thread.currentThread().setContextClassLoader(this.contextClassLoader);
    }
}

