/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api;

import java.io.File;
import java.lang.ref.WeakReference;
import net.citizensnpcs.api.CitizensPlugin;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.scripting.ScriptCompiler;
import net.citizensnpcs.api.trait.TraitManager;
import org.bukkit.plugin.Plugin;

public final class CitizensAPI {
    private WeakReference<CitizensPlugin> implementation;
    private static final CitizensAPI instance = new CitizensAPI();
    private static final ScriptCompiler scriptCompiler = new ScriptCompiler();

    private CitizensAPI() {
    }

    public static File getDataFolder() {
        return CitizensAPI.getImplementation().getDataFolder();
    }

    private static CitizensPlugin getImplementation() {
        return CitizensAPI.instance.implementation != null ? (CitizensPlugin)CitizensAPI.instance.implementation.get() : null;
    }

    public static NPCRegistry getNPCRegistry() {
        return CitizensAPI.getImplementation().getNPCRegistry();
    }

    public static Plugin getPlugin() {
        return CitizensAPI.getImplementation();
    }

    public static ScriptCompiler getScriptCompiler() {
        return scriptCompiler;
    }

    public static File getScriptFolder() {
        return CitizensAPI.getImplementation().getScriptFolder();
    }

    public static TraitManager getTraitManager() {
        return CitizensAPI.getImplementation().getTraitManager();
    }

    public static boolean hasImplementation() {
        return CitizensAPI.getImplementation() != null;
    }

    public static void setImplementation(CitizensPlugin implementation) {
        if (CitizensAPI.hasImplementation()) {
            CitizensAPI.getImplementation().onImplementationChanged();
        }
        CitizensAPI.instance.implementation = new WeakReference<CitizensPlugin>(implementation);
    }

    static {
        new Thread(scriptCompiler).start();
    }
}

