/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc;

import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.util.List;
import java.util.Map;
import net.citizensnpcs.api.event.NPCRemoveEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.character.Character;
import net.citizensnpcs.api.trait.Trait;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.event.Event;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.metadata.MetadataStoreBase;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;

public abstract class AbstractNPC
implements NPC {
    private Character character;
    private final int id;
    private String name;
    protected final List<Runnable> runnables = Lists.newArrayList();
    protected final Map<Class<? extends Trait>, Trait> traits = Maps.newHashMap();
    private static final MetadataStoreBase<NPC> METADATA = new MetadataStoreBase<NPC>(){

        protected String disambiguate(NPC subject, String metadataKey) {
            return Integer.toString(subject.getId()) + ":" + subject.getName() + ":" + metadataKey;
        }
    };

    protected AbstractNPC(int id, String name) {
        this.id = id;
        this.name = name;
    }

    @Override
    public void addTrait(Class<? extends Trait> clazz) {
        this.addTrait(this.getTraitFor(clazz));
    }

    @Override
    public void addTrait(Trait trait) {
        if (trait == null) {
            System.err.println("[Citizens] Cannot register a null trait. Was it registered properly?");
            return;
        }
        if (trait instanceof Runnable) {
            this.runnables.add((Runnable)((Object)trait));
            if (this.traits.containsKey(trait.getClass())) {
                this.runnables.remove(this.traits.get(trait.getClass()));
            }
        }
        if (trait instanceof Listener) {
            Bukkit.getPluginManager().registerEvents((Listener)trait, trait.getPlugin());
        }
        this.traits.put(trait.getClass(), trait);
    }

    @Override
    public Character getCharacter() {
        return this.character;
    }

    @Override
    public String getFullName() {
        return this.name;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public List<MetadataValue> getMetadata(String key) {
        return METADATA.getMetadata((Object)this, key);
    }

    @Override
    public String getName() {
        String parsed = this.name;
        for (ChatColor color : ChatColor.values()) {
            if (!parsed.contains("<" + color.getChar() + ">")) continue;
            parsed = parsed.replace("<" + color.getChar() + ">", "");
        }
        return parsed;
    }

    @Override
    public <T extends Trait> T getTrait(Class<T> clazz) {
        Trait trait = this.traits.get(clazz);
        if (trait == null) {
            trait = this.getTraitFor(clazz);
            this.addTrait(trait);
        }
        return (T)(trait != null ? (Trait)clazz.cast(trait) : null);
    }

    protected abstract Trait getTraitFor(Class<? extends Trait> var1);

    public boolean hasMetadata(String key) {
        return METADATA.hasMetadata((Object)this, key);
    }

    @Override
    public boolean hasTrait(Class<? extends Trait> trait) {
        return this.traits.containsKey(trait);
    }

    @Override
    public void remove() {
        Bukkit.getPluginManager().callEvent((Event)new NPCRemoveEvent(this));
        this.runnables.clear();
        for (Trait trait : this.traits.values()) {
            if (!(trait instanceof Listener)) continue;
            HandlerList.unregisterAll((Listener)((Listener)trait));
        }
        this.traits.clear();
    }

    public void removeMetadata(String key, Plugin plugin) {
        METADATA.removeMetadata((Object)this, key, plugin);
    }

    @Override
    public void removeTrait(Class<? extends Trait> trait) {
        Trait t = this.traits.remove(trait);
        if (t != null) {
            if (t instanceof Runnable) {
                this.runnables.remove(t);
            }
            t.onRemove();
        }
    }

    @Override
    public void setCharacter(Character character) {
        if (this.character != null) {
            if (this.character instanceof Runnable) {
                this.runnables.remove(this.character);
            }
            this.character.onRemove(this);
        }
        this.character = character;
        if (character != null) {
            if (character instanceof Runnable) {
                this.runnables.add((Runnable)((Object)character));
            }
            character.onSet(this);
        }
    }

    public void setMetadata(String key, MetadataValue value) {
        METADATA.setMetadata((Object)this, key, value);
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    public void update() {
        for (int i = 0; i < this.runnables.size(); ++i) {
            this.runnables.get(i).run();
        }
    }
}

