/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.scripting;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.scripting.ContextProvider;
import net.citizensnpcs.api.scripting.Script;
import org.bukkit.event.Event;
import org.bukkit.event.EventException;
import org.bukkit.event.EventPriority;
import org.bukkit.event.HandlerList;
import org.bukkit.event.Listener;
import org.bukkit.plugin.EventExecutor;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.PluginManager;

public class EventRegistrar
implements ContextProvider {
    private final Plugin plugin;

    public EventRegistrar(Plugin plugin) {
        if (plugin == null || !plugin.isEnabled()) {
            throw new IllegalArgumentException("Invalid plugin passed to EventRegistrar. Is it enabled?");
        }
        this.plugin = plugin;
    }

    @Override
    public void provide(Script script) {
        script.setAttribute("events", new Events(this.plugin, script));
    }

    private static class FunctionReference {
        private final String functionName;
        private final Object instance;

        public FunctionReference(String name, Object instance) {
            this.functionName = name;
            this.instance = instance;
        }

        public int hashCode() {
            int prime = 31;
            int result = 31 + (this.functionName == null ? 0 : this.functionName.hashCode());
            return 31 * result + (this.instance == null ? 0 : this.instance.hashCode());
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null || this.getClass() != obj.getClass()) {
                return false;
            }
            FunctionReference other = (FunctionReference)obj;
            if (this.functionName == null ? other.functionName != null : !this.functionName.equals(other.functionName)) {
                return false;
            }
            return !(this.instance == null ? other.instance != null : !this.instance.equals(other.instance));
        }
    }

    public static class Events {
        private final Map<FunctionReference, Listener> anonymousListeners = Maps.newHashMap();
        private final Plugin plugin;
        private final Script script;

        public Events(Plugin plugin, Script script) {
            this.plugin = plugin;
            this.script = script;
        }

        public void deregister(Object instance, String functionName) {
            if (instance == null) {
                this.deregister(functionName);
                return;
            }
            Listener listener = this.script.convertToInterface(functionName, Listener.class);
            if (listener == null) {
                listener = this.anonymousListeners.remove(new FunctionReference(functionName, instance));
            }
            this.deregisterListener(listener);
        }

        public void deregister(String functionName) {
            this.deregisterListener(this.anonymousListeners.remove(new FunctionReference(functionName, null)));
        }

        private void deregisterListener(Listener listener) {
            if (listener != null) {
                HandlerList.unregisterAll((Listener)listener);
            }
        }

        public void register(Object instance, String functionName, Class<? extends Event> eventClass) {
            this.registerEvent(instance, functionName, eventClass);
        }

        public void register(String functionName, Class<? extends Event> eventClass) {
            this.registerEvent(null, functionName, eventClass);
        }

        private void registerEvent(final Object object, final String functionName, final Class<? extends Event> eventClass) {
            Listener listener;
            if (!this.plugin.isEnabled()) {
                throw new IllegalStateException("Plugin is no longer valid.");
            }
            if (functionName == null || eventClass == null) {
                throw new IllegalArgumentException("Arguments should not be null");
            }
            Listener listener2 = listener = object != null ? this.script.convertToInterface(object, Listener.class) : null;
            if (listener == null) {
                listener = new Listener(){};
                this.anonymousListeners.put(new FunctionReference(functionName, object), listener);
            }
            PluginManager manager = this.plugin.getServer().getPluginManager();
            manager.registerEvent(eventClass, listener, EventPriority.NORMAL, new EventExecutor(){

                public void execute(Listener listener, Event event) throws EventException {
                    try {
                        if (!eventClass.isAssignableFrom(event.getClass())) {
                            return;
                        }
                        if (object != null) {
                            Events.this.script.invoke(object, functionName, event);
                        } else {
                            Events.this.script.invoke(functionName, event);
                        }
                    }
                    catch (Throwable t) {
                        throw new EventException(t);
                    }
                }
            }, this.plugin);
        }
    }
}

