/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api;

import java.io.File;
import java.lang.ref.WeakReference;
import net.citizensnpcs.api.CitizensPlugin;
import net.citizensnpcs.api.npc.NPCRegistry;
import net.citizensnpcs.api.scripting.ScriptCompiler;
import net.citizensnpcs.api.trait.TraitFactory;
import org.bukkit.Bukkit;
import org.bukkit.event.Listener;
import org.bukkit.plugin.Plugin;

public final class CitizensAPI {
    private WeakReference<CitizensPlugin> implementation;
    private static final CitizensAPI instance = new CitizensAPI();
    private static ScriptCompiler scriptCompiler;

    private CitizensAPI() {
    }

    public static File getDataFolder() {
        return CitizensAPI.getImplementation().getDataFolder();
    }

    private static CitizensPlugin getImplementation() {
        return CitizensAPI.instance.implementation != null ? (CitizensPlugin)CitizensAPI.instance.implementation.get() : null;
    }

    public static NPCRegistry getNPCRegistry() {
        return CitizensAPI.getImplementation().getNPCRegistry();
    }

    public static Plugin getPlugin() {
        return CitizensAPI.getImplementation();
    }

    public static ScriptCompiler getScriptCompiler() {
        if (scriptCompiler == null) {
            scriptCompiler = new ScriptCompiler();
            scriptCompiler.start();
        }
        return scriptCompiler;
    }

    public static File getScriptFolder() {
        return CitizensAPI.getImplementation().getScriptFolder();
    }

    public static TraitFactory getTraitFactory() {
        return CitizensAPI.getImplementation().getTraitFactory();
    }

    public static boolean hasImplementation() {
        return CitizensAPI.getImplementation() != null;
    }

    public static void setImplementation(CitizensPlugin implementation) {
        if (implementation == null) {
            CitizensAPI.instance.implementation = null;
            return;
        }
        if (CitizensAPI.hasImplementation()) {
            CitizensAPI.getImplementation().onImplementationChanged();
        }
        CitizensAPI.instance.implementation = new WeakReference<CitizensPlugin>(implementation);
    }

    public static void shutdown() {
        if (scriptCompiler != null) {
            scriptCompiler.interrupt();
            scriptCompiler = null;
        }
    }

    public static void registerEvents(Listener listener) {
        Bukkit.getPluginManager().registerEvents(listener, CitizensAPI.getPlugin());
    }
}

