/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import java.util.HashMap;
import java.util.Map;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.trait.waypoint.LinearWaypointProvider;
import net.citizensnpcs.trait.waypoint.WaypointProvider;
import org.bukkit.entity.Player;

public class Waypoints
extends Trait {
    private WaypointProvider provider = new LinearWaypointProvider();
    private String providerName = "linear";
    private static final Map<Class<? extends WaypointProvider>, String> providers = new HashMap<Class<? extends WaypointProvider>, String>();

    public Waypoints() {
        super("waypoints");
    }

    private WaypointProvider create(Class<? extends WaypointProvider> clazz) {
        if (!providers.containsKey(clazz)) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception ex) {
            return null;
        }
    }

    public WaypointProvider getCurrentProvider() {
        return this.provider;
    }

    public Editor getEditor(Player player) {
        return this.provider.createEditor(player);
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        this.provider = null;
        this.providerName = key.getString("provider", "linear");
        for (Map.Entry<Class<? extends WaypointProvider>, String> entry : providers.entrySet()) {
            if (!entry.getValue().equals(this.providerName)) continue;
            this.provider = this.create(entry.getKey());
            break;
        }
        if (this.provider == null) {
            return;
        }
        this.provider.load(key.getRelative(this.providerName));
    }

    @Override
    public void onSpawn() {
        if (this.provider != null) {
            this.provider.onSpawn(this.getNPC());
        }
    }

    @Override
    public void save(DataKey key) {
        if (this.provider == null) {
            return;
        }
        this.provider.save(key.getRelative(this.providerName));
        key.setString("provider", this.providerName);
    }

    public void setWaypointProvider(Class<? extends WaypointProvider> clazz) {
        this.provider = this.create(clazz);
        if (this.provider != null) {
            this.providerName = providers.get(clazz);
        }
    }

    public static void registerWaypointProvider(Class<? extends WaypointProvider> clazz, String name) {
        providers.put(clazz, name);
    }

    static {
        providers.put(LinearWaypointProvider.class, "linear");
    }
}

