/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensMobNPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.Util;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityCreeper;
import net.minecraft.server.EntityLightning;
import net.minecraft.server.World;
import org.bukkit.entity.Creeper;
import org.bukkit.util.Vector;

public class CitizensCreeperNPC
extends CitizensMobNPC {
    public CitizensCreeperNPC(int id, String name) {
        super(id, name, EntityCreeperNPC.class);
    }

    public Creeper getBukkitEntity() {
        return (Creeper)this.getHandle().getBukkitEntity();
    }

    public static class EntityCreeperNPC
    extends EntityCreeper
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityCreeperNPC(World world) {
            this(world, null);
        }

        public EntityCreeperNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                Util.clearGoals(this.goalSelector, this.targetSelector);
            }
        }

        public void a(EntityLightning entitylightning) {
            if (this.npc == null) {
                super.a(entitylightning);
            }
        }

        public void bc() {
            super.bc();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public void collide(Entity entity) {
            super.collide(entity);
            Util.callCollisionEvent(this.npc, entity);
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                return;
            }
            NPCPushEvent event = Util.callPushEvent(this.npc, new Vector(x, y, z));
            if (!event.isCancelled()) {
                super.g(x, y, z);
            }
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

