/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensMobNPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.util.NMSReflection;
import net.citizensnpcs.util.Util;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityEnderDragon;
import net.minecraft.server.World;
import org.bukkit.entity.EnderDragon;
import org.bukkit.util.Vector;

public class CitizensEnderDragonNPC
extends CitizensMobNPC {
    public CitizensEnderDragonNPC(int id, String name) {
        super(id, name, EntityEnderDragonNPC.class);
    }

    public EnderDragon getBukkitEntity() {
        return (EnderDragon)this.getHandle().getBukkitEntity();
    }

    public static class EntityEnderDragonNPC
    extends EntityEnderDragon
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEnderDragonNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMSReflection.clearGoals(this.goalSelector, this.targetSelector);
            }
        }

        public void be() {
            if (this.npc == null) {
                super.be();
            }
        }

        public void collide(Entity entity) {
            super.collide(entity);
            Util.callCollisionEvent(this.npc, entity);
        }

        public void d() {
            if (this.npc != null) {
                this.npc.update();
            } else {
                super.d();
            }
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                return;
            }
            NPCPushEvent event = Util.callPushEvent(this.npc, new Vector(x, y, z));
            if (!event.isCancelled()) {
                super.g(x, y, z);
            }
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

