/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.editor.Equipable;
import net.citizensnpcs.npc.CitizensMobNPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.Saddle;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.NMSReflection;
import net.citizensnpcs.util.StringHelper;
import net.citizensnpcs.util.Util;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityLightning;
import net.minecraft.server.EntityPig;
import net.minecraft.server.World;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Pig;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;
import org.bukkit.util.Vector;

public class CitizensPigNPC
extends CitizensMobNPC
implements Equipable {
    public CitizensPigNPC(int id, String name) {
        super(id, name, EntityPigNPC.class);
    }

    @Override
    public void equip(Player equipper) {
        ItemStack hand = equipper.getItemInHand();
        if (hand.getType() == Material.SADDLE) {
            if (!this.getBukkitEntity().hasSaddle()) {
                this.getTrait(Saddle.class).toggle();
                equipper.setItemInHand(null);
                Messaging.send((CommandSender)equipper, StringHelper.wrap(this.getName()) + " is now saddled.");
            }
        } else if (this.getBukkitEntity().hasSaddle()) {
            equipper.getWorld().dropItemNaturally(this.getBukkitEntity().getLocation(), new ItemStack(Material.SADDLE, 1));
            this.getTrait(Saddle.class).toggle();
            Messaging.send((CommandSender)equipper, StringHelper.wrap(this.getName()) + " is no longer saddled.");
        }
    }

    public Pig getBukkitEntity() {
        return (Pig)this.getHandle().getBukkitEntity();
    }

    public static class EntityPigNPC
    extends EntityPig
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityPigNPC(World world) {
            this(world, null);
        }

        public EntityPigNPC(World world, NPC npc) {
            super(world);
            this.npc = (CitizensNPC)npc;
            if (npc != null) {
                NMSReflection.clearGoals(this.goalSelector, this.targetSelector);
            }
        }

        public void a(EntityLightning entitylightning) {
            if (this.npc == null) {
                super.a(entitylightning);
            }
        }

        public void bc() {
            super.bc();
            if (this.npc != null) {
                this.npc.update();
            }
        }

        public void collide(Entity entity) {
            super.collide(entity);
            Util.callCollisionEvent(this.npc, entity);
        }

        public void g(double x, double y, double z) {
            if (this.npc == null) {
                super.g(x, y, z);
                return;
            }
            if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
                return;
            }
            NPCPushEvent event = Util.callPushEvent(this.npc, new Vector(x, y, z));
            if (!event.isCancelled()) {
                super.g(x, y, z);
            }
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }
    }
}

