/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault;

import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.net.Proxy;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import net.milkbowl.vault.Vault;
import net.milkbowl.vault.chat.Chat;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.configuration.file.YamlConfiguration;
import org.bukkit.plugin.Plugin;
import org.bukkit.plugin.RegisteredServiceProvider;

public class Metrics {
    private static final int REVISION = 5;
    private static final String BASE_URL = "http://metrics.griefcraft.com";
    private static final String REPORT_URL = "/report/%s";
    private static final String CUSTOM_DATA_SEPARATOR = "~~";
    private static final String CONFIG_FILE = "plugins/PluginMetrics/config.yml";
    private static final int PING_INTERVAL = 10;
    private Map<Plugin, Set<Graph>> graphs = Collections.synchronizedMap(new HashMap());
    private Map<Plugin, Graph> defaultGraphs = Collections.synchronizedMap(new HashMap());
    private final YamlConfiguration configuration;
    private String guid;
    private final String pluginVersion;
    private final String authors;

    public Metrics(String version, String authors) throws IOException {
        this.pluginVersion = version;
        this.authors = authors;
        File file = new File(CONFIG_FILE);
        this.configuration = YamlConfiguration.loadConfiguration((File)file);
        this.configuration.addDefault("opt-out", (Object)false);
        this.configuration.addDefault("guid", (Object)UUID.randomUUID().toString());
        if (this.configuration.get("guid", null) == null) {
            this.configuration.options().header(BASE_URL).copyDefaults(true);
            this.configuration.save(file);
        }
        this.guid = this.configuration.getString("guid");
    }

    public Graph createGraph(Plugin plugin, Graph.Type type, String name) {
        if (plugin == null || type == null || name == null) {
            throw new IllegalArgumentException("All arguments must not be null");
        }
        Graph graph = new Graph(type, name);
        Set<Graph> graphs = this.getOrCreateGraphs(plugin);
        graphs.add(graph);
        return graph;
    }

    public void findCustomData(Vault plugin) {
        Graph econGraph = this.createGraph((Plugin)plugin, Graph.Type.Pie, "Economy");
        RegisteredServiceProvider rspEcon = Bukkit.getServer().getServicesManager().getRegistration(Economy.class);
        Economy econ = null;
        if (rspEcon != null) {
            econ = (Economy)rspEcon.getProvider();
        }
        String econName = econ != null ? econ.getName() : "No Economy";
        econGraph.addPlotter(new Plotter(econName){

            @Override
            public int getValue() {
                return 1;
            }
        });
        Graph permGraph = this.createGraph((Plugin)plugin, Graph.Type.Pie, "Permission");
        String permName = ((Permission)Bukkit.getServer().getServicesManager().getRegistration(Permission.class).getProvider()).getName();
        permGraph.addPlotter(new Plotter(permName){

            @Override
            public int getValue() {
                return 1;
            }
        });
        Graph chatGraph = this.createGraph((Plugin)plugin, Graph.Type.Pie, "Chat");
        RegisteredServiceProvider rspChat = Bukkit.getServer().getServicesManager().getRegistration(Chat.class);
        Chat chat = null;
        if (rspChat != null) {
            chat = (Chat)rspChat.getProvider();
        }
        String chatName = chat != null ? chat.getName() : "No Chat";
        chatGraph.addPlotter(new Plotter(chatName){

            @Override
            public int getValue() {
                return 1;
            }
        });
    }

    public synchronized void addCustomData(Plugin plugin, Plotter plotter) {
        Graph graph = this.getOrCreateDefaultGraph(plugin);
        graph.addPlotter(plotter);
        this.getOrCreateGraphs(plugin).add(graph);
    }

    public void beginMeasuringPlugin(final Plugin plugin) throws IOException {
        if (this.configuration.getBoolean("opt-out", false)) {
            return;
        }
        plugin.getServer().getScheduler().scheduleAsyncRepeatingTask(plugin, new Runnable(){
            private boolean firstPost = true;

            @Override
            public void run() {
                try {
                    Metrics.this.postPlugin(plugin, !this.firstPost);
                    this.firstPost = false;
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }, 0L, 12000L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void postPlugin(Plugin plugin, boolean isPing) throws IOException {
        Set<Graph> graphs;
        String data = Metrics.encode("guid") + '=' + Metrics.encode(this.guid) + Metrics.encodeDataPair("authors", this.authors) + Metrics.encodeDataPair("version", this.pluginVersion) + Metrics.encodeDataPair("server", Bukkit.getVersion()) + Metrics.encodeDataPair("players", Integer.toString(Bukkit.getServer().getOnlinePlayers().length)) + Metrics.encodeDataPair("revision", String.valueOf(5));
        if (isPing) {
            data = data + Metrics.encodeDataPair("ping", "true");
        }
        Set<Graph> set = graphs = this.getOrCreateGraphs(plugin);
        synchronized (set) {
            for (Graph graph : graphs) {
                for (Plotter plotter : graph.getPlotters()) {
                    String key = String.format("C%s%s%s%s", CUSTOM_DATA_SEPARATOR, graph.getName(), CUSTOM_DATA_SEPARATOR, plotter.getColumnName());
                    String value = Integer.toString(plotter.getValue());
                    data = data + Metrics.encodeDataPair(key, value);
                }
            }
        }
        URL url = new URL(BASE_URL + String.format(REPORT_URL, plugin.getDescription().getName()));
        URLConnection connection = this.isMineshafterPresent() ? url.openConnection(Proxy.NO_PROXY) : url.openConnection();
        connection.setDoOutput(true);
        OutputStreamWriter writer = new OutputStreamWriter(connection.getOutputStream());
        writer.write(data);
        writer.flush();
        BufferedReader reader = new BufferedReader(new InputStreamReader(connection.getInputStream()));
        String response = reader.readLine();
        writer.close();
        reader.close();
        if (response == null || response.startsWith("ERR")) {
            throw new IOException(response);
        }
        if (response.contains("OK This is your first update this hour")) {
            Set<Graph> set2 = graphs;
            synchronized (set2) {
                for (Graph graph : graphs) {
                    for (Plotter plotter : graph.getPlotters()) {
                        plotter.reset();
                    }
                }
            }
        }
    }

    private Set<Graph> getOrCreateGraphs(Plugin plugin) {
        Set<Graph> theGraphs = this.graphs.get(plugin);
        if (theGraphs == null) {
            theGraphs = Collections.synchronizedSet(new HashSet());
            this.graphs.put(plugin, theGraphs);
        }
        return theGraphs;
    }

    private Graph getOrCreateDefaultGraph(Plugin plugin) {
        Graph graph = this.defaultGraphs.get(plugin);
        if (graph == null) {
            graph = new Graph(Graph.Type.Line, "Default");
            this.defaultGraphs.put(plugin, graph);
        }
        return graph;
    }

    private boolean isMineshafterPresent() {
        try {
            Class.forName("mineshafter.MineServer");
            return true;
        }
        catch (Exception e) {
            return false;
        }
    }

    private static String encodeDataPair(String key, String value) throws UnsupportedEncodingException {
        return "&" + Metrics.encode(key) + "=" + Metrics.encode(value);
    }

    private static String encode(String text) throws UnsupportedEncodingException {
        return URLEncoder.encode(text, "UTF-8");
    }

    public static abstract class Plotter {
        private final String name;

        public Plotter() {
            this("Default");
        }

        public Plotter(String name) {
            this.name = name;
        }

        public String getColumnName() {
            return this.name;
        }

        public abstract int getValue();

        public int hashCode() {
            return this.getColumnName().hashCode() + this.getValue();
        }

        public void reset() {
        }

        public boolean equals(Object object) {
            if (!(object instanceof Plotter)) {
                return false;
            }
            Plotter plotter = (Plotter)object;
            return plotter.getColumnName().equals(this.getColumnName()) && plotter.getValue() == this.getValue();
        }
    }

    public static class Graph {
        private final Type type;
        private final String name;
        private final Set<Plotter> plotters = new LinkedHashSet<Plotter>();

        private Graph(Type type, String name) {
            this.type = type;
            this.name = name;
        }

        public String getName() {
            return this.name;
        }

        public void addPlotter(Plotter plotter) {
            this.plotters.add(plotter);
        }

        public void removePlotter(Plotter plotter) {
            this.plotters.remove(plotter);
        }

        public Set<Plotter> getPlotters() {
            return Collections.unmodifiableSet(this.plotters);
        }

        public int hashCode() {
            return this.type.hashCode() * 17 ^ this.name.hashCode();
        }

        public boolean equals(Object object) {
            if (!(object instanceof Graph)) {
                return false;
            }
            Graph graph = (Graph)object;
            return graph.type == this.type && graph.name.equals(this.name);
        }

        public static enum Type {
            Line,
            Area,
            Column,
            Pie;

        }
    }
}

