/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.economy.plugins;

import com.flobi.GoldIsMoney.GoldIsMoney;
import java.util.ArrayList;
import java.util.List;
import java.util.logging.Logger;
import net.milkbowl.vault.economy.Economy;
import net.milkbowl.vault.economy.EconomyResponse;
import org.bukkit.Bukkit;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Economy_GoldIsMoney
implements Economy {
    private static final Logger log = Logger.getLogger("Minecraft");
    private final String name = "GoldIsMoney";
    private Plugin plugin = null;
    protected GoldIsMoney economy = null;

    public Economy_GoldIsMoney(Plugin plugin) {
        Plugin ec;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new EconomyServerListener(this), plugin);
        if (this.economy == null && (ec = plugin.getServer().getPluginManager().getPlugin("GoldIsMoney")) != null && ec.isEnabled() && ec.getClass().getName().equals("com.flobi.GoldIsMoney.GoldIsMoney")) {
            this.economy = (GoldIsMoney)ec;
            log.info(String.format("[%s][Economy] %s hooked.", plugin.getDescription().getName(), "GoldIsMoney"));
        }
    }

    @Override
    public boolean isEnabled() {
        if (this.economy == null) {
            return false;
        }
        return this.economy.isEnabled();
    }

    @Override
    public String getName() {
        return "GoldIsMoney";
    }

    private double getAccountBalance(String playerName) {
        return GoldIsMoney.getBalance((String)playerName);
    }

    @Override
    public double getBalance(String playerName) {
        return this.getAccountBalance(playerName);
    }

    @Override
    public EconomyResponse withdrawPlayer(String playerName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot withdraw negative funds");
        }
        if (GoldIsMoney.has((String)playerName, (long)Math.round(amount))) {
            GoldIsMoney.withdrawPlayer((String)playerName, (long)((long)amount));
            return new EconomyResponse(amount, this.getAccountBalance(playerName), EconomyResponse.ResponseType.SUCCESS, null);
        }
        return new EconomyResponse(0.0, this.getAccountBalance(playerName), EconomyResponse.ResponseType.FAILURE, "Insufficient funds");
    }

    @Override
    public EconomyResponse depositPlayer(String playerName, double amount) {
        if (amount < 0.0) {
            return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.FAILURE, "Cannot desposit negative funds");
        }
        GoldIsMoney.depositPlayer((String)playerName, (long)Math.round(amount));
        return new EconomyResponse(amount, GoldIsMoney.getBalance((String)playerName), EconomyResponse.ResponseType.SUCCESS, null);
    }

    @Override
    public String format(double amount) {
        return GoldIsMoney.format((long)Math.round(amount));
    }

    @Override
    public String currencyNameSingular() {
        return GoldIsMoney.currencyNameSingular();
    }

    @Override
    public String currencyNamePlural() {
        return GoldIsMoney.currencyNamePlural();
    }

    @Override
    public boolean has(String playerName, double amount) {
        return this.getBalance(playerName) >= amount;
    }

    @Override
    public EconomyResponse createBank(String name, String player) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "GoldIsMoney does not support single account banks!");
    }

    @Override
    public EconomyResponse deleteBank(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "GoldIsMoney does not support bank accounts!");
    }

    @Override
    public EconomyResponse bankHas(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "GoldIsMoney does not support single bank accounts!");
    }

    @Override
    public EconomyResponse bankWithdraw(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "GoldIsMoney does not support single bank accounts!");
    }

    @Override
    public EconomyResponse bankDeposit(String name, double amount) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "GoldIsMoney does not support single bank accounts!");
    }

    @Override
    public EconomyResponse isBankOwner(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "GoldIsMoney does not support single bank accounts!");
    }

    @Override
    public EconomyResponse isBankMember(String name, String playerName) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "GoldIsMoney does not support single bank accounts!");
    }

    @Override
    public EconomyResponse bankBalance(String name) {
        return new EconomyResponse(0.0, 0.0, EconomyResponse.ResponseType.NOT_IMPLEMENTED, "GoldIsMoney does not support single bank accounts!");
    }

    @Override
    public List<String> getBanks() {
        return new ArrayList<String>();
    }

    @Override
    public boolean hasBankSupport() {
        return false;
    }

    @Override
    public boolean hasAccount(String playerName) {
        return GoldIsMoney.hasAccount((String)playerName);
    }

    @Override
    public boolean createPlayerAccount(String playerName) {
        return this.hasAccount(playerName);
    }

    @Override
    public int fractionalDigits() {
        return 0;
    }

    public class EconomyServerListener
    implements Listener {
        Economy_GoldIsMoney economy = null;

        public EconomyServerListener(Economy_GoldIsMoney economy_GoldIsMoney2) {
            this.economy = economy_GoldIsMoney2;
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin ec;
            if (this.economy.economy == null && (ec = Economy_GoldIsMoney.this.plugin.getServer().getPluginManager().getPlugin("GoldIsMoney")) != null && ec.isEnabled() && ec.getClass().getName().equals("com.GoldIsMoney.GoldIsMoney")) {
                this.economy.economy = (GoldIsMoney)ec;
                log.info(String.format("[%s][Economy] %s hooked.", Economy_GoldIsMoney.this.plugin.getDescription().getName(), "GoldIsMoney"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (this.economy.economy != null && event.getPlugin().getDescription().getName().equals("GoldIsMoney")) {
                this.economy.economy = null;
                log.info(String.format("[%s][Economy] %s unhooked.", Economy_GoldIsMoney.this.plugin.getDescription().getName(), "GoldIsMoney"));
            }
        }
    }
}

