/*
 * Decompiled with CFR 0.152.
 */
package net.milkbowl.vault.permission.plugins;

import com.dthielke.starburst.Group;
import com.dthielke.starburst.GroupManager;
import com.dthielke.starburst.GroupSet;
import com.dthielke.starburst.StarburstPlugin;
import com.dthielke.starburst.User;
import java.util.ArrayList;
import java.util.Set;
import net.milkbowl.vault.permission.Permission;
import org.bukkit.Bukkit;
import org.bukkit.OfflinePlayer;
import org.bukkit.entity.Player;
import org.bukkit.event.EventHandler;
import org.bukkit.event.EventPriority;
import org.bukkit.event.Listener;
import org.bukkit.event.server.PluginDisableEvent;
import org.bukkit.event.server.PluginEnableEvent;
import org.bukkit.plugin.Plugin;

public class Permission_Starburst
extends Permission {
    private StarburstPlugin perms;
    private final String name = "Starburst";

    public Permission_Starburst(Plugin plugin) {
        Plugin p;
        this.plugin = plugin;
        Bukkit.getServer().getPluginManager().registerEvents((Listener)new PermissionServerListener(), plugin);
        if (this.perms == null && (p = plugin.getServer().getPluginManager().getPlugin("Starburst")) != null) {
            this.perms = (StarburstPlugin)p;
            log.info(String.format("[%s][Permission] %s hooked.", plugin.getDescription().getName(), "Starburst"));
        }
    }

    @Override
    public String[] getGroups() {
        String[] s = new String[this.perms.getGroupManager().getDefaultGroupSet().getGroups().size()];
        int i = 0;
        for (Group g : this.perms.getGroupManager().getDefaultGroupSet().getGroups()) {
            s[i] = g.getName();
            ++i;
        }
        return s;
    }

    @Override
    public String getName() {
        return "Starburst";
    }

    @Override
    public String[] getPlayerGroups(String world, String player) {
        OfflinePlayer op = Bukkit.getOfflinePlayer((String)player);
        GroupSet set = this.perms.getGroupManager().getWorldSet(Bukkit.getWorld((String)world));
        User user = set.getUser(op);
        Set children = user.getChildren(true);
        ArrayList<String> groups = new ArrayList<String>();
        for (Group child : children) {
            groups.add(child.getName());
        }
        return groups.toArray(new String[groups.size()]);
    }

    @Override
    public String getPrimaryGroup(String world, String player) {
        OfflinePlayer op = Bukkit.getOfflinePlayer((String)player);
        GroupSet set = this.perms.getGroupManager().getWorldSet(Bukkit.getWorld((String)world));
        User user = set.getUser(op);
        Set children = user.getChildren(false);
        if (!children.isEmpty()) {
            return ((Group)children.iterator().next()).getName();
        }
        return null;
    }

    @Override
    public boolean groupAdd(String world, String group, String permission) {
        GroupManager gm = this.perms.getGroupManager();
        GroupSet set = gm.getWorldSet(Bukkit.getWorld((String)world));
        if (set.hasGroup(group)) {
            Group g = set.getGroup(group);
            boolean value = !permission.startsWith("^");
            permission = value ? permission : permission.substring(1);
            g.addPermission(permission, value, true, true);
            for (User user : gm.getAffectedUsers(g)) {
                user.applyPermissions(gm.getFactory());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean groupHas(String world, String group, String permission) {
        GroupSet set = this.perms.getGroupManager().getWorldSet(Bukkit.getWorld((String)world));
        if (set.hasGroup(group)) {
            Group g = set.getGroup(group);
            return g.hasPermission(permission, true);
        }
        return false;
    }

    @Override
    public boolean groupRemove(String world, String group, String permission) {
        GroupManager gm = this.perms.getGroupManager();
        GroupSet set = gm.getWorldSet(Bukkit.getWorld((String)world));
        if (set.hasGroup(group)) {
            Group g = set.getGroup(group);
            boolean value = !permission.startsWith("^");
            String string = permission = value ? permission : permission.substring(1);
            if (g.hasPermission(permission, false)) {
                g.removePermission(permission, true);
                for (User user : gm.getAffectedUsers(g)) {
                    user.applyPermissions(gm.getFactory());
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean hasSuperPermsCompat() {
        return true;
    }

    @Override
    public boolean isEnabled() {
        return this.perms != null && this.perms.isEnabled();
    }

    @Override
    public boolean playerAdd(String world, String player, String permission) {
        OfflinePlayer op = Bukkit.getOfflinePlayer((String)player);
        GroupSet set = this.perms.getGroupManager().getWorldSet(Bukkit.getWorld((String)world));
        User user = set.getUser(op);
        boolean value = !permission.startsWith("^");
        permission = value ? permission : permission.substring(1);
        user.addPermission(permission, value, true, true);
        if (user.isActive()) {
            user.applyPermissions(this.perms.getGroupManager().getFactory());
        }
        return true;
    }

    @Override
    public boolean playerAddGroup(String world, String player, String group) {
        OfflinePlayer op = Bukkit.getOfflinePlayer((String)player);
        GroupSet set = this.perms.getGroupManager().getWorldSet(Bukkit.getWorld((String)world));
        User user = set.getUser(op);
        if (set.hasGroup(group)) {
            Group g = set.getGroup(group);
            if (!user.hasChild(g, false)) {
                user.addChild(g, true);
                if (user.isActive()) {
                    user.applyPermissions(this.perms.getGroupManager().getFactory());
                }
                return true;
            }
            return false;
        }
        return false;
    }

    @Override
    public boolean playerHas(String world, String player, String permission) {
        Player p;
        OfflinePlayer op = Bukkit.getOfflinePlayer((String)player);
        if (op.isOnline() && (p = (Player)op).getWorld().getName().equalsIgnoreCase(world)) {
            return p.hasPermission(permission);
        }
        GroupSet set = this.perms.getGroupManager().getWorldSet(Bukkit.getWorld((String)world));
        User user = set.getUser(op);
        return user.hasPermission(permission, true);
    }

    @Override
    public boolean playerInGroup(String world, String player, String group) {
        OfflinePlayer op = Bukkit.getOfflinePlayer((String)player);
        GroupSet set = this.perms.getGroupManager().getWorldSet(Bukkit.getWorld((String)world));
        User user = set.getUser(op);
        if (set.hasGroup(group)) {
            Group g = set.getGroup(group);
            return user.hasChild(g, true);
        }
        return false;
    }

    @Override
    public boolean playerRemove(String world, String player, String permission) {
        OfflinePlayer op = Bukkit.getOfflinePlayer((String)player);
        GroupSet set = this.perms.getGroupManager().getWorldSet(Bukkit.getWorld((String)world));
        User user = set.getUser(op);
        boolean value = !permission.startsWith("^");
        String string = permission = value ? permission : permission.substring(1);
        if (user.hasPermission(permission, false)) {
            user.removePermission(permission, true);
            if (user.isActive()) {
                user.applyPermissions(this.perms.getGroupManager().getFactory());
            }
            return true;
        }
        return false;
    }

    @Override
    public boolean playerRemoveGroup(String world, String player, String group) {
        OfflinePlayer op = Bukkit.getOfflinePlayer((String)player);
        GroupSet set = this.perms.getGroupManager().getWorldSet(Bukkit.getWorld((String)world));
        User user = set.getUser(op);
        if (set.hasGroup(group)) {
            Group g = set.getGroup(group);
            if (user.hasChild(g, false)) {
                user.removeChild(g, true);
                if (user.isActive()) {
                    user.applyPermissions(this.perms.getGroupManager().getFactory());
                }
                return true;
            }
            return false;
        }
        return false;
    }

    public class PermissionServerListener
    implements Listener {
        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginEnable(PluginEnableEvent event) {
            Plugin p;
            if (Permission_Starburst.this.perms == null && (p = event.getPlugin()).getDescription().getName().equals("Starburst") && p.isEnabled()) {
                Permission_Starburst.this.perms = (StarburstPlugin)p;
                log.info(String.format("[%s][Permission] %s hooked.", Permission_Starburst.this.plugin.getDescription().getName(), "Starburst"));
            }
        }

        @EventHandler(priority=EventPriority.MONITOR)
        public void onPluginDisable(PluginDisableEvent event) {
            if (Permission_Starburst.this.perms != null && event.getPlugin().getDescription().getName().equals("Starburst")) {
                Permission_Starburst.this.perms = null;
                log.info(String.format("[%s][Permission] %s un-hooked.", Permission_Starburst.this.plugin.getDescription().getName(), "Starburst"));
            }
        }
    }
}

