/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import java.io.IOException;
import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.network.EmptyNetHandler;
import net.citizensnpcs.npc.network.EmptyNetworkManager;
import net.citizensnpcs.npc.network.EmptySocket;
import net.citizensnpcs.util.Util;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.EnumGamemode;
import net.minecraft.server.ItemInWorldManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Navigation;
import net.minecraft.server.NetHandler;
import net.minecraft.server.World;
import org.bukkit.util.Vector;

public class EntityHumanNPC
extends EntityPlayer
implements NPCHolder {
    private final CitizensNPC npc;

    public EntityHumanNPC(MinecraftServer minecraftServer, World world, String string, ItemInWorldManager itemInWorldManager, NPC npc) {
        super(minecraftServer, world, string, itemInWorldManager);
        this.npc = (CitizensNPC)npc;
        itemInWorldManager.setGameMode(EnumGamemode.SURVIVAL);
        EmptySocket socket = new EmptySocket();
        EmptyNetworkManager netMgr = new EmptyNetworkManager(socket, "npc mgr", new NetHandler(){

            public boolean a() {
                return false;
            }
        }, this.server.E().getPrivate());
        this.netServerHandler = new EmptyNetHandler(minecraftServer, netMgr, this);
        netMgr.a((NetHandler)this.netServerHandler);
        try {
            socket.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    public void collide(Entity entity) {
        super.collide(entity);
        Util.callCollisionEvent(this.npc, entity);
    }

    public void g(double x, double y, double z) {
        if (this.npc == null) {
            super.g(x, y, z);
            return;
        }
        if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
            return;
        }
        Vector vector = new Vector(x, y, z);
        NPCPushEvent event = Util.callPushEvent(this.npc, vector);
        if (!event.isCancelled()) {
            vector = event.getCollisionVector();
            super.g(vector.getX(), vector.getY(), vector.getZ());
        }
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    public void h_() {
        super.h_();
        Navigation navigation = this.getNavigation();
        if (!navigation.f()) {
            navigation.e();
            this.moveOnCurrentHeading();
        } else if (this.motX != 0.0 || this.motZ != 0.0 || this.motY != 0.0) {
            // empty if block
        }
        if (this.noDamageTicks > 0) {
            --this.noDamageTicks;
        }
        this.npc.update();
    }

    private void moveOnCurrentHeading() {
        this.getControllerMove().c();
        this.getControllerLook().a();
        this.getControllerJump().b();
        if (this.bu) {
            boolean inLiquid;
            boolean bl = inLiquid = this.H() || this.J();
            if (inLiquid) {
                this.motY += 0.04;
            } else if (this.onGround && this.bE == 0) {
                this.motY = 0.6;
                this.bE = 10;
            }
        } else {
            this.bE = 0;
        }
        this.bs *= 0.98f;
        this.aG *= this.bs();
        this.e(this.br, this.bs);
        this.as = this.yaw;
    }
}

