/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.command.command;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.command.Command;
import net.citizensnpcs.command.CommandConfigurable;
import net.citizensnpcs.command.CommandContext;
import net.citizensnpcs.command.exception.CommandException;
import net.citizensnpcs.command.exception.NoPermissionsException;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;

public class TraitCommands {
    @Command(aliases={"trait", "tr"}, usage="[trait name], [trait name]...", desc="Adds traits to the NPC", modifiers={"*"}, min=1, max=1, flags="r", permission="npc.trait")
    public void add(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        ArrayList added = Lists.newArrayList();
        ArrayList removed = Lists.newArrayList();
        ArrayList failed = Lists.newArrayList();
        for (String traitName : Splitter.on((char)',').split((CharSequence)args.getJoinedStrings(0))) {
            Class clazz;
            if (!sender.hasPermission("citizens.npc.trait." + traitName)) {
                failed.add(String.format("%s: No permission", traitName));
            }
            if ((clazz = CitizensAPI.getTraitFactory().getTraitClass(traitName)) == null) {
                failed.add(String.format("%s: Trait not found", traitName));
                continue;
            }
            boolean remove = npc.hasTrait(clazz);
            if (remove) {
                npc.removeTrait(clazz);
                removed.add(StringHelper.wrap(traitName));
                continue;
            }
            npc.addTrait(clazz);
            added.add(StringHelper.wrap(traitName));
        }
        if (added.size() > 0) {
            Messaging.sendF(sender, ChatColor.GREEN + "Added %s successfully.", Joiner.on((String)", ").join((Iterable)removed));
        }
        if (removed.size() > 0) {
            Messaging.sendF(sender, ChatColor.GREEN + "Removed %s successfully.", Joiner.on((String)", ").join((Iterable)removed));
        }
        if (failed.size() > 0) {
            Messaging.send(sender, ChatColor.GRAY + "Couldn't change the following traits - " + Joiner.on((String)", ").join((Iterable)failed));
        }
    }

    @Command(aliases={"traitc", "trc", "tc"}, usage="[trait name] [flags]", desc="Configures a trait", modifiers={"*"}, min=2, flags="*", permission="npc.trait-configure")
    public void configure(CommandContext args, CommandSender sender, NPC npc) throws CommandException {
        String traitName = args.getString(0);
        if (!sender.hasPermission("citizens.npc.trait-configure." + traitName)) {
            throw new NoPermissionsException();
        }
        Class clazz = CitizensAPI.getTraitFactory().getTraitClass(args.getString(0));
        if (clazz == null) {
            throw new CommandException("Trait not found.");
        }
        if (!clazz.isAssignableFrom(CommandConfigurable.class)) {
            throw new CommandException("That trait is not configurable");
        }
        if (!npc.hasTrait(clazz)) {
            throw new CommandException("The NPC doesn't have that trait.");
        }
        CommandConfigurable trait = (CommandConfigurable)npc.getTrait(clazz);
        trait.configure(args);
    }
}

