/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.ListMultimap;
import com.google.gson.internal.Pair;
import java.util.Iterator;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.event.NPCLeftClickEvent;
import net.citizensnpcs.api.event.NPCRightClickEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.CitizensNPCManager;
import net.citizensnpcs.npc.entity.EntityHumanNPC;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.trait.text.Text;
import net.citizensnpcs.util.Messaging;
import org.bukkit.Bukkit;
import org.bukkit.Chunk;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.event.EventHandler;
import org.bukkit.event.Listener;
import org.bukkit.event.entity.EntityDamageByEntityEvent;
import org.bukkit.event.entity.EntityDamageEvent;
import org.bukkit.event.entity.EntityDeathEvent;
import org.bukkit.event.entity.EntityTargetEvent;
import org.bukkit.event.player.PlayerChangedWorldEvent;
import org.bukkit.event.player.PlayerInteractEntityEvent;
import org.bukkit.event.player.PlayerQuitEvent;
import org.bukkit.event.world.ChunkLoadEvent;
import org.bukkit.event.world.ChunkUnloadEvent;
import org.bukkit.event.world.WorldLoadEvent;
import org.bukkit.event.world.WorldUnloadEvent;
import org.bukkit.metadata.MetadataValue;

public class EventListen
implements Listener {
    private volatile CitizensNPCManager npcManager;
    private final ListMultimap<Pair<Integer, Integer>, Integer> toRespawn = ArrayListMultimap.create();

    public EventListen(CitizensNPCManager npcManager) {
        this.npcManager = npcManager;
    }

    @EventHandler
    public void onChunkLoad(ChunkLoadEvent event) {
        Pair<Integer, Integer> coord = this.toIntPair(event.getChunk());
        if (!this.toRespawn.containsKey(coord)) {
            return;
        }
        Iterator i$ = this.toRespawn.get(coord).iterator();
        while (i$.hasNext()) {
            int id = (Integer)i$.next();
            NPC npc = this.npcManager.getNPC(id);
            npc.spawn(npc.getTrait(CurrentLocation.class).getLocation());
        }
        this.toRespawn.removeAll(coord);
    }

    @EventHandler
    public void onChunkUnload(ChunkUnloadEvent event) {
        if (event.isCancelled()) {
            return;
        }
        Pair<Integer, Integer> coord = this.toIntPair(event.getChunk());
        for (NPC npc : this.npcManager) {
            if (!npc.isSpawned()) continue;
            Location loc = npc.getBukkitEntity().getLocation();
            if (!event.getWorld().equals(loc.getWorld()) || event.getChunk().getX() != loc.getChunk().getX() || event.getChunk().getZ() != loc.getChunk().getZ()) continue;
            npc.despawn();
            this.toRespawn.put(coord, (Object)npc.getId());
        }
    }

    @EventHandler
    public void onEntityDamage(EntityDamageEvent event) {
        EntityDamageByEntityEvent e;
        if (!this.npcManager.isNPC(event.getEntity())) {
            return;
        }
        event.setCancelled(true);
        if (event instanceof EntityDamageByEntityEvent && (e = (EntityDamageByEntityEvent)event).getDamager() instanceof Player) {
            Player damager = (Player)e.getDamager();
            NPC npc = this.npcManager.getNPC(event.getEntity());
            NPCLeftClickEvent leftClickEvent = new NPCLeftClickEvent(npc, damager);
            Bukkit.getPluginManager().callEvent((Event)leftClickEvent);
            if (leftClickEvent.isCancelled()) {
                return;
            }
            if (npc.getCharacter() != null) {
                npc.getCharacter().onLeftClick(npc, damager);
            }
        }
    }

    @EventHandler
    public void onEntityTarget(EntityTargetEvent event) {
        if (event.isCancelled() || !this.npcManager.isNPC(event.getEntity()) || !(event.getTarget() instanceof Player)) {
            return;
        }
        NPC npc = this.npcManager.getNPC(event.getEntity());
        Player player = (Player)event.getTarget();
        NPCRightClickEvent rightClickEvent = new NPCRightClickEvent(npc, player);
        Bukkit.getPluginManager().callEvent((Event)rightClickEvent);
        if (rightClickEvent.isCancelled()) {
            return;
        }
        if (!(player.hasMetadata("selected") && player.getMetadata("selected").size() != 0 && ((MetadataValue)player.getMetadata("selected").get(0)).asInt() == npc.getId() || player.getItemInHand().getTypeId() != Settings.Setting.SELECTION_ITEM.asInt() || !npc.getTrait(Owner.class).getOwner().equals(player.getName()) && !player.hasPermission("citizens.admin"))) {
            this.npcManager.selectNPC(player, npc);
            Messaging.sendWithNPC((CommandSender)player, Settings.Setting.SELECTION_MESSAGE.asString(), npc);
            if (!Settings.Setting.QUICK_SELECT.asBoolean()) {
                return;
            }
        }
        if (player.getItemInHand().getTypeId() == Settings.Setting.TALK_ITEM.asInt() && !npc.getTrait(Text.class).shouldTalkClose()) {
            npc.getTrait(Text.class).sendText(player);
        }
        if (npc.getCharacter() != null) {
            npc.getCharacter().onRightClick(npc, player);
        }
    }

    @EventHandler
    public void onEntityDeath(EntityDeathEvent event) {
        if (!this.npcManager.isNPC((Entity)event.getEntity())) {
            return;
        }
        NPC npc = this.npcManager.getNPC((Entity)event.getEntity());
        npc.despawn();
    }

    @EventHandler
    public void onPlayerChangedWorld(PlayerChangedWorldEvent event) {
        if (!(((CraftPlayer)event.getPlayer()).getHandle() instanceof EntityHumanNPC)) {
            return;
        }
        ((CraftServer)Bukkit.getServer()).getHandle().players.remove(((CraftPlayer)event.getPlayer()).getHandle());
    }

    @EventHandler
    public void onPlayerInteractEntity(PlayerInteractEntityEvent event) {
        if (!this.npcManager.isNPC(event.getRightClicked())) {
            return;
        }
        Bukkit.getPluginManager().callEvent((Event)new EntityTargetEvent(event.getRightClicked(), (Entity)event.getPlayer(), EntityTargetEvent.TargetReason.CUSTOM));
    }

    @EventHandler
    public void onPlayerQuit(PlayerQuitEvent event) {
        Editor.leave(event.getPlayer());
    }

    @EventHandler
    public void onWorldLoad(WorldLoadEvent event) {
        for (Pair chunk : this.toRespawn.keySet()) {
            if (!event.getWorld().isChunkLoaded(((Integer)chunk.first).intValue(), ((Integer)chunk.second).intValue())) continue;
            Iterator i$ = this.toRespawn.get((Object)chunk).iterator();
            while (i$.hasNext()) {
                int id = (Integer)i$.next();
                NPC npc = this.npcManager.getNPC(id);
                npc.spawn(npc.getTrait(CurrentLocation.class).getLocation());
            }
            this.toRespawn.removeAll((Object)chunk);
        }
    }

    @EventHandler
    public void onWorldUnload(WorldUnloadEvent event) {
        if (event.isCancelled()) {
            return;
        }
        for (NPC npc : this.npcManager) {
            if (!npc.isSpawned() || !npc.getBukkitEntity().getWorld().equals(event.getWorld())) continue;
            npc.despawn();
            this.toRespawn.put(this.toIntPair(npc.getBukkitEntity().getLocation().getChunk()), (Object)npc.getId());
        }
    }

    private Pair<Integer, Integer> toIntPair(Chunk chunk) {
        return new Pair((Object)chunk.getX(), (Object)chunk.getZ());
    }
}

