/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs;

import java.io.File;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Storage;
import net.citizensnpcs.api.util.YamlStorage;
import net.citizensnpcs.util.Messaging;

public class Settings {
    private final Storage config;

    public Settings(File folder) {
        this.config = new YamlStorage(folder + File.separator + "config.yml", "Citizens Configuration");
    }

    public void load() {
        DataKey root = this.config.getKey("");
        for (Setting setting : Setting.values()) {
            if (!root.keyExists(setting.path)) {
                Messaging.log("Writing default setting: '" + setting.path + "'");
                root.setRaw(setting.path, setting.get());
                continue;
            }
            setting.set(root.getRaw(setting.path));
        }
        this.save();
    }

    public void save() {
        this.config.save();
    }

    public static enum Setting {
        CHAT_PREFIX("npc.chat.prefix", "[<npc>]: "),
        DATABASE_DRIVER("database.driver", ""),
        DATABASE_PASSWORD("database.password", ""),
        DATABASE_URL("database.url", ""),
        DATABASE_USERNAME("database.username", ""),
        DEBUG_MODE("general.debug-mode", false),
        DEFAULT_LOOK_CLOSE("npc.default.look-close", false),
        DEFAULT_RANDOM_TALKER("npc.default.random-talker", true),
        DEFAULT_TALK_CLOSE("npc.default.talk-close", false),
        QUICK_SELECT("npc.selection.quick-select", false),
        SELECTION_ITEM("npc.selection.item", 280),
        SELECTION_MESSAGE("npc.selection.message", "<b>You selected <a><npc><b>!"),
        TALK_CLOSE_MAXIMUM_COOLDOWN("npc.talk.max-cooldown", 60),
        TALK_CLOSE_MINIMUM_COOLDOWN("npc.talk.min-cooldown", 30),
        TALK_ITEM("npc.talk-item", 340),
        USE_DATABASE("use-database", false);

        private String path;
        private Object value;

        private Setting(String path, Object value) {
            this.path = path;
            this.value = value;
        }

        public boolean asBoolean() {
            return (Boolean)this.value;
        }

        public double asDouble() {
            return (Double)this.value;
        }

        public int asInt() {
            return (Integer)this.value;
        }

        public long asLong() {
            return (Long)this.value;
        }

        public String asString() {
            return this.value.toString();
        }

        private Object get() {
            return this.value;
        }

        private void set(Object value) {
            this.value = value;
        }
    }
}

