/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.command.command;

import java.util.ArrayList;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.character.Character;
import net.citizensnpcs.api.npc.character.CharacterManager;
import net.citizensnpcs.api.trait.trait.MobType;
import net.citizensnpcs.api.trait.trait.Owner;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.command.Command;
import net.citizensnpcs.command.CommandContext;
import net.citizensnpcs.command.Requirements;
import net.citizensnpcs.command.exception.CommandException;
import net.citizensnpcs.command.exception.NoPermissionsException;
import net.citizensnpcs.npc.CitizensNPCManager;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.trait.LookClose;
import net.citizensnpcs.trait.Powered;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.Paginator;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.ChatColor;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Entity;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;
import org.bukkit.event.player.PlayerTeleportEvent;

@Requirements(selected=true, ownership=true)
public class NPCCommands {
    private final CharacterManager characterManager = CitizensAPI.getCharacterManager();
    private final CitizensNPCManager npcManager;

    public NPCCommands(Citizens plugin) {
        this.npcManager = plugin.getNPCManager();
    }

    @Command(aliases={"npc"}, usage="character [character]", desc="Set the character of a NPC", modifiers={"character"}, min=2, max=2)
    public void character(CommandContext args, Player player, NPC npc) throws CommandException {
        String name = args.getString(1).toLowerCase();
        Character character = this.characterManager.getCharacter(name);
        if (character == null) {
            throw new CommandException("The character '" + args.getString(1) + "' does not exist.");
        }
        if (npc.getCharacter() != null && npc.getCharacter().getName().equalsIgnoreCase(character.getName())) {
            throw new CommandException("The NPC already has the character '" + name + "'.");
        }
        if (!(player.hasPermission("citizens.npc.character." + character.getName()) || player.hasPermission("citizens.npc.character.*") || player.hasPermission("citizens.admin"))) {
            throw new NoPermissionsException();
        }
        EntityType type = EntityType.valueOf((String)npc.getTrait(MobType.class).getType());
        if (!character.getValidTypes().isEmpty() && !character.getValidTypes().contains(type)) {
            Messaging.sendError((CommandSender)player, "This NPC cannot be given the character '" + character.getName() + "'.");
            return;
        }
        Messaging.send((CommandSender)player, StringHelper.wrap(npc.getName() + "'s") + " character is now '" + StringHelper.wrap(name) + "'.");
        npc.setCharacter(character);
    }

    @Command(aliases={"npc"}, usage="create [name] (--type (type) --char (char))", desc="Create a new NPC", modifiers={"create"}, min=2, max=5, permission="npc.create")
    @Requirements
    public void create(CommandContext args, Player player, NPC npc) {
        String name = args.getString(1);
        if (name.length() > 16) {
            Messaging.sendError((CommandSender)player, "NPC names cannot be longer than 16 characters. The name has been shortened.");
            name = name.substring(0, 15);
        }
        EntityType type = EntityType.PLAYER;
        if (args.hasValueFlag("type")) {
            try {
                type = EntityType.valueOf((String)args.getFlag("type").toUpperCase().replace('-', '_'));
            }
            catch (IllegalArgumentException ex) {
                Messaging.sendError((CommandSender)player, "'" + args.getFlag("type") + "' is not a valid mob type. Using default NPC.");
            }
        }
        NPC create = this.npcManager.createNPC(type, name);
        String msg = ChatColor.GREEN + "You created " + StringHelper.wrap(create.getName());
        if (args.hasValueFlag("char")) {
            String character = args.getFlag("char").toLowerCase();
            if (this.characterManager.getCharacter(character) == null) {
                Messaging.sendError((CommandSender)player, "'" + args.getFlag("char") + "' is not a valid character.");
                return;
            }
            Character set = this.characterManager.getCharacter(character);
            if (!set.getValidTypes().isEmpty() && !set.getValidTypes().contains(type)) {
                Messaging.sendError((CommandSender)player, "The character '" + set.getName() + "' cannot be given the mob type '" + type.name().toLowerCase() + "'.");
                create.remove();
                return;
            }
            create.setCharacter(this.characterManager.getCharacter(character));
            msg = msg + " with the character " + StringHelper.wrap(character);
        }
        msg = msg + " at your location.";
        create.getTrait(Owner.class).setOwner(player.getName());
        create.getTrait(MobType.class).setType(type.toString());
        create.spawn(player.getLocation());
        this.npcManager.selectNPC(player, create);
        Messaging.send((CommandSender)player, msg);
    }

    @Command(aliases={"npc"}, usage="despawn", desc="Despawn a NPC", modifiers={"despawn"}, min=1, max=1, permission="npc.despawn")
    public void despawn(CommandContext args, Player player, NPC npc) {
        npc.getTrait(Spawned.class).setSpawned(false);
        npc.despawn();
        Messaging.send((CommandSender)player, ChatColor.GREEN + "You despawned " + StringHelper.wrap(npc.getName()) + ".");
    }

    @Command(aliases={"npc"}, usage="list (page) ((-a) --owner (owner) --type (type) --char (char))", desc="List NPCs", flags="a", modifiers={"list"}, min=1, max=2, permission="npc.list")
    @Requirements
    public void list(CommandContext args, Player player, NPC npc) throws CommandException {
        ArrayList<NPC> npcs = new ArrayList<NPC>();
        if (args.hasFlag('a')) {
            for (NPC add : this.npcManager) {
                npcs.add(add);
            }
        } else if (args.getValueFlags().size() == 0 && args.argsLength() == 1 || args.argsLength() == 2) {
            for (NPC add : this.npcManager) {
                if (!add.getTrait(Owner.class).getOwner().equalsIgnoreCase(player.getName())) continue;
                npcs.add(add);
            }
        } else {
            if (args.hasValueFlag("owner")) {
                String name = args.getFlag("owner");
                for (NPC add : this.npcManager) {
                    if (!add.getTrait(Owner.class).getOwner().equalsIgnoreCase(name)) continue;
                    npcs.add(add);
                }
            }
            if (args.hasValueFlag("type")) {
                String type = args.getFlag("type");
                try {
                    EntityType.valueOf((String)type.toUpperCase().replace('-', '_'));
                }
                catch (IllegalArgumentException ex) {
                    throw new CommandException("'" + type + "' is not a valid mob type.");
                }
                for (NPC add : this.npcManager) {
                    if (npcs.contains(add) || !add.getTrait(MobType.class).getType().equalsIgnoreCase(type)) continue;
                    npcs.add(add);
                }
            }
            if (args.hasValueFlag("char")) {
                String character = args.getFlag("char");
                if (this.characterManager.getCharacter(character) == null) {
                    throw new CommandException("'" + character + "' is not a valid character.");
                }
                for (NPC add : this.npcManager.getNPCs(this.characterManager.getCharacter(character).getClass())) {
                    if (npcs.contains(add) || add.getCharacter() == null || !add.getCharacter().getName().equals(character.toLowerCase())) continue;
                    npcs.add(add);
                }
            }
        }
        Paginator paginator = new Paginator();
        paginator.setHeaderText("NPCs");
        paginator.addLine("<e>Key: <a>ID  <b>Name");
        for (int i = 0; i < npcs.size(); i += 2) {
            String line = "<a>" + ((NPC)npcs.get(i)).getId() + "<b>  " + ((NPC)npcs.get(i)).getName();
            if (npcs.size() >= i + 2) {
                line = line + "      <a>" + ((NPC)npcs.get(i + 1)).getId() + "<b>  " + ((NPC)npcs.get(i + 1)).getName();
            }
            paginator.addLine(line);
        }
        int page = 1;
        try {
            page = args.getInteger(1);
        }
        catch (Exception ex) {
            // empty catch block
        }
        if (!paginator.sendPage((CommandSender)player, page)) {
            throw new CommandException("The page '" + page + "' does not exist.");
        }
    }

    @Command(aliases={"npc"}, usage="lookclose", desc="Toggle whether a NPC will look when a player is near", modifiers={"lookclose", "look", "rotate"}, min=1, max=1, permission="npc.lookclose")
    public void lookClose(CommandContext args, Player player, NPC npc) {
        String msg = StringHelper.wrap(npc.getName()) + " will " + (npc.getTrait(LookClose.class).toggle() ? "now rotate" : "no longer rotate");
        msg = msg + " when a player is nearby.";
        Messaging.send((CommandSender)player, msg);
    }

    @Command(aliases={"npc"}, desc="Show basic NPC information", max=0)
    public void npc(CommandContext args, Player player, NPC npc) {
        Messaging.send((CommandSender)player, StringHelper.wrapHeader(npc.getName()));
        Messaging.send((CommandSender)player, "    <a>ID: <e>" + npc.getId());
        Messaging.send((CommandSender)player, "    <a>Character: <e>" + (npc.getCharacter() != null ? npc.getCharacter().getName() : "None"));
        Messaging.send((CommandSender)player, "    <a>Type: <e>" + npc.getTrait(MobType.class).getType());
    }

    @Command(aliases={"npc"}, usage="owner [name]", desc="Set the owner of an NPC", modifiers={"owner"}, min=2, max=2, permission="npc.owner")
    public void owner(CommandContext args, Player player, NPC npc) throws CommandException {
        String name = args.getString(1);
        if (npc.getTrait(Owner.class).getOwner().equals(name)) {
            throw new CommandException("'" + name + "' is already the owner of " + npc.getName() + ".");
        }
        npc.getTrait(Owner.class).setOwner(name);
        Messaging.send((CommandSender)player, StringHelper.wrap(name) + " is now the owner of " + StringHelper.wrap(npc.getName()) + ".");
    }

    @Command(aliases={"npc"}, usage="remove (all)", desc="Remove a NPC", modifiers={"remove"}, min=1, max=2)
    @Requirements
    public void remove(CommandContext args, Player player, NPC npc) throws CommandException {
        if (args.argsLength() == 2) {
            if (!args.getString(1).equals("all")) {
                throw new CommandException("Incorrect syntax. /npc remove (all)");
            }
            if (!player.hasPermission("citizens.npc.remove.all") && !player.hasPermission("citizens.admin")) {
                throw new NoPermissionsException();
            }
            this.npcManager.removeAll();
            Messaging.send((CommandSender)player, "<a>You permanently removed all NPCs.");
            return;
        }
        if (npc == null) {
            throw new CommandException("You must have an NPC selected to execute that command.");
        }
        if (!npc.getTrait(Owner.class).getOwner().equals(player.getName()) && !player.hasPermission("citizens.admin")) {
            throw new CommandException("You must be the owner of this NPC to execute that command.");
        }
        if (!player.hasPermission("citizens.npc.remove") && !player.hasPermission("citizens.admin")) {
            throw new NoPermissionsException();
        }
        npc.remove();
        Messaging.send((CommandSender)player, "<a>You permanently removed " + StringHelper.wrap(npc.getName()) + ".");
    }

    @Command(aliases={"npc"}, usage="rename [name]", desc="Rename a NPC", modifiers={"rename"}, min=2, max=2, permission="npc.rename")
    public void rename(CommandContext args, Player player, NPC npc) {
        String oldName = npc.getName();
        String newName = args.getString(1);
        if (newName.length() > 16) {
            Messaging.sendError((CommandSender)player, "NPC names cannot be longer than 16 characters. The name has been shortened.");
            newName = newName.substring(0, 15);
        }
        npc.setName(newName);
        Messaging.send((CommandSender)player, ChatColor.GREEN + "You renamed " + StringHelper.wrap(oldName) + " to " + StringHelper.wrap(newName) + ".");
    }

    @Command(aliases={"npc"}, usage="select [id]", desc="Select a NPC with the given ID", modifiers={"select"}, min=2, max=2, permission="npc.select")
    @Requirements(ownership=true)
    public void select(CommandContext args, Player player, NPC npc) throws CommandException {
        NPC toSelect = this.npcManager.getNPC(args.getInteger(1));
        if (toSelect == null || !toSelect.getTrait(Spawned.class).shouldSpawn()) {
            throw new CommandException("No NPC with the ID '" + args.getInteger(1) + "' is spawned.");
        }
        if (npc != null && toSelect.getId() == npc.getId()) {
            throw new CommandException("You already have that NPC selected.");
        }
        this.npcManager.selectNPC(player, toSelect);
        Messaging.sendWithNPC((CommandSender)player, Settings.Setting.SELECTION_MESSAGE.asString(), toSelect);
    }

    @Command(aliases={"npc"}, usage="spawn [id]", desc="Spawn an existing NPC", modifiers={"spawn"}, min=2, max=2, permission="npc.spawn")
    @Requirements
    public void spawn(CommandContext args, Player player, NPC npc) throws CommandException {
        NPC respawn = this.npcManager.getNPC(args.getInteger(1));
        if (respawn == null) {
            throw new CommandException("No NPC with the ID '" + args.getInteger(1) + "' exists.");
        }
        if (!respawn.getTrait(Owner.class).getOwner().equals(player.getName())) {
            throw new CommandException("You must be the owner of this NPC to execute that command.");
        }
        if (!respawn.spawn(player.getLocation())) {
            throw new CommandException(respawn.getName() + " is already spawned at another location." + " Use '/npc tphere' to teleport the NPC to your location.");
        }
        this.npcManager.selectNPC(player, respawn);
        Messaging.send((CommandSender)player, ChatColor.GREEN + "You respawned " + StringHelper.wrap(respawn.getName()) + " at your location.");
    }

    @Command(aliases={"npc"}, usage="tp", desc="Teleport to a NPC", modifiers={"tp", "teleport"}, min=1, max=1, permission="npc.tp")
    public void tp(CommandContext args, Player player, NPC npc) {
        if (!npc.isSpawned()) {
            npc.spawn(npc.getTrait(CurrentLocation.class).getLocation());
        }
        player.teleport((Entity)npc.getBukkitEntity(), PlayerTeleportEvent.TeleportCause.COMMAND);
        Messaging.send((CommandSender)player, ChatColor.GREEN + "You teleported to " + StringHelper.wrap(npc.getName()) + ".");
    }

    @Command(aliases={"npc"}, usage="tphere", desc="Teleport a NPC to your location", modifiers={"tphere"}, min=1, max=1, permission="npc.tphere")
    public void tphere(CommandContext args, Player player, NPC npc) {
        if (!npc.isSpawned()) {
            npc.spawn(npc.getTrait(CurrentLocation.class).getLocation());
        }
        npc.getBukkitEntity().teleport((Entity)player, PlayerTeleportEvent.TeleportCause.COMMAND);
        Messaging.send((CommandSender)player, StringHelper.wrap(npc.getName()) + " was teleported to your location.");
    }

    @Command(aliases={"npc"}, usage="power", desc="Toggle a creeper NPC as powered", modifiers={"power"}, min=1, max=1, permission="npc.power")
    @Requirements(selected=true, ownership=true, types={EntityType.CREEPER})
    public void power(CommandContext args, Player player, NPC npc) {
        String msg = StringHelper.wrap(npc.getName()) + " will " + (npc.getTrait(Powered.class).toggle() ? "now" : "no longer");
        msg = msg + " be powered.";
        Messaging.send((CommandSender)player, msg);
    }
}

