/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc;

import java.util.logging.Level;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.event.NPCDespawnEvent;
import net.citizensnpcs.api.event.NPCSpawnEvent;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.AbstractNPC;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.npc.character.Character;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.trait.trait.Spawned;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.npc.CitizensNPCManager;
import net.citizensnpcs.npc.CitizensTraitManager;
import net.citizensnpcs.npc.ai.CitizensAI;
import net.citizensnpcs.trait.CurrentLocation;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityLiving;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.LivingEntity;
import org.bukkit.entity.Player;
import org.bukkit.event.Event;
import org.bukkit.inventory.InventoryHolder;

public abstract class CitizensNPC
extends AbstractNPC {
    private final CitizensAI ai = new CitizensAI(this);
    private final CitizensNPCManager manager;
    protected EntityLiving mcEntity;
    private final CitizensTraitManager traitManager;

    protected CitizensNPC(CitizensNPCManager manager, int id, String name) {
        super(id, name);
        this.manager = manager;
        this.traitManager = (CitizensTraitManager)CitizensAPI.getTraitManager();
    }

    @Override
    public void chat(Player player, String message) {
        Messaging.sendWithNPC((CommandSender)player, Settings.Setting.CHAT_PREFIX.asString() + message, this);
    }

    @Override
    public void chat(String message) {
        for (Player player : Bukkit.getOnlinePlayers()) {
            this.chat(player, message);
        }
    }

    protected abstract EntityLiving createHandle(Location var1);

    @Override
    public boolean despawn() {
        if (!this.isSpawned()) {
            Messaging.debug("The NPC with the ID '" + this.getId() + "' is already despawned.");
            return false;
        }
        Bukkit.getPluginManager().callEvent((Event)new NPCDespawnEvent(this));
        this.manager.despawn(this, this.getTrait(Spawned.class).shouldSpawn());
        this.mcEntity = null;
        return true;
    }

    @Override
    public CitizensAI getAI() {
        return this.ai;
    }

    @Override
    public LivingEntity getBukkitEntity() {
        return (LivingEntity)this.getHandle().getBukkitEntity();
    }

    public EntityLiving getHandle() {
        return this.mcEntity;
    }

    public org.bukkit.inventory.Inventory getInventory() {
        org.bukkit.inventory.Inventory inventory = Bukkit.getServer().createInventory((InventoryHolder)this, 36, StringHelper.parseColors(this.getFullName()));
        inventory.setContents(this.getTrait(Inventory.class).getContents());
        return inventory;
    }

    @Override
    public <T extends Trait> T getTrait(Class<T> clazz) {
        Trait t = (Trait)this.traits.get(clazz);
        if (t == null) {
            this.addTrait((Trait)this.traitManager.getTrait(clazz, (NPC)this));
        }
        return (T)(this.traits.get(clazz) != null ? (Trait)clazz.cast(this.traits.get(clazz)) : null);
    }

    @Override
    public boolean isSpawned() {
        return this.getHandle() != null;
    }

    @Override
    public void remove() {
        super.remove();
        this.manager.remove(this);
        if (this.isSpawned()) {
            this.despawn();
        }
    }

    @Override
    public void setName(String name) {
        super.setName(name);
    }

    @Override
    public boolean spawn(Location loc) {
        if (this.isSpawned()) {
            Messaging.debug("The NPC with the ID '" + this.getId() + "' is already spawned.");
            return false;
        }
        NPCSpawnEvent spawnEvent = new NPCSpawnEvent(this, loc);
        Bukkit.getPluginManager().callEvent((Event)spawnEvent);
        if (spawnEvent.isCancelled()) {
            return false;
        }
        this.mcEntity = this.createHandle(loc);
        this.mcEntity.world.addEntity((Entity)this.mcEntity);
        this.mcEntity.world.players.remove(this.mcEntity);
        this.getTrait(CurrentLocation.class).spawn(loc);
        this.getTrait(Spawned.class).setSpawned(true);
        for (Trait trait : this.getTraits()) {
            trait.onNPCSpawn();
        }
        return true;
    }

    @Override
    public void update() {
        super.update();
        this.ai.update();
    }

    public void load(DataKey root) throws NPCLoadException {
        Character character = CitizensAPI.getCharacterManager().getCharacter(root.getString("character"));
        if (character != null) {
            character.load(root.getRelative("characters." + character.getName()));
            this.setCharacter(character);
        }
        for (DataKey traitKey : root.getRelative("traits").getSubKeys()) {
            Object trait = this.traitManager.getTrait(traitKey.name(), (NPC)this);
            if (trait == null) {
                throw new NPCLoadException("No trait with the name '" + traitKey.name() + "' exists. Was it registered properly?");
            }
            try {
                ((Trait)trait).load(traitKey);
            }
            catch (Exception ex) {
                Bukkit.getLogger().log(Level.SEVERE, "[Citizens] The trait '" + traitKey.name() + "' failed to load properly for the NPC with the ID '" + this.getId() + "'. " + ex.getMessage());
                ex.printStackTrace();
            }
            this.addTrait((Trait)trait);
        }
        if (this.getTrait(Spawned.class).shouldSpawn()) {
            this.spawn(this.getTrait(CurrentLocation.class).getLocation());
        }
    }

    public void save(DataKey root) {
        root.setString("name", this.getFullName());
        if (this.getCharacter() != null) {
            root.setString("character", this.getCharacter().getName());
            this.getCharacter().save(root.getRelative("characters." + this.getCharacter().getName()));
        }
        for (Trait trait : this.getTraits()) {
            trait.save(root.getRelative("traits." + trait.getName()));
        }
    }
}

