/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.trait.trait.Equipment;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.editor.Equipable;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.CitizensNPCManager;
import net.citizensnpcs.npc.entity.EntityHumanNPC;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import net.minecraft.server.EntityLiving;
import net.minecraft.server.ItemInWorldManager;
import net.minecraft.server.World;
import net.minecraft.server.WorldServer;
import org.bukkit.Location;
import org.bukkit.Material;
import org.bukkit.command.CommandSender;
import org.bukkit.craftbukkit.CraftWorld;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class CitizensHumanNPC
extends CitizensNPC
implements Equipable {
    public CitizensHumanNPC(CitizensNPCManager manager, int id, String name) {
        super(manager, id, name);
    }

    @Override
    protected EntityLiving createHandle(Location loc) {
        WorldServer ws = ((CraftWorld)loc.getWorld()).getHandle();
        EntityHumanNPC handle = new EntityHumanNPC(ws.getServer().getServer(), (World)ws, StringHelper.parseColors(this.getFullName()), new ItemInWorldManager(ws));
        handle.removeFromPlayerMap(this.getFullName());
        handle.setPositionRotation(loc.getX(), loc.getY(), loc.getZ(), loc.getYaw(), loc.getPitch());
        return handle;
    }

    public Player getBukkitEntity() {
        return this.getHandle().getBukkitEntity();
    }

    public EntityHumanNPC getHandle() {
        return (EntityHumanNPC)this.mcEntity;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        super.load(key);
    }

    @Override
    public void setName(String name) {
        super.setName(name);
        Location prev = this.getBukkitEntity().getLocation();
        this.despawn();
        this.spawn(prev);
    }

    @Override
    public void update() {
        super.update();
        if (this.mcEntity != null) {
            this.mcEntity.move(0.0, -0.1, 0.0);
        }
    }

    @Override
    public void equip(Player equipper) {
        ItemStack set;
        ItemStack hand = equipper.getItemInHand();
        Equipment trait = this.getTrait(Equipment.class);
        int slot = 0;
        switch (hand.getType()) {
            case PUMPKIN: 
            case JACK_O_LANTERN: 
            case LEATHER_HELMET: 
            case CHAINMAIL_HELMET: 
            case GOLD_HELMET: 
            case IRON_HELMET: 
            case DIAMOND_HELMET: {
                if (equipper.isSneaking()) break;
                slot = 1;
                break;
            }
            case LEATHER_CHESTPLATE: 
            case CHAINMAIL_CHESTPLATE: 
            case GOLD_CHESTPLATE: 
            case IRON_CHESTPLATE: 
            case DIAMOND_CHESTPLATE: {
                if (equipper.isSneaking()) break;
                slot = 2;
                break;
            }
            case LEATHER_LEGGINGS: 
            case CHAINMAIL_LEGGINGS: 
            case GOLD_LEGGINGS: 
            case IRON_LEGGINGS: 
            case DIAMOND_LEGGINGS: {
                if (equipper.isSneaking()) break;
                slot = 3;
                break;
            }
            case LEATHER_BOOTS: 
            case CHAINMAIL_BOOTS: 
            case GOLD_BOOTS: 
            case IRON_BOOTS: 
            case DIAMOND_BOOTS: {
                if (equipper.isSneaking()) break;
                slot = 4;
                break;
            }
            case AIR: {
                for (int i = 0; i < 5; ++i) {
                    if (trait.get(i) == null || trait.get(i).getType() == Material.AIR) continue;
                    equipper.getWorld().dropItemNaturally(this.getBukkitEntity().getLocation(), trait.get(i));
                    trait.set(i, null);
                }
                Messaging.send((CommandSender)equipper, "<e>" + this.getName() + " <a>had all of its items removed.");
            }
        }
        if (trait.get(slot) != null && trait.get(slot).getType() != Material.AIR) {
            equipper.getWorld().dropItemNaturally(this.getBukkitEntity().getLocation(), trait.get(slot));
        }
        if ((set = hand) != null && set.getType() != Material.AIR) {
            if (hand.getAmount() > 1) {
                hand.setAmount(hand.getAmount() - 1);
            } else {
                hand = null;
            }
            equipper.setItemInHand(hand);
            set.setAmount(1);
        }
        trait.set(slot, set);
    }
}

