/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.text;

import java.util.ArrayList;
import java.util.Calendar;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import net.citizensnpcs.Settings;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.editor.Editor;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.trait.Toggleable;
import net.citizensnpcs.trait.text.prompt.StartPrompt;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.Paginator;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityHuman;
import net.minecraft.server.EntityLiving;
import org.bukkit.Bukkit;
import org.bukkit.command.CommandSender;
import org.bukkit.conversations.Conversable;
import org.bukkit.conversations.Conversation;
import org.bukkit.conversations.ConversationAbandonedEvent;
import org.bukkit.conversations.ConversationAbandonedListener;
import org.bukkit.conversations.ConversationFactory;
import org.bukkit.conversations.Prompt;
import org.bukkit.entity.Player;
import org.bukkit.plugin.Plugin;

public class Text
extends Trait
implements Runnable,
Toggleable,
ConversationAbandonedListener {
    private final Plugin plugin;
    private final NPC npc;
    private final List<String> text = new ArrayList<String>();
    private final Map<String, Calendar> cooldowns = new HashMap<String, Calendar>();
    private boolean talkClose = Settings.Setting.DEFAULT_TALK_CLOSE.asBoolean();
    private boolean randomTalker = Settings.Setting.DEFAULT_RANDOM_TALKER.asBoolean();
    private int currentIndex;

    public Text(NPC npc) {
        this.npc = npc;
        this.plugin = Bukkit.getPluginManager().getPlugin("Citizens");
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        for (DataKey sub : key.getIntegerSubKeys()) {
            this.text.add(sub.getString(""));
        }
        if (key.keyExists("talk-close")) {
            this.talkClose = key.getBoolean("talk-close");
        }
        if (key.keyExists("random-talker")) {
            this.randomTalker = key.getBoolean("random-talker");
        }
    }

    @Override
    public void save(DataKey key) {
        key.setBoolean("talk-close", this.talkClose);
        key.setBoolean("random-talker", this.randomTalker);
        for (int i = 0; i < this.text.size(); ++i) {
            key.setString(String.valueOf(i), this.text.get(i));
        }
    }

    @Override
    public boolean toggle() {
        this.talkClose = !this.talkClose;
        return this.talkClose;
    }

    @Override
    public void run() {
        if (!this.npc.isSpawned()) {
            return;
        }
        EntityHuman search = null;
        EntityLiving handle = ((CitizensNPC)this.npc).getHandle();
        search = handle.world.findNearbyPlayer((Entity)handle, 5.0);
        if (search != null && this.talkClose) {
            Player player = (Player)search.getBukkitEntity();
            if (this.cooldowns.get(player.getName()) != null) {
                if (!Calendar.getInstance().after(this.cooldowns.get(player.getName()))) {
                    return;
                }
                this.cooldowns.remove(player.getName());
            }
            if (this.sendText(player)) {
                Calendar wait = Calendar.getInstance();
                wait.add(13, new Random().nextInt(Settings.Setting.TALK_CLOSE_MAXIMUM_COOLDOWN.asInt()) + Settings.Setting.TALK_CLOSE_MINIMUM_COOLDOWN.asInt());
                this.cooldowns.put(player.getName(), wait);
            }
        }
    }

    public void conversationAbandoned(ConversationAbandonedEvent event) {
        Bukkit.dispatchCommand((CommandSender)((Player)event.getContext().getForWhom()), (String)"npc text");
    }

    public boolean shouldTalkClose() {
        return this.talkClose;
    }

    public Editor getEditor(final Player player) {
        final Conversation conversation = new ConversationFactory(this.plugin).addConversationAbandonedListener((ConversationAbandonedListener)this).withLocalEcho(false).withEscapeSequence("/npc text").withModality(false).withFirstPrompt((Prompt)new StartPrompt(this)).buildConversation((Conversable)player);
        return new Editor(){

            @Override
            public void begin() {
                Messaging.send((CommandSender)player, "<b>Entered the text editor!");
                conversation.begin();
            }

            @Override
            public void end() {
                Messaging.send((CommandSender)player, "<a>Exited the text editor.");
            }
        };
    }

    public void add(String string) {
        this.text.add(string);
    }

    public void remove(int index) {
        this.text.remove(index);
    }

    public void edit(int index, String newText) {
        this.text.set(index, newText);
    }

    public boolean hasIndex(int index) {
        return this.text.size() > index;
    }

    public boolean sendPage(Player player, int page) {
        Paginator paginator = new Paginator();
        paginator.setHeaderText(this.npc.getName() + "'s Text Entries");
        for (int i = 0; i < this.text.size(); ++i) {
            paginator.addLine("<a>" + i + " <7>- <e>" + this.text.get(i));
        }
        return paginator.sendPage((CommandSender)player, page);
    }

    public boolean sendText(Player player) {
        if (!player.hasPermission("citizens.admin") && !player.hasPermission("citizens.npc.talk")) {
            return false;
        }
        if (this.text.size() == 0) {
            return false;
        }
        int index = 0;
        if (this.randomTalker) {
            index = new Random().nextInt(this.text.size());
        } else {
            if (this.currentIndex > this.text.size() - 1) {
                this.currentIndex = 0;
            }
            index = this.currentIndex++;
        }
        this.npc.chat(player, this.text.get(index));
        return true;
    }

    public boolean toggleRandomTalker() {
        this.randomTalker = !this.randomTalker;
        return this.randomTalker;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("Text{talk-close=" + this.talkClose + ",text=");
        for (String line : this.text) {
            builder.append(line + ",");
        }
        builder.append("}");
        return builder.toString();
    }
}

