/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import java.util.ArrayList;
import java.util.List;
import net.citizensnpcs.util.Messaging;
import net.citizensnpcs.util.StringHelper;
import org.bukkit.command.CommandSender;

public class Paginator {
    private static final int LINES_PER_PAGE = 9;
    private String header;
    private final List<String> lines = new ArrayList<String>();

    public void addLine(String line) {
        this.lines.add(line);
    }

    public boolean sendPage(CommandSender sender, int page) {
        int pages = (int)(this.lines.size() / 9 == 0 ? 1.0 : Math.ceil((double)this.lines.size() / 9.0));
        if (page < 0 || page > pages) {
            return false;
        }
        int startIndex = 9 * page - 9;
        int endIndex = page * 9;
        Messaging.send(sender, StringHelper.wrapHeader("<e>" + this.header + " <f>" + page + "/" + pages));
        if (this.lines.size() < endIndex) {
            endIndex = this.lines.size();
        }
        for (String line : this.lines.subList(startIndex, endIndex)) {
            Messaging.send(sender, line);
        }
        return true;
    }

    public void setHeaderText(String header) {
        this.header = header;
    }
}

