/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.npc.entity;

import java.io.IOException;
import java.util.List;
import net.citizensnpcs.api.event.NPCPushEvent;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.network.EmptyNetHandler;
import net.citizensnpcs.npc.network.EmptyNetworkManager;
import net.citizensnpcs.npc.network.EmptySocket;
import net.citizensnpcs.util.Util;
import net.minecraft.server.Entity;
import net.minecraft.server.EntityPlayer;
import net.minecraft.server.EnumGamemode;
import net.minecraft.server.ItemInWorldManager;
import net.minecraft.server.MinecraftServer;
import net.minecraft.server.Navigation;
import net.minecraft.server.NetHandler;
import net.minecraft.server.World;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.CraftServer;
import org.bukkit.craftbukkit.entity.CraftPlayer;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.plugin.Plugin;
import org.bukkit.util.Vector;

public class EntityHumanNPC
extends EntityPlayer
implements NPCHolder {
    private final CitizensNPC npc;
    private static final float STEP_HEIGHT = 1.0f;

    public EntityHumanNPC(MinecraftServer minecraftServer, World world, String string, ItemInWorldManager itemInWorldManager, NPC npc) {
        super(minecraftServer, world, string, itemInWorldManager);
        itemInWorldManager.setGameMode(EnumGamemode.SURVIVAL);
        this.npc = (CitizensNPC)npc;
        if (npc != null) {
            this.initialise(minecraftServer);
        }
    }

    public void collide(Entity entity) {
        super.collide(entity);
        if (this.npc != null) {
            Util.callCollisionEvent(this.npc, entity);
        }
    }

    public void g(double x, double y, double z) {
        if (this.npc == null) {
            super.g(x, y, z);
            return;
        }
        if (NPCPushEvent.getHandlerList().getRegisteredListeners().length == 0) {
            if (!this.npc.data().get("protected", true).booleanValue()) {
                super.g(x, y, z);
            }
            return;
        }
        Vector vector = new Vector(x, y, z);
        NPCPushEvent event = Util.callPushEvent(this.npc, vector);
        if (!event.isCancelled()) {
            vector = event.getCollisionVector();
            super.g(vector.getX(), vector.getY(), vector.getZ());
        }
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc == null) {
            return super.getBukkitEntity();
        }
        if (this.bukkitEntity != null) {
            return (CraftPlayer)this.bukkitEntity;
        }
        this.bukkitEntity = new CraftPlayer((CraftServer)Bukkit.getServer(), this){

            public List<MetadataValue> getMetadata(String metadataKey) {
                return this.server.getEntityMetadata().getMetadata((Object)this, metadataKey);
            }

            public boolean hasMetadata(String metadataKey) {
                return this.server.getEntityMetadata().hasMetadata((Object)this, metadataKey);
            }

            public void removeMetadata(String metadataKey, Plugin owningPlugin) {
                this.server.getEntityMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
            }

            public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
                this.server.getEntityMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
            }
        };
        return (CraftPlayer)this.bukkitEntity;
    }

    @Override
    public NPC getNPC() {
        return this.npc;
    }

    public void h_() {
        super.h_();
        if (this.npc == null) {
            return;
        }
        Navigation navigation = this.getNavigation();
        if (!navigation.f()) {
            navigation.e();
            this.moveOnCurrentHeading();
        } else if (!(this.npc.getNavigator().isNavigating() || this.motX == 0.0 && this.motZ == 0.0 && this.motY == 0.0)) {
            this.e(0.0f, 0.0f);
        }
        if (this.noDamageTicks > 0) {
            --this.noDamageTicks;
        }
        this.npc.update();
    }

    private void initialise(MinecraftServer minecraftServer) {
        EmptySocket socket = new EmptySocket();
        EmptyNetworkManager netMgr = null;
        try {
            netMgr = new EmptyNetworkManager(socket, "npc mgr", new NetHandler(){

                public boolean a() {
                    return false;
                }
            }, this.server.E().getPrivate());
            this.netServerHandler = new EmptyNetHandler(minecraftServer, netMgr, this);
            netMgr.a((NetHandler)this.netServerHandler);
        }
        catch (IOException e) {
            // empty catch block
        }
        this.W = 1.0f;
        this.getNavigation().e(true);
        try {
            socket.close();
        }
        catch (IOException ex) {
            // empty catch block
        }
    }

    private void moveOnCurrentHeading() {
        this.getControllerMove().c();
        this.getControllerLook().a();
        this.getControllerJump().b();
        this.e(this.npc.getNavigator().getDefaultParameters().speed());
        if (this.bu) {
            boolean inLiquid;
            boolean bl = inLiquid = this.H() || this.J();
            if (inLiquid) {
                this.motY += 0.04;
            } else if (this.onGround && this.bE == 0) {
                this.motY = 0.6;
                this.bE = 10;
            }
        } else {
            this.bE = 0;
        }
        this.br *= 0.98f;
        this.bs *= 0.98f;
        this.bt *= 0.9f;
        float prev = this.aG;
        this.aG *= this.bs() * this.npc.getNavigator().getDefaultParameters().speed();
        this.e(this.br, this.bs);
        this.aG = prev;
        this.as = this.yaw;
    }
}

