/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R3.entity;

import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.nms.v1_21_R3.entity.MobEntityController;
import net.citizensnpcs.nms.v1_21_R3.util.ForwardingNPCHolder;
import net.citizensnpcs.nms.v1_21_R3.util.NMSBoundingBox;
import net.citizensnpcs.nms.v1_21_R3.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.trait.versioned.EnderDragonTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.server.level.EntityPlayer;
import net.minecraft.server.level.WorldServer;
import net.minecraft.sounds.SoundEffect;
import net.minecraft.tags.TagKey;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.EntityInsentient;
import net.minecraft.world.entity.EntityTypes;
import net.minecraft.world.entity.IEntitySelector;
import net.minecraft.world.entity.boss.enderdragon.DragonFlightHistory;
import net.minecraft.world.entity.boss.enderdragon.EntityEnderDragon;
import net.minecraft.world.entity.boss.enderdragon.phases.DragonControllerPhase;
import net.minecraft.world.entity.vehicle.EntityBoat;
import net.minecraft.world.entity.vehicle.EntityMinecartAbstract;
import net.minecraft.world.level.World;
import net.minecraft.world.level.material.EnumPistonReaction;
import net.minecraft.world.level.material.FluidType;
import net.minecraft.world.level.portal.TeleportTransition;
import net.minecraft.world.phys.AxisAlignedBB;
import net.minecraft.world.phys.Vec3D;
import org.bukkit.Bukkit;
import org.bukkit.craftbukkit.v1_21_R3.CraftServer;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEnderDragon;
import org.bukkit.craftbukkit.v1_21_R3.entity.CraftEntity;
import org.bukkit.entity.EnderDragon;
import org.bukkit.entity.Entity;

public class EnderDragonController
extends MobEntityController {
    public EnderDragonController() {
        super(EntityEnderDragonNPC.class, EntityTypes.P);
    }

    public EnderDragon getBukkitEntity() {
        return (EnderDragon)super.getBukkitEntity();
    }

    public static class EntityEnderDragonNPC
    extends EntityEnderDragon
    implements NPCHolder {
        private final CitizensNPC npc;

        public EntityEnderDragonNPC(EntityTypes<? extends EntityEnderDragon> types, World level) {
            this(types, level, null);
        }

        public EntityEnderDragonNPC(EntityTypes<? extends EntityEnderDragon> types, World level, NPC npc) {
            super(types, level);
            this.npc = (CitizensNPC)npc;
        }

        public void d_() {
            if (this.npc != null) {
                NMSImpl.updateMinecraftAIState(this.npc, (EntityInsentient)this);
                this.npc.update();
            }
            if (this.npc != null && !this.npc.useMinecraftAI()) {
                if (this.eE()) {
                    this.x(0.0f);
                    return;
                }
                this.b.a(this.dC(), this.dL());
                float[][] pos = NMS.calculateDragonPositions(this.dL(), new double[][]{this.toa(this.b.a(0, 1.0f)), this.toa(this.b.a(5, 1.0f)), this.toa(this.b.a(10, 1.0f)), this.toa(this.b.a(12, 1.0f)), this.toa(this.b.a(14, 1.0f)), this.toa(this.b.a(16, 1.0f))});
                for (int j = 0; j < this.cj.length; ++j) {
                    Vec3D vec3 = new Vec3D(this.cj[j].dA(), this.cj[j].dC(), this.cj[j].dG());
                    this.cj[j].a_(this.dA() + (double)pos[j][0], this.dC() + (double)pos[j][1], this.dG() + (double)pos[j][2]);
                    this.cj[j].K = this.cj[j].aa = vec3.d;
                    this.cj[j].L = this.cj[j].ab = vec3.e;
                    this.cj[j].M = this.cj[j].ac = vec3.f;
                }
                if (this.cZ() != null) {
                    this.v(this.cZ().getBukkitYaw() - 180.0f);
                }
                Vec3D mot = this.dy();
                if (mot.d != 0.0 || mot.e != 0.0 || mot.f != 0.0) {
                    mot = mot.d(0.98, 0.91, 0.98);
                    if (this.cZ() == null) {
                        this.v(Util.getYawFromVelocity((Entity)this.getBukkitEntity(), mot.d, mot.f));
                    }
                    this.a_(this.dA() + mot.d, this.dC() + mot.e, this.dG() + mot.f);
                    this.i(mot);
                }
                if (this.npc.hasTrait(EnderDragonTrait.class) && this.npc.getOrAddTrait(EnderDragonTrait.class).isDestroyWalls() && NMSImpl.ENDERDRAGON_CHECK_WALLS != null) {
                    for (int i = 0; i < 3; ++i) {
                        try {
                            this.bY |= NMSImpl.ENDERDRAGON_CHECK_WALLS.invoke(this, this.cj[i].cR());
                            continue;
                        }
                        catch (Throwable e) {
                            e.printStackTrace();
                        }
                    }
                }
                if (this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(false)).booleanValue()) {
                    try {
                        NMSImpl.ENDERDRAGON_KNOCKBACK.invoke(this, this.dV(), this.dV().a((net.minecraft.world.entity.Entity)this, this.cj[6].cR().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        NMSImpl.ENDERDRAGON_KNOCKBACK.invoke(this, this.dV(), this.dV().a((net.minecraft.world.entity.Entity)this, this.cj[7].cR().c(4.0, 2.0, 4.0).d(0.0, -2.0, 0.0), IEntitySelector.e));
                        NMSImpl.ENDERDRAGON_HURT.invoke(this, this.dV(), this.dV().a((net.minecraft.world.entity.Entity)this, this.cj[0].cR().g(1.0), IEntitySelector.e));
                        NMSImpl.ENDERDRAGON_HURT.invoke(this, this.dV(), this.dV().a((net.minecraft.world.entity.Entity)this, this.cj[1].cR().g(1.0), IEntitySelector.e));
                    }
                    catch (Throwable t) {
                        t.printStackTrace();
                    }
                }
            } else {
                super.d_();
            }
        }

        public boolean a(EntityPlayer player) {
            return NMS.shouldBroadcastToPlayer(this.npc, () -> super.a(player));
        }

        protected boolean o(net.minecraft.world.entity.Entity entity) {
            if (this.npc != null && (entity instanceof EntityBoat || entity instanceof EntityMinecartAbstract)) {
                return !this.npc.isProtected();
            }
            return super.o(entity);
        }

        public void dH() {
            if (this.npc == null) {
                super.dH();
            }
        }

        protected SoundEffect u() {
            return NMSImpl.getSoundEffect(this.npc, super.u(), NPC.Metadata.AMBIENT_SOUND);
        }

        public CraftEntity getBukkitEntity() {
            if (this.npc != null && !(super.getBukkitEntity() instanceof NPCHolder)) {
                NMSImpl.setBukkitEntity((net.minecraft.world.entity.Entity)this, (CraftEntity)new EnderDragonNPC(this));
            }
            return super.getBukkitEntity();
        }

        protected SoundEffect o_() {
            return NMSImpl.getSoundEffect(this.npc, super.o_(), NPC.Metadata.DEATH_SOUND);
        }

        protected SoundEffect e(DamageSource damagesource) {
            return NMSImpl.getSoundEffect(this.npc, super.e(damagesource), NPC.Metadata.HURT_SOUND);
        }

        public float fj() {
            return NMS.getJumpPower(this.npc, super.fj());
        }

        public int cE() {
            return NMS.getFallDistance(this.npc, super.cE());
        }

        @Override
        public NPC getNPC() {
            return this.npc;
        }

        public EnumPistonReaction n_() {
            return Util.callPistonPushEvent(this.npc) ? EnumPistonReaction.d : super.n_();
        }

        public boolean P_() {
            return NMSImpl.isLeashed(this.npc, () -> super.P_(), (EntityInsentient)this);
        }

        public boolean bI() {
            return this.npc == null ? super.bI() : this.npc.data().get(NPC.Metadata.COLLIDABLE, Boolean.valueOf(!this.npc.isProtected())).booleanValue();
        }

        public void p(double strength, double dx, double dz) {
            NMS.callKnockbackEvent(this.npc, (float)strength, dx, dz, evt -> super.p((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
        }

        protected AxisAlignedBB c(Vec3D vec3) {
            return NMSBoundingBox.makeBB(this.npc, super.c(vec3));
        }

        public void h(net.minecraft.world.entity.Entity entity) {
            super.h(entity);
            if (this.npc != null) {
                Util.callCollisionEvent(this.npc, (Entity)entity.getBukkitEntity());
            }
        }

        protected void c(WorldServer level, DamageSource source, float f) {
            if (this.npc == null) {
                return;
            }
            Vec3D old = this.dy();
            super.c(level, source, f);
            if (this.go().a().h() == DragonControllerPhase.k) {
                this.i(old);
            }
        }

        public boolean e(NBTTagCompound save) {
            return this.npc == null ? super.e(save) : false;
        }

        public net.minecraft.world.entity.Entity b(TeleportTransition transition) {
            if (this.npc == null) {
                return super.b(transition);
            }
            return NMSImpl.teleportAcrossWorld((net.minecraft.world.entity.Entity)this, transition);
        }

        private double[] toa(DragonFlightHistory.a sample) {
            return new double[]{sample.a(), sample.b()};
        }

        public boolean a(TagKey<FluidType> tagkey, double d0) {
            if (this.npc == null) {
                return super.a(tagkey, d0);
            }
            Vec3D old = this.dy().b(0.0, 0.0, 0.0);
            boolean res = super.a(tagkey, d0);
            if (!this.npc.isPushableByFluids()) {
                this.i(old);
            }
            return res;
        }
    }

    public static class EnderDragonNPC
    extends CraftEnderDragon
    implements ForwardingNPCHolder {
        public EnderDragonNPC(EntityEnderDragonNPC entity) {
            super((CraftServer)Bukkit.getServer(), (EntityEnderDragon)entity);
        }
    }
}

