/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.shop;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.function.Consumer;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import net.citizensnpcs.api.gui.InputMenus;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.gui.InventoryMenuSlot;
import net.citizensnpcs.api.gui.Menu;
import net.citizensnpcs.api.gui.MenuContext;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.trait.shop.NPCShopAction;
import net.citizensnpcs.util.InventoryMultiplexer;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.kyori.adventure.platform.bukkit.BukkitComponentSerializer;
import net.kyori.adventure.text.Component;
import net.kyori.adventure.text.ComponentBuilder;
import org.bukkit.ChatColor;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.HumanEntity;
import org.bukkit.inventory.InventoryHolder;
import org.bukkit.inventory.ItemStack;
import org.bukkit.inventory.meta.Damageable;

public class ItemAction
extends NPCShopAction {
    @Persist
    public boolean compareSimilarity = true;
    @Persist
    public List<ItemStack> items = Lists.newArrayList();
    @Persist
    public List<String> metaFilter = Lists.newArrayList();
    @Persist
    public boolean requireUndamaged = true;
    private static boolean SUPPORT_TRANSLATABLE = true;

    public ItemAction() {
    }

    public ItemAction(ItemStack ... items) {
        this(Arrays.asList(items));
    }

    public ItemAction(List<ItemStack> items) {
        this.items = items;
    }

    @Override
    public String describe() {
        if (this.items.size() == 1) {
            return this.stringify(this.items.get(0));
        }
        String description = this.items.size() + " items";
        for (int i = 0; i < this.items.size(); ++i) {
            ItemStack item = this.items.get(i);
            description = description + "\n" + this.stringify(item);
            if (i != 3) continue;
            description = description + "...";
            break;
        }
        return description;
    }

    @Override
    public int getMaxRepeats(Entity entity, InventoryMultiplexer im) {
        if (!(entity instanceof InventoryHolder)) {
            return 0;
        }
        ItemStack[] inventory = im.getInventory();
        List req = this.items.stream().map(ItemStack::getAmount).collect(Collectors.toList());
        List has = this.items.stream().map(i -> 0).collect(Collectors.toList());
        block0: for (int i2 = 0; i2 < inventory.length; ++i2) {
            ItemStack toMatch = inventory[i2];
            if (toMatch == null || toMatch.getType() == Material.AIR || this.tooDamaged(toMatch)) continue;
            toMatch = toMatch.clone();
            for (int j = 0; j < this.items.size(); ++j) {
                if (!this.matches(this.items.get(j), toMatch)) continue;
                int remaining = (Integer)req.get(j);
                int taken = toMatch.getAmount() > remaining ? remaining : toMatch.getAmount();
                has.set(j, (Integer)has.get(j) + taken);
                if (toMatch.getAmount() - taken <= 0) continue block0;
                toMatch.setAmount(toMatch.getAmount() - taken);
            }
        }
        return IntStream.range(0, req.size()).map(i -> (Integer)req.get(i) == 0 ? 0 : (Integer)has.get(i) / (Integer)req.get(i)).reduce(Math::min).orElse(0);
    }

    private void giveItems(ItemStack[] inventory, int repeats) {
        for (int i = 0; i < repeats; ++i) {
            int j;
            List toAdd = this.items.stream().map(ItemStack::clone).collect(Collectors.toList());
            for (j = 0; j < inventory.length; ++j) {
                ItemStack last;
                if (toAdd.isEmpty()) {
                    return;
                }
                if (inventory[j] == null || !inventory[j].isSimilar(last = (ItemStack)toAdd.get(toAdd.size() - 1)) || inventory[j].getAmount() >= inventory[j].getMaxStackSize()) continue;
                int diff = inventory[j].getMaxStackSize() - inventory[j].getAmount();
                if (diff >= last.getAmount()) {
                    inventory[j].setAmount(inventory[j].getAmount() + last.getAmount());
                    toAdd.remove(toAdd.size() - 1);
                    continue;
                }
                inventory[j].setAmount(inventory[j].getAmount() + diff);
                last.setAmount(last.getAmount() - diff);
            }
            for (j = 0; j < inventory.length && !toAdd.isEmpty(); ++j) {
                if (inventory[j] != null && inventory[j].getType() != Material.AIR) continue;
                inventory[j] = (ItemStack)toAdd.remove(toAdd.size() - 1);
            }
        }
    }

    @Override
    public NPCShopAction.Transaction grant(Entity entity, InventoryMultiplexer im, int repeats) {
        if (!(entity instanceof InventoryHolder)) {
            return NPCShopAction.Transaction.fail();
        }
        return NPCShopAction.Transaction.create(() -> {
            ItemStack[] inventory = im.getInventory();
            int free = 0;
            for (ItemStack stack : inventory) {
                if (stack != null && stack.getType() != Material.AIR) continue;
                ++free;
            }
            return free >= this.items.size() * repeats;
        }, () -> im.transact(inventory -> this.giveItems((ItemStack[])inventory, repeats)), () -> im.transact(inventory -> this.takeItems((ItemStack[])inventory, repeats, true)));
    }

    private boolean matches(ItemStack a, ItemStack b) {
        if (a.getType() != b.getType() || this.metaFilter.size() > 0 && !this.metaMatches(a, b, this.metaFilter)) {
            return false;
        }
        return !this.compareSimilarity || a.isSimilar(b);
    }

    private boolean metaMatches(ItemStack needle, ItemStack haystack, List<String> meta) {
        Map<String, Object> source = NMS.getComponentMap(needle);
        Map<String, Object> compare = NMS.getComponentMap(haystack);
        Messaging.idebug(() -> "Shop filter: comparing " + source + " to " + compare);
        for (String nbt : meta) {
            String[] parts = nbt.split("\\.");
            Object acc = source;
            Object cmp = compare;
            for (int i = 0; i < parts.length; ++i) {
                if (acc == null || cmp == null) {
                    return false;
                }
                if (i < parts.length - 1 && !(acc instanceof Map)) {
                    return false;
                }
                if (i < parts.length - 1 && !(cmp instanceof Map)) {
                    return false;
                }
                Map<String, Object> nextAcc = acc;
                Map<String, Object> nextCmp = cmp;
                if (!nextAcc.containsKey(parts[i])) {
                    Messaging.warn("Probable error in shop filter: source item does not contain requested meta " + this.metaFilter + " actual meta is: " + source);
                    return false;
                }
                if (!nextCmp.containsKey(parts[i])) {
                    return false;
                }
                acc = nextAcc.get(parts[i]);
                cmp = nextCmp.get(parts[i]);
                if (i != parts.length - 1 || acc.equals(cmp)) continue;
                return false;
            }
        }
        return true;
    }

    private void sanityCheck() {
        if (this.metaFilter.size() > 0) {
            for (ItemStack item : this.items) {
                this.metaMatches(item, item, this.metaFilter);
            }
        }
    }

    private String stringify(ItemStack item) {
        if (SUPPORT_TRANSLATABLE) {
            return BukkitComponentSerializer.legacy().serialize(Component.text((String)(item.getAmount() + " ")).append((ComponentBuilder)Component.translatable().key(item.getTranslationKey())));
        }
        return item.getAmount() + " " + Util.prettyEnum(item.getType());
    }

    @Override
    public NPCShopAction.Transaction take(Entity entity, InventoryMultiplexer im, int repeats) {
        if (!(entity instanceof InventoryHolder)) {
            return NPCShopAction.Transaction.fail();
        }
        return NPCShopAction.Transaction.create(() -> this.takeItems(im.getInventory(), repeats, false), () -> im.transact(inventory -> this.takeItems((ItemStack[])inventory, repeats, true)), () -> im.transact(inventory -> this.giveItems((ItemStack[])inventory, repeats)));
    }

    private boolean takeItems(ItemStack[] contents, int repeats, boolean modify) {
        List req = this.items.stream().map(i -> i.getAmount() * repeats).collect(Collectors.toList());
        for (int i2 = 0; i2 < contents.length; ++i2) {
            ItemStack toMatch = contents[i2];
            if (toMatch == null || toMatch.getType() == Material.AIR || this.tooDamaged(toMatch)) continue;
            toMatch = toMatch.clone();
            for (int j = 0; j < this.items.size() && toMatch != null; ++j) {
                int taken;
                ItemStack item = this.items.get(j);
                if ((Integer)req.get(j) <= 0 || !this.matches(item, toMatch)) continue;
                int remaining = (Integer)req.get(j);
                int n2 = taken = toMatch.getAmount() > remaining ? remaining : toMatch.getAmount();
                if (toMatch.getAmount() == taken) {
                    toMatch = null;
                } else {
                    toMatch.setAmount(toMatch.getAmount() - taken);
                }
                if (modify) {
                    contents[i2] = toMatch == null ? null : toMatch.clone();
                }
                req.set(j, remaining - taken);
            }
        }
        return req.stream().collect(Collectors.summingInt(n -> n)) <= 0;
    }

    private boolean tooDamaged(ItemStack toMatch) {
        if (!this.requireUndamaged) {
            return false;
        }
        if (SpigotUtil.isUsing1_13API()) {
            return toMatch.getItemMeta() instanceof Damageable && ((Damageable)toMatch.getItemMeta()).getDamage() != 0;
        }
        return toMatch.getDurability() == toMatch.getType().getMaxDurability();
    }

    static {
        try {
            Class.forName("org.bukkit.Translatable");
        }
        catch (ClassNotFoundException e) {
            SUPPORT_TRANSLATABLE = false;
        }
    }

    public static class ItemActionGUI
    implements NPCShopAction.GUI {
        @Override
        public InventoryMenuPage createEditor(NPCShopAction previous, Consumer<NPCShopAction> callback) {
            return new ItemActionEditor(previous == null ? new ItemAction() : (ItemAction)previous, callback);
        }

        @Override
        public ItemStack createMenuItem(NPCShopAction previous) {
            String description = null;
            if (previous != null) {
                ItemAction old = (ItemAction)previous;
                description = old.describe();
            }
            return Util.createItem(Material.CHEST, "Item", description);
        }

        @Override
        public boolean manages(NPCShopAction action) {
            return action instanceof ItemAction;
        }
    }

    @Menu(title="Item editor", dimensions={4, 9})
    public static class ItemActionEditor
    extends InventoryMenuPage {
        private ItemAction base;
        private Consumer<NPCShopAction> callback;
        private MenuContext ctx;

        public ItemActionEditor() {
        }

        public ItemActionEditor(ItemAction base, Consumer<NPCShopAction> callback) {
            this.base = base;
            this.callback = callback;
        }

        @Override
        public void initialise(MenuContext ctx) {
            this.ctx = ctx;
            for (int i = 0; i < 27; ++i) {
                InventoryMenuSlot slot = ctx.getSlot(i);
                slot.clear();
                if (i < this.base.items.size()) {
                    slot.setItemStack(this.base.items.get(i).clone());
                }
                slot.setClickHandler(event -> {
                    event.setCurrentItem(event.getCursorNonNull());
                    event.setCancelled(true);
                });
            }
            ctx.getSlot(28).setItemStack(new ItemStack(Material.ANVIL), "Must have no damage", this.base.requireUndamaged ? ChatColor.GREEN + "On" : ChatColor.RED + "Off");
            ctx.getSlot(28).addClickHandler(InputMenus.toggler(res -> {
                this.base.requireUndamaged = res;
            }, this.base.requireUndamaged));
            ctx.getSlot(29).setItemStack(new ItemStack(Util.getFallbackMaterial("COMPARATOR", "REDSTONE_COMPARATOR")), "Compare item similarity", this.base.compareSimilarity ? ChatColor.GREEN + "On" : ChatColor.RED + "Off");
            ctx.getSlot(29).addClickHandler(InputMenus.toggler(res -> {
                this.base.compareSimilarity = res;
            }, this.base.compareSimilarity));
            ctx.getSlot(30).setItemStack(new ItemStack(Material.BOOK), "Component comparison filter", Joiner.on((String)"\n").join(this.base.metaFilter));
            ctx.getSlot(30).addClickHandler(event -> ctx.getMenu().transition(InputMenus.stringSetter(() -> Joiner.on((char)',').join(this.base.metaFilter), res -> {
                this.base.metaFilter = res == null ? null : Arrays.asList(res.split(","));
            })));
        }

        @Override
        public void onClose(HumanEntity player) {
            ArrayList items = Lists.newArrayList();
            for (int i = 0; i < 27; ++i) {
                if (this.ctx.getSlot(i).getCurrentItem() == null) continue;
                items.add(this.ctx.getSlot(i).getCurrentItem().clone());
            }
            this.base.items = items;
            this.base.sanityCheck();
            this.callback.accept(items.isEmpty() ? null : this.base);
        }
    }
}

