/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.shop;

import java.util.function.Consumer;
import net.citizensnpcs.Citizens;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.gui.InputMenus;
import net.citizensnpcs.api.gui.InventoryMenuPage;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.trait.ShopTrait;
import net.citizensnpcs.trait.shop.NPCShopAction;
import net.citizensnpcs.util.InventoryMultiplexer;
import net.citizensnpcs.util.Util;
import org.bukkit.Bukkit;
import org.bukkit.Material;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.inventory.ItemStack;

public class OpenShopAction
extends NPCShopAction {
    @Persist
    public String shopName;

    public OpenShopAction() {
    }

    public OpenShopAction(String shopName) {
        this.shopName = shopName;
    }

    @Override
    public String describe() {
        ShopTrait.NPCShop shop = ((Citizens)CitizensAPI.getPlugin()).getShops().getShop(this.shopName);
        String description = "Open " + shop.getName();
        return description;
    }

    @Override
    public int getMaxRepeats(Entity entity, InventoryMultiplexer inventory) {
        return -1;
    }

    @Override
    public NPCShopAction.Transaction grant(Entity entity, InventoryMultiplexer inventory, int repeats) {
        return this.take(entity, inventory, repeats);
    }

    @Override
    public NPCShopAction.Transaction take(Entity entity, InventoryMultiplexer inventory, int repeats) {
        if (!(entity instanceof Player)) {
            return NPCShopAction.Transaction.fail();
        }
        ShopTrait.NPCShop shop = ((Citizens)CitizensAPI.getPlugin()).getShops().getShop(this.shopName);
        Player player = (Player)entity;
        return NPCShopAction.Transaction.create(() -> shop.canView(player), () -> {
            player.closeInventory();
            Bukkit.getScheduler().scheduleSyncDelayedTask(CitizensAPI.getPlugin(), () -> shop.display(player));
        }, () -> {});
    }

    public static class OpenShopActionGUI
    implements NPCShopAction.GUI {
        @Override
        public InventoryMenuPage createEditor(NPCShopAction previous, Consumer<NPCShopAction> callback) {
            OpenShopAction action = previous == null ? new OpenShopAction() : (OpenShopAction)previous;
            return InputMenus.stringSetter(() -> action.shopName, s -> {
                if (s == null || s.isEmpty()) {
                    callback.accept(null);
                    return;
                }
                action.shopName = s;
                callback.accept(action);
            });
        }

        @Override
        public ItemStack createMenuItem(NPCShopAction previous) {
            String description = null;
            if (previous != null) {
                OpenShopAction old = (OpenShopAction)previous;
                description = old.describe();
            }
            return Util.createItem(Material.BOOKSHELF, "Open Shop", description);
        }

        @Override
        public boolean manages(NPCShopAction action) {
            return action instanceof OpenShopAction;
        }
    }
}

