/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.shop;

import com.google.common.collect.Maps;
import java.util.Map;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.persistence.PersistenceLoader;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.Storage;
import net.citizensnpcs.api.util.YamlStorage;
import net.citizensnpcs.trait.ShopTrait;

public class StoredShops {
    @Persist(value="global", reify=true)
    public Map<String, ShopTrait.NPCShop> globalShops = Maps.newHashMap();
    @Persist(value="npc", reify=true)
    public Map<String, ShopTrait.NPCShop> npcShops = Maps.newHashMap();
    private final Storage storage;

    public StoredShops(YamlStorage storage) {
        this.storage = storage;
    }

    public void deleteShop(ShopTrait.NPCShop shop) {
        if (Messaging.isDebugging()) {
            Messaging.debug("Deleting shop", shop.getName());
        }
        if (this.npcShops.containsKey(shop.getName())) {
            this.npcShops.remove(shop.getName());
        } else {
            this.globalShops.remove(shop.getName());
        }
    }

    public ShopTrait.NPCShop getGlobalShop(String name) {
        return this.globalShops.get(name);
    }

    public ShopTrait.NPCShop getShop(String name) {
        ShopTrait.NPCShop shop = this.npcShops.get(name);
        return shop == null ? this.getGlobalShop(name) : shop;
    }

    public void load() {
        PersistenceLoader.load(this, this.storage.getKey(""));
    }

    public boolean loadFromDisk() {
        return this.storage.load();
    }

    public void saveToDisk() {
        this.storage.save();
    }

    public void storeShops() {
        PersistenceLoader.save(this, this.storage.getKey(""));
    }
}

