/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.nms.v1_21_R4.entity;

import com.mojang.authlib.GameProfile;
import java.io.IOException;
import java.lang.invoke.MethodHandle;
import java.util.List;
import net.citizensnpcs.api.CitizensAPI;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.trait.Inventory;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.api.util.SpigotUtil;
import net.citizensnpcs.nms.v1_21_R4.network.EmptyConnection;
import net.citizensnpcs.nms.v1_21_R4.network.EmptyPacketListener;
import net.citizensnpcs.nms.v1_21_R4.util.EmptyAdvancementDataPlayer;
import net.citizensnpcs.nms.v1_21_R4.util.EmptyServerStatsCounter;
import net.citizensnpcs.nms.v1_21_R4.util.MobAI;
import net.citizensnpcs.nms.v1_21_R4.util.NMSImpl;
import net.citizensnpcs.npc.CitizensNPC;
import net.citizensnpcs.npc.ai.NPCHolder;
import net.citizensnpcs.npc.skin.SkinPacketTracker;
import net.citizensnpcs.npc.skin.SkinnableEntity;
import net.citizensnpcs.trait.EntityPoseTrait;
import net.citizensnpcs.trait.Gravity;
import net.citizensnpcs.trait.SkinTrait;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import net.minecraft.server.MinecraftServer;
import org.bukkit.Bukkit;
import org.bukkit.Location;
import org.bukkit.World;
import org.bukkit.craftbukkit.v1_21_R4.CraftServer;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftEntity;
import org.bukkit.craftbukkit.v1_21_R4.entity.CraftPlayer;
import org.bukkit.entity.Entity;
import org.bukkit.entity.Player;
import org.bukkit.metadata.MetadataValue;
import org.bukkit.permissions.Permissible;
import org.bukkit.plugin.Plugin;

public class EntityHumanNPC
extends asc
implements NPCHolder,
SkinnableEntity,
MobAI.ForwardingMobAI {
    private alz advancements;
    private final MobAI ai;
    private int jumpTicks = 0;
    private final CitizensNPC npc;
    private boolean setBukkitEntity;
    private final SkinPacketTracker skinTracker;
    private EmptyServerStatsCounter statsCache;
    private static final float EPSILON = 0.003f;
    private static final MethodHandle GAMEMODE_SETTER = NMS.getFirstMethodHandle(asd.class, (boolean)true, (Class[])new Class[]{dkg.class, dkg.class});

    public EntityHumanNPC(MinecraftServer minecraftServer, asb world, GameProfile gameProfile, arl ci, NPC npc) {
        super(minecraftServer, world, gameProfile, ci);
        this.npc = (CitizensNPC)npc;
        if (npc != null) {
            this.ai = new MobAI.BasicMobAI((byf)this);
            this.skinTracker = new SkinPacketTracker((SkinnableEntity)this);
            try {
                GAMEMODE_SETTER.invoke(this.h, dkg.a, null);
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
            this.initialise(minecraftServer, ci);
        } else {
            this.ai = null;
            this.skinTracker = null;
        }
    }

    public boolean a(asc player) {
        return NMS.shouldBroadcastToPlayer((NPC)this.npc, () -> super.a(player));
    }

    public boolean a(double f, float f1, bvt damagesource) {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.a(f, f1, damagesource);
        }
        return false;
    }

    protected void a(double d0, boolean flag, ebq iblockdata, iw blockposition) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a(d0, flag, iblockdata, blockposition);
        }
    }

    public void a(bvt damagesource) {
        if (this.bc) {
            return;
        }
        super.a(damagesource);
        Bukkit.getScheduler().runTaskLater(CitizensAPI.getPlugin(), () -> {
            ((asb)this.dV()).a((asc)this, bxe.d.a);
            ((asb)this.dV()).m().a((bxe)this);
        }, 15L);
    }

    public void h() {
        boolean navigating;
        if (this.npc == null) {
            super.h();
            return;
        }
        NMSImpl.callNPCMoveEvent((NPC)this.npc, (bxe)this);
        super.aw();
        boolean bl = navigating = this.npc.getNavigator().isNavigating() || this.ai.getMoveControl().b();
        if (!(navigating || this.getBukkitEntity() == null || this.npc.hasTrait(Gravity.class) && !((Gravity)this.npc.getOrAddTrait(Gravity.class)).hasGravity() || !Util.isLoaded((Location)this.getBukkitEntity().getLocation()) || this.npc.isProtected() && !SpigotUtil.checkYSafe((double)this.dC(), (World)this.getBukkitEntity().getWorld()))) {
            this.moveWithFallDamage(fgc.c);
        }
        fgc mot = this.dy();
        if (Math.abs(mot.d) < (double)0.003f && Math.abs(mot.e) < (double)0.003f && Math.abs(mot.f) < (double)0.003f) {
            this.i(fgc.c);
        }
        if (navigating) {
            if (!this.ai.getNavigation().k()) {
                this.ai.getNavigation().c();
            }
            this.moveOnCurrentHeading();
        }
        this.tickAI();
        this.aI();
        this.ad = this.ak();
        if (this.ak()) {
            this.aH = false;
        }
        this.n();
        if (this.npc.useMinecraftAI()) {
            this.bS.a((asc)this);
        }
        if (((Boolean)this.npc.data().get(NPC.Metadata.PICKUP_ITEMS, (Object)false)).booleanValue()) {
            if (this.bX > 0) {
                --this.bX;
            }
            ffx axisalignedbb = this.bY() && !this.dk().dQ() ? this.cR().b(this.dk().cR()).c(1.0, 0.0, 1.0) : this.cR().c(1.0, 0.5, 1.0);
            for (bxe entity : this.dV().a_((bxe)this, axisalignedbb)) {
                entity.a_((csi)this);
            }
        }
        ++this.aS;
        this.gG().a();
        EntityPoseTrait ept = (EntityPoseTrait)this.npc.getTraitNullable(EntityPoseTrait.class);
        if (ept == null || ept.getPose() == null) {
            this.gc();
        }
    }

    public alz R() {
        if (this.npc == null) {
            return super.R();
        }
        if (this.advancements == null) {
            this.advancements = new EmptyAdvancementDataPlayer(this.cV().aC(), this.cV().ag(), this);
        }
        return this.advancements;
    }

    @Override
    public MobAI getAI() {
        return this.ai;
    }

    public CraftPlayer getBukkitEntity() {
        if (this.npc != null && !this.setBukkitEntity) {
            NMSImpl.setBukkitEntity((bxe)this, (CraftEntity)new PlayerNPC(this));
            this.setBukkitEntity = true;
        }
        return super.getBukkitEntity();
    }

    protected awx j_() {
        return NMSImpl.getSoundEffect((NPC)this.npc, super.j_(), NPC.Metadata.DEATH_SOUND);
    }

    protected awx e(bvt damagesource) {
        return NMSImpl.getSoundEffect((NPC)this.npc, super.e(damagesource), NPC.Metadata.HURT_SOUND);
    }

    public float fh() {
        return NMS.getJumpPower((NPC)this.npc, (float)super.fh());
    }

    public int cE() {
        return NMS.getFallDistance((NPC)this.npc, (int)super.cE());
    }

    public NPC getNPC() {
        return this.npc;
    }

    public eyf i_() {
        return Util.callPistonPushEvent((NPC)this.npc) ? eyf.d : super.i_();
    }

    public GameProfile getProfile() {
        return super.gi();
    }

    public String getSkinName() {
        String skinName = ((SkinTrait)this.npc.getOrAddTrait(SkinTrait.class)).getSkinName();
        if (skinName == null) {
            skinName = this.npc.getName();
        }
        return skinName.toLowerCase();
    }

    public SkinPacketTracker getSkinTracker() {
        return this.skinTracker;
    }

    public axe H() {
        return this.statsCache == null ? (this.statsCache = new EmptyServerStatsCounter()) : this.statsCache;
    }

    public xg N() {
        if (this.npc != null && this.npc.shouldRemoveFromTabList()) {
            return xu.a((xh)new yn.a(""));
        }
        return this.npc != null ? (xg)Messaging.minecraftComponentFromRawMessage((String)this.npc.getRawName()) : super.N();
    }

    public boolean a(asb level, bvt damagesource, float f) {
        boolean damaged = super.a(level, damagesource, f);
        if (damaged && this.T) {
            this.T = false;
            Bukkit.getScheduler().runTask(CitizensAPI.getPlugin(), () -> {
                this.T = true;
            });
        }
        return damaged;
    }

    private void initialise(MinecraftServer minecraftServer, arl clientInfo) {
        try {
            EmptyConnection conn = new EmptyConnection(zp.b);
            this.f = new EmptyPacketListener(minecraftServer, conn, this, new asr(this.getProfile(), 0, clientInfo, false));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.v(true);
        this.setSkinFlags((byte)-1);
    }

    public boolean bK() {
        if (this.npc == null || this.ad || this.fR()) {
            return super.bK();
        }
        return Util.inBlock((Entity)this.getBukkitEntity());
    }

    public boolean bG() {
        return this.npc == null ? super.bG() : ((Boolean)this.npc.data().get(NPC.Metadata.COLLIDABLE, (Object)(!this.npc.isProtected() ? 1 : 0))).booleanValue();
    }

    public void p(double strength, double dx, double dz) {
        NMS.callKnockbackEvent((NPC)this.npc, (float)((float)strength), (double)dx, (double)dz, evt -> super.p((double)((float)evt.getStrength()), evt.getKnockbackVector().getX(), evt.getKnockbackVector().getZ()));
    }

    private void moveOnCurrentHeading() {
        if (this.bf) {
            if (this.aH && this.jumpTicks == 0) {
                this.r();
                this.jumpTicks = 10;
            }
        } else {
            this.jumpTicks = 0;
        }
        this.bg *= 0.98f;
        this.bi *= 0.98f;
        this.moveWithFallDamage(new fgc((double)this.bg, (double)this.bh, (double)this.bi));
        NMS.setHeadAndBodyYaw((Entity)this.getBukkitEntity(), (float)this.dL());
        if (this.jumpTicks > 0) {
            --this.jumpTicks;
        }
    }

    private void moveWithFallDamage(fgc vec) {
        double x = this.dA();
        double y = this.dC();
        double z = this.dG();
        this.a_(vec);
        if (!this.npc.isProtected()) {
            this.a(this.dA() - x, this.dC() - y, this.dG() - z, this.aH);
        }
    }

    public boolean k_() {
        if (this.npc == null || !this.npc.isFlyable()) {
            return super.k_();
        }
        return false;
    }

    public void h(bxe entity) {
        super.h(entity);
        if (this.npc != null) {
            Util.callCollisionEvent((NPC)this.npc, (Entity)entity.getBukkitEntity());
        }
    }

    public void a(bxe.d reason) {
        super.a(reason);
        this.R().b();
    }

    public void setSkinFlags(byte flags) {
        this.ar().a(csi.bK, (Object)flags);
    }

    public void setSkinName(String name) {
        ((SkinTrait)this.npc.getOrAddTrait(SkinTrait.class)).setSkinName(name);
    }

    public void setSkinName(String name, boolean forceUpdate) {
        ((SkinTrait)this.npc.getOrAddTrait(SkinTrait.class)).setSkinName(name, forceUpdate);
    }

    public void setSkinPersistent(String skinName, String signature, String data) {
        ((SkinTrait)this.npc.getOrAddTrait(SkinTrait.class)).setSkinPersistent(skinName, signature, data);
    }

    public void g() {
        super.g();
        if (this.npc == null) {
            return;
        }
        this.detectEquipmentUpdatesPublic();
        this.c(List.of());
        Bukkit.getServer().getPluginManager().unsubscribeFromPermission("bukkit.broadcast.user", (Permissible)this.getBukkitEntity());
        this.updatePackets(this.npc.getNavigator().isNavigating());
        this.npc.update();
        if (NMSImpl.PAPER_PLAYER_MOB_COUNTS != null && this.npc.shouldRemoveFromPlayerList()) {
            try {
                int[] counts = NMSImpl.PAPER_PLAYER_MOB_COUNTS.invoke(this);
                for (int i = 0; i < counts.length; ++i) {
                    counts[i] = 0;
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    @Override
    public void tickAI() {
        this.ai.getMoveControl().a();
        this.ai.getJumpControl().b();
    }

    public void a_(fgc vec3d) {
        if (this.npc == null || !this.npc.isFlyable()) {
            super.a_(vec3d);
        } else {
            NMSImpl.moveLogic((byf)this, vec3d);
        }
    }

    public boolean a(ayc<exz> tagkey, double d0) {
        fgc old = this.dy().b(0.0, 0.0, 0.0);
        boolean res = super.a(tagkey, d0);
        if (!this.npc.isPushableByFluids()) {
            this.i(old);
        }
        return res;
    }

    private void updatePackets(boolean navigating) {
        if (!this.npc.isUpdating(NPC.NPCUpdate.PACKET)) {
            return;
        }
        this.bK = true;
    }

    public static class PlayerNPC
    extends CraftPlayer
    implements NPCHolder,
    SkinnableEntity {
        private final CitizensNPC npc;

        private PlayerNPC(EntityHumanNPC entity) {
            super((CraftServer)Bukkit.getServer(), (asc)entity);
            this.npc = entity.npc;
            this.npc.getOrAddTrait(Inventory.class);
        }

        public boolean canSee(Entity entity) {
            if (entity != null && entity.getType().name().contains("ITEM_FRAME")) {
                return false;
            }
            return super.canSee(entity);
        }

        public Player getBukkitEntity() {
            return this;
        }

        public EntityHumanNPC getHandle() {
            return (EntityHumanNPC)this.entity;
        }

        public List<MetadataValue> getMetadata(String metadataKey) {
            return ((CraftServer)Bukkit.getServer()).getEntityMetadata().getMetadata((Object)this, metadataKey);
        }

        public NPC getNPC() {
            return this.npc;
        }

        public String getSkinName() {
            return ((SkinnableEntity)this.entity).getSkinName();
        }

        public SkinPacketTracker getSkinTracker() {
            return ((SkinnableEntity)this.entity).getSkinTracker();
        }

        public boolean hasMetadata(String metadataKey) {
            return ((CraftServer)Bukkit.getServer()).getEntityMetadata().hasMetadata((Object)this, metadataKey);
        }

        public void removeMetadata(String metadataKey, Plugin owningPlugin) {
            ((CraftServer)Bukkit.getServer()).getEntityMetadata().removeMetadata((Object)this, metadataKey, owningPlugin);
        }

        public void setMetadata(String metadataKey, MetadataValue newMetadataValue) {
            ((CraftServer)Bukkit.getServer()).getEntityMetadata().setMetadata((Object)this, metadataKey, newMetadataValue);
        }

        public void setSkinFlags(byte flags) {
            ((SkinnableEntity)this.entity).setSkinFlags(flags);
        }

        public void setSkinName(String name) {
            ((SkinnableEntity)this.entity).setSkinName(name);
        }

        public void setSkinName(String skinName, boolean forceUpdate) {
            ((SkinnableEntity)this.entity).setSkinName(skinName, forceUpdate);
        }

        public void setSkinPersistent(String skinName, String signature, String data) {
            ((SkinnableEntity)this.entity).setSkinPersistent(skinName, signature, data);
        }
    }
}

