/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.util;

import com.mojang.authlib.GameProfile;
import com.mojang.authlib.properties.Property;
import java.lang.invoke.MethodHandle;
import java.util.Collection;
import net.citizensnpcs.util.NMS;

public class SkinProperty {
    public final String name;
    public final String signature;
    public final String value;
    private static MethodHandle GET_NAME_METHOD = null;
    private static MethodHandle GET_SIGNATURE_METHOD = null;
    private static MethodHandle GET_VALUE_METHOD = null;

    public SkinProperty(String name, String value, String signature) {
        this.name = name;
        this.value = value;
        this.signature = signature;
    }

    public void apply(GameProfile profile) {
        profile.getProperties().removeAll((Object)"textures");
        profile.getProperties().put((Object)"textures", (Object)new Property(this.name, this.value, this.signature));
    }

    public static SkinProperty fromMojang(Object prop) {
        if (prop == null) {
            return null;
        }
        try {
            return new SkinProperty(GET_NAME_METHOD.invoke(prop), GET_VALUE_METHOD.invoke(prop), GET_SIGNATURE_METHOD.invoke(prop));
        }
        catch (Throwable e) {
            e.printStackTrace();
            return null;
        }
    }

    public static SkinProperty fromMojangProfile(GameProfile profile) {
        if (profile == null) {
            return null;
        }
        Collection textures = profile.getProperties().get((Object)"textures");
        if (textures == null || textures.size() == 0) {
            return null;
        }
        return SkinProperty.fromMojang(textures.iterator().next());
    }

    static {
        GET_NAME_METHOD = NMS.getMethodHandle(Property.class, "getName", false, new Class[0]);
        if (GET_NAME_METHOD == null) {
            GET_NAME_METHOD = NMS.getMethodHandle(Property.class, "name", false, new Class[0]);
        }
        if ((GET_SIGNATURE_METHOD = NMS.getMethodHandle(Property.class, "getSignature", false, new Class[0])) == null) {
            GET_SIGNATURE_METHOD = NMS.getMethodHandle(Property.class, "signature", false, new Class[0]);
        }
        if ((GET_VALUE_METHOD = NMS.getMethodHandle(Property.class, "getValue", false, new Class[0])) == null) {
            GET_VALUE_METHOD = NMS.getMethodHandle(Property.class, "value", false, new Class[0]);
        }
    }
}

