/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.versioned;

import java.lang.invoke.MethodHandle;
import net.citizensnpcs.api.command.Command;
import net.citizensnpcs.api.command.CommandContext;
import net.citizensnpcs.api.command.Flag;
import net.citizensnpcs.api.command.Requirements;
import net.citizensnpcs.api.command.exception.CommandException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.persistence.Persist;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.trait.TraitName;
import net.citizensnpcs.api.util.Messaging;
import net.citizensnpcs.util.NMS;
import net.citizensnpcs.util.Util;
import org.bukkit.command.CommandSender;
import org.bukkit.entity.Cow;
import org.bukkit.entity.EntityType;

@TraitName(value="cowtrait")
public class CowTrait
extends Trait {
    @Persist
    private Cow.Variant variant;
    private static MethodHandle COW_VARIANT_SETTER;

    public CowTrait() {
        super("cowtrait");
    }

    public Cow.Variant getVariant() {
        return this.variant;
    }

    @Override
    public void run() {
        if (this.variant != null && this.npc.getEntity() instanceof Cow) {
            Cow cow = (Cow)this.npc.getEntity();
            try {
                COW_VARIANT_SETTER.invoke(cow, this.variant);
            }
            catch (Throwable e) {
                Messaging.severe("Failed to set cow variant");
                e.printStackTrace();
            }
        }
    }

    public void setVariant(Cow.Variant variant) {
        this.variant = variant;
    }

    @Command(aliases={"npc"}, usage="cow (--variant variant)", desc="", modifiers={"cow"}, min=1, max=1, permission="citizens.npc.cow")
    @Requirements(selected=true, ownership=true, types={EntityType.COW})
    public static void cow(CommandContext args, CommandSender sender, NPC npc, @Flag(value={"variant"}) Cow.Variant variant) throws CommandException {
        CowTrait trait = npc.getOrAddTrait(CowTrait.class);
        String output = "";
        if (args.hasValueFlag("variant")) {
            if (variant == null) {
                throw new CommandException("citizens.commands.npc.pig.invalid-variant", Util.listValuesPretty(Cow.Variant.class));
            }
            trait.setVariant(variant);
            output = output + Messaging.tr("citizens.commands.npc.pig.variant-set", variant.getKeyOrNull().getKey());
        }
        if (!output.isEmpty()) {
            Messaging.send(sender, output);
        }
    }

    static {
        try {
            COW_VARIANT_SETTER = NMS.getMethodHandle(Class.forName("org.bukkit.entity.Cow"), "setVariant", true, Cow.Variant.class);
        }
        catch (ClassNotFoundException e) {
            e.printStackTrace();
        }
    }
}

