/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.npc.character;

import java.util.HashSet;
import java.util.Set;
import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.entity.EntityType;
import org.bukkit.entity.Player;

public abstract class Character {
    private String name = null;
    private Set<EntityType> types;

    public final String getName() {
        return this.name;
    }

    public final void setName(String name) {
        if (this.name != null) {
            throw new IllegalStateException("Cannot change the name of a character.");
        }
        this.name = name;
    }

    public final Set<EntityType> getValidTypes() {
        return this.types;
    }

    public final void setValidTypes(EntityType ... types) {
        if (this.types != null) {
            throw new IllegalStateException("Cannot change the valid mob types of a character.");
        }
        this.types = new HashSet<EntityType>();
        for (EntityType type : types) {
            this.types.add(type);
        }
    }

    public abstract void load(DataKey var1) throws NPCLoadException;

    public void onLeftClick(NPC npc, Player by) {
    }

    public void onRemove(NPC npc) {
    }

    public void onRightClick(NPC npc, Player by) {
    }

    public void onSet(NPC npc) {
    }

    public abstract void save(DataKey var1);
}

