/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.trait.waypoint;

import java.util.Iterator;
import net.citizensnpcs.api.ai.AI;
import net.citizensnpcs.api.ai.NavigationCallback;
import net.citizensnpcs.trait.waypoint.Waypoint;
import org.bukkit.Location;

public class GenericWaypointCallback
extends NavigationCallback {
    private AI ai;
    private Location dest;
    private boolean executing;
    private Iterator<Waypoint> itr;
    private final Iterable<Waypoint> provider;

    public GenericWaypointCallback(Iterable<Waypoint> provider) {
        this.provider = provider;
    }

    private void ensureItr() {
        if (this.itr == null || !this.itr.hasNext()) {
            this.itr = this.provider.iterator();
        }
    }

    @Override
    public void onAttach(AI ai) {
        this.ai = ai;
        this.executing |= !ai.hasDestination();
        if (!this.executing) {
            return;
        }
        if (this.dest == null) {
            this.ensureItr();
            if (this.itr.hasNext()) {
                this.dest = this.itr.next().getLocation();
            }
        }
        if (this.dest != null) {
            ai.setDestination(this.dest);
        }
    }

    @Override
    public boolean onCancel(AI ai, NavigationCallback.CancelReason reason) {
        if (this.executing && reason == NavigationCallback.CancelReason.REPLACE) {
            this.executing = false;
            return false;
        }
        this.executing = true;
        this.ensureItr();
        if (this.dest == null && this.itr.hasNext()) {
            this.dest = this.itr.next().getLocation();
        }
        if (this.dest != null) {
            ai.setDestination(this.dest);
        }
        return false;
    }

    @Override
    public boolean onCompletion(AI ai) {
        if (this.executing) {
            this.ensureItr();
            this.dest = this.itr.hasNext() ? this.itr.next().getLocation() : null;
        } else {
            this.executing = true;
        }
        if (this.dest != null) {
            ai.setDestination(this.dest);
        }
        return false;
    }

    public void onProviderChanged() {
        this.itr = this.provider.iterator();
        Location location = this.dest = this.itr.hasNext() ? this.itr.next().getLocation() : null;
        if (this.dest != null) {
            this.ai.setDestination(this.dest);
        }
    }
}

