/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.trait.trait;

import net.citizensnpcs.api.exception.NPCLoadException;
import net.citizensnpcs.api.npc.NPC;
import net.citizensnpcs.api.trait.Trait;
import net.citizensnpcs.api.util.DataKey;
import org.bukkit.DyeColor;
import org.bukkit.entity.Sheep;

public class WoolColor
extends Trait {
    private DyeColor color;
    private final NPC npc;

    public WoolColor(NPC npc) {
        this.npc = npc;
    }

    @Override
    public void load(DataKey key) throws NPCLoadException {
        try {
            this.color = DyeColor.valueOf((String)key.getString(""));
        }
        catch (Exception ex) {
            this.color = DyeColor.WHITE;
        }
    }

    @Override
    public void onNPCSpawn() {
        if (this.npc.getBukkitEntity() instanceof Sheep) {
            ((Sheep)this.npc.getBukkitEntity()).setColor(this.color);
        }
    }

    @Override
    public void save(DataKey key) {
        key.setString("", this.color.name());
    }

    public DyeColor getColor() {
        return this.color;
    }

    public void setColor(DyeColor color) {
        this.color = color;
        if (this.npc.getBukkitEntity() instanceof Sheep) {
            ((Sheep)this.npc.getBukkitEntity()).setColor(color);
        }
    }

    public String toString() {
        return "WoolColor{" + this.color + "}";
    }
}

