/*
 * Decompiled with CFR 0.152.
 */
package net.citizensnpcs.api.util;

import com.google.common.base.Joiner;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import net.citizensnpcs.api.util.DataKey;
import net.citizensnpcs.api.util.Storage;
import org.apache.commons.dbutils.DbUtils;

public class DatabaseStorage
implements Storage {
    private final Map<String, Table> tables = Maps.newHashMap();
    private final String url;
    private final String username;
    private final String password;
    private static final Pattern INTEGER = Pattern.compile("([\\+-]?\\d+)([eE][\\+-]?\\d+)?");

    public DatabaseStorage(String driver, String url, String username, String password) throws SQLException {
        this.url = url = "jdbc:" + url;
        this.username = username;
        this.password = password;
        DatabaseType.match(driver).load();
        this.load();
    }

    private void createForeignKey(Table from, Table to) {
        String fk = "fk_" + to.name;
        String sql = "ALTER TABLE `" + from.name + "` ADD FOREIGN KEY (`" + fk + "`) REFERENCES " + to.name + "(`" + to.name + "_id`)";
        this.executeSQL(sql);
        from.foreignKeys.put(fk, new ForeignKey(to, fk));
    }

    private Table createTable(String name, int type) {
        String pk = name + "_id";
        String sql = "CREATE TABLE IF NOT EXISTS `" + name + "` ( `" + pk + "` ";
        switch (type) {
            case 4: {
                sql = sql + "int NOT NULL";
                break;
            }
            case 12: {
                sql = sql + "varchar(255) NOT NULL";
                break;
            }
            default: {
                throw new IllegalArgumentException("type not supported");
            }
        }
        this.executeSQL(sql + " primary key (`" + pk + "`))");
        Table table = new Table().setName(name).setPrimaryKey(pk).setPrimaryKeyType(type);
        this.tables.put(name, table);
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void executeSQL(String ... updates) {
        System.out.println(Joiner.on((String)" ").join((Object[])updates));
        Connection conn = this.getConnection();
        if (conn == null) {
            return;
        }
        try {
            for (String sql : updates) {
                PreparedStatement stmt = conn.prepareStatement(sql);
                stmt.execute();
                stmt.close();
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly(conn);
        }
    }

    private Connection getConnection() {
        try {
            return this.username.isEmpty() && this.password.isEmpty() ? DriverManager.getConnection(this.url) : DriverManager.getConnection(this.url, this.username, this.password);
        }
        catch (SQLException ex) {
            ex.printStackTrace();
            return null;
        }
    }

    @Override
    public DataKey getKey(String root) {
        String[] split = (String[])Iterables.toArray((Iterable)Splitter.on((char)'.').split((CharSequence)root), String.class);
        DataKey table = new DatabaseKey(split[0].isEmpty() ? null : split[0]);
        if (split.length == 1) {
            return table;
        }
        for (int i = 1; i < split.length; ++i) {
            table = ((DataKey)table).getRelative(split[i]);
        }
        return table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void load() {
        Connection conn = this.getConnection();
        try {
            ResultSet rs = conn.getMetaData().getTables(null, null, null, new String[]{"TABLE"});
            while (rs.next()) {
                this.tables.put(rs.getString("TABLE_NAME"), new Table());
            }
            rs.close();
            for (Map.Entry<String, Table> entry : this.tables.entrySet()) {
                entry.getValue().name = entry.getKey();
                rs = conn.getMetaData().getColumns(null, null, entry.getKey(), null);
                while (rs.next()) {
                    entry.getValue().columns.add(rs.getString("COLUMN_NAME"));
                    rs.getMetaData().getColumnType(0);
                }
                rs.close();
                rs = conn.getMetaData().getPrimaryKeys(null, null, entry.getKey());
                while (rs.next()) {
                    entry.getValue().primaryKey = rs.getString("PK_NAME");
                    entry.getValue().setPrimaryKeyType(rs.getMetaData().getColumnType(4));
                }
                rs.close();
                rs = conn.getMetaData().getImportedKeys(null, null, entry.getKey());
                while (rs.next()) {
                    ForeignKey key = new ForeignKey(this.tables.get(rs.getString("FKTABLE_NAME")), rs.getString("PKCOLUMN_NAME"));
                    entry.getValue().foreignKeys.put(key.localColumn, key);
                }
                rs.close();
                System.out.println(entry.getValue());
            }
        }
        catch (SQLException ex) {
            ex.printStackTrace();
        }
        finally {
            DbUtils.closeQuietly(conn);
        }
    }

    @Override
    public void save() {
    }

    private static class Table {
        final List<String> columns = Lists.newArrayList();
        final Map<String, ForeignKey> foreignKeys = Maps.newHashMap();
        String name;
        String primaryKey;
        int primaryKeyType;

        private Table() {
        }

        public Table setName(String tableName) {
            this.name = tableName;
            return this;
        }

        public Table setPrimaryKey(String pk) {
            this.primaryKey = pk;
            return this;
        }

        public Table setPrimaryKeyType(int type) {
            this.primaryKeyType = type;
            return this;
        }

        public String toString() {
            return "Table [primaryKey=" + this.primaryKey + ", foreignKeys=" + this.foreignKeys + ", columns=" + this.columns + "]";
        }
    }

    private static class ForeignKey {
        final Table foreignTable;
        final String localColumn;

        ForeignKey(Table foreign, String from) {
            this.foreignTable = foreign;
            this.localColumn = from;
        }
    }

    public static enum DatabaseType {
        H2("org.h2.Driver"),
        MYSQL("com.mysql.jdbc.Driver"),
        POSTGRE("org.postgresql.Driver"),
        SQLITE("org.sqlite.JDBC");

        private final String driver;
        private boolean loaded = false;

        private DatabaseType(String driver) {
            this.driver = driver;
        }

        public boolean load() {
            if (this.loaded) {
                return true;
            }
            if (DbUtils.loadDriver(this.driver)) {
                this.loaded = true;
            }
            return this.loaded;
        }

        public static DatabaseType match(String driver) {
            for (DatabaseType type : DatabaseType.values()) {
                if (!type.name().toLowerCase().contains(driver)) continue;
                return type;
            }
            return null;
        }
    }

    public class DatabaseKey
    extends DataKey {
        private String currentKey;
        private Table table;
        private String tableName;

        public DatabaseKey(String string) {
            if (string.charAt(string.length()) == 's') {
                string = string.substring(0, string.length() - 1);
            }
            this.table = (Table)DatabaseStorage.this.tables.get(string);
            this.tableName = string;
        }

        private DatabaseKey(Table table, String currentKey) {
            this.table = table;
            this.currentKey = currentKey;
        }

        @Override
        public void copy(String to) {
        }

        @Override
        public boolean getBoolean(String key) {
            return false;
        }

        @Override
        public double getDouble(String key) {
            return 0.0;
        }

        @Override
        public int getInt(String key) {
            return 0;
        }

        @Override
        public List<DataKey> getIntegerSubKeys() {
            return null;
        }

        @Override
        public long getLong(String key) {
            return 0L;
        }

        @Override
        public Object getRaw(String key) {
            return null;
        }

        @Override
        public DataKey getRelative(String relative) {
            if (relative.isEmpty()) {
                return this;
            }
            String[] split = relative.split("\\.");
            if (this.table == null) {
                String primary = null;
                if (this.tableName == null) {
                    this.tableName = split[0];
                    if ((split = Arrays.copyOfRange(split, 1, split.length)).length > 1) {
                        primary = split[1];
                        split = Arrays.copyOfRange(split, 1, split.length);
                    }
                } else {
                    primary = split[0];
                    split = Arrays.copyOfRange(split, 1, split.length);
                }
                if (primary != null) {
                    this.table = DatabaseStorage.this.createTable(this.tableName, INTEGER.matcher(primary).matches() ? 4 : 12);
                    this.currentKey = primary;
                }
            }
            Connection conn = DatabaseStorage.this.getConnection();
            String rel = split[0];
            if (!DatabaseStorage.this.tables.containsKey(rel)) {
                DatabaseStorage.this.createTable(rel, 4);
            }
            Table foreign = (Table)DatabaseStorage.this.tables.get(rel);
            if (!this.table.foreignKeys.containsKey("fk_" + foreign.name)) {
                DatabaseStorage.this.createForeignKey(this.table, foreign);
            }
            ForeignKey key = this.table.foreignKeys.get("fk_" + foreign.name);
            String name = key.foreignTable.name;
            try {
                PreparedStatement stmt = conn.prepareStatement("SELECT `" + key.foreignTable.primaryKey + "` FROM `" + name + "` INNER JOIN `" + this.table.name + "` ON `" + key.foreignTable.primaryKey + "`=`" + key.localColumn + "`");
                ResultSet rs = stmt.executeQuery();
                if (!rs.next()) {
                    System.out.println("NO MATCHING RELATION");
                }
                DbUtils.closeQuietly(conn);
                return new DatabaseKey(key.foreignTable, rs.getString(key.foreignTable.primaryKey));
            }
            catch (SQLException ex) {
                ex.printStackTrace();
                DbUtils.closeQuietly(conn);
                return null;
            }
        }

        @Override
        public String getString(String key) {
            return null;
        }

        @Override
        public Iterable<DataKey> getSubKeys() {
            return null;
        }

        @Override
        public boolean keyExists(String key) {
            return false;
        }

        @Override
        public String name() {
            return this.currentKey != null ? this.currentKey : this.table.name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void removeKey(String key) {
            Connection conn = DatabaseStorage.this.getConnection();
            if (conn == null) {
                return;
            }
            PreparedStatement stmt = null;
            try {
                stmt = conn.prepareStatement("DELETE FROM `" + this.table.name + "` WHERE `" + this.table.primaryKey + "` = `" + key + "`");
                stmt.execute();
                DbUtils.closeQuietly(conn, stmt, null);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
            finally {
                DbUtils.closeQuietly(conn, stmt, null);
            }
        }

        @Override
        public void setBoolean(String key, boolean value) {
            this.setPrimitive(key, value);
        }

        @Override
        public void setDouble(String key, double value) {
            this.setPrimitive(key, value);
        }

        @Override
        public void setInt(String key, int value) {
            this.setPrimitive(key, value);
        }

        @Override
        public void setLong(String key, long value) {
            this.setPrimitive(key, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void setPrimitive(String key, Object value) {
            Connection conn = DatabaseStorage.this.getConnection();
            PreparedStatement stmt = null;
            try {
                stmt = conn.prepareStatement("UPDATE `" + this.table.name + "` SET `" + key + "`=" + value + " WHERE `" + this.table.primaryKey + "` =" + this.currentKey);
                stmt.execute();
                DbUtils.closeQuietly(conn, stmt, null);
            }
            catch (SQLException ex) {
                ex.printStackTrace();
            }
            finally {
                DbUtils.closeQuietly(conn, stmt, null);
            }
        }

        @Override
        public void setRaw(String key, Object value) {
            this.setPrimitive(key, value);
        }

        @Override
        public void setString(String key, String value) {
            this.setPrimitive(key, value);
        }
    }
}

